/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.formatter;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.Regex;
import org.appwork.utils.formatter.StringFormatter;

public class TimeFormatter {
    private static final ArrayList<SimpleDateFormat> dateformats = new ArrayList();
    public static final int HIDE_SECONDS = 2;
    public static final int HIDE_MARKER = 4;
    public static final int CLOCK = 8;

    public static String formatMilliSeconds(long l, int n) {
        return TimeFormatter.formatSeconds(l / 1000L, n);
    }

    public static String formatSeconds(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = l / 86400L;
        long l3 = (l -= l2 * 24L * 60L * 60L) / 3600L;
        long l4 = (l -= l3 * 60L * 60L) / 60L;
        long l5 = l - l4 * 60L;
        if (!BinaryLogic.containsAll(n, 8)) {
            if (l2 != 0L) {
                stringBuilder.append(l2);
                stringBuilder.append('d');
            }
        } else if (l2 != 0L) {
            l3 += l2 * 24L;
        }
        if (l3 != 0L || stringBuilder.length() != 0 || BinaryLogic.containsAll(n, 8)) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(l3);
            if (BinaryLogic.containsNone(n, 4)) {
                stringBuilder.append('h');
            }
        }
        if (l4 != 0L || stringBuilder.length() != 0 || BinaryLogic.containsAll(n, 8)) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(StringFormatter.fillStart(l4 + "", 2, "0"));
            if (BinaryLogic.containsNone(n, 4)) {
                stringBuilder.append('m');
            }
        }
        if (BinaryLogic.containsNone(n, 2)) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(':');
            }
            stringBuilder.append(StringFormatter.fillStart(l5 + "", 2, "0"));
            if (BinaryLogic.containsNone(n, 4)) {
                stringBuilder.append('s');
            }
        }
        return stringBuilder.toString();
    }

    public static long formatStringToMilliseconds(String string) {
        String[] stringArray = new Regex(string, "(\\d+)\\w?:(\\d+)").getRow(0);
        if (stringArray == null) {
            return 0L;
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        if (n >= 24) {
            n = 24;
            n2 = 0;
        }
        if (n2 >= 60) {
            ++n;
            n2 = 0;
        }
        return n * 60 * 60 * 1000 + n2 * 60 * 1000;
    }

    public static long getMilliSeconds(String string) {
        String[][] stringArray = new Regex(string, "([\\d]+) ?[\\.|\\,|\\:] ?([\\d]+)").getMatches();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new Regex(string, Pattern.compile("([\\d]+)")).getMatches();
        }
        if (stringArray == null || stringArray.length == 0) {
            return -1L;
        }
        double d = 0.0;
        if (stringArray[0].length == 1) {
            d = Double.parseDouble(stringArray[0][0]);
        }
        if (stringArray[0].length == 2) {
            d = Double.parseDouble(stringArray[0][0] + "." + stringArray[0][1]);
        }
        d = Regex.matches((Object)string, Pattern.compile("(h|st)", 2)) ? (d *= 3600000.0) : (Regex.matches((Object)string, Pattern.compile("(m)", 2)) ? (d *= 60000.0) : (d *= 1000.0));
        return Math.round(d);
    }

    public static long getMilliSeconds(String string, String string2, Locale locale) {
        if (string != null) {
            SimpleDateFormat simpleDateFormat = locale != null ? new SimpleDateFormat(string2, locale) : new SimpleDateFormat(string2);
            try {
                return simpleDateFormat.parse(string).getTime();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return -1L;
    }

    public static Date parseDateString(String string) {
        if (string == null) {
            return null;
        }
        Date date = null;
        for (SimpleDateFormat simpleDateFormat : dateformats) {
            try {
                date = simpleDateFormat.parse(string);
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (date == null) {
            return null;
        }
        return date;
    }

    static {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy z", Locale.UK);
            dateformats.add(simpleDateFormat);
            simpleDateFormat.setLenient(false);
            simpleDateFormat = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.UK);
            dateformats.add(simpleDateFormat);
            simpleDateFormat.setLenient(false);
            simpleDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(simpleDateFormat);
            simpleDateFormat.setLenient(false);
            simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(simpleDateFormat);
            simpleDateFormat.setLenient(false);
            simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.UK);
            dateformats.add(simpleDateFormat);
            simpleDateFormat.setLenient(false);
            simpleDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(simpleDateFormat);
            simpleDateFormat.setLenient(false);
            simpleDateFormat = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss z", Locale.UK);
            dateformats.add(simpleDateFormat);
            simpleDateFormat.setLenient(false);
            simpleDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.UK);
            dateformats.add(simpleDateFormat);
            simpleDateFormat.setLenient(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

