/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Regex {
    private Matcher matcher;
    private boolean memOpt = true;

    public static String escape(String string) {
        return Pattern.quote(string);
    }

    public static String[] getLines(String string) {
        if (string == null) {
            return new String[0];
        }
        String[] stringArray = string.split("[\r\n]{1,2}");
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = new String(stringArray[i].trim());
        }
        return stringArray2;
    }

    public static boolean matches(Object object, Pattern pattern) {
        return new Regex(object, pattern).matches();
    }

    public static boolean matches(Object object, String string) {
        return new Regex(object, string).matches();
    }

    public static String replace(String string, String string2, String string3) {
        return Pattern.compile(string2, 40).matcher(string).replaceAll(string3);
    }

    public Regex(Matcher matcher) {
        if (matcher != null) {
            this.matcher = matcher;
        }
    }

    public Regex(Object object, Pattern pattern) {
        this(object.toString(), pattern);
    }

    public Regex(Object object, String string) {
        this(object.toString(), string);
    }

    public Regex(Object object, String string, int n) {
        this(object.toString(), string, n);
    }

    public Regex(String string, Pattern pattern) {
        if (string != null && pattern != null) {
            this.matcher = pattern.matcher(string);
        }
    }

    public Regex(String string, String string2) {
        if (string != null && string2 != null) {
            this.matcher = Pattern.compile(string2, 34).matcher(string);
        }
    }

    public Regex(String string, String string2, int n) {
        if (string != null && string2 != null) {
            this.matcher = Pattern.compile(string2, n).matcher(string);
        }
    }

    public int count() {
        if (this.matcher == null) {
            return 0;
        }
        this.matcher.reset();
        int n = 0;
        Matcher matcher = this.matcher;
        while (matcher.find()) {
            ++n;
        }
        return n;
    }

    public String[] getColumn(int n) {
        if (this.matcher == null) {
            return null;
        }
        ++n;
        Matcher matcher = this.matcher;
        matcher.reset();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            String string = matcher.group(n);
            if (string != null && this.memOpt) {
                string = new String(string);
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getMatch(int n) {
        if (this.matcher != null) {
            Matcher matcher = this.matcher;
            matcher.reset();
            if (matcher.find()) {
                String string = matcher.group(n + 1);
                if (string != null && this.memOpt) {
                    return new String(string);
                }
                return string;
            }
        }
        return null;
    }

    public String getMatch(int n, int n2) {
        if (this.matcher != null) {
            Matcher matcher = this.matcher;
            matcher.reset();
            ++n;
            int n3 = 0;
            while (matcher.find()) {
                if (n3 == n2) {
                    String string = matcher.group(n);
                    if (string != null && this.memOpt) {
                        return new String(string);
                    }
                    return string;
                }
                ++n3;
            }
        }
        return null;
    }

    public Matcher getMatcher() {
        if (this.matcher != null) {
            this.matcher.reset();
        }
        return this.matcher;
    }

    public String[][] getMatches() {
        if (this.matcher == null) {
            return null;
        }
        Matcher matcher = this.matcher;
        matcher.reset();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (matcher.find()) {
            String[] stringArray;
            int n = matcher.groupCount();
            int n2 = 1;
            if (n == 0) {
                stringArray = new String[n + 1];
                n2 = 0;
            } else {
                stringArray = new String[n];
            }
            for (int i = n2; i <= n; ++i) {
                String string = matcher.group(i);
                if (string != null && this.memOpt) {
                    string = new String(string);
                }
                stringArray[i - n2] = string;
            }
            arrayList.add(stringArray);
        }
        return arrayList.size() == 0 ? new String[][]{} : (String[][])arrayList.toArray((T[])new String[0][]);
    }

    public String[] getRow(int n) {
        if (this.matcher != null) {
            Matcher matcher = this.matcher;
            matcher.reset();
            int n2 = 0;
            while (matcher.find()) {
                if (n2 == n) {
                    int n3 = matcher.groupCount();
                    String[] stringArray = new String[n3];
                    for (int i = 1; i <= n3; ++i) {
                        String string = matcher.group(i);
                        if (string != null && this.memOpt) {
                            string = new String(string);
                        }
                        stringArray[i - 1] = string;
                    }
                    return stringArray;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean matches() {
        Matcher matcher = this.matcher;
        if (matcher == null) {
            return false;
        }
        matcher.reset();
        return matcher.find();
    }

    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public Regex setMemoryOptimized(boolean bl) {
        this.memOpt = bl;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String[][] stringArray = this.getMatches();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i];
            int n2 = stringArray2.length;
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append("match[");
                stringBuilder.append(i);
                stringBuilder.append("][");
                stringBuilder.append(j);
                stringBuilder.append("] = ");
                stringBuilder.append(stringArray2[j]);
                stringBuilder.append(System.getProperty("line.separator"));
            }
        }
        this.matcher.reset();
        return stringBuilder.toString();
    }
}

