/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import org.appwork.storage.JSonStorage;
import org.appwork.txtresource.Default;
import org.appwork.txtresource.TranslateData;
import org.appwork.utils.logging.Log;

public class TranslateResource {
    private final URL url;
    private TranslateData data;
    private final String name;

    public TranslateResource(URL uRL, String string) {
        this.url = uRL;
        this.name = string;
    }

    public TranslateData getData() {
        if (this.data == null && this.url != null) {
            try {
                String string = this.read(this.url);
                this.data = JSonStorage.restoreFromString(string, TranslateData.class);
            }
            catch (Throwable throwable) {
                Log.L.severe("Error in Translation File: " + this.url);
                Log.exception(throwable);
                this.data = new TranslateData();
            }
        }
        return this.data;
    }

    public String getEntry(Method method) throws UnsupportedEncodingException, IOException {
        if (this.url == null) {
            return this.readDefaults(method);
        }
        String string = null;
        string = (String)this.getData().get(method.getName());
        if (string == null) {
            return this.readDefaults(method);
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(URL uRL) throws UnsupportedEncodingException, IOException {
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        try {
            String string;
            inputStreamReader = new InputStreamReader(uRL.openStream(), "UTF8");
            bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = System.getProperty("line.separator");
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().startsWith("//")) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(string);
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable) {}
            try {
                inputStreamReader.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public String readDefaults(Method method) {
        Default default_ = method.getAnnotation(Default.class);
        if (default_ == null) {
            Log.L.warning("Default missing for: " + method);
            return null;
        }
        for (int i = 0; i < default_.lngs().length; ++i) {
            if (!default_.lngs()[i].equals(this.name)) continue;
            return default_.values()[i];
        }
        return null;
    }
}

