/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.storage.config.annotations.DefaultFactory;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.logging.Log;

public abstract class ListHandler<T>
extends KeyHandler<T> {
    public static final int MIN_LIFETIME = 10000;
    private MinTimeWeakReference<T> cache;
    private final TypeRef<Object> typeRef;
    private File path;
    private URL url;

    public ListHandler(StorageHandler<?> storageHandler, String string, Type type) {
        super(storageHandler, string);
        this.typeRef = new TypeRef<Object>(type){};
    }

    @Override
    public T getValue() {
        Object object;
        Object object2 = object = this.cache != null ? (Object)this.cache.get() : null;
        if (object == null) {
            try {
                object = this.read();
            }
            catch (Throwable throwable) {
                throw new WTFException(throwable);
            }
            this.cache = new MinTimeWeakReference<Object>(object, 10000L, "Storage " + this.getKey());
        }
        return (T)object;
    }

    @Override
    protected void initDefaults() throws Throwable {
    }

    @Override
    protected void initHandler() throws Throwable {
        this.path = new File(this.storageHandler.getPath() + "." + this.getKey() + "." + (this.isCrypted() ? "ejs" : "json"));
        if (this.storageHandler.getRelativCPPath() != null && !this.path.exists()) {
            this.url = Application.getRessourceURL(this.storageHandler.getRelativCPPath() + "." + this.getKey() + "." + (this.isCrypted() ? "ejs" : "json"));
        }
    }

    @Override
    protected void putValue(T t) {
        this.write(t);
        this.cache = new MinTimeWeakReference<T>(t, 10000L, "Storage " + this.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object read() throws InstantiationException, IllegalAccessException, IOException {
        try {
            Object object = new Object();
            Object object2 = null;
            if (this.url != null) {
                Log.L.finer("Read Config: " + this.url);
                object2 = JSonStorage.restoreFromString(IO.readURL(this.url), !this.crypted, this.cryptKey, this.typeRef, object);
            } else {
                Log.L.finer("Read Config: " + this.path.getAbsolutePath());
                object2 = JSonStorage.restoreFrom(this.path, !this.crypted, this.cryptKey, this.typeRef, object);
            }
            if (object2 == object) {
                if (this.getDefaultValue() != null) {
                    Object RawClass = this.getDefaultValue();
                    return RawClass;
                }
                DefaultJsonObject defaultJsonObject = this.getAnnotation(DefaultJsonObject.class);
                DefaultFactory defaultFactory = this.getAnnotation(DefaultFactory.class);
                if (defaultJsonObject != null) {
                    this.setDefaultValue(JSonStorage.restoreFromString(defaultJsonObject.value(), this.typeRef, null));
                    Object RawClass = this.getDefaultValue();
                    return RawClass;
                }
                if (defaultFactory != null) {
                    this.setDefaultValue(defaultFactory.value().newInstance().getDefaultValue());
                    Object RawClass = this.getDefaultValue();
                    return RawClass;
                }
                Annotation annotation = this.getAnnotation(this.getDefaultAnnotation());
                if (annotation != null) {
                    try {
                        this.setDefaultValue(annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    Object RawClass = this.getDefaultValue();
                    return RawClass;
                }
                Object var6_12 = null;
                return var6_12;
            }
            Object object3 = object2;
            return object3;
        }
        finally {
            if (!this.path.exists() && this.url == null) {
                this.write(this.getDefaultValue());
            }
        }
    }

    @Override
    protected void validateValue(T t) throws Throwable {
    }

    protected void write(T t) {
        JSonStorage.saveTo(this.path, !this.crypted, this.cryptKey, JSonStorage.serializeToJson(t));
    }
}

