/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.controlling;

import java.util.ArrayList;
import java.util.HashMap;
import org.appwork.controlling.State;
import org.appwork.controlling.StateConflictException;
import org.appwork.controlling.StateEvent;
import org.appwork.controlling.StateEventListener;
import org.appwork.controlling.StateEventsender;
import org.appwork.controlling.StateListener;
import org.appwork.controlling.StateMachineInterface;
import org.appwork.controlling.StatePathEntry;
import org.appwork.controlling.StateViolationException;
import org.appwork.utils.logging.Log;

public class StateMachine {
    private final State initState;
    private volatile State currentState;
    private final StateEventsender eventSender;
    private final State finalState;
    private final ArrayList<StatePathEntry> path;
    private final StateMachineInterface owner;
    private final Object lock = new Object();
    private final Object lock2 = new Object();
    private final HashMap<State, Throwable> exceptionMap;

    private static State checkState(State state) {
        State state2 = null;
        for (State state3 : state.getChildren()) {
            State state4 = StateMachine.checkState(state3);
            if (state2 == null) {
                state2 = state4;
            }
            if (state2 == state4) continue;
            throw new StateConflictException("States do not all result in one common final state");
        }
        if (state2 == null) {
            throw new StateConflictException(state + " is a blind state (has no children)");
        }
        return state2;
    }

    public static void validateStateChain(State state) {
        if (state.getParents().size() > 0) {
            throw new StateConflictException("initState must not have a parent");
        }
        StateMachine.checkState(state);
    }

    public StateMachine(StateMachineInterface stateMachineInterface, State state, State state2) {
        this.owner = stateMachineInterface;
        this.initState = state;
        this.currentState = state;
        this.finalState = state2;
        this.exceptionMap = new HashMap();
        this.eventSender = new StateEventsender();
        this.path = new ArrayList();
        this.path.add(new StatePathEntry(this.initState));
    }

    public void addListener(StateEventListener stateEventListener) {
        this.eventSender.addListener(stateEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeIfOnState(Runnable runnable, State state) {
        if (runnable == null || state == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isState(state)) {
                runnable.run();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOnceOnState(final Runnable runnable, State state) {
        if (runnable == null || state == null) {
            return;
        }
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.hasPassed(state)) {
                bl = true;
            } else {
                this.addListener(new StateListener(state){

                    @Override
                    public void onStateReached(StateEvent stateEvent) {
                        StateMachine.this.removeListener(this);
                        runnable.run();
                    }
                });
            }
            if (bl) {
                new Thread(runnable, "AsyncOnStateWorker").start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUpdate(State state) {
        Object object;
        if (state != null) {
            object = this.lock;
            synchronized (object) {
                if (this.currentState != state) {
                    throw new StateConflictException("Cannot update state " + state + " because current state is " + this.currentState);
                }
            }
        }
        object = new StateEvent(this, StateEvent.Types.UPDATED, state, state);
        this.eventSender.fireEvent(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceState(State state) {
        StateEvent stateEvent;
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == state) {
                return;
            }
            stateEvent = new StateEvent(this, StateEvent.Types.CHANGED, this.currentState, state);
            Object object2 = this.lock2;
            synchronized (object2) {
                this.path.add(new StatePathEntry(state));
            }
            Log.L.finest(this.owner + " State changed " + this.currentState + " -> " + state);
            this.currentState = state;
        }
        this.eventSender.fireEvent(stateEvent);
    }

    public Throwable getCause(State state) {
        return this.exceptionMap.get(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatePathEntry getLatestStateEntry(State state) {
        try {
            StatePathEntry statePathEntry = null;
            Object object = this.lock2;
            synchronized (object) {
                for (int i = this.path.size() - 1; i >= 0; --i) {
                    statePathEntry = this.path.get(i);
                    if (statePathEntry.getState() != state) continue;
                    return statePathEntry;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public StateMachineInterface getOwner() {
        return this.owner;
    }

    public ArrayList<StatePathEntry> getPath() {
        return this.path;
    }

    public State getState() {
        return this.currentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPassed(State ... stateArray) {
        Object object = this.lock2;
        synchronized (object) {
            for (State state : stateArray) {
                for (StatePathEntry statePathEntry : this.path) {
                    if (statePathEntry.getState() != state) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinal() {
        Object object = this.lock;
        synchronized (object) {
            return this.finalState == this.currentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStartState() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentState == this.initState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isState(State ... stateArray) {
        Object object = this.lock;
        synchronized (object) {
            for (State state : stateArray) {
                if (state != this.currentState) continue;
                return true;
            }
        }
        return false;
    }

    public void removeListener(StateEventListener stateEventListener) {
        this.eventSender.removeListener(stateEventListener);
    }

    public void reset() {
        this.reset(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(boolean bl) {
        StateEvent stateEvent;
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == this.initState) {
                return;
            }
            if (!bl && this.finalState != this.currentState) {
                throw new StateConflictException("Cannot reset from state " + this.currentState);
            }
            stateEvent = new StateEvent(this, StateEvent.Types.CHANGED, this.currentState, this.initState);
            Log.L.finest(this.owner + " State changed (reset) " + this.currentState + " -> " + this.initState);
            this.currentState = this.initState;
            Object object2 = this.lock2;
            synchronized (object2) {
                this.path.clear();
                this.path.add(new StatePathEntry(this.initState));
            }
        }
        this.eventSender.fireEvent(stateEvent);
    }

    public void setCause(State state, Throwable throwable) {
        this.exceptionMap.put(state, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(State state) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == state) {
                return;
            }
            if (!this.currentState.getChildren().contains(state)) {
                throw new StateConflictException("Cannot change state from " + this.currentState + " to " + state);
            }
        }
        this.forceState(state);
    }

    public void validateState(State state) {
        if (!this.isState(state)) {
            throw new StateViolationException(state);
        }
    }
}

