/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.controlling;

import org.appwork.controlling.State;
import org.appwork.controlling.StateEvent;
import org.appwork.controlling.StateEventListener;
import org.appwork.controlling.StateExceptionException;
import org.appwork.controlling.StateMachine;

public class StateLocker
implements StateEventListener {
    private StateMachine[] stateMachines;
    private int counter;
    private State waitState;
    private State[] exceptions;
    private State interruptState = null;
    private StateMachine interruptStatemachine;

    public StateLocker(StateMachine ... stateMachineArray) {
        this.stateMachines = (StateMachine[])stateMachineArray.clone();
        this.counter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockUntilAllHavePassed(State state, State ... stateArray) throws InterruptedException, StateExceptionException {
        this.waitState = state;
        this.exceptions = stateArray;
        if (this.stateMachines == null || this.stateMachines.length == 0) {
            return;
        }
        try {
            for (StateMachine stateMachine : this.stateMachines) {
                for (State state2 : stateArray) {
                    if (!stateMachine.hasPassed(state2)) continue;
                    throw new StateExceptionException(stateMachine, state2);
                }
                if (stateMachine.hasPassed(state)) {
                    this.increaseCounter();
                    continue;
                }
                stateMachine.addListener(this);
            }
            block8: while (this.counter < this.stateMachines.length) {
                StateLocker stateLocker = this;
                synchronized (stateLocker) {
                    this.wait(2000L);
                }
                if (this.interruptState != null) {
                    throw new StateExceptionException(this.interruptStatemachine, this.interruptState);
                }
                for (StateMachine stateMachine : this.stateMachines) {
                    if (!stateMachine.hasPassed(state)) continue block8;
                }
                break;
            }
        }
        finally {
            for (StateMachine stateMachine : this.stateMachines) {
                stateMachine.removeListener(this);
            }
        }
    }

    private synchronized int increaseCounter() {
        return ++this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStateChange(StateEvent stateEvent) {
        if (stateEvent.getNewState() == this.waitState) {
            if (this.increaseCounter() == this.stateMachines.length) {
                StateLocker stateLocker = this;
                synchronized (stateLocker) {
                    this.notify();
                }
                stateEvent.getStateMachine().removeListener(this);
            }
        } else {
            for (State state : this.exceptions) {
                if (stateEvent.getNewState() != state) continue;
                this.interruptState = state;
                this.interruptStatemachine = stateEvent.getStateMachine();
                StateLocker stateLocker = this;
                synchronized (stateLocker) {
                    this.notify();
                }
                return;
            }
        }
    }

    @Override
    public void onStateUpdate(StateEvent stateEvent) {
    }
}

