/*
 * Decompiled with CFR 0.152.
 */
package jd.utils.locale;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.swing.JComponent;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDFileFilter;
import jd.utils.EditDistance;
import jd.utils.JDGeoCode;
import jd.utils.JDUtilities;
import jd.utils.locale.JDLocale;
import jd.utils.locale.Translation;

public final class JDL {
    private static final HashMap<String, JDLocale> CACHE = new HashMap();
    public static final String CONFIG = "LOCALE";
    private static String COUNTRY_CODE = null;
    private static final HashMap<Integer, String> DATA = new HashMap();
    public static boolean DEBUG = false;
    private static HashMap<Integer, String> DEFAULT_DATA = null;
    private static int KEY;
    private static String LANGUAGES_DIR;
    public static final String LOCALE_PARAM_ID = "LOCALE4";
    public static final JDLocale DEFAULT_LOCALE;
    private static File LOCALE_FILE;
    private static JDLocale LOCALE_ID;
    private static String STATIC_LOCALE;

    private JDL() {
    }

    public static String getCountryCodeByIP() {
        if (COUNTRY_CODE != null) {
            return COUNTRY_CODE;
        }
        COUNTRY_CODE = SubConfiguration.getConfig(CONFIG).getStringProperty("DEFAULTLANGUAGE", null);
        if (COUNTRY_CODE != null) {
            return COUNTRY_CODE;
        }
        Browser browser = new Browser();
        browser.setFollowRedirects(true);
        browser.setConnectTimeout(10000);
        browser.setReadTimeout(10000);
        try {
            COUNTRY_CODE = browser.getPage("http://www.jdownloader.org/advert/getLanguage.php?id=" + System.currentTimeMillis() + new Random(System.currentTimeMillis()).nextLong());
            if (!browser.getRequest().getHttpConnection().isOK()) {
                COUNTRY_CODE = null;
            } else {
                COUNTRY_CODE = COUNTRY_CODE.trim().toUpperCase();
                SubConfiguration.getConfig(CONFIG).setProperty("DEFAULTLANGUAGE", COUNTRY_CODE);
                SubConfiguration.getConfig(CONFIG).save();
            }
        }
        catch (Exception exception) {
            COUNTRY_CODE = null;
        }
        return COUNTRY_CODE;
    }

    public static boolean isNorthAmerica(String string) {
        String[] stringArray;
        string = string.toUpperCase();
        for (String string2 : stringArray = new String[]{"US", "CA", "BS", "BB", "AI", "AG", "VG", "VI", "KY", "BM", "GD", "TC", "MS", "MP", "GU", "AS", "LC", "DM", "VC", "PR", "DO", "DO", "DO", "TT", "KN", "JM", "PR"}) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEurope(String string) {
        String[] stringArray;
        string = string.toUpperCase();
        for (String string2 : stringArray = new String[]{"GR", "NL", "BE", "FR", "ES", "GI", "PT", "LU", "IE", "IS", "AL", "MT", "CY", "FI", "AX", "BG", "HU", "LT", "LV", "EE", "MD", "AM", "QN", "BY", "AD", "MC", "SM", "VA", "UA", "RS", "ME", "HR", "SI", "BA", "EU", "MK", "IT", "VA", "RO", "CH", "CZ", "SK", "LI", "AT", "GB", "GG", "IM", "JE", "DK", "SE", "NO", "SJ", "PL", "DE"}) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSouthAmerica(String string) {
        String[] stringArray;
        string = string.toUpperCase();
        for (String string2 : stringArray = new String[]{"FK", "BZ", "GT", "SV", "HN", "NI", "CR", "PA", "PM", "HT", "PE", "MX", "CU", "AR", "BR", "CL", "CO", "VE", "GP", "BL", "MF", "BO", "GY", "EC", "GF", "PY", "MQ", "SR", "UY", "AN"}) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static JDLocale getInstance(String string) {
        JDLocale jDLocale = CACHE.get(string);
        if (jDLocale != null) {
            return jDLocale;
        }
        jDLocale = new JDLocale(string);
        CACHE.put(string, jDLocale);
        return jDLocale;
    }

    public static String[] getKeysFor(String string) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = Integer.MAX_VALUE;
        for (Map.Entry<Integer, String> stringArray2 : DATA.entrySet()) {
            n = EditDistance.getLevenshteinDistance(string, stringArray2.getValue());
            if (n < n2) {
                arrayList.clear();
                arrayList.add(stringArray2.getKey());
                n2 = n;
                continue;
            }
            if (n2 != n) continue;
            arrayList.add(stringArray2.getKey());
            n2 = n;
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            return null;
        }
        String[] stringArray = new String[n3];
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = JDL.hashToKey((Integer)arrayList.get(i));
        }
        return stringArray;
    }

    public static File getLanguageFile() {
        return LOCALE_FILE;
    }

    public static JDLocale getConfigLocale() {
        return SubConfiguration.getConfig(CONFIG).getGenericProperty(LOCALE_PARAM_ID, DEFAULT_LOCALE);
    }

    public static void setConfigLocale(JDLocale jDLocale) {
        SubConfiguration.getConfig(CONFIG).setProperty(LOCALE_PARAM_ID, jDLocale);
        SubConfiguration.getConfig(CONFIG).save();
    }

    public static JDLocale getLocale() {
        if (DEBUG) {
            return DEFAULT_LOCALE;
        }
        return LOCALE_ID;
    }

    public static ArrayList<JDLocale> getLocaleIDs() {
        File file = JDUtilities.getResourceFile(LANGUAGES_DIR);
        if (!file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles(new JDFileFilter(null, ".loc", false));
        ArrayList<JDLocale> arrayList = new ArrayList<JDLocale>();
        String string = null;
        for (File file2 : fileArray) {
            string = file2.getName().split("\\.")[0];
            if (JDGeoCode.parseLanguageCode(string) == null) {
                file2.renameTo(new File(file2, ".outdated"));
                continue;
            }
            arrayList.add(JDL.getInstance(string));
        }
        return arrayList;
    }

    public static String getLocaleString(String string, String string2) {
        if (DEBUG) {
            return string;
        }
        if (DATA == null || LOCALE_FILE == null) {
            JDL.setLocale(JDL.getConfigLocale());
            if (DATA == null) {
                return "Error in JDL: DATA==null";
            }
        }
        if (DATA.containsKey(KEY = string.toLowerCase().hashCode())) {
            return DATA.get(KEY);
        }
        System.out.println("Key not found: " + string + " Defaultvalue: " + string2);
        if (string2 == null && (string2 = JDL.getDefaultLocaleString(KEY)) == null) {
            string2 = string;
        }
        DATA.put(KEY, string2);
        return string2;
    }

    public static String getDefaultLocaleString(int n) {
        JDL.loadDefault();
        if (DEFAULT_DATA.containsKey(n)) {
            return DEFAULT_DATA.get(n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String hashToKey(Integer n) {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(LOCALE_FILE), "UTF8"));
            while ((string = bufferedReader.readLine()) != null) {
                int n2;
                if (string.charAt(0) == '#' || (n2 = string.indexOf(61)) <= 0) continue;
                String string2 = string.substring(0, n2).trim().toLowerCase();
                if (n.intValue() != string2.hashCode()) continue;
                String string3 = string2;
                return string3;
            }
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                JDLogger.exception(exception);
            }
        }
        return null;
    }

    public static void initLocalisation() {
        JComponent.setDefaultLocale(new Locale(JDL.getLocale().getLanguageCode()));
    }

    public static boolean isGerman() {
        String string = System.getProperty("user.country");
        return string != null && string.equalsIgnoreCase("DE");
    }

    public static String L(String string, String string2) {
        return JDL.getLocaleString(string, string2);
    }

    public static String LF(String string, String string2, Object ... objectArray) {
        if (DEBUG) {
            return string;
        }
        if (objectArray == null || objectArray.length == 0) {
            JDLogger.getLogger().severe("FIXME: " + string);
        }
        try {
            return String.format(JDL.L(string, string2), objectArray);
        }
        catch (Exception exception) {
            JDLogger.getLogger().severe("FIXME: " + string);
            return "FIXME: " + string;
        }
    }

    private static void loadDefault() {
        if (DEFAULT_DATA == null) {
            File file;
            System.err.println("JD have to load the default language, there is an missing entry");
            DEFAULT_DATA = new HashMap();
            File file2 = file = STATIC_LOCALE == null ? JDUtilities.getResourceFile(LANGUAGES_DIR + DEFAULT_LOCALE.getLngGeoCode() + ".loc") : new File(STATIC_LOCALE);
            if (file.exists()) {
                JDL.parseLanguageFile(file, DEFAULT_DATA);
            } else {
                System.out.println("Could not load the default languagefile: " + file);
            }
        }
    }

    public static void parseLanguageFile(File file, HashMap<Integer, String> hashMap) {
        JDLogger.getLogger().info("parse lng file " + file);
        hashMap.clear();
        if (file == null || !file.exists()) {
            System.out.println("JDLocale: " + file + " not found");
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.length() == 0 || string.charAt(0) == '#' || (n = string.indexOf(61)) <= 0) continue;
                String string2 = string.substring(0, n).trim().toLowerCase();
                String string3 = string.substring(n + 1).trim() + (string.endsWith(" ") ? " " : "");
                string3 = string3.replace("\\r", "\r").replace("\\n", "\n");
                hashMap.put(string2.hashCode(), string3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
        }
        JDLogger.getLogger().info("parse lng file end " + file);
    }

    public static void setLocale(JDLocale jDLocale) {
        if (jDLocale == null) {
            return;
        }
        LOCALE_ID = jDLocale;
        System.out.println("Loaded language: " + jDLocale);
        File file = LOCALE_FILE = STATIC_LOCALE == null ? JDUtilities.getResourceFile(LANGUAGES_DIR + LOCALE_ID.getLngGeoCode() + ".loc") : new File(STATIC_LOCALE);
        if (!LOCALE_FILE.exists()) {
            System.out.println("Language " + LOCALE_ID + " not installed");
            return;
        }
        JDL.parseLanguageFile(LOCALE_FILE, DATA);
    }

    public static Translation translate(String string, String string2) {
        return JDL.translate("auto", string, string2);
    }

    public static Translation translate(String string, String string2, String string3) {
        try {
            Translation translation = new Translation(string3, string2);
            Browser browser = new Browser();
            browser.getPage("http://www.google.com/uds/Gtranslate?callback=google.language.callbacks.id101&context=22&q=" + Encoding.urlEncode(string3) + "&langpair=|en&key=notsupplied&v=1.0");
            String[] stringArray = browser.getRegex("\"translatedText\":\"(.*?)\",\"detectedSourceLanguage\":\"(.*?)\"").getRow(0);
            translation.setTranslated(Encoding.UTF8Decode(Encoding.htmlDecode(stringArray[0])));
            translation.setSourceLanguage(Encoding.UTF8Decode(Encoding.htmlDecode(stringArray[1])));
            return translation;
        }
        catch (Exception exception) {
            JDLogger.exception(exception);
            return null;
        }
    }

    public static void setStaticLocale(String string) {
        STATIC_LOCALE = string;
    }

    static {
        LANGUAGES_DIR = "jd/languages/";
        DEFAULT_LOCALE = JDL.getInstance("en");
    }
}

