/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import jd.PluginWrapper;
import jd.config.SubConfiguration;
import jd.controlling.AccountController;
import jd.controlling.IOPermission;
import jd.controlling.JDLogger;
import jd.controlling.JDPluginLogger;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.http.Browser;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.KeyValueInfoGenerator;
import jd.plugins.LinkStatus;
import jd.plugins.Plugin;
import jd.plugins.PluginException;
import jd.plugins.download.DownloadInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Regex;
import org.jdownloader.DomainInfo;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.translate._JDT;

public abstract class PluginForHost
extends Plugin {
    private IOPermission ioPermission = null;
    private LazyHostPlugin lazyP = null;
    protected DownloadInterface dl = null;
    private static final HashMap<String, Long> LAST_CONNECTION_TIME = new HashMap();
    private static final HashMap<String, Long> LAST_STARTED_TIME = new HashMap();
    private Long WAIT_BETWEEN_STARTS = 0L;
    private boolean enablePremium = false;
    private boolean accountWithoutUsername = false;
    private String premiumurl = null;
    private DownloadLink link = null;

    public LazyHostPlugin getLazyP() {
        return this.lazyP;
    }

    public void setLazyP(LazyHostPlugin lazyHostPlugin) {
        this.lazyP = lazyHostPlugin;
    }

    @Deprecated
    public PluginForHost(PluginWrapper pluginWrapper) {
        super(pluginWrapper);
        this.br = null;
        this.dl = null;
        this.lazyP = (LazyHostPlugin)pluginWrapper.getLazy();
    }

    public void setLogger(JDPluginLogger jDPluginLogger) {
        this.logger = jDPluginLogger;
    }

    public JDPluginLogger getLogger() {
        return this.logger;
    }

    public void setBrowser(Browser browser) {
        this.br = browser;
    }

    protected String getCaptchaCode(String string, DownloadLink downloadLink) throws IOException, PluginException {
        return this.getCaptchaCode(this.getHost(), string, downloadLink);
    }

    @Override
    public long getVersion() {
        return this.lazyP.getVersion();
    }

    @Override
    public Pattern getSupportedLinks() {
        return this.lazyP.getPattern();
    }

    protected String getCaptchaCode(String string, String string2, DownloadLink downloadLink) throws IOException, PluginException {
        if (string2 == null) {
            this.logger.severe("Captcha Adresse nicht definiert");
            throw new PluginException(8);
        }
        File file = this.getLocalCaptchaFile();
        try {
            Browser.download(file, this.br.cloneBrowser().openGetConnection(string2));
        }
        catch (Exception exception) {
            this.logger.severe("Captcha Download fehlgeschlagen: " + string2);
            throw new PluginException(8);
        }
        String string3 = this.getCaptchaCode(string, file, downloadLink);
        file.delete();
        return string3;
    }

    protected String getCaptchaCode(File file, DownloadLink downloadLink) throws PluginException {
        return this.getCaptchaCode(this.getHost(), file, downloadLink);
    }

    protected String getCaptchaCode(String string, File file, DownloadLink downloadLink) throws PluginException {
        return this.getCaptchaCode(string, file, 0, downloadLink, null, null);
    }

    protected String getCaptchaCode(String string, File file, int n, DownloadLink downloadLink, String string2, String string3) throws PluginException {
        return null;
    }

    public boolean checkLinks(DownloadLink[] downloadLinkArray) {
        return false;
    }

    @Override
    public String getHost() {
        return this.lazyP.getDisplayName();
    }

    @Override
    public SubConfiguration getPluginConfig() {
        return SubConfiguration.getConfig(this.lazyP.getHost());
    }

    @Override
    public void clean() {
        this.dl = null;
        this.br = null;
        super.clean();
    }

    public void setDownloadInterface(DownloadInterface downloadInterface) {
        this.dl = downloadInterface;
    }

    protected void setBrowserExclusive() {
        if (this.br == null) {
            return;
        }
        this.br.setCookiesExclusive(true);
        this.br.clearCookies(this.getHost());
    }

    public PluginForHost getNewInstance() {
        if (this.lazyP == null) {
            return null;
        }
        return this.lazyP.newInstance();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public AccountInfo fetchAccountInfo(Account account) throws Exception {
        AccountInfo accountInfo = new AccountInfo();
        account.setValid(true);
        return accountInfo;
    }

    public boolean getAccountwithoutUsername() {
        return this.accountWithoutUsername;
    }

    public void setAccountwithoutUsername(boolean bl) {
        this.accountWithoutUsername = bl;
    }

    public abstract String getAGBLink();

    protected void enablePremium() {
        this.enablePremium(null);
    }

    protected void enablePremium(String string) {
        this.premiumurl = string;
        this.enablePremium = true;
    }

    public ArrayList<DownloadLink> getDownloadLinks(String string, FilePackage filePackage) {
        ArrayList<DownloadLink> arrayList = null;
        String[] stringArray = new Regex(string, this.getSupportedLinks()).getColumn(-1);
        if (stringArray != null && stringArray.length > 0) {
            arrayList = new ArrayList<DownloadLink>(stringArray.length);
            for (String string2 : stringArray) {
                string2 = string2.trim();
                while (string2.charAt(0) == '\"') {
                    string2 = string2.substring(1);
                }
                while (string2.charAt(string2.length() - 1) == '\"') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                try {
                    DownloadLink downloadLink = new DownloadLink(this, null, this.getHost(), string2, true);
                    arrayList.add(downloadLink);
                }
                catch (Throwable throwable) {
                    JDLogger.exception(throwable);
                }
            }
        }
        if (arrayList != null && filePackage != null && filePackage != FilePackage.getDefaultFilePackage()) {
            filePackage.addLinks(arrayList);
        }
        return arrayList;
    }

    public void correctDownloadLink(DownloadLink downloadLink) throws Exception {
    }

    public abstract DownloadLink.AvailableStatus requestFileInformation(DownloadLink var1) throws Exception;

    public String getFileInformationString(DownloadLink downloadLink) {
        return downloadLink.getName() + " (" + Formatter.formatReadable(downloadLink.getDownloadSize()) + ")";
    }

    public int getMaxRetries() {
        return JsonConfig.create(GeneralSettings.class).getMaxPluginRetries();
    }

    public int getMaxSimultanFreeDownloadNum() {
        return 1;
    }

    public int getMaxSimultanPremiumDownloadNum() {
        return -1;
    }

    public int getMaxSimultanDownload(Account account) {
        int n;
        if (account == null) {
            n = this.getMaxSimultanFreeDownloadNum();
        } else {
            n = account.getMaxSimultanDownloads();
            if (n < 0) {
                return Integer.MAX_VALUE;
            }
            if (n == 0) {
                n = this.getMaxSimultanPremiumDownloadNum();
            } else {
                return n;
            }
        }
        if (n <= 0) {
            return Integer.MAX_VALUE;
        }
        if (n == Integer.MIN_VALUE) {
            return 0;
        }
        return n;
    }

    public boolean bypassMaxSimultanDownloadNum(DownloadLink downloadLink, Account account) {
        return false;
    }

    @Deprecated
    public boolean isPremiumDownload() {
        return true;
    }

    public synchronized long getLastTimeStarted() {
        if (!LAST_STARTED_TIME.containsKey(this.getHost())) {
            return 0L;
        }
        return Math.max(0L, LAST_STARTED_TIME.get(this.getHost()));
    }

    public synchronized void putLastTimeStarted(long l) {
        LAST_STARTED_TIME.put(this.getHost(), l);
    }

    public synchronized long getLastConnectionTime() {
        if (!LAST_CONNECTION_TIME.containsKey(this.getHost())) {
            return 0L;
        }
        return Math.max(0L, LAST_CONNECTION_TIME.get(this.getHost()));
    }

    public synchronized void putLastConnectionTime(long l) {
        LAST_CONNECTION_TIME.put(this.getHost(), l);
    }

    public void handlePremium(DownloadLink downloadLink, Account account) throws Exception {
        LinkStatus linkStatus = downloadLink.getLinkStatus();
        linkStatus.addStatus(0x400000);
        linkStatus.setErrorMessage(_JDT._.plugins_hoster_nopremiumsupport());
    }

    public abstract void handleFree(DownloadLink var1) throws Exception;

    public Object getInfoGenerator(Account account) {
        AccountInfo accountInfo = account.getAccountInfo();
        HashMap<String, Object> hashMap = null;
        if (accountInfo == null) {
            return null;
        }
        hashMap = accountInfo.getProperties();
        if (hashMap == null || hashMap.size() == 0) {
            return null;
        }
        KeyValueInfoGenerator keyValueInfoGenerator = new KeyValueInfoGenerator(_JDT._.pluginforhost_infogenerator_title(account.getUser(), account.getHoster()));
        for (Map.Entry<String, Object> entry : accountInfo.getProperties().entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object == null) continue;
            keyValueInfoGenerator.addPair(string, object.toString());
        }
        return keyValueInfoGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(DownloadLink downloadLink, Account account) throws Exception {
        try {
            while (this.waitForNextStartAllowed(downloadLink)) {
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.putLastTimeStarted(System.currentTimeMillis());
        if (account != null) {
            long l = downloadLink.getDownloadCurrent();
            boolean bl = false;
            try {
                this.handlePremium(downloadLink, account);
            }
            catch (PluginException pluginException) {
                pluginException.fillLinkStatus(downloadLink.getLinkStatus());
                if (pluginException.getLinkStatus() == 0x400000) {
                    this.logger.info(JDLogger.getStackTrace(pluginException));
                }
                this.logger.info(downloadLink.getLinkStatus().getLongErrorMessage());
                if (downloadLink.getLinkStatus().hasStatus(16) || downloadLink.getLinkStatus().hasStatus(4096)) {
                    bl = true;
                }
            }
            finally {
                try {
                    this.dl.getConnection().disconnect();
                }
                catch (Throwable throwable) {}
                try {
                    this.br.getHttpConnection().disconnect();
                }
                catch (Throwable throwable) {}
                try {
                    downloadLink.getDownloadLinkController().getConnectionHandler().removeConnectionHandler(this.dl.getManagedConnetionHandler());
                }
                catch (Throwable throwable) {}
                this.setDownloadInterface(null);
            }
            long l2 = Math.max(0L, downloadLink.getDownloadCurrent() - l);
            AccountInfo accountInfo = account.getAccountInfo();
            Object object = AccountController.ACCOUNT_LOCK;
            synchronized (object) {
                AccountInfo accountInfo2 = accountInfo;
                if (l2 > 0L && accountInfo2 != null && !accountInfo2.isUnlimitedTraffic()) {
                    long l3 = Math.max(0L, accountInfo2.getTrafficLeft() - l2);
                    accountInfo2.setTrafficLeft(l3);
                    if (l3 == 0L && accountInfo2.isSpecialTraffic()) {
                        this.logger.severe("Premium Account " + account.getUser() + ": Traffic Limit could be reached, but SpecialTraffic might be available!");
                    } else if (l3 == 0L) {
                        this.logger.severe("Premium Account " + account.getUser() + ": Traffic Limit reached");
                        account.setTempDisabled(true);
                    }
                }
                if (bl) {
                    this.logger.severe("Account: " + account.getUser() + " is blocked, temp. disabling it!");
                    AccountController.getInstance().addAccountBlocked(account);
                }
            }
            if (downloadLink.getLinkStatus().hasStatus(256)) {
                if (downloadLink.getLinkStatus().getValue() == 0L) {
                    this.logger.severe("Premium Account " + account.getUser() + ": Traffic Limit reached");
                    account.setTempDisabled(true);
                    account.getAccountInfo().setTrafficLeft(0L);
                    if (accountInfo != null) {
                        accountInfo.setStatus(downloadLink.getLinkStatus().getErrorMessage());
                    }
                } else if (downloadLink.getLinkStatus().getValue() == 1L) {
                    account.setEnabled(false);
                    if (accountInfo != null) {
                        accountInfo.setStatus(downloadLink.getLinkStatus().getErrorMessage());
                    }
                    this.logger.severe("Premium Account " + account.getUser() + ": expired:" + downloadLink.getLinkStatus().getLongErrorMessage());
                } else {
                    account.setEnabled(false);
                    if (accountInfo != null) {
                        accountInfo.setStatus(downloadLink.getLinkStatus().getErrorMessage());
                    }
                    this.logger.severe("Premium Account " + account.getUser() + ":" + downloadLink.getLinkStatus().getLongErrorMessage());
                }
            } else if (accountInfo != null) {
                accountInfo.setStatus(_JDT._.plugins_hoster_premium_status_ok());
            }
        } else {
            try {
                this.handleFree(downloadLink);
            }
            catch (PluginException pluginException) {
                pluginException.fillLinkStatus(downloadLink.getLinkStatus());
                if (pluginException.getLinkStatus() == 0x400000) {
                    this.logger.info(JDLogger.getStackTrace(pluginException));
                }
                this.logger.info(downloadLink.getLinkStatus().getLongErrorMessage());
            }
            finally {
                try {
                    this.dl.getConnection().disconnect();
                }
                catch (Throwable throwable) {}
                try {
                    this.br.getHttpConnection().disconnect();
                }
                catch (Throwable throwable) {}
                try {
                    downloadLink.getDownloadLinkController().getConnectionHandler().removeConnectionHandler(this.dl.getManagedConnetionHandler());
                }
                catch (Throwable throwable) {}
                this.setDownloadInterface(null);
            }
        }
    }

    public abstract void reset();

    public abstract void resetDownloadlink(DownloadLink var1);

    public void resetPluginGlobals() {
    }

    public int getTimegapBetweenConnections() {
        return 50;
    }

    public void setStartIntervall(long l) {
        this.WAIT_BETWEEN_STARTS = l;
    }

    public boolean waitForNextStartAllowed(DownloadLink downloadLink) throws InterruptedException {
        long l = Math.max(0L, this.WAIT_BETWEEN_STARTS - (System.currentTimeMillis() - this.getLastTimeStarted()));
        if (l > 0L) {
            try {
                this.sleep(l, downloadLink);
            }
            catch (PluginException pluginException) {
                throw new InterruptedException();
            }
            return true;
        }
        return false;
    }

    public boolean waitForNextConnectionAllowed() throws InterruptedException {
        long l = Math.max(0L, (long)this.getTimegapBetweenConnections() - (System.currentTimeMillis() - this.getLastConnectionTime()));
        if (l > 0L) {
            Thread.sleep(l);
            return true;
        }
        return false;
    }

    public void sleep(long l, DownloadLink downloadLink) throws PluginException {
        this.sleep(l, downloadLink, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sleep(long l, DownloadLink downloadLink, String string) throws PluginException {
        SingleDownloadController singleDownloadController = downloadLink.getDownloadLinkController();
        try {
            while (l > 0L && singleDownloadController != null && !singleDownloadController.isAborted()) {
                downloadLink.getLinkStatus().setStatusText(string + _JDT._.gui_download_waittime_status2(Formatter.formatSeconds((l -= 1000L) / 1000L)));
                PluginForHost pluginForHost = this;
                synchronized (pluginForHost) {
                    this.wait(1000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PluginException(1);
        }
        downloadLink.getLinkStatus().setStatusText(null);
    }

    protected boolean isAborted(DownloadLink downloadLink) {
        SingleDownloadController singleDownloadController = downloadLink.getDownloadLinkController();
        return singleDownloadController != null && singleDownloadController.isAborted();
    }

    public Browser getBrowser() {
        return this.br;
    }

    public String getBuyPremiumUrl() {
        if (this.premiumurl != null) {
            return "http://jdownloader.org/r.php?u=" + Encoding.urlEncode(this.premiumurl);
        }
        return this.premiumurl;
    }

    public boolean isPremiumEnabled() {
        return this.enablePremium;
    }

    public ArrayList<Account> getPremiumAccounts() {
        return AccountController.getInstance().getAllAccounts(this);
    }

    public String getSessionInfo() {
        return this.getHost();
    }

    public void setDownloadLink(DownloadLink downloadLink) {
        this.link = downloadLink;
    }

    public DownloadLink getDownloadLink() {
        return this.link;
    }

    public boolean rewriteHost(DownloadLink downloadLink) {
        return false;
    }

    public String getCustomFavIconURL() {
        return this.getHost();
    }

    public void setIOPermission(IOPermission iOPermission) {
        this.ioPermission = iOPermission;
    }

    public IOPermission getIOPermission() {
        return this.ioPermission;
    }

    public DomainInfo getDomainInfo() {
        String string = this.getCustomFavIconURL();
        if (string == null) {
            string = this.getHost();
        }
        return DomainInfo.getInstance(string);
    }

    public boolean hasCaptcha() {
        return false;
    }

    public boolean hasAutoCaptcha() {
        return false;
    }
}

