/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins;

import java.io.File;
import java.lang.reflect.Field;
import jd.controlling.JDLogger;
import org.appwork.utils.formatter.StringFormatter;

public class ContainerStatus {
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_FINISHED = 2;
    public static final int TODO = 1;
    private File container;
    private int status = 1;
    private String statusText;
    private int latestStatus;

    public ContainerStatus() {
    }

    public ContainerStatus(File file) {
        this.container = file;
    }

    public void addStatus(int n) {
        this.latestStatus = n;
        this.status |= n;
    }

    public File getContainer() {
        return this.container;
    }

    public boolean hasStatus(int n) {
        return (this.status & n) > 0;
    }

    public boolean isStatus(int n) {
        return this.status == n;
    }

    public void removeStatus(int n) {
        this.status ^= n;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    public String getStatusText() {
        return this.statusText;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var5_8;
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringFormatter.fillString(Integer.toBinaryString(this.status), "0", "", 32) + " <Statuscode\r\n");
        String string = "";
        for (Field field : fieldArray) {
            if (field.getModifiers() != 25) continue;
            try {
                int n = field.getInt(this);
                if (!this.hasStatus(n)) continue;
                if (n == this.latestStatus) {
                    string = "latest:" + field.getName() + "\r\n";
                    stringBuilder.append(StringFormatter.fillString(Integer.toBinaryString(n), "0", "", 32) + " |" + field.getName() + "\r\n");
                    continue;
                }
                stringBuilder.append(StringFormatter.fillString(Integer.toBinaryString(n), "0", "", 32) + " |" + field.getName() + "\r\n");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JDLogger.exception(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                JDLogger.exception(illegalAccessException);
            }
        }
        String string2 = string + stringBuilder;
        if (this.statusText != null) {
            String string3 = string2 + "StatusText: " + this.statusText + "\r\n";
        }
        return var5_8;
    }
}

