/*
 * Decompiled with CFR 0.152.
 */
package jd.parser.html;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import org.appwork.utils.encoding.Hex;
import org.appwork.utils.logging.Log;

public class HTMLParser {
    private static final Httppattern[] linkAndFormPattern = new Httppattern[]{new Httppattern(Pattern.compile("src.*?=.*?['|\"](.*?)['|\"]", 34), 1), new Httppattern(Pattern.compile("src.*?=(.*?)[ |>]", 34), 1), new Httppattern(Pattern.compile("(<[ ]?a[^>]*?href=|<[ ]?form[^>]*?action=)('|\")(.*?)\\2", 34), 3), new Httppattern(Pattern.compile("(<[ ]?a[^>]*?href=|<[ ]?form[^>]*?action=)([^'\"][^\\s]*)", 34), 2), new Httppattern(Pattern.compile("\\[(link|url)\\](.*?)\\[/\\1\\]", 34), 2)};
    private static final String protocolPattern = "(directhttp://https?://|flashget://|https?viajd://|https?://|ccf://|dlc://|ftp://|jd://|rsdf://|jdlist://|file://)";
    private static final Pattern[] basePattern = new Pattern[]{Pattern.compile("href=('|\")(.*?)('|\")", 2), Pattern.compile("src=('|\")(.*?)('|\")", 2), Pattern.compile("(?s)<[ ]?base[^>]*?href=('|\")(.*?)\\1", 2), Pattern.compile("(?s)<[ ]?base[^>]*?(href)=([^'\"][^\\s]*)", 2)};
    private static final Pattern pat1 = Pattern.compile("((directhttp://https?://|flashget://|https?viajd://|https?://|ccf://|dlc://|ftp://|jd://|rsdf://|jdlist://|file://)|(?<!://)www\\.)", 34);
    private static final Pattern protocols = Pattern.compile("((directhttp://https?://|flashget://|https?viajd://|https?://|ccf://|dlc://|ftp://|jd://|rsdf://|jdlist://|file://))");
    private static Pattern mp = null;

    private static HashSet<String> _getHttpLinksDeepWalker(String string, String string2, HashSet<String> hashSet) {
        Object object;
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        if (string == null || (string = string.trim()).length() == 0) {
            return hashSet;
        }
        if ((string.startsWith("directhttp://") || string.startsWith("httpviajd://") || string.startsWith("httpsviajd://")) && hashSet.contains(string)) {
            return hashSet;
        }
        String string3 = new StringBuilder(string).reverse().toString();
        HTMLParser._getHttpLinksFinder(string3, string2, hashSet);
        string3 = null;
        String string4 = Encoding.urlDecode(string, true);
        String string5 = Encoding.Base64Decode(string4);
        string4 = null;
        HTMLParser._getHttpLinksFinder(string5, string2, hashSet);
        string5 = null;
        String[] stringArray = new Regex(string, "unescape\\(('|\")(.*?)('|\")").getColumn(1);
        if (stringArray != null) {
            object = stringArray;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                object2 = Encoding.htmlDecode((String)object2);
                HTMLParser._getHttpLinksFinder((String)object2, string2, hashSet);
            }
            stringArray = null;
        }
        if ((object = new Regex(string, "(([0-9a-fA-F]{2}| )+)").getMatch(0)) != null && ((String)object).length() > 24) {
            try {
                object = ((String)object).replaceAll(" ", "");
                String string6 = Hex.hex2String((String)object);
                object = null;
                HTMLParser._getHttpLinksFinder(string6, string2, hashSet);
                string6 = null;
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    private static HashSet<String> _getHttpLinksFinder(String string, String string2, HashSet<String> hashSet) {
        String string3;
        String string4 = string2;
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        if (string == null || (string = string.trim()).length() == 0) {
            return hashSet;
        }
        if (!string.matches(".*<.*>.*")) {
            int n = new Regex(string, pat1).count();
            if (n == 0) {
                if (!string.contains("href") && !string.contains("src=")) {
                    return hashSet;
                }
            } else if (n == 1 && string.length() < 100 && string.matches("^\"?((directhttp://https?://|flashget://|https?viajd://|https?://|ccf://|dlc://|ftp://|jd://|rsdf://|jdlist://|file://)://|www\\.).*")) {
                if (string.startsWith("file://")) {
                    hashSet.add(string.replaceAll("\\s", "%20"));
                } else {
                    string3 = string.replaceFirst("h.{2,3}://", "http://").replaceFirst("^www\\.", "http://www.").replaceAll("[<>\"]*", "");
                    if (!string3.matches(".*\\s.*")) {
                        hashSet.add(HTMLParser.correctURL(string3));
                    }
                }
            }
        }
        string2 = string2 == null ? "" : string2;
        for (Pattern pattern : basePattern) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(2);
            break;
        }
        String string5 = HTMLParser.getProtocol(string2);
        if (string4 != null && string2 != null && (string2.startsWith("./") || string5 == null)) {
            if (string5 == null) {
                String string6;
                string2 = string2.startsWith("/") || string2.startsWith("./") ? ((string6 = new Regex(string4, "(.*?\\..*?/)").getMatch(0)) != null ? Browser.correctURL(string6 + "/" + string2) : Browser.correctURL(string4 + "/" + string2)) : Browser.correctURL(string4 + "/" + string2);
            }
            String string7 = HTMLParser.getProtocol(string2);
        }
        if (string2 != null && string2.trim().length() > 0) {
            hashSet.add(HTMLParser.correctURL(string2));
        } else {
            string2 = "";
        }
        for (Httppattern httppattern : linkAndFormPattern) {
            Matcher matcher = httppattern.p.matcher(string);
            while (matcher.find()) {
                string3 = matcher.group(httppattern.group);
                if (!((string3 = string3.replaceAll("h.{2,3}://", "http://")).length() > 3 && string3.matches("^(directhttp://https?://|flashget://|https?viajd://|https?://|ccf://|dlc://|ftp://|jd://|rsdf://|jdlist://|file://)://.*") || string3.length() <= 0)) {
                    if (string3.length() > 2 && string3.startsWith("www")) {
                        void var8_12;
                        string3 = (String)var8_12 + "://" + string3;
                    }
                    string3 = string3.charAt(0) == '/' ? "" + string3 : (string3.charAt(0) == '#' ? string2 + string3 : "" + string3);
                }
                string3 = string3.trim();
                try {
                    new URL(string3);
                    hashSet.add(HTMLParser.correctURL(string3));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        if (mp != null) {
            Matcher matcher = mp.matcher(string);
            while (matcher.find()) {
                string3 = matcher.group(0);
                string3 = string3.trim();
                Matcher matcher2 = protocols.matcher(string3);
                int n = -1;
                while (matcher2.find()) {
                    if (n == -1) {
                        n = matcher2.start();
                        continue;
                    }
                    hashSet.add(HTMLParser.correctURL(string3.substring(n, matcher2.start())));
                    n = matcher2.start();
                }
                if (n != -1) {
                    hashSet.add(HTMLParser.correctURL(string3.substring(n)));
                }
                string3 = string3.replaceAll("^h.{2,3}://", "http://");
                string3 = string3.replaceFirst("^www\\.", "http://www\\.");
                hashSet.add(HTMLParser.correctURL(string3));
            }
        }
        return hashSet;
    }

    private static HashSet<String> _getHttpLinksWalker(String string, String string2, HashSet<String> hashSet) {
        String string3;
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        if (string == null || (string = string.trim()).length() == 0) {
            return hashSet;
        }
        while ((string3 = new Regex(string, "<(.*?)>").setMemoryOptimized(false).getMatch(0)) != null && string3.length() != 0) {
            HTMLParser._getHttpLinksWalker(string3, string2, hashSet);
            int n = string.indexOf(62);
            if (n >= 0 && string.length() >= n + 1) {
                int n2 = string.indexOf(60);
                if (n2 > 0 && n2 < n) {
                    String string4 = string.substring(0, n2);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (string4.contains(">")) {
                        stringBuilder.append("<");
                        stringBuilder.append(string4);
                    } else {
                        stringBuilder.append("<");
                        stringBuilder.append(string4);
                        stringBuilder.append(">");
                    }
                    stringBuilder.append(" ");
                    stringBuilder.append(string.substring(n + 1));
                    string = stringBuilder.toString();
                    stringBuilder = null;
                    string4 = null;
                    continue;
                }
                if ((string = string.substring(n + 1)).length() != 0) continue;
                return hashSet;
            }
            if ((string = string.substring(n + 1)).length() != 0) continue;
            return hashSet;
        }
        if (!(string.contains("://") && string.length() >= 10 || string.contains("href") || string.contains("unescape") || string.contains("src="))) {
            return hashSet;
        }
        HTMLParser._getHttpLinksFinder(string, string2, hashSet);
        HTMLParser._getHttpLinksDeepWalker(string, string2, hashSet);
        string3 = new Regex(string, "://[^\r\n]*?/[^\r\n]+\\?.[^\r\n]*?=(.*?)($|\r|\n)").setMemoryOptimized(false).getMatch(0);
        HTMLParser._getHttpLinksDeepWalker(string3, string2, hashSet);
        string3 = new Regex(string, "://[^\r\n]*?/[^\r\n]*?\\?(.*?)($|\r|\n)").setMemoryOptimized(false).getMatch(0);
        HTMLParser._getHttpLinksDeepWalker(string3, string2, hashSet);
        return hashSet;
    }

    private static String ArrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[]{'\"', '\r', '\n'};
        for (String string : stringArray) {
            stringBuilder.append('\"');
            stringBuilder.append(string.trim());
            stringBuilder.append(cArray);
        }
        return stringBuilder.toString();
    }

    private static String correctURL(String string) {
        return string.replaceAll("\\s", "%20");
    }

    public static ArrayList<String> findPasswords(String string) {
        String string2;
        if (string == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.replaceAll("(?s)<!-- .*? -->", "").replaceAll("(?s)<script .*?>.*?</script>", "").replaceAll("(?s)<.*?>", "").replaceAll("Spoiler:", "").replaceAll("(no.{0,2}|kein.{0,8}|ohne.{0,8}|nicht.{0,8})(pw|passwort|password|pass)", "").replaceAll("(pw|passwort|password|pass).{0,12}(nicht|falsch|wrong)", "");
        Pattern pattern = Pattern.compile("(\u00c3\u0090\u00c2\u00bf\u00c3\u0090\u00c2\u00b0\u00c3\u0091\u00e2\u0082\u00ac\u00c3\u0090\u00c2\u00be\u00c3\u0090\u00c2\u00bb\u00c3\u0091\u00c5\u0092|\u00c3\u0090\u00c2\u00bf\u00c3\u0090\u00c2\u00b0\u00c3\u0091\u00ef\u00bf\u00bd\u00c3\u0091\u00ef\u00bf\u00bd|pa?s?w|passwort|password|passw?)[\\s][\\s]*?[\"']([[^\\:\"'\\s]][^\"'\\s]*)[\"']?", 2);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(2);
            if (string2 == null || string2.length() <= 2 || string2.matches(".*(rar|zip|jpg|gif|png|html|php|avi|mpg)$") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        pattern = Pattern.compile("(\u00c3\u0090\u00c2\u00bf\u00c3\u0090\u00c2\u00b0\u00c3\u0091\u00e2\u0082\u00ac\u00c3\u0090\u00c2\u00be\u00c3\u0090\u00c2\u00bb\u00c3\u0091\u00c5\u0092|\u00c3\u0090\u00c2\u00bf\u00c3\u0090\u00c2\u00b0\u00c3\u0091\u00ef\u00bf\u00bd\u00c3\u0091\u00ef\u00bf\u00bd|pa?s?w|passwort|password|passw?)[\\s][\\s]*?([[^\\:\"'\\s]][^\"'\\s]*)[\\s]?", 2);
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(2);
            if (string2 == null || string2.length() <= 4 || string2.matches(".*(rar|zip|jpg|gif|png|html|php|avi|mpg)$") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        pattern = Pattern.compile("(\u00c3\u0090\u00c2\u00bf\u00c3\u0090\u00c2\u00b0\u00c3\u0091\u00e2\u0082\u00ac\u00c3\u0090\u00c2\u00be\u00c3\u0090\u00c2\u00bb\u00c3\u0091\u00c5\u0092|\u00c3\u0090\u00c2\u00bf\u00c3\u0090\u00c2\u00b0\u00c3\u0091\u00ef\u00bf\u00bd\u00c3\u0091\u00ef\u00bf\u00bd|pa?s?w|passwort|password|passw?)[\\s]?(\\:|=)[\\s]*?[\"']([^\"']+)[\"']?", 2);
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(2);
            if (string2 == null || string2.length() <= 2 || string2.matches(".*(rar|zip|jpg|gif|png|html|php|avi|mpg)$") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        pattern = Pattern.compile("(\u00c3\u0090\u00c2\u00bf\u00c3\u0090\u00c2\u00b0\u00c3\u0091\u00e2\u0082\u00ac\u00c3\u0090\u00c2\u00be\u00c3\u0090\u00c2\u00bb\u00c3\u0091\u00c5\u0092|\u00c3\u0090\u00c2\u00bf\u00c3\u0090\u00c2\u00b0\u00c3\u0091\u00ef\u00bf\u00bd\u00c3\u0091\u00ef\u00bf\u00bd|pa?s?w|passwort|password|passw?)[\\s]?(\\:|=[\\s]*?)([^\"'\\s]+)[\\s]?", 2);
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string2 = matcher.group(3);
            if (string2 == null || string2.length() <= 2 || string2.matches(".*(rar|zip|jpg|gif|png|html|php|avi|mpg)$") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String getFormInputHidden(String string) {
        return HTMLParser.joinMap(HTMLParser.getInputHiddenFields(string), "=", "&");
    }

    public static String getFormInputHidden(String string, String string2, String string3) {
        String string4 = new Regex(string, string2 + "(.*?)" + string3).getMatch(0);
        if (string4 == null) {
            return null;
        }
        return HTMLParser.getFormInputHidden(string4);
    }

    public static String getHttpLinkList(String string) {
        return HTMLParser.getHttpLinkList(string, null);
    }

    public static String getHttpLinkList(String string, String string2) {
        String[] stringArray = HTMLParser.getHttpLinks(string, string2);
        return HTMLParser.ArrayToString(stringArray);
    }

    public static String[] getHttpLinks(String string) {
        return HTMLParser.getHttpLinks(string, null);
    }

    public static String[] getHttpLinks(String string, String string2) {
        String[] stringArray = HTMLParser.getHttpLinksIntern(string, string2);
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string3 : stringArray) {
            if (string3.contains("...")) {
                String string4 = string3.substring(0, string3.indexOf("..."));
                String string5 = string3;
                for (String string6 : stringArray) {
                    if (!string6.startsWith(string4) || string6.contains("...")) continue;
                    string5 = string6;
                    break;
                }
                hashSet.add(string5);
                continue;
            }
            hashSet.add(string3);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String[] getHttpLinksIntern(String string, String string2) {
        if ((string = string.trim()).length() == 0) {
            return new String[0];
        }
        string = string.replaceAll("&lt;", ">");
        string = string.replaceAll("&gt;", "<");
        string = string.replaceAll("&amp;", "&");
        string = string.replaceAll("&quot;", "\"");
        string = string.replaceAll("<br.*?>", "\r\n");
        string = string.replaceAll("<wbr>", "");
        string = string.replaceAll("</?(i|b|u|s)>", "");
        string = string.replaceAll("(?s)\\[(url|link)\\].*?\\[/(url|link)\\]", "");
        HashSet<String> hashSet = new HashSet<String>();
        HTMLParser._getHttpLinksWalker(string, string2, hashSet);
        string = null;
        if (hashSet.isEmpty()) {
            return new String[0];
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static HashMap<String, String> getInputHiddenFields(String string) {
        Pattern pattern = Pattern.compile("(?s)<[ ]?input([^>]*?type=['\"]?hidden['\"]?[^>]*?)[/]?>", 2);
        Pattern pattern2 = Pattern.compile("name=['\"]([^'\"]*?)['\"]", 2);
        Pattern pattern3 = Pattern.compile("value=['\"]([^'\"]*?)['\"]", 2);
        Pattern pattern4 = Pattern.compile("name=([^\\s]*)", 2);
        Pattern pattern5 = Pattern.compile("value=([^\\s]*)", 2);
        Matcher matcher = pattern.matcher(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            Matcher matcher2 = pattern2.matcher(matcher.group(1) + " ");
            Matcher matcher3 = pattern3.matcher(matcher.group(1) + " ");
            Matcher matcher4 = pattern4.matcher(matcher.group(1) + " ");
            Matcher matcher5 = pattern5.matcher(matcher.group(1) + " ");
            boolean bl = false;
            String string2 = null;
            String string3 = null;
            if (matcher2.find()) {
                bl = true;
                string3 = matcher2.group(1);
            } else if (matcher4.find()) {
                bl = true;
                string3 = matcher4.group(1);
            }
            if (matcher3.find() && bl) {
                string2 = matcher3.group(1);
            } else if (matcher5.find() && bl) {
                string2 = matcher5.group(1);
            } else {
                bl = false;
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    public static HashMap<String, String> getInputHiddenFields(String string, String string2, String string3) {
        return HTMLParser.getInputHiddenFields(new Regex(string, string2 + "(.*?)" + string3).getMatch(0));
    }

    private static String getProtocol(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.startsWith("directhttp://")) {
            string2 = "directhttp";
        } else if (string.startsWith("https://")) {
            string2 = "https";
        } else if (string.startsWith("jd://")) {
            string2 = "jd";
        } else if (string.startsWith("rsdf://")) {
            string2 = "rsdf";
        } else if (string.startsWith("ccf://")) {
            string2 = "ccf";
        } else if (string.startsWith("dlc://")) {
            string2 = "dlc";
        } else if (string.startsWith("jdlist://")) {
            string2 = "jdlist";
        } else if (string.startsWith("ftp://")) {
            string2 = "ftp";
        } else if (string.startsWith("flashget://")) {
            string2 = "flashget";
        } else if (string.startsWith("http://")) {
            string2 = "http";
        }
        return string2;
    }

    public static String joinMap(Map<String, String> map, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append(string);
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    static {
        try {
            mp = Pattern.compile("((directhttp://https?://|flashget://|https?viajd://|https?://|ccf://|dlc://|ftp://|jd://|rsdf://|jdlist://|file://)|www\\.)[^\\r\\t\\n\\v\\f<>'\"]*(((?!\\s(directhttp://https?://|flashget://|https?viajd://|https?://|ccf://|dlc://|ftp://|jd://|rsdf://|jdlist://|file://)|\\swww\\.)[^<>'\"]){0,20}([\\?|\\&][^<>'^\\r\\t\\n\\v\\f\"]{1,10}\\=[^<>'^\\r\\t\\n\\v\\f\"]+|\\.([a-zA-Z0-9]{2,4})[^<>'^\\r\\t\\n\\v\\f\"]*))?", 2);
        }
        catch (Throwable throwable) {
            Log.exception(throwable);
        }
    }

    static final class Httppattern {
        public Pattern p;
        public int group;

        public Httppattern(Pattern pattern, int n) {
            this.p = pattern;
            this.group = n;
        }
    }
}

