/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Logger;
import jd.nutils.DynByteBuffer;
import jd.nutils.ProcessListener;

public class Executer
extends Thread
implements Runnable {
    public static final String CODEPAGE = Executer.isWindows() ? "ISO-8859-1" : "UTF-8";
    private boolean debug = true;
    private Logger logger;
    private String codepage = CODEPAGE;
    public static int LISTENER_ERRORSTREAM = 1;
    public static int LISTENER_STDSTREAM = 2;
    private String command;
    private ArrayList<String> parameter;
    private String runIn;
    private final DynByteBuffer inputStreamBuffer;
    private final DynByteBuffer errorStreamBuffer;
    private final ArrayList<ProcessListener> listener = new ArrayList();
    private final ArrayList<ProcessListener> elistener = new ArrayList();
    private int waitTimeout = 60;
    private int exitValue = -1;
    private boolean gotInterrupted = false;
    private Process process;
    private StreamObserver sbeObserver;
    private StreamObserver sboObserver;
    private OutputStream outputStream = null;
    private Exception exception = null;

    private static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("windows")) {
            return true;
        }
        return string.contains("nt");
    }

    public Executer(String string) {
        super("Executer: " + string);
        this.command = string;
        this.parameter = new ArrayList();
        this.inputStreamBuffer = new DynByteBuffer(4096);
        this.errorStreamBuffer = new DynByteBuffer(4096);
    }

    public void addParameter(String string) {
        this.parameter.add(string);
    }

    public void addParameters(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            this.parameter.add(string);
        }
    }

    public void addProcessListener(ProcessListener processListener, int n) {
        this.removeProcessListener(processListener, n);
        if ((n & LISTENER_STDSTREAM) > 0) {
            this.listener.add(processListener);
        }
        if ((n & LISTENER_ERRORSTREAM) > 0) {
            this.elistener.add(processListener);
        }
    }

    private void fireEvent(DynByteBuffer dynByteBuffer, int n, int n2) {
        if (this.isInterrupted()) {
            return;
        }
        if ((n2 & LISTENER_STDSTREAM) > 0) {
            for (ProcessListener processListener : this.listener) {
                processListener.onBufferChanged(this, dynByteBuffer, n);
            }
        }
        if ((n2 & LISTENER_ERRORSTREAM) > 0) {
            for (ProcessListener processListener : this.elistener) {
                processListener.onBufferChanged(this, dynByteBuffer, n);
            }
        }
    }

    private void fireEvent(String string, DynByteBuffer dynByteBuffer, int n) {
        if ((n & LISTENER_STDSTREAM) > 0) {
            for (ProcessListener processListener : this.listener) {
                processListener.onProcess(this, string, dynByteBuffer);
            }
        }
        if ((n & LISTENER_ERRORSTREAM) > 0) {
            for (ProcessListener processListener : this.elistener) {
                processListener.onProcess(this, string, dynByteBuffer);
            }
        }
    }

    public String getCodepage() {
        return this.codepage;
    }

    public String getCommand() {
        return this.command;
    }

    public String getErrorStream() {
        return this.errorStreamBuffer.toString(this.codepage);
    }

    public DynByteBuffer getErrorStreamBuffer() {
        return this.errorStreamBuffer;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public DynByteBuffer getInputStreamBuffer() {
        return this.inputStreamBuffer;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getOutputStream() {
        return this.inputStreamBuffer.toString(this.codepage);
    }

    public ArrayList<String> getParameter() {
        return this.parameter;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getRunin() {
        return this.runIn;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public boolean gotInterrupted() {
        return this.gotInterrupted;
    }

    @Override
    public void interrupt() {
        this.gotInterrupted = true;
        super.interrupt();
        if (this.sbeObserver != null) {
            this.sbeObserver.requestInterrupt();
        }
        if (this.sboObserver != null) {
            this.sboObserver.requestInterrupt();
        }
        this.process.destroy();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void removeProcessListener(ProcessListener processListener, int n) {
        if ((n & LISTENER_STDSTREAM) > 0) {
            this.listener.remove(processListener);
        }
        if ((n & LISTENER_ERRORSTREAM) > 0) {
            this.elistener.remove(processListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        if (this.command == null || this.command.trim().length() == 0) {
            if (this.logger != null) {
                this.logger.severe("Execute Parameter error: No Command");
            }
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.command);
        arrayList.addAll(this.parameter);
        if (this.isDebug()) {
            object = new StringBuilder();
            for (String string : arrayList) {
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append(' ');
            }
            if (this.logger != null) {
                this.logger.info("Execute: " + object + " in " + this.runIn);
            }
        }
        object = new ProcessBuilder(arrayList.toArray(new String[0]));
        if (this.runIn != null && this.runIn.length() > 0) {
            if (new File(this.runIn).exists()) {
                ((ProcessBuilder)object).directory(new File(this.runIn));
            } else if (new File((String)arrayList.get(0)).getParentFile().exists()) {
                ((ProcessBuilder)object).directory(new File((String)arrayList.get(0)).getParentFile());
            } else if (this.logger != null) {
                this.logger.severe("Working directory " + this.runIn + " does not exist!");
            }
        }
        try {
            this.process = ((ProcessBuilder)object).start();
            if (this.waitTimeout == 0) {
                return;
            }
            this.outputStream = this.process.getOutputStream();
            this.sbeObserver = new StreamObserver(this.process.getErrorStream(), this.errorStreamBuffer);
            this.sbeObserver.setName(this.getName() + " ERRstreamobserver");
            this.sboObserver = new StreamObserver(this.process.getInputStream(), this.inputStreamBuffer);
            this.sboObserver.setName(this.getName() + " STDstreamobserver");
            this.sbeObserver.start();
            this.sboObserver.start();
            Object object2 = null;
            if (this.waitTimeout > 0) {
                object2 = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(Executer.this.waitTimeout * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Executer.this.interrupt();
                    }
                };
                ((Thread)object2).start();
            }
            try {
                this.process.waitFor();
                this.exitValue = this.process.exitValue();
            }
            catch (InterruptedException interruptedException) {
                this.process.destroy();
                this.gotInterrupted = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    this.outputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (this.logger != null) {
                this.logger.finer("Process returned");
            }
            if (this.sboObserver != null && this.sboObserver.isIdle()) {
                if (this.logger != null) {
                    this.logger.finer("sbo idle - interrupt");
                }
                this.sboObserver.requestInterrupt();
            }
            if (this.sbeObserver != null && this.sbeObserver.isIdle()) {
                if (this.logger != null) {
                    this.logger.finer("sbe idle - interrupt");
                }
                this.sbeObserver.requestInterrupt();
            }
            long l = System.currentTimeMillis();
            Thread.interrupted();
            while (this.sbeObserver != null && this.sbeObserver.isAlive() || this.sboObserver != null && this.sboObserver.isAlive()) {
                Thread.sleep(50L);
                if (System.currentTimeMillis() - l <= 60000L) continue;
                if (this.logger != null) {
                    this.logger.severe("Executer Error. REPORT THIS BUG INCL. THIS LOG to jd support");
                }
                this.sboObserver.requestInterrupt();
                this.sbeObserver.requestInterrupt();
                break;
            }
            if (object2 != null) {
                ((Thread)object2).interrupt();
            }
            if (this.logger != null) {
                this.logger.finer("Stream observer closed");
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            return;
        }
        catch (InterruptedException interruptedException) {
            this.exception = interruptedException;
        }
    }

    public void setCodepage(String string) {
        this.codepage = string;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setParameter(ArrayList<String> arrayList) {
        this.parameter = arrayList;
    }

    public void setRunin(String string) {
        this.runIn = string;
    }

    public void setWaitTimeout(int n) {
        this.waitTimeout = n;
    }

    public void waitTimeout() {
        while (this.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void writetoOutputStream(String string) {
        if (string == null || string.length() == 0) {
            string = "";
        }
        try {
            this.outputStream.write(string.getBytes());
            this.outputStream.write("\n".getBytes());
            if (this.isDebug()) {
                System.out.println("Out>" + string);
            }
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class StreamObserver
    extends Thread
    implements Runnable {
        private final BufferedInputStream reader;
        private final DynByteBuffer dynbuf;
        private boolean started;
        private boolean idle = true;
        private boolean endOfFileReceived = false;
        private final InputStream stream;
        private boolean isClosed = false;
        private final Object LOCK = new Object();

        public StreamObserver(InputStream inputStream, DynByteBuffer dynByteBuffer) {
            this.stream = inputStream;
            this.reader = new BufferedInputStream(inputStream);
            this.dynbuf = dynByteBuffer;
        }

        public boolean isIdle() {
            return this.idle;
        }

        public boolean isStarted() {
            return this.started;
        }

        private int readLine() throws IOException, InterruptedException {
            int n = 0;
            byte[] byArray = new byte[1];
            this.idle = false;
            while (true) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                int n2 = this.reader.read(byArray);
                if (n2 < 0) {
                    this.endOfFileReceived = true;
                    return n;
                }
                if (n2 > 0) {
                    n += n2;
                    this.dynbuf.put(byArray, n2);
                    if (byArray[0] == 8 || byArray[0] == 13 || byArray[0] == 10) {
                        return n;
                    }
                    Executer.this.fireEvent(this.dynbuf, n2, this == Executer.this.sbeObserver ? LISTENER_ERRORSTREAM : LISTENER_STDSTREAM);
                    continue;
                }
                Thread.sleep(100L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestInterrupt() {
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    if (!this.isClosed && this.idle && this.reader.available() > 0) {
                        return;
                    }
                }
                this.isClosed = true;
                super.interrupt();
                this.stream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.started = true;
            try {
                Executer.this.fireEvent(this.dynbuf, 0, this == Executer.this.sbeObserver ? LISTENER_ERRORSTREAM : LISTENER_STDSTREAM);
                while (this.isInterrupted() || this.reader.available() <= 0) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    Thread.sleep(150L);
                }
                Object object = this.LOCK;
                synchronized (object) {
                    this.idle = false;
                }
                while (!this.endOfFileReceived) {
                    int n = this.readLine();
                    try {
                        object = new String(this.dynbuf.getLast(n), Executer.this.codepage).trim();
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                        object = new String(this.dynbuf.getLast(n)).trim();
                    }
                    if (((String)object).length() <= 0) continue;
                    if (Executer.this.isDebug()) {
                        System.out.println(this + ": " + (String)object + "");
                    }
                    Executer.this.fireEvent((String)object, this.dynbuf, this == Executer.this.sbeObserver ? LISTENER_ERRORSTREAM : LISTENER_STDSTREAM);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (Throwable throwable) {}
                try {
                    this.stream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

