/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.util.logging.Logger;
import jd.http.BrowserSettings;
import org.appwork.utils.net.httpconnection.HTTPProxy;

public class BrowserSettingsThread
extends Thread
implements BrowserSettings {
    private HTTPProxy proxy;
    private boolean debug;
    private boolean verbose;
    protected Logger logger;

    public BrowserSettingsThread(Runnable runnable) {
        super(runnable);
        this.copySettings();
    }

    public BrowserSettingsThread(Runnable runnable, String string) {
        super(runnable, string);
        this.copySettings();
    }

    public BrowserSettingsThread(String string) {
        super(string);
        this.copySettings();
    }

    private void copySettings() {
        Thread thread = Thread.currentThread();
        if (thread != null && thread instanceof BrowserSettings) {
            BrowserSettings browserSettings = (BrowserSettings)((Object)thread);
            this.proxy = browserSettings.getCurrentProxy();
            this.debug = browserSettings.isDebug();
            this.verbose = browserSettings.isVerbose();
            this.logger = browserSettings.getLogger();
        }
    }

    @Override
    public HTTPProxy getCurrentProxy() {
        return this.proxy;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setCurrentProxy(HTTPProxy hTTPProxy) {
        this.proxy = hTTPProxy;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }
}

