/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.ChildrenView;
import org.appwork.exceptions.WTFException;
import org.jdownloader.DomainInfo;

public class CrawledPackageView
extends ChildrenView<CrawledLink> {
    private static final long serialVersionUID = 4415726693932960026L;
    protected long fileSize = 0L;
    protected HashMap<DomainInfo, Integer> hostCountMap = new HashMap();
    protected TreeSet<DomainInfo> domainList = new TreeSet();
    private DomainInfo[] domainInfos;
    protected HashSet<CrawledLink> enabled = new HashSet();
    protected HashMap<CrawledLink, Long> sizes;
    private HashSet<CrawledLink> offline = new HashSet();
    private HashSet<CrawledLink> online = new HashSet();

    public CrawledPackageView() {
        this.sizes = new HashMap();
        this.domainInfos = new DomainInfo[0];
    }

    @Override
    public void replace(ArrayList<CrawledLink> arrayList) {
        CrawledPackageView crawledPackageView = new CrawledPackageView();
        crawledPackageView.addAll((Collection<? extends CrawledLink>)arrayList);
        this.fileSize = crawledPackageView.fileSize;
        this.hostCountMap = crawledPackageView.hostCountMap;
        this.domainList = crawledPackageView.domainList;
        this.domainInfos = crawledPackageView.domainInfos;
        this.enabled = crawledPackageView.enabled;
        this.sizes = crawledPackageView.sizes;
        this.offline = crawledPackageView.offline;
        this.online = crawledPackageView.online;
        super.clear();
        super.addAll(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrawledLink set(int n, CrawledLink crawledLink) {
        CrawledLink crawledLink2 = (CrawledLink)this.get(n);
        try {
            CrawledLink crawledLink3 = super.set(n, crawledLink);
            return crawledLink3;
        }
        finally {
            if (crawledLink2 != null) {
                this.removeInfo(crawledLink2);
            }
            this.addInfo(crawledLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(CrawledLink crawledLink) {
        try {
            boolean bl = super.add(crawledLink);
            return bl;
        }
        finally {
            this.addInfo(crawledLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int n, CrawledLink crawledLink) {
        try {
            super.add(n, crawledLink);
        }
        finally {
            this.addInfo(crawledLink);
        }
    }

    private void addInfo(CrawledLink crawledLink) {
        DomainInfo domainInfo = crawledLink.getDomainInfo();
        Integer n = this.hostCountMap.get(domainInfo);
        if (n == null) {
            n = 0;
        }
        this.hostCountMap.put(domainInfo, n + 1);
        this.domainList.add(domainInfo);
        this.domainInfos = this.domainList.toArray(new DomainInfo[0]);
        if (crawledLink.isEnabled()) {
            this.enabled.add(crawledLink);
        }
        if (crawledLink.getLinkState() == CrawledLink.LinkState.OFFLINE) {
            this.offline.add(crawledLink);
        } else if (crawledLink.getLinkState() == CrawledLink.LinkState.ONLINE) {
            this.online.add(crawledLink);
        }
        this.sizes.put(crawledLink, crawledLink.getSize());
        this.fileSize += this.sizes.get(crawledLink).longValue();
    }

    private void removeInfo(CrawledLink crawledLink) {
        DomainInfo domainInfo = crawledLink.getDomainInfo();
        Integer n = this.hostCountMap.get(domainInfo);
        if (n == null || n < 1) {
            throw new WTFException("cannot remove element. Is not there");
        }
        if (n == 1) {
            this.hostCountMap.remove(domainInfo);
            this.domainList.remove(domainInfo);
        } else {
            this.hostCountMap.put(domainInfo, n - 1);
        }
        this.domainInfos = this.domainList.toArray(new DomainInfo[0]);
        this.enabled.remove(crawledLink);
        this.offline.remove(crawledLink);
        this.online.remove(crawledLink);
        this.fileSize -= this.sizes.get(crawledLink).longValue();
        if (this.fileSize < 0L) {
            throw new WTFException("Filesize cannot be less than 0");
        }
    }

    @Override
    public CrawledLink remove(int n) {
        CrawledLink crawledLink = (CrawledLink)super.remove(n);
        this.removeInfo(crawledLink);
        return crawledLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        try {
            boolean bl = super.remove(object);
            return bl;
        }
        finally {
            if (object instanceof CrawledLink) {
                this.removeInfo((CrawledLink)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            super.clear();
        }
        finally {
            this.fileSize = 0L;
            this.hostCountMap.clear();
            this.domainList.clear();
            this.offline.clear();
            this.online.clear();
            this.enabled.clear();
            this.sizes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends CrawledLink> collection) {
        try {
            boolean bl = super.addAll(collection);
            return bl;
        }
        finally {
            for (CrawledLink crawledLink : collection) {
                this.addInfo(crawledLink);
            }
        }
    }

    @Override
    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n, Collection<? extends CrawledLink> collection) {
        try {
            boolean bl = super.addAll(n, collection);
            return bl;
        }
        finally {
            for (CrawledLink crawledLink : collection) {
                this.addInfo(crawledLink);
            }
        }
    }

    @Override
    protected void removeRange(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.get(i));
        }
        super.removeRange(n, n2);
        for (CrawledLink crawledLink : arrayList) {
            if (crawledLink == null) continue;
            this.removeInfo(crawledLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        try {
            boolean bl = super.removeAll(collection);
            return bl;
        }
        finally {
            for (Object obj : collection) {
                if (obj == null || !(obj instanceof CrawledLink)) continue;
                this.removeInfo((CrawledLink)obj);
            }
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new WTFException("Not supported");
    }

    public void updateInfo(CrawledLink crawledLink) {
        this.removeInfo(crawledLink);
        this.addInfo(crawledLink);
    }

    @Override
    public DomainInfo[] getDomainInfos() {
        return this.domainInfos;
    }

    public boolean isEnabled() {
        return this.enabled.size() > 0;
    }

    public int getOfflineCount() {
        return this.offline.size();
    }

    public int getOnlineCount() {
        return this.online.size();
    }

    public long getFileSize() {
        return this.fileSize;
    }
}

