/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import javax.swing.ImageIcon;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcrawler.BrokenCrawlerHandler;
import jd.controlling.linkcrawler.CheckableLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.PackageInfo;
import jd.controlling.linkcrawler.UnknownCrawledLinkHandler;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.http.Browser;
import jd.plugins.CryptedLink;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import org.appwork.utils.StringUtils;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.filter.FilterRule;

public class CrawledLink
implements AbstractPackageChildrenNode<CrawledPackage>,
CheckableLink,
AbstractNodeNotifier<DownloadLink> {
    protected static final String PACKAGETAG = "<jd:packagename>";
    private boolean crawlDeep = false;
    private CrawledPackage parent = null;
    private UnknownCrawledLinkHandler unknownHandler = null;
    private CrawledLinkModifier modifyHandler = null;
    private BrokenCrawlerHandler brokenCrawlerHandler = null;
    private boolean autoConfirmEnabled = false;
    private boolean autoStartEnabled = false;
    private PluginForDecrypt dPlugin = null;
    private LinkCollectingJob sourceJob = null;
    private long created = -1L;
    boolean enabledState = true;
    private PackageInfo desiredPackageInfo = null;
    private PluginForHost hPlugin = null;
    private PluginsC cPlugin = null;
    private DownloadLink dlLink = null;
    private CryptedLink cLink = null;
    private String url;
    private CrawledLink sourceLink = null;
    private String name = null;
    private FilterRule matchingFilter;

    public boolean isCrawlDeep() {
        return this.crawlDeep;
    }

    public void setCrawlDeep(boolean bl) {
        this.crawlDeep = bl;
    }

    public boolean isAutoConfirmEnabled() {
        return this.autoConfirmEnabled;
    }

    public void setAutoConfirmEnabled(boolean bl) {
        this.autoConfirmEnabled = bl;
    }

    public boolean isAutoStartEnabled() {
        return this.autoStartEnabled;
    }

    public void setAutoStartEnabled(boolean bl) {
        this.autoStartEnabled = bl;
    }

    public UnknownCrawledLinkHandler getUnknownHandler() {
        return this.unknownHandler;
    }

    public void setUnknownHandler(UnknownCrawledLinkHandler unknownCrawledLinkHandler) {
        this.unknownHandler = unknownCrawledLinkHandler;
    }

    public PackageInfo getDesiredPackageInfo() {
        return this.desiredPackageInfo;
    }

    public void setDesiredPackageInfo(PackageInfo packageInfo) {
        this.desiredPackageInfo = packageInfo;
    }

    public String getLinkID() {
        if (this.dlLink != null) {
            return this.dlLink.getLinkID();
        }
        return this.getURL();
    }

    public LinkCollectingJob getSourceJob() {
        return this.sourceJob;
    }

    public void setSourceJob(LinkCollectingJob linkCollectingJob) {
        this.sourceJob = linkCollectingJob;
    }

    public PluginForDecrypt getdPlugin() {
        return this.dPlugin;
    }

    public void setdPlugin(PluginForDecrypt pluginForDecrypt) {
        this.dPlugin = pluginForDecrypt;
    }

    public long getSize() {
        if (this.dlLink != null) {
            return this.dlLink.getDownloadSize();
        }
        return -1L;
    }

    public PluginForHost gethPlugin() {
        if (this.hPlugin != null) {
            return this.hPlugin;
        }
        if (this.dlLink != null) {
            return this.dlLink.getDefaultPlugin();
        }
        return null;
    }

    public void sethPlugin(PluginForHost pluginForHost) {
        this.hPlugin = pluginForHost;
    }

    public PluginsC getcPlugin() {
        return this.cPlugin;
    }

    public void setcPlugin(PluginsC pluginsC) {
        this.cPlugin = pluginsC;
    }

    @Override
    public DownloadLink getDownloadLink() {
        return this.dlLink;
    }

    public CryptedLink getCryptedLink() {
        return this.cLink;
    }

    public CrawledLink(DownloadLink downloadLink) {
        this.dlLink = downloadLink;
        if (downloadLink != null) {
            downloadLink.setNodeChangeListener(this);
        }
    }

    public void setDownloadLink(DownloadLink downloadLink) {
        if (this.dlLink != null) {
            this.dlLink.setNodeChangeListener(null);
        }
        this.dlLink = downloadLink;
        if (downloadLink != null) {
            downloadLink.setNodeChangeListener(this);
        }
    }

    public CrawledLink(CryptedLink cryptedLink) {
        this.cLink = cryptedLink;
    }

    public CrawledLink(String string) {
        if (string == null) {
            return;
        }
        this.url = new String(string);
    }

    @Override
    public String getName() {
        String string = this.name;
        if (string != null) {
            CrawledPackage crawledPackage = this.getParentNode();
            if (crawledPackage == null) {
                return string;
            }
            return this.name.replace(PACKAGETAG, crawledPackage.getName());
        }
        if (this.dlLink != null) {
            return this.dlLink.getName();
        }
        return "DUMMY";
    }

    public int getChunks() {
        if (this.dlLink != null) {
            return this.dlLink.getChunks();
        }
        return -1;
    }

    public void setChunks(int n) {
        if (this.dlLink != null) {
            this.dlLink.setChunks(n);
        }
    }

    public void setName(String string) {
        this.name = StringUtils.isEmpty(string) ? null : string;
    }

    public String _getName() {
        return this.name;
    }

    public boolean isNameSet() {
        return this.name != null;
    }

    public String getHost() {
        if (this.dlLink != null) {
            return this.dlLink.getHost();
        }
        return null;
    }

    public ImageIcon getIcon() {
        if (this.dlLink != null) {
            return this.dlLink.getIcon();
        }
        return null;
    }

    public String getURL() {
        if (this.dlLink != null) {
            return this.dlLink.getDownloadURL();
        }
        if (this.cLink != null) {
            return this.cLink.getCryptedUrl();
        }
        if (this.url != null) {
            return this.url;
        }
        return null;
    }

    public String toString() {
        CrawledLink crawledLink = this.sourceLink;
        StringBuilder stringBuilder = new StringBuilder();
        if (crawledLink != null) {
            stringBuilder.append(crawledLink.toString() + "-->");
        }
        if (this.url != null) {
            stringBuilder.append("URL:" + this.getURL());
        }
        if (this.dlLink != null) {
            stringBuilder.append("DLLink:" + this.getURL());
        }
        if (this.cLink != null) {
            stringBuilder.append("CLink:" + this.getURL());
        }
        return stringBuilder.toString();
    }

    @Override
    public CrawledPackage getParentNode() {
        return this.parent;
    }

    @Override
    public void setParentNode(CrawledPackage crawledPackage) {
        this.parent = crawledPackage;
    }

    @Override
    public boolean isEnabled() {
        return this.enabledState;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl == this.enabledState) {
            return;
        }
        this.enabledState = bl;
        this.notifyChanges();
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long l) {
        this.created = l;
    }

    @Override
    public long getFinishedDate() {
        return 0L;
    }

    public CrawledLink getSourceLink() {
        return this.sourceLink;
    }

    public CrawledLink getOriginLink() {
        if (this.sourceLink == null) {
            return this;
        }
        return this.sourceLink.getOriginLink();
    }

    public void setSourceLink(CrawledLink crawledLink) {
        this.sourceLink = crawledLink;
    }

    public void setMatchingFilter(FilterRule filterRule) {
        this.matchingFilter = filterRule;
    }

    public FilterRule getMatchingFilter() {
        return this.matchingFilter;
    }

    public LinkState getLinkState() {
        if (this.dlLink != null) {
            switch (this.dlLink.getAvailableStatus()) {
                case FALSE: {
                    return LinkState.OFFLINE;
                }
                case TRUE: {
                    return LinkState.ONLINE;
                }
                case UNCHECKABLE: {
                    return LinkState.TEMP_UNKNOWN;
                }
                case UNCHECKED: {
                    return LinkState.UNKNOWN;
                }
            }
            return LinkState.UNKNOWN;
        }
        return LinkState.UNKNOWN;
    }

    public Priority getPriority() {
        try {
            if (this.dlLink == null) {
                return Priority.DEFAULT;
            }
            return Priority.values()[this.dlLink.getPriority() + 1];
        }
        catch (Throwable throwable) {
            return Priority.DEFAULT;
        }
    }

    public void setPriority(Priority priority) {
        if (this.dlLink != null) {
            this.dlLink.setPriority(priority.getId());
        }
    }

    public boolean hasAutoCaptcha() {
        if (this.gethPlugin() != null) {
            return this.gethPlugin().hasAutoCaptcha();
        }
        return true;
    }

    public boolean hasCaptcha() {
        if (this.gethPlugin() != null) {
            return this.gethPlugin().hasCaptcha();
        }
        return false;
    }

    @Override
    public DomainInfo getDomainInfo() {
        if (this.dlLink != null) {
            return this.dlLink.getDomainInfo();
        }
        return DomainInfo.getInstance(Browser.getHost(this.getURL(), false));
    }

    public CrawledLinkModifier getCustomCrawledLinkModifier() {
        return this.modifyHandler;
    }

    public void setCustomCrawledLinkModifier(CrawledLinkModifier crawledLinkModifier) {
        this.modifyHandler = crawledLinkModifier;
    }

    public void setBrokenCrawlerHandler(BrokenCrawlerHandler brokenCrawlerHandler) {
        this.brokenCrawlerHandler = brokenCrawlerHandler;
    }

    public BrokenCrawlerHandler getBrokenCrawlerHandler() {
        return this.brokenCrawlerHandler;
    }

    @Override
    public void nodeUpdated(DownloadLink downloadLink) {
        this.notifyChanges();
    }

    private void notifyChanges() {
        CrawledPackage crawledPackage = this.parent;
        if (crawledPackage != null) {
            crawledPackage.nodeUpdated(this);
        }
    }

    public static enum LinkState {
        ONLINE,
        OFFLINE,
        UNKNOWN,
        TEMP_UNKNOWN;

    }
}

