/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.authentication;

import java.util.ArrayList;
import jd.controlling.authentication.AuthenticationControllerSettings;
import jd.controlling.authentication.AuthenticationInfo;
import jd.http.Browser;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.predefined.changeevent.ChangeEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeEventSender;
import org.appwork.utils.logging.Log;

public class AuthenticationController {
    private static final AuthenticationController INSTANCE = new AuthenticationController();
    private AuthenticationControllerSettings config;
    private ArrayList<AuthenticationInfo> list;
    private ChangeEventSender eventSender = new ChangeEventSender();

    public static AuthenticationController getInstance() {
        return INSTANCE;
    }

    private AuthenticationController() {
        this.config = JsonConfig.create(AuthenticationControllerSettings.class);
        this.list = this.cleanup(this.config.getList());
        if (this.list == null) {
            this.list = new ArrayList();
        }
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            @Override
            public void run() {
                AuthenticationController.this.config.setList(AuthenticationController.this.list);
            }

            @Override
            public String toString() {
                return "save auths...";
            }
        });
    }

    public ChangeEventSender getEventSender() {
        return this.eventSender;
    }

    public synchronized ArrayList<AuthenticationInfo> list() {
        return new ArrayList<AuthenticationInfo>(this.list);
    }

    private ArrayList<AuthenticationInfo> cleanup(ArrayList<AuthenticationInfo> arrayList) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<AuthenticationInfo> arrayList2 = new ArrayList<AuthenticationInfo>(arrayList.size());
        for (AuthenticationInfo authenticationInfo : arrayList) {
            if (StringUtils.isEmpty(authenticationInfo.getHostmask()) || StringUtils.isEmpty(authenticationInfo.getPassword()) && StringUtils.isEmpty(authenticationInfo.getPassword())) continue;
            arrayList2.add(authenticationInfo);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AuthenticationInfo authenticationInfo) {
        if (authenticationInfo == null) {
            return;
        }
        AuthenticationController authenticationController = this;
        synchronized (authenticationController) {
            ArrayList<AuthenticationInfo> arrayList = new ArrayList<AuthenticationInfo>(this.list);
            arrayList.add(authenticationInfo);
            this.list = arrayList;
            this.config.setList(this.list);
        }
        this.eventSender.fireEvent(new ChangeEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(AuthenticationInfo authenticationInfo) {
        if (authenticationInfo == null) {
            return;
        }
        AuthenticationController authenticationController = this;
        synchronized (authenticationController) {
            ArrayList<AuthenticationInfo> arrayList = new ArrayList<AuthenticationInfo>(this.list);
            arrayList.remove(authenticationInfo);
            this.list = arrayList;
            this.config.setList(this.list);
        }
        this.eventSender.fireEvent(new ChangeEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ArrayList<AuthenticationInfo> arrayList) {
        if (arrayList == null) {
            return;
        }
        AuthenticationController authenticationController = this;
        synchronized (authenticationController) {
            ArrayList<AuthenticationInfo> arrayList2 = new ArrayList<AuthenticationInfo>(this.list);
            arrayList2.removeAll(arrayList);
            this.list = arrayList2;
            this.config.setList(this.list);
        }
        this.eventSender.fireEvent(new ChangeEvent(this));
    }

    public String[] getLogins(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        AuthenticationInfo.Type type = null;
        if (string.startsWith("ftp")) {
            type = AuthenticationInfo.Type.FTP;
        } else if (string.startsWith("http")) {
            type = AuthenticationInfo.Type.HTTP;
        } else {
            Log.L.info("Unknown Protocoll: " + string);
            return null;
        }
        ArrayList<AuthenticationInfo> arrayList = this.list;
        AuthenticationInfo authenticationInfo = null;
        String string2 = Browser.getHost(string, true);
        for (AuthenticationInfo authenticationInfo2 : arrayList) {
            if (!authenticationInfo2.isEnabled()) continue;
            String string3 = authenticationInfo2.getHostmask();
            if (!authenticationInfo2.getType().equals((Object)type) || StringUtils.isEmpty(string3)) continue;
            boolean bl = false;
            bl = string3.length() > string2.length() ? string3.contains(string2) : string2.contains(string3);
            if (!bl) continue;
            if (authenticationInfo == null) {
                authenticationInfo = authenticationInfo2;
                continue;
            }
            if (string3.length() > string2.length() || authenticationInfo2.getHostmask().length() <= authenticationInfo.getHostmask().length()) continue;
            authenticationInfo = authenticationInfo2;
        }
        if (authenticationInfo == null) {
            return null;
        }
        return new String[]{authenticationInfo.getUsername(), authenticationInfo.getPassword()};
    }
}

