/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import jd.controlling.JDLogger;

public class LogFormatter
extends SimpleFormatter {
    private final Date dat = new Date();
    private final DateFormat longTimestamp = DateFormat.getDateTimeInstance(3, 2);
    private final String lineSeparator = System.getProperty("line.separator");
    private int lastThreadID;

    @Override
    public synchronized String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.dat.setTime(logRecord.getMillis());
        String string = this.formatMessage(logRecord);
        int n = logRecord.getThreadID();
        if (n != this.lastThreadID) {
            stringBuilder.append("\r\n------------------------  Thread: ");
            stringBuilder.append(n);
            stringBuilder.append("  -----------------------\r\n");
        }
        this.lastThreadID = n;
        if (JDLogger.getLogger().getLevel() == Level.ALL) {
            stringBuilder.append(logRecord.getThreadID());
            stringBuilder.append(' ');
            stringBuilder.append(this.longTimestamp.format(this.dat));
            stringBuilder.append(" - ");
            stringBuilder.append(logRecord.getLevel().getName());
            stringBuilder.append(" [");
            if (logRecord.getSourceClassName() != null) {
                stringBuilder.append(logRecord.getSourceClassName());
            } else {
                stringBuilder.append(logRecord.getLoggerName());
            }
            if (logRecord.getSourceMethodName() != null) {
                stringBuilder.append('(');
                stringBuilder.append(logRecord.getSourceMethodName());
                stringBuilder.append(')');
            }
            stringBuilder.append("] ");
            stringBuilder.append("-> ");
        } else {
            stringBuilder.append(this.longTimestamp.format(this.dat));
            stringBuilder.append(" - ");
            if (logRecord.getSourceClassName() != null) {
                stringBuilder.append(logRecord.getSourceClassName().substring(logRecord.getSourceClassName().lastIndexOf(".") + 1));
            } else {
                stringBuilder.append(logRecord.getLoggerName());
            }
            stringBuilder.append("-> ");
        }
        stringBuilder.append(string);
        stringBuilder.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            stringBuilder.append(JDLogger.getStackTrace(logRecord.getThrown()));
        }
        return stringBuilder.toString();
    }
}

