/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import jd.config.Property;
import jd.config.SubConfiguration;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageEvent;
import org.appwork.storage.StorageKeyAddedEvent;
import org.appwork.storage.StorageKeyRemovedEvent;
import org.appwork.storage.StorageValueChangeEvent;
import org.appwork.storage.TypeRef;
import org.appwork.utils.event.DefaultEventListener;
import org.appwork.utils.logging.Log;
import org.appwork.utils.reflection.Clazz;

public class JSonWrapper
extends Property
implements DefaultEventListener<StorageEvent<?>> {
    private static final long serialVersionUID = 1L;
    private static HashMap<Storage, JSonWrapper> MAP = new HashMap();
    private Storage storage;
    private String path;
    private boolean plain;
    private static final HashMap<String, TypeRef<?>> MAPPING = new HashMap();

    private JSonWrapper(Storage storage) {
        this.storage = storage;
        this.storage.getEventSender().addListener(this);
        String string = ((JsonKeyValueStorage)this.storage).getFile().getAbsolutePath();
        this.path = string.substring(0, string.length() - (string.endsWith(".json") ? 5 : 4));
        this.plain = ((JsonKeyValueStorage)this.storage).isPlain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSonWrapper get(String string) {
        HashMap<Storage, JSonWrapper> hashMap = MAP;
        synchronized (hashMap) {
            Storage storage = JSonStorage.getPlainStorage(string);
            JSonWrapper jSonWrapper = MAP.get(storage);
            if (jSonWrapper == null) {
                jSonWrapper = new JSonWrapper(storage);
                if (storage.size() == 0) {
                    JSonWrapper.convert(string, jSonWrapper);
                }
                MAP.put(storage, jSonWrapper);
            }
            return jSonWrapper;
        }
    }

    public int size() {
        return this.storage.size();
    }

    private static void convert(String string, JSonWrapper jSonWrapper) {
        SubConfiguration subConfiguration = SubConfiguration.getConfig(string);
        HashMap<String, Object> hashMap = subConfiguration.getProperties();
        if (hashMap != null && hashMap.size() > 0) {
            Iterator<Map.Entry<String, Object>> iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                try {
                    jSonWrapper.setProperty(entry.getKey(), entry.getValue());
                }
                catch (Throwable throwable) {
                    Log.exception(throwable);
                }
                iterator.remove();
            }
            subConfiguration.setProperties(hashMap);
            subConfiguration.save();
            jSonWrapper.save();
        }
    }

    @Override
    public <E> E getGenericProperty(String string, E e) {
        if (e == null || Clazz.isPrimitive(e.getClass())) {
            return this.storage.get(string, e);
        }
        System.out.println("Read " + this.path + "." + string + (this.plain ? ".json" : ".ejs"));
        return JSonStorage.restoreFrom(new File(this.path + "." + string + (this.plain ? ".json" : ".ejs")), e);
    }

    @Override
    public Boolean getBooleanProperty(String string) {
        return this.storage.get(string, false);
    }

    @Override
    public Boolean getBooleanProperty(String string, boolean bl) {
        return this.storage.get(string, bl);
    }

    @Override
    public Double getDoubleProperty(String string) {
        return this.storage.get(string, -1.0);
    }

    @Override
    public Double getDoubleProperty(String string, Double d) {
        return this.storage.get(string, d);
    }

    @Override
    public int getIntegerProperty(String string) {
        return this.storage.get(string, -1);
    }

    @Override
    public long getLongProperty(String string, long l) {
        return this.storage.get(string, l);
    }

    @Override
    public int getIntegerProperty(String string, int n) {
        return this.storage.get(string, n);
    }

    @Override
    public HashMap<String, Object> getProperties() {
        throw new RuntimeException("no Implemented");
    }

    @Override
    public Object getProperty(String string) {
        try {
            if (this.storage.hasProperty(string)) {
                return this.storage.get(string, null);
            }
            if (this.getObjectKey(string).exists()) {
                return this.getProperty(string, null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    @Override
    public Object getProperty(String string, Object object) {
        try {
            if (this.storage.hasProperty(string)) {
                return this.storage.get(string, null);
            }
            if (this.getObjectKey(string).exists()) {
                if (object != null) {
                    return JSonStorage.restoreFrom(this.getObjectKey(string), object);
                }
                TypeRef<?> typeRef = this.getType(string);
                System.out.println("Read " + this.path + "." + string + (this.plain ? ".json" : ".ejs"));
                if (typeRef == null) {
                    Log.exception(new Exception(this.path + ".json." + string + " type missing"));
                }
                return JSonStorage.restoreFrom(this.getObjectKey(string), true, null, typeRef, null);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return object;
    }

    private TypeRef<?> getType(String string) {
        return MAPPING.get(((JsonKeyValueStorage)this.storage).getFile().getName() + "." + string);
    }

    @Override
    public String getStringProperty(String string) {
        return this.storage.get(string, null);
    }

    @Override
    public String getStringProperty(String string, String string2) {
        return this.storage.get(string, string2);
    }

    @Override
    public boolean hasProperty(String string) {
        if (this.storage.hasProperty(string)) {
            return true;
        }
        return this.getObjectKey(string).exists();
    }

    @Override
    public void setProperties(HashMap<String, Object> hashMap) {
        throw new RuntimeException("no Implemented");
    }

    @Override
    public void setProperty(String string, Object object) {
        if (object == null) {
            this.storage.remove(string);
        } else if (object instanceof Boolean) {
            this.storage.put(string, (Boolean)object);
        } else if (object instanceof Long) {
            this.storage.put(string, (Long)object);
        } else if (object instanceof Integer) {
            this.storage.put(string, (Integer)object);
        } else if (object instanceof Byte) {
            this.storage.put(string, (Byte)object);
        } else if (object instanceof String) {
            this.storage.put(string, (String)object);
        } else if (object instanceof Double) {
            this.storage.put(string, (Double)object);
        } else {
            System.out.println("Write " + this.path + "." + string + (this.plain ? ".json" : ".ejs"));
            JSonStorage.saveTo(this.getObjectKey(string), object);
        }
    }

    private File getObjectKey(String string) {
        return new File(this.path + "." + string + (this.plain ? ".json" : ".ejs"));
    }

    @Override
    public boolean hasChanges() {
        return this.changes;
    }

    @Override
    public String toString() {
        return this.storage.toString();
    }

    @Override
    public void onEvent(StorageEvent<?> storageEvent) {
        if (!(storageEvent instanceof StorageKeyAddedEvent)) {
            if (storageEvent instanceof StorageValueChangeEvent) {
                if (((StorageValueChangeEvent)storageEvent).hasChanged()) {
                    this.changes = true;
                }
            } else if (storageEvent instanceof StorageKeyRemovedEvent) {
                this.changes = true;
            }
        }
    }

    public void save() {
        this.storage.save();
    }

    static {
        MAPPING.put("folderwatch.json.FOLDER_LIST", new TypeRef<Vector<String>>(){});
    }
}

