/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.io.Serializable;
import java.util.HashMap;
import jd.config.Property;
import jd.controlling.JDLogger;
import jd.utils.JDUtilities;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.Storage;

public class SubConfiguration
extends Property
implements Serializable {
    private static final long serialVersionUID = 7803718581558607222L;
    private static transient boolean SUBCONFIG_LOCK = false;
    protected String name;
    transient boolean valid = false;
    private Storage json = null;
    private static transient HashMap<String, SubConfiguration> SUB_CONFIGS = new HashMap();

    public SubConfiguration() {
    }

    private SubConfiguration(String string) {
        this.valid = true;
        this.name = string;
        this.json = JSonStorage.getStorage("subconf_" + string);
        this.setProperties(((JsonKeyValueStorage)this.json).getInternalStorageMap());
        if (this.json.size() == 0) {
            Object object = JDUtilities.getDatabaseConnector().getData(string);
            if (object != null && object instanceof HashMap) {
                HashMap hashMap = (HashMap)object;
                if (hashMap.isEmpty()) {
                    hashMap = new HashMap();
                }
                ((JsonKeyValueStorage)this.json).getInternalStorageMap().putAll(hashMap);
            } else if (object != null) {
                this.valid = false;
                JDLogger.getLogger().severe("Invalid Config Entry for " + string);
            }
        }
        this.json.put("saveWorkaround", System.currentTimeMillis());
    }

    public void save() {
        if (this.valid) {
            this.json.save();
            this.changes = false;
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean hasConfig(String string) {
        if (SUBCONFIG_LOCK) {
            JDLogger.exception(new Exception("Static Database init error!!"));
        }
        SUBCONFIG_LOCK = true;
        try {
            if (SUB_CONFIGS.containsKey(string)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = JDUtilities.getDatabaseConnector().hasData(string);
            return bl;
        }
        finally {
            SUBCONFIG_LOCK = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SubConfiguration getConfig(String string) {
        if (SUBCONFIG_LOCK) {
            JDLogger.exception(new Exception("Static Database init error!!"));
        }
        SUBCONFIG_LOCK = true;
        try {
            if (SUB_CONFIGS.containsKey(string)) {
                SubConfiguration subConfiguration = SUB_CONFIGS.get(string);
                return subConfiguration;
            }
            SubConfiguration subConfiguration = new SubConfiguration(string);
            SUB_CONFIGS.put(string, subConfiguration);
            subConfiguration.save();
            SubConfiguration subConfiguration2 = subConfiguration;
            return subConfiguration2;
        }
        finally {
            SUBCONFIG_LOCK = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void removeConfig(String string) {
        if (SUBCONFIG_LOCK) {
            JDLogger.exception(new Exception("Static Database init error!!"));
        }
        SUBCONFIG_LOCK = true;
        try {
            SUB_CONFIGS.remove(string);
            JDUtilities.getDatabaseConnector().removeData(string);
        }
        finally {
            SUBCONFIG_LOCK = false;
        }
    }
}

