/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.pf.file.FileUtil;
import org.pf.text.StringUtil;

public class FileLocator {
    private static final boolean DEBUG = false;
    private static final String FILE_PROTOCOL_INDICATOR = "file:" + File.separator;
    private static final String ARCHIVE_INDICATOR = "!" + File.separator;
    private FileLocator parent = null;
    private File file = null;
    private ZipFile zipFile = null;
    private boolean exists = true;
    private Exception exception = null;

    protected FileLocator getParent() {
        return this.parent;
    }

    protected void setParent(FileLocator fileLocator) {
        this.parent = fileLocator;
    }

    protected File getFile() {
        return this.file;
    }

    protected void setFile(File file) {
        this.file = file;
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    protected void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    protected boolean getExists() {
        return this.exists;
    }

    protected void setExists(boolean bl) {
        this.exists = bl;
    }

    protected Exception getException() {
        return this.exception;
    }

    protected void setException(Exception exception) {
        this.exception = exception;
    }

    public static FileLocator create(File file) {
        FileLocator fileLocator = new FileLocator();
        return fileLocator.createFrom(file);
    }

    public static FileLocator create(String string) {
        return FileLocator.create(new File(string));
    }

    private static FileLocator newWith(FileLocator fileLocator, String[] stringArray) throws Exception {
        FileLocator fileLocator2 = new FileLocator();
        return fileLocator2.createFrom(fileLocator, stringArray);
    }

    private FileLocator() {
    }

    public File realFile() {
        File file;
        try {
            file = this.fileRef();
        }
        catch (Exception exception) {
            file = null;
        }
        return file;
    }

    public boolean exists() {
        return this.getExists();
    }

    public boolean isFile() {
        try {
            if (this.exists()) {
                return this.isFileElement(this.getFile());
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDirectory() {
        try {
            if (this.exists()) {
                return !this.isFileElement(this.getFile());
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public long size() {
        try {
            if (this.isInArchive()) {
                ZipEntry zipEntry = this.archiveEntry();
                return zipEntry.getSize();
            }
            return this.getFile().length();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long lastModified() {
        try {
            if (this.isInArchive()) {
                ZipEntry zipEntry = this.archiveEntry();
                return zipEntry.getTime();
            }
            return this.getFile().lastModified();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public InputStream getInputStream() throws Exception {
        if (this.isInArchive()) {
            ZipEntry zipEntry = this.archiveEntry();
            return this.container().getInputStream(zipEntry);
        }
        return new FileInputStream(this.getFile());
    }

    public boolean isInArchive() {
        return this.getParent() != null;
    }

    public String getPath() {
        return this.fullFilePath(false).getPath();
    }

    public String getAbsolutePath() {
        return this.fullFilePath(true).getPath();
    }

    public String getStandardizedPath() {
        return this.fileUtil().standardize(this.getPath());
    }

    public String getStandardizedAbsolutePath() {
        return this.fileUtil().standardize(this.getAbsolutePath());
    }

    public Exception exception() {
        return this.getException();
    }

    public URL toURL() throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        this.urlPath(stringBuffer);
        return new URL(stringBuffer.toString());
    }

    protected FileLocator createFrom(File file) {
        FileLocator fileLocator = null;
        String[] stringArray = null;
        File file2 = file;
        if (file2.getPath().startsWith(FILE_PROTOCOL_INDICATOR)) {
            file2 = this.convertFromURLSyntax(file2);
        }
        stringArray = this.str().parts(file2.getPath(), File.separator);
        try {
            fileLocator = this.initFromPath(stringArray, file2.getPath().startsWith(File.separator));
        }
        catch (Exception exception) {
            this.setException(exception);
            this.doesNotExist(file2);
            fileLocator = this;
        }
        return fileLocator;
    }

    private FileLocator createFrom(FileLocator fileLocator, String[] stringArray) throws Exception {
        this.setParent(fileLocator);
        return this.initFromPath(stringArray, false);
    }

    protected FileLocator initFromPath(String[] stringArray, boolean bl) throws Exception {
        FileLocator fileLocator = this;
        File file = null;
        String[] stringArray2 = null;
        boolean bl2 = false;
        if (bl) {
            file = new File(File.separator);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            bl2 = this.doesElementExist(file = file == null ? new File(stringArray[i]) : new File(file, stringArray[i]));
            if (bl2) {
                this.setFile(file);
                if (!this.isFileElement(file)) continue;
                if (i >= stringArray.length - 1) break;
                stringArray2 = this.str().copyFrom(stringArray, i + 1);
                fileLocator = FileLocator.newWith(this, stringArray2);
                break;
            }
            if (this.isInArchive()) {
                if (i < stringArray.length - 1) continue;
                throw new Exception("\"" + file.getPath() + "\" does not exist");
            }
            throw new Exception("\"" + file.getPath() + "\" does not exist");
        }
        return fileLocator;
    }

    protected boolean doesElementExist(File file) throws Exception {
        if (this.isInArchive()) {
            return this.doesElementExistInArchive(file.getPath());
        }
        return file.exists();
    }

    protected boolean isFileElement(File file) throws Exception {
        if (this.isInArchive()) {
            return this.isFileInArchive(file.getPath());
        }
        return file.isFile();
    }

    protected boolean doesElementExistInArchive(String string) throws Exception {
        ZipEntry zipEntry = this.entryFromArchive(string);
        return zipEntry != null;
    }

    protected boolean isFileInArchive(String string) throws Exception {
        ZipEntry zipEntry = this.entryFromArchive(string);
        return zipEntry != null && zipEntry.getSize() > 0L;
    }

    protected ZipEntry entryFromArchive(String string) throws Exception {
        String string2 = this.str().replaceAll(string, "\\", "/");
        ZipFile zipFile = this.container();
        ZipEntry zipEntry = zipFile.getEntry(string2);
        return zipEntry;
    }

    protected ZipEntry archiveEntry() throws Exception {
        return this.entryFromArchive(this.getFile().getPath());
    }

    protected void doesNotExist(File file) {
        this.setExists(false);
        this.setFile(file);
    }

    protected File fullFilePath(boolean bl) {
        File file = this.isInArchive() ? new File(this.getParent().fullFilePath(bl), this.getFile().getPath()) : (bl ? this.getFile().getAbsoluteFile() : this.getFile());
        return file;
    }

    protected void urlPath(StringBuffer stringBuffer) {
        if (this.isInArchive()) {
            this.getParent().urlPath(stringBuffer);
            stringBuffer.append(ARCHIVE_INDICATOR);
        } else {
            stringBuffer.append(FILE_PROTOCOL_INDICATOR);
        }
        stringBuffer.append(this.getFile().getPath());
    }

    protected File fileRef() throws Exception {
        if (this.isInArchive()) {
            ZipEntry zipEntry = this.archiveEntry();
            InputStream inputStream = this.container().getInputStream(zipEntry);
            File file = File.createTempFile("FLOC_", ".xtr");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.fileUtil().copyStream(inputStream, fileOutputStream);
            return file;
        }
        return this.getFile();
    }

    protected ZipFile archive() throws Exception {
        if (this.getZipFile() == null) {
            this.setZipFile(new ZipFile(this.fileRef()));
        }
        return this.getZipFile();
    }

    protected ZipFile container() throws Exception {
        if (this.isInArchive()) {
            return this.getParent().archive();
        }
        return null;
    }

    protected File convertFromURLSyntax(File file) {
        String string = file.getPath().substring(FILE_PROTOCOL_INDICATOR.length());
        string = this.str().replaceAll(string, ARCHIVE_INDICATOR, File.separator);
        return new File(string);
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }
}

