/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Stack;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.Yylex;
import org.json.simple.parser.Yytoken;

public class JSONParser {
    public static final int S_INIT = 0;
    public static final int S_IN_FINISHED_VALUE = 1;
    public static final int S_IN_OBJECT = 2;
    public static final int S_IN_ARRAY = 3;
    public static final int S_PASSED_PAIR_KEY = 4;
    public static final int S_IN_ERROR = -1;

    private int peekStatus(Stack stack) {
        if (stack.size() == 0) {
            return -1;
        }
        Integer n = (Integer)stack.peek();
        return n;
    }

    public Object parse(Reader reader) throws Exception {
        Stack<Integer> stack = new Stack<Integer>();
        Stack<Object> stack2 = new Stack<Object>();
        Yylex yylex = new Yylex(reader);
        Yytoken yytoken = null;
        int n = 0;
        do {
            if ((yytoken = yylex.yylex()) == null) {
                yytoken = new Yytoken(-1, null);
            }
            block1 : switch (n) {
                case 0: {
                    switch (yytoken.type) {
                        case 0: {
                            n = 1;
                            stack.push(new Integer(n));
                            stack2.push(yytoken.value);
                            break block1;
                        }
                        case 1: {
                            n = 2;
                            stack.push(new Integer(n));
                            stack2.push(new JSONObject());
                            break block1;
                        }
                        case 3: {
                            n = 3;
                            stack.push(new Integer(n));
                            stack2.push(new JSONArray());
                            break block1;
                        }
                    }
                    n = -1;
                    break;
                }
                case 1: {
                    if (yytoken.type == -1) {
                        return stack2.pop();
                    }
                    return null;
                }
                case 2: {
                    Object object;
                    switch (yytoken.type) {
                        case 5: {
                            break block1;
                        }
                        case 0: {
                            if (yytoken.value instanceof String) {
                                object = (String)yytoken.value;
                                stack2.push(object);
                                n = 4;
                                stack.push(new Integer(n));
                                break block1;
                            }
                            n = -1;
                            break block1;
                        }
                        case 2: {
                            if (stack2.size() > 1) {
                                stack.pop();
                                object = (JSONObject)stack2.pop();
                                ((LightHashMap)object).compactify(-0.9f);
                                n = this.peekStatus(stack);
                                break block1;
                            }
                            n = 1;
                            break block1;
                        }
                    }
                    n = -1;
                    break;
                }
                case 4: {
                    JSONArray jSONArray;
                    JSONObject jSONObject;
                    Object object;
                    switch (yytoken.type) {
                        case 6: {
                            break block1;
                        }
                        case 0: {
                            stack.pop();
                            object = (String)stack2.pop();
                            jSONObject = (JSONObject)stack2.peek();
                            jSONObject.put(object, yytoken.value);
                            n = this.peekStatus(stack);
                            break block1;
                        }
                        case 3: {
                            stack.pop();
                            object = (String)stack2.pop();
                            jSONObject = (JSONObject)stack2.peek();
                            jSONArray = new JSONArray();
                            jSONObject.put(object, jSONArray);
                            n = 3;
                            stack.push(new Integer(n));
                            stack2.push(jSONArray);
                            break block1;
                        }
                        case 1: {
                            stack.pop();
                            object = (String)stack2.pop();
                            jSONObject = (JSONObject)stack2.peek();
                            JSONObject jSONObject2 = new JSONObject();
                            jSONObject.put(object, jSONObject2);
                            n = 2;
                            stack.push(new Integer(n));
                            stack2.push(jSONObject2);
                            break block1;
                        }
                    }
                    n = -1;
                    break;
                }
                case 3: {
                    JSONArray jSONArray;
                    JSONObject jSONObject;
                    Object object;
                    switch (yytoken.type) {
                        case 5: {
                            break block1;
                        }
                        case 0: {
                            object = (JSONArray)stack2.peek();
                            ((ArrayList)object).add(yytoken.value);
                            break block1;
                        }
                        case 4: {
                            if (stack2.size() > 1) {
                                stack.pop();
                                stack2.pop();
                                n = this.peekStatus(stack);
                                break block1;
                            }
                            n = 1;
                            break block1;
                        }
                        case 1: {
                            object = (JSONArray)stack2.peek();
                            jSONObject = new JSONObject();
                            ((ArrayList)object).add(jSONObject);
                            n = 2;
                            stack.push(new Integer(n));
                            stack2.push(jSONObject);
                            break block1;
                        }
                        case 3: {
                            object = (JSONArray)stack2.peek();
                            jSONArray = new JSONArray();
                            ((ArrayList)object).add(jSONArray);
                            n = 3;
                            stack.push(new Integer(n));
                            stack2.push(jSONArray);
                            break block1;
                        }
                    }
                    n = -1;
                    break;
                }
                case -1: {
                    return null;
                }
            }
            if (n != -1) continue;
            return null;
        } while (yytoken.type != -1);
        return null;
    }
}

