/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.update;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderListener;

public class PluginUpdatePlugin
implements Plugin {
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.update";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.update";
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    private PluginInterface plugin_interface;
    private LoggerChannel log;
    private boolean loader_listener_added;
    private String last_id_info = "";

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Plugin Updater");
        this.log = this.plugin_interface.getLogger().getChannel("Plugin Update");
        UIManager uIManager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel basicPluginViewModel = uIManager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        final PluginConfig pluginConfig = this.plugin_interface.getPluginconfig();
        boolean bl = pluginConfig.getPluginBooleanParameter("enable.update", true);
        basicPluginViewModel.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.getStatus().setText(bl ? "Running" : "Optional checks disabled");
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            @Override
            public void messageLogged(int n, String string) {
                basicPluginViewModel.getLogArea().appendText(string + "\n");
            }

            @Override
            public void messageLogged(String string, Throwable throwable) {
                basicPluginViewModel.getLogArea().appendText(throwable.toString() + "\n");
            }
        });
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        basicPluginConfigModel.addBooleanParameter2("enable.update", "Plugin.pluginupdate.enablecheck", true);
        this.plugin_interface.addEventListener(new PluginEventListener(){

            @Override
            public void handleEvent(PluginEvent pluginEvent) {
                if (pluginEvent.getType() == 7) {
                    PluginUpdatePlugin.this.plugin_interface.removeEventListener(this);
                    PluginUpdatePlugin.this.initComplete(pluginConfig);
                }
            }
        });
    }

    protected void initComplete(final PluginConfig pluginConfig) {
        int n;
        UpdateManager updateManager = this.plugin_interface.getUpdateManager();
        updateManager.addListener(new UpdateManagerListener(){

            @Override
            public void checkInstanceCreated(UpdateCheckInstance updateCheckInstance) {
                SFPluginDetailsLoaderFactory.getSingleton().reset();
            }
        });
        final PluginManager pluginManager = this.plugin_interface.getPluginManager();
        PluginInterface[] pluginInterfaceArray = pluginManager.getPlugins();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < pluginInterfaceArray.length; ++n) {
            PluginInterface pluginInterface = pluginInterfaceArray[n];
            boolean bl = pluginInterface.getPluginState().isMandatory();
            if (bl) {
                ++n2;
                continue;
            }
            ++n3;
        }
        n = n3;
        final int n4 = n2;
        updateManager.registerUpdatableComponent(new UpdatableComponent(){

            @Override
            public String getName() {
                return "Non-mandatory plugins";
            }

            @Override
            public int getMaximumCheckTime() {
                return n * 30;
            }

            @Override
            public void checkForUpdate(UpdateChecker updateChecker) {
                if (PluginUpdatePlugin.this.checkForUpdateSupport(updateChecker, null, false) == 0) {
                    Object object;
                    VersionCheckClient versionCheckClient = VersionCheckClient.getSingleton();
                    String[] stringArray = versionCheckClient.getRecommendedPlugins();
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        object = stringArray[i];
                        if (pluginManager.getPluginInterfaceByID((String)object, false) != null) continue;
                        final String string = "recommended.processed." + (String)object;
                        if (!pluginConfig.getPluginBooleanParameter(string, false)) {
                            try {
                                final PluginInstaller throwable = PluginUpdatePlugin.this.plugin_interface.getPluginManager().getPluginInstaller();
                                StandardPlugin[] standardPluginArray = throwable.getStandardPlugins();
                                for (int j = 0; j < standardPluginArray.length; ++j) {
                                    final StandardPlugin standardPlugin = standardPluginArray[j];
                                    if (!standardPlugin.getId().equals(object)) continue;
                                    bl = true;
                                    updateChecker.getCheckInstance().addListener(new UpdateCheckInstanceListener(){

                                        @Override
                                        public void cancelled(UpdateCheckInstance updateCheckInstance) {
                                        }

                                        @Override
                                        public void complete(UpdateCheckInstance updateCheckInstance) {
                                            if (updateCheckInstance.getUpdates().length == 0) {
                                                PluginUpdatePlugin.this.installRecommendedPlugin(throwable, standardPlugin);
                                                pluginConfig.setPluginParameter(string, true);
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (bl) break;
                    }
                    if (!bl) {
                        Set<String> set = versionCheckClient.getAutoInstallPluginIDs();
                        object = new ArrayList();
                        for (String string : set) {
                            if (pluginManager.getPluginInterfaceByID(string, false) != null) continue;
                            object.add(string);
                        }
                        if (object.size() > 0) {
                            new AEThread2("pup:autoinst", (List)object){
                                final /* synthetic */ List val$to_do;
                                {
                                    this.val$to_do = list;
                                    super(string);
                                }

                                @Override
                                public void run() {
                                    try {
                                        Thread.sleep(120000L);
                                    }
                                    catch (Throwable throwable) {
                                        Debug.out(throwable);
                                        return;
                                    }
                                    UpdateManager updateManager = PluginUpdatePlugin.this.plugin_interface.getUpdateManager();
                                    final ArrayList<UpdateCheckInstance> arrayList = new ArrayList<UpdateCheckInstance>();
                                    updateManager.addListener(new UpdateManagerListener(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void checkInstanceCreated(UpdateCheckInstance updateCheckInstance) {
                                            List list = arrayList;
                                            synchronized (list) {
                                                arrayList.add(updateCheckInstance);
                                            }
                                        }
                                    });
                                    UpdateCheckInstance[] updateCheckInstanceArray = updateManager.getCheckInstances();
                                    arrayList.addAll(Arrays.asList(updateCheckInstanceArray));
                                    long l = SystemTime.getMonotonousTime();
                                    while (SystemTime.getMonotonousTime() - l < 300000L) {
                                        try {
                                            Thread.sleep(5000L);
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                            return;
                                        }
                                        if (arrayList.size() <= 0) continue;
                                        boolean bl = true;
                                        for (UpdateCheckInstance object : arrayList) {
                                            if (object.isCompleteOrCancelled()) continue;
                                            bl = false;
                                            break;
                                        }
                                        if (!bl) continue;
                                        break;
                                    }
                                    if (updateManager.getInstallers().length > 0) {
                                        return;
                                    }
                                    PluginInstaller pluginInstaller = PluginUpdatePlugin.this.plugin_interface.getPluginManager().getPluginInstaller();
                                    ArrayList arrayList2 = new ArrayList();
                                    for (String string : this.val$to_do) {
                                        try {
                                            StandardPlugin standardPlugin = pluginInstaller.getStandardPlugin(string);
                                            if (standardPlugin != null) {
                                                PluginUpdatePlugin.this.log.log("Auto-installing " + string);
                                                arrayList2.add(standardPlugin);
                                                continue;
                                            }
                                            PluginUpdatePlugin.this.log.log("Standard plugin '" + string + "' missing");
                                        }
                                        catch (Throwable throwable) {
                                            PluginUpdatePlugin.this.log.log("Standard plugin '" + string + "' missing", throwable);
                                        }
                                    }
                                    if (arrayList2.size() > 0) {
                                        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
                                        hashMap.put(1, 3);
                                        hashMap.put(3, true);
                                        try {
                                            pluginInstaller.install(arrayList2.toArray(new InstallablePlugin[arrayList2.size()]), false, hashMap, new PluginInstallationListener(){

                                                @Override
                                                public void completed() {
                                                }

                                                @Override
                                                public void cancelled() {
                                                }

                                                @Override
                                                public void failed(PluginException pluginException) {
                                                }
                                            });
                                        }
                                        catch (Throwable throwable) {
                                            PluginUpdatePlugin.this.log.log("Auto install failed", throwable);
                                        }
                                    }
                                }
                            }.start();
                        }
                    }
                }
            }
        }, false);
        updateManager.registerUpdatableComponent(new UpdatableComponent(){

            @Override
            public String getName() {
                return "Mandatory plugins";
            }

            @Override
            public int getMaximumCheckTime() {
                return n4 * 30;
            }

            @Override
            public void checkForUpdate(UpdateChecker updateChecker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(updateChecker, null, true);
            }
        }, true);
        updateManager.addListener(new UpdateManagerListener(){

            @Override
            public void checkInstanceCreated(UpdateCheckInstance updateCheckInstance) {
                PluginUpdatePlugin.this.log.log(1, "**** Update check starts ****");
            }
        });
    }

    protected void installRecommendedPlugin(PluginInstaller pluginInstaller, StandardPlugin standardPlugin) {
        try {
            pluginInstaller.requestInstall(MessageText.getString("plugin.installer.recommended.plugin"), standardPlugin);
        }
        catch (Throwable throwable) {
            this.log.log(throwable);
        }
    }

    public UpdatableComponent getCustomUpdateableComponent(final String string, final boolean bl) {
        return new UpdatableComponent(){

            @Override
            public String getName() {
                return "Installation of '" + string + "'";
            }

            @Override
            public int getMaximumCheckTime() {
                return 30;
            }

            @Override
            public void checkForUpdate(UpdateChecker updateChecker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(updateChecker, new String[]{string}, bl);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int checkForUpdateSupport(UpdateChecker updateChecker, String[] stringArray, boolean n) {
        int n2 = 0;
        try {
            Object object;
            Object object2;
            int n3;
            String string;
            String[] stringArray2;
            if (n == 0 && stringArray == null && !this.plugin_interface.getPluginconfig().getPluginBooleanParameter("enable.update", true)) {
                int n4 = n2;
                return n4;
            }
            PluginInterface[] pluginInterfaceArray = this.plugin_interface.getPluginManager().getPlugins();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            for (int i = 0; i < pluginInterfaceArray.length; ++i) {
                stringArray2 = pluginInterfaceArray[i];
                if (stringArray2.getPluginState().isDisabled() && !stringArray2.getPluginState().hasFailed()) continue;
                string = stringArray2.getPluginProperties().getProperty("plugin.mandatory");
                int n5 = n3 = string != null && string.trim().toLowerCase().equals("true") ? 1 : 0;
                if (n3 != n) continue;
                object2 = stringArray2.getPluginID();
                object = stringArray2.getPluginVersion();
                String string2 = stringArray2.getPluginName();
                if (stringArray != null) {
                    boolean bl = false;
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!stringArray[j].equals(object2)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                }
                if (object != null) {
                    if (arrayList2.contains(object2)) {
                        String string3 = (String)hashMap.get(object2);
                        if (!string2.equals(object2)) {
                            hashMap.put(object2, string3 + "," + string2);
                        }
                    } else {
                        arrayList2.add(object2);
                        arrayList.add(stringArray2);
                        hashMap.put(object2, string2.equals(object2) ? "" : string2);
                    }
                }
                String string4 = stringArray2.getPluginDirectoryName();
                this.log.log(1, (n != 0 ? "*" : "-") + stringArray2.getPluginName() + ", id = " + (String)object2 + (object == null ? "" : ", version = " + stringArray2.getPluginVersion()) + (string4 == null ? "" : ", loc = " + string4));
            }
            SFPluginDetailsLoader sFPluginDetailsLoader = SFPluginDetailsLoaderFactory.getSingleton();
            if (!this.loader_listener_added) {
                this.loader_listener_added = true;
                sFPluginDetailsLoader.addListener(new SFPluginDetailsLoaderListener(){

                    @Override
                    public void log(String string) {
                        PluginUpdatePlugin.this.log.log(1, "[" + string + "]");
                    }
                });
            }
            stringArray2 = sFPluginDetailsLoader.getPluginIDs();
            string = "";
            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                object2 = stringArray2[n3];
                object = sFPluginDetailsLoader.getPluginDetails((String)object2);
                string = string + (n3 == 0 ? "" : ",") + stringArray2[n3] + "=" + object.getVersion() + "/" + object.getCVSVersion();
            }
            if (!string.equals(this.last_id_info)) {
                this.last_id_info = string;
                this.log.log(1, "Downloaded plugin info = " + string);
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                if (updateChecker.getCheckInstance().isCancelled()) {
                    throw new Exception("Update check cancelled");
                }
                object2 = (PluginInterface)arrayList.get(n3);
                object = object2.getPluginID();
                boolean bl = false;
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!stringArray2[i].equalsIgnoreCase((String)object)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (object2.getPluginState().isBuiltIn()) continue;
                    this.log.log(1, "Skipping " + (String)object + " as not listed on web site");
                    continue;
                }
                String string5 = (String)hashMap.get(object);
                this.log.log(1, "Checking " + (String)object);
                try {
                    Object object3;
                    String string6;
                    String string7;
                    updateChecker.reportProgress("Loading details for " + (String)object + "/" + object2.getPluginName());
                    SFPluginDetails sFPluginDetails = sFPluginDetailsLoader.getPluginDetails((String)object);
                    if (string5.length() == 0) {
                        string5 = sFPluginDetails.getName();
                    }
                    boolean bl2 = this.plugin_interface.getUtilities().isCVSVersion();
                    String string8 = object2.getPluginProperties().getProperty("plugin.version.info");
                    String string9 = object2.getPluginVersion();
                    String string10 = string7 = sFPluginDetails.getVersion();
                    if (bl2 && (string6 = sFPluginDetails.getCVSVersion()).length() > 0) {
                        string7 = string6;
                        string10 = string7.substring(0, string7.length() - 4);
                    }
                    if (string10.length() == 0 || !Character.isDigit(string10.charAt(0))) {
                        this.log.log(1, "Skipping " + (String)object + " as no valid version to check");
                        continue;
                    }
                    int n6 = PluginUtils.comparePluginVersions(string9, string10);
                    this.log.log(1, "    Current: " + string9 + (n6 == 0 && string7.endsWith("_CVS") ? "_CVS" : "") + ", Latest: " + string7 + (string8 == null ? "" : " [" + string8 + "]"));
                    updateChecker.reportProgress("    current=" + string9 + (n6 == 0 && string7.endsWith("_CVS") ? "_CVS" : "") + ", latest=" + string7);
                    if (n6 >= 0 || object2.getPlugin() instanceof UpdatableComponent) continue;
                    String string11 = sFPluginDetails.getDownloadURL();
                    if (bl2 && ((String)(object3 = sFPluginDetails.getCVSVersion())).length() > 0) {
                        string11 = sFPluginDetails.getCVSDownloadURL();
                    }
                    this.log.log(1, "    Description:");
                    object3 = new ArrayList();
                    List list = HTMLUtils.convertHTMLToText("", sFPluginDetails.getDescription());
                    this.logMultiLine("        ", list);
                    object3.addAll(list);
                    this.log.log(1, "    Comment:");
                    List list2 = HTMLUtils.convertHTMLToText("    ", sFPluginDetails.getComment());
                    this.logMultiLine("    ", list2);
                    object3.addAll(list2);
                    String string12 = "A newer version (version " + string7 + ") of plugin '" + (String)object + "' " + (string5.length() == 0 ? "" : "(" + string5 + ") ") + "is available. ";
                    this.log.log(1, "");
                    this.log.log(1, "        " + string12 + "Download from " + string11);
                    ResourceDownloaderFactory resourceDownloaderFactory = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                    ResourceDownloader resourceDownloader = resourceDownloaderFactory.create(new URL(string11));
                    String string13 = "http://torrent.vuze.com/torrents/";
                    int n7 = string11.lastIndexOf("/");
                    string13 = n7 == -1 ? string13 + string11 : string13 + string11.substring(n7 + 1);
                    string13 = string13 + ".torrent";
                    ResourceDownloader resourceDownloader2 = resourceDownloaderFactory.create(new URL(string13));
                    resourceDownloader2 = resourceDownloaderFactory.getSuffixBasedDownloader(resourceDownloader2);
                    ResourceDownloader resourceDownloader3 = resourceDownloaderFactory.getAlternateDownloader(new ResourceDownloader[]{resourceDownloader2, resourceDownloader});
                    resourceDownloaderFactory.getTimeoutDownloader(resourceDownloaderFactory.getRetryDownloader(resourceDownloader3, 3), 10000).getSize();
                    String[] stringArray3 = new String[object3.size()];
                    object3.toArray(stringArray3);
                    ++n2;
                    boolean bl3 = true;
                    for (int i = 0; i < pluginInterfaceArray.length; ++i) {
                        PluginInterface pluginInterface = pluginInterfaceArray[i];
                        if (!pluginInterface.getPluginID().equals(object)) continue;
                        bl3 &= pluginInterface.getPluginState().isUnloadable();
                    }
                    if (bl3) {
                        updateChecker.reportProgress("Plugin is unloadable");
                    }
                    Update update = this.addUpdate((PluginInterface)object2, updateChecker, (String)object + "/" + string5, stringArray3, string7, resourceDownloader3, string11.toLowerCase().endsWith(".jar"), bl3 ? 1 : 2, true);
                    update.setRelativeURLBase(sFPluginDetails.getRelativeURLBase());
                    update.setDescriptionURL(sFPluginDetails.getInfoURL());
                    continue;
                }
                catch (Throwable throwable) {
                    updateChecker.reportProgress("Failed to load details for plugin '" + (String)object + "': " + Debug.getNestedExceptionMessage(throwable));
                    this.log.log("    Plugin check failed", throwable);
                }
            }
        }
        catch (Throwable throwable) {
            if (!"Update check cancelled".equals(throwable.getMessage())) {
                this.log.log("Failed to load plugin details", throwable);
            }
            updateChecker.reportProgress("Failed to load plugin details: " + Debug.getNestedExceptionMessage(throwable));
            updateChecker.failed();
        }
        finally {
            updateChecker.completed();
        }
        return n2;
    }

    public Update addUpdate(final PluginInterface pluginInterface, final UpdateChecker updateChecker, String string, String[] stringArray, final String string2, ResourceDownloader resourceDownloader, final boolean bl, final int n, final boolean bl2) {
        final Update update = updateChecker.addUpdate(string, stringArray, string2, resourceDownloader, n);
        update.setUserObject(pluginInterface);
        resourceDownloader.addListener(new ResourceDownloaderAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean completed(final ResourceDownloader resourceDownloader, InputStream inputStream) {
                LoggerChannelListener loggerChannelListener = new LoggerChannelListener(){

                    @Override
                    public void messageLogged(int n, String string) {
                        resourceDownloader.reportActivity(string);
                    }

                    @Override
                    public void messageLogged(String string, Throwable throwable) {
                        resourceDownloader.reportActivity(string);
                    }
                };
                try {
                    PluginUpdatePlugin.this.log.addListener(loggerChannelListener);
                    PluginUpdatePlugin.this.installUpdate(updateChecker, update, pluginInterface, n == 1, bl, string2, inputStream, bl2);
                    boolean bl3 = true;
                    return bl3;
                }
                finally {
                    PluginUpdatePlugin.this.log.removeListener(loggerChannelListener);
                }
            }

            @Override
            public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
                Debug.out(resourceDownloader.getName() + " failed", resourceDownloaderException);
                update.complete(false);
            }
        });
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void installUpdate(UpdateChecker updateChecker, Update update, PluginInterface pluginInterface, boolean bl, boolean bl2, String string, InputStream inputStream, boolean bl3) {
        this.log.log(1, "Installing plugin '" + update.getName() + "', version " + string);
        String string2 = string.endsWith("_CVS") ? string.substring(0, string.length() - 4) : string;
        UpdateInstaller updateInstaller = null;
        boolean bl4 = false;
        try {
            Object object;
            Comparable<File> comparable;
            inputStream = update.verifyData(inputStream, bl3);
            this.log.log("    Data verification stage complete");
            boolean bl5 = false;
            String string3 = pluginInterface.getPluginDirectoryName();
            if (string3 == null || string3.length() == 0) {
                this.log.log(1, "    This is a built-in plugin, updating core");
                update.setRestartRequired(2);
            } else {
                Object object2;
                Object object3;
                File file;
                File file2;
                Object object4;
                File file3;
                comparable = new File(string3);
                object = new File(this.plugin_interface.getUtilities().getAzureusUserDir());
                File file4 = new File(this.plugin_interface.getUtilities().getAzureusProgramDir());
                HashMap<String, List<String[]>> hashMap = new HashMap<String, List<String[]>>();
                boolean bl6 = false;
                if (Constants.isWindowsVistaOrHigher) {
                    file3 = new File((File)comparable, "_aztest45.dll");
                    boolean bl7 = false;
                    try {
                        if (file3.exists()) {
                            file3.delete();
                        }
                        object4 = new FileOutputStream(file3);
                        ((FileOutputStream)object4).write(32);
                        ((FileOutputStream)object4).close();
                        bl7 = file3.delete();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!bl7) {
                        this.log.log("Can't write directly to the plugin directroy, installing indirectly");
                        bl6 = true;
                    }
                }
                if (bl6) {
                    file2 = AETemporaryFileHandler.createTempDir();
                    file3 = new File(file2, "plugin");
                    object4 = new File(file2, "user");
                    file = new File(file2, "prog");
                    file3.mkdirs();
                    ((File)object4).mkdirs();
                    file.mkdirs();
                    updateInstaller = update.getCheckInstance().createInstaller();
                    update.setRestartRequired(2);
                } else {
                    file3 = comparable;
                    object4 = object;
                    file = file4;
                }
                file2 = new File(file3, pluginInterface.getPluginID() + "_" + string2 + (bl2 ? ".jar" : ".zip"));
                FileUtil.copyFile(inputStream, new FileOutputStream(file2));
                if (!bl2) {
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    object3 = new ZipInputStream(new BufferedInputStream(new FileInputStream(file2)));
                    object2 = null;
                    Object object9 = null;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    try {
                        ZipEntry zipEntry;
                        block34: while ((zipEntry = ((ZipInputStream)object3).getNextEntry()) != null) {
                            int n;
                            object8 = zipEntry.getName();
                            if (((String)object8).equals("plugin_install.properties")) {
                                object7 = new ByteArrayOutputStream(32768);
                                byte[] byArray = new byte[65536];
                                while (true) {
                                    int n2;
                                    if ((n2 = ((FilterInputStream)object3).read(byArray)) <= 0) {
                                        try {
                                            object6 = new LineNumberReader(new InputStreamReader((InputStream)new ByteArrayInputStream(((ByteArrayOutputStream)object7).toByteArray()), "UTF-8"));
                                            while ((object5 = ((LineNumberReader)object6).readLine()) != null) {
                                                String[] stringArray = ((String)object5).split(",");
                                                if (stringArray.length <= 1) continue;
                                                ArrayList<String[]> arrayList2 = (ArrayList<String[]>)hashMap.get(stringArray[0]);
                                                if (arrayList2 == null) {
                                                    arrayList2 = new ArrayList<String[]>();
                                                    hashMap.put(stringArray[0], arrayList2);
                                                }
                                                arrayList2.add(stringArray);
                                            }
                                            continue block34;
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                            continue block34;
                                        }
                                    }
                                    ((ByteArrayOutputStream)object7).write(byArray, 0, n2);
                                }
                            }
                            if (!((String)object8).equals("azureus.sig") && !((String)object8).endsWith("/")) {
                                if (object2 == null) {
                                    object2 = object8;
                                } else {
                                    int n3 = 0;
                                    for (n = 0; n < Math.min(((String)object2).length(), ((String)object8).length()) && ((String)object2).charAt(n) == ((String)object8).charAt(n); ++n3, ++n) {
                                    }
                                    object2 = ((String)object2).substring(0, n3);
                                }
                                int n4 = ((String)object8).indexOf("platform/");
                                if (n4 != -1 && (n = ((String)object8).indexOf("/", n4 += 9)) != -1) {
                                    object6 = ((String)object8).substring(n4, n);
                                    object5 = null;
                                    int n5 = ((String)object6).indexOf("_");
                                    if (n5 != -1) {
                                        object5 = ((String)object6).substring(n5 + 1);
                                        object6 = ((String)object6).substring(0, n5);
                                    }
                                    if (Constants.isWindows && ((String)object6).equalsIgnoreCase("windows") || Constants.isLinux && ((String)object6).equalsIgnoreCase("linux") || Constants.isUnix && ((String)object6).equalsIgnoreCase("unix") || Constants.isFreeBSD && ((String)object6).equalsIgnoreCase("freebsd") || Constants.isSolaris && ((String)object6).equalsIgnoreCase("solaris") || Constants.isOSX && ((String)object6).equalsIgnoreCase("osx")) {
                                        object9 = object6;
                                        if (object5 != null && !arrayList.contains(object5)) {
                                            arrayList.add((String)object5);
                                        }
                                    }
                                }
                            }
                            object7 = new byte[65536];
                            while ((n = ((FilterInputStream)object3).read((byte[])object7)) > 0) {
                            }
                        }
                    }
                    finally {
                        ((ZipInputStream)object3).close();
                    }
                    if (object9 != null) {
                        String[] stringArray = new String[arrayList.size()];
                        arrayList.toArray(stringArray);
                        if (stringArray.length == 1) {
                            object9 = object9 + "_" + stringArray[0];
                            this.log.log(1, "platform is '" + (String)object9 + "'");
                        } else if (stringArray.length > 1) {
                            object8 = (String)update.getDecision(0, "Select Platform", "Multiple platform options exist for this plugin, please select required one", stringArray);
                            if (object8 == null) {
                                throw new Exception("Valid sub-platform selection not selected");
                            }
                            object9 = (String)object9 + "_" + (String)object8;
                            this.log.log(1, "platform is '" + (String)object9 + "'");
                        }
                    }
                    if (object2 != null) {
                        int n = ((String)object2).lastIndexOf("/");
                        object2 = n == -1 ? "" : ((String)object2).substring(0, n + 1);
                        object3 = new ZipInputStream(new BufferedInputStream(new FileInputStream(file2)));
                        try {
                            while ((object8 = ((ZipInputStream)object3).getNextEntry()) != null) {
                                Object object10;
                                Object object11;
                                Object object12;
                                Object object13;
                                Object object14;
                                object7 = ((ZipEntry)object8).getName();
                                OutputStream outputStream = null;
                                object6 = null;
                                object5 = null;
                                Object object15 = null;
                                boolean bl8 = false;
                                try {
                                    int n6;
                                    if (((String)object7).length() >= ((String)object2).length() && !((String)object7).equals("azureus.sig") && !((String)object7).endsWith("/")) {
                                        boolean bl9 = false;
                                        String string4 = ((ZipEntry)object8).getName().substring(((String)object2).length());
                                        if (object9 != null && string4.indexOf("platform/") != -1) {
                                            object14 = "platform/" + (String)object9;
                                            int n7 = string4.indexOf((String)object14);
                                            if (n7 != -1) {
                                                string4 = string4.substring(0, n7) + string4.substring(n7 + ((String)object14).length() + 1);
                                            } else {
                                                bl9 = true;
                                            }
                                        }
                                        if (string4.startsWith("shared/lib")) {
                                            update.setRestartRequired(2);
                                            bl = false;
                                            if (pluginInterface.getPluginState().isShared()) {
                                                object13 = file4;
                                                object14 = file;
                                            } else {
                                                object13 = object;
                                                object14 = object4;
                                            }
                                        } else {
                                            object13 = comparable;
                                            object14 = file3;
                                        }
                                        object6 = new File((File)object13, string4);
                                        object15 = object5 = new File((File)object14, string4);
                                        if (((File)object6).exists()) {
                                            if (string4.indexOf(47) == -1 && (string4.toLowerCase(MessageText.LOCALE_ENGLISH).endsWith(".properties") || string4.toLowerCase(MessageText.LOCALE_ENGLISH).endsWith(".config"))) {
                                                bl8 = string4.toLowerCase(MessageText.LOCALE_ENGLISH).equals("plugin.properties");
                                                object12 = string4;
                                                string4 = string4 + "_" + string2;
                                                object15 = new File((File)object14, string4);
                                                this.log.log(1, "saving new file '" + (String)object12 + "'as '" + string4 + "'");
                                            } else if (this.isVersioned(string4)) {
                                                this.log.log(1, "Version '" + string4 + "' already present, skipping");
                                                bl9 = true;
                                            } else {
                                                this.log.log(1, "overwriting '" + string4 + "'");
                                                object12 = new File(((File)object6).getParentFile(), ((File)object6).getName() + ".bak");
                                                if (bl6) {
                                                    if (((File)object12).exists()) {
                                                        updateInstaller.addRemoveAction(((File)object12).getAbsolutePath());
                                                    }
                                                    updateInstaller.addMoveAction(((File)object6).getAbsolutePath(), ((File)object12).getAbsolutePath());
                                                } else {
                                                    if (((File)object12).exists()) {
                                                        ((File)object12).delete();
                                                    }
                                                    if (!((File)object5).renameTo((File)object12)) {
                                                        this.log.log(1, "    failed to backup '" + string4 + "', deferring until restart");
                                                        if (updateInstaller == null) {
                                                            update.setRestartRequired(2);
                                                            updateInstaller = update.getCheckInstance().createInstaller();
                                                        }
                                                        object11 = new File(((File)object5).getParentFile(), ((File)object5).getName() + ".tmp");
                                                        ((File)object11).delete();
                                                        updateInstaller.addMoveAction(((File)object11).getAbsolutePath(), ((File)object5).getAbsolutePath());
                                                        object15 = object11;
                                                    }
                                                }
                                            }
                                        }
                                        if (!bl9) {
                                            FileUtil.mkdirs(((File)object15).getParentFile());
                                            outputStream = new FileOutputStream((File)object15);
                                        }
                                    }
                                    object10 = new byte[65536];
                                    while ((n6 = ((FilterInputStream)object3).read((byte[])object10)) > 0) {
                                        if (outputStream == null) continue;
                                        outputStream.write((byte[])object10, 0, n6);
                                    }
                                }
                                finally {
                                    if (outputStream != null) {
                                        outputStream.close();
                                    }
                                }
                                if (bl8) {
                                    Object object16;
                                    Object object17;
                                    Object object18;
                                    object10 = new Properties();
                                    Properties properties = new Properties();
                                    object14 = new ArrayList();
                                    object13 = new HashMap();
                                    object12 = new HashMap();
                                    try {
                                        object11 = new FileInputStream((File)object6);
                                        ((Properties)object10).load((InputStream)object11);
                                        try {
                                            ((FileInputStream)object11).close();
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        object11 = new FileInputStream((File)object15);
                                        properties.load((InputStream)object11);
                                        try {
                                            ((FileInputStream)object11).close();
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                    catch (Throwable throwable) {
                                        Debug.printStackTrace(throwable);
                                    }
                                    properties.put("plugin.version", string2);
                                    object11 = new String[]{"plugin.name", "plugin.names", "plugin.class", "plugin.classes", "plugin.version", "plugin.langfile"};
                                    for (int i = 0; i < ((String[])object11).length; ++i) {
                                        object18 = object11[i];
                                        object17 = ((Properties)object10).getProperty((String)object18);
                                        object16 = properties.getProperty((String)object18);
                                        if (object16 == null) continue;
                                        if (((String)object18).equals("plugin.name")) {
                                            object14.add("plugin.names");
                                        } else if (((String)object18).equals("plugin.names")) {
                                            object14.add("plugin.name");
                                        } else if (((String)object18).equals("plugin.class")) {
                                            object14.add("plugin.classes");
                                        } else if (((String)object18).equals("plugin.classes")) {
                                            object14.add("plugin.class");
                                        }
                                        if (object17 == null) {
                                            object12.put(object18, object16);
                                            continue;
                                        }
                                        if (((String)object16).equals(object17)) continue;
                                        object13.put(object18, object16);
                                    }
                                    Object object19 = bl6 ? object5 : new File(((File)object5).getParentFile(), ((File)object5).getName() + ".tmp");
                                    object18 = null;
                                    object17 = null;
                                    try {
                                        String string52;
                                        object18 = new LineNumberReader(new FileReader((File)object6));
                                        object17 = new PrintWriter(new FileWriter((File)object19));
                                        for (String string52 : object12.keySet()) {
                                            String string6 = (String)object12.get(string52);
                                            this.log.log("    Inserting property:" + string52 + "=" + string6);
                                            ((PrintWriter)object17).println(string52 + "=" + string6);
                                        }
                                        while ((string52 = ((LineNumberReader)object18).readLine()) != null) {
                                            int n8 = string52.indexOf(61);
                                            if (n8 != -1) {
                                                String string7 = string52.substring(0, n8).trim();
                                                if (object14.contains(string7)) {
                                                    this.log.log("    Deleting property:" + string7);
                                                    continue;
                                                }
                                                String string8 = (String)object13.get(string7);
                                                if (string8 != null) {
                                                    this.log.log("    Replacing property:" + string7 + " with " + string8);
                                                    ((PrintWriter)object17).println(string7 + "=" + string8);
                                                    continue;
                                                }
                                                ((PrintWriter)object17).println(string52);
                                                continue;
                                            }
                                            ((PrintWriter)object17).println(string52);
                                        }
                                    }
                                    finally {
                                        ((BufferedReader)object18).close();
                                        if (object17 != null) {
                                            ((PrintWriter)object17).close();
                                        }
                                    }
                                    object16 = new File(((File)object6).getParentFile(), ((File)object6).getName() + ".bak");
                                    if (bl6) {
                                        if (((File)object16).exists()) {
                                            updateInstaller.addRemoveAction(((File)object16).getAbsolutePath());
                                        }
                                        updateInstaller.addMoveAction(((File)object6).getAbsolutePath(), ((File)object16).getAbsolutePath());
                                        continue;
                                    }
                                    if (((File)object16).exists()) {
                                        ((File)object16).delete();
                                    }
                                    if (!((File)object5).renameTo((File)object16)) {
                                        throw new IOException("Failed to rename '" + ((File)object5).toString() + "' to '" + ((File)object16).toString() + "'");
                                    }
                                    if (!((File)object19).renameTo((File)object5)) {
                                        ((File)object16).renameTo((File)object5);
                                        throw new IOException("Failed to rename '" + ((File)object19).toString() + "' to '" + ((File)object5).toString() + "'");
                                    }
                                    ((File)object16).delete();
                                    continue;
                                }
                                if (object15 == null || !((File)object15).getName().equalsIgnoreCase("update.txt")) continue;
                                bl5 = true;
                                object10 = null;
                                try {
                                    String string9;
                                    object10 = new LineNumberReader(new FileReader((File)object15));
                                    while ((string9 = ((LineNumberReader)object10).readLine()) != null) {
                                        this.log.log(1, string9);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                }
                                finally {
                                    if (object10 == null) continue;
                                    ((BufferedReader)object10).close();
                                }
                            }
                        }
                        finally {
                            ((ZipInputStream)object3).close();
                        }
                    }
                }
                if (bl) {
                    object3 = pluginInterface.getPluginID();
                    object2 = pluginInterface.getPluginManager().getPlugins();
                    boolean bl10 = true;
                    for (int i = 0; i < ((PluginInterface[])object2).length; ++i) {
                        PluginInterface pluginInterface2 = object2[i];
                        if (!pluginInterface2.getPluginID().equals(object3)) continue;
                        bl10 &= pluginInterface2.getPluginState().isUnloadable();
                    }
                    if (!bl10) {
                        this.log.log("Switching unloadability for " + (String)object3 + " as changed during update");
                        update.setRestartRequired(2);
                        bl = false;
                    }
                }
                if (bl6) {
                    this.addInstallationActions(updateInstaller, (Map<String, List<String[]>>)hashMap, "%plugin%", file3, (File)comparable);
                    this.addInstallationActions(updateInstaller, hashMap, "%app%", file, file4);
                    this.addInstallationActions(updateInstaller, hashMap, "%user%", (File)object4, (File)object);
                } else {
                    this.applyInstallProperties((Map<String, List<String[]>>)hashMap, "%plugin%", (File)comparable);
                    this.applyInstallProperties(hashMap, "%app%", file4);
                    this.applyInstallProperties(hashMap, "%user%", (File)object);
                    if (bl) {
                        this.log.log("Plugin initialising, please wait... ");
                        pluginInterface.getPluginState().reload();
                        this.log.log("... initialisation complete.");
                    }
                }
            }
            comparable = (Boolean)update.getCheckInstance().getProperty(3);
            if (bl5 || comparable == null || !((Boolean)comparable).booleanValue()) {
                object = "Version " + string + " of plugin '" + update.getName() + "' " + "installed successfully";
                if (bl5) {
                    object = (String)object + " - See update log for details";
                }
                this.log.logAlertRepeatable(bl5 ? 2 : 1, (String)object);
            }
            try {
                object = pluginInterface.getPluginID();
                PluginInitializer.fireEvent(updateChecker.getCheckInstance().getType() == 1 ? 10 : 11, object);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
            bl4 = true;
            return;
        }
        catch (Throwable throwable) {
            String string10 = "Version " + string + " of plugin '" + update.getName() + "' " + "failed to install - " + throwable.getMessage();
            this.log.logAlertRepeatable(3, string10);
            return;
        }
        finally {
            update.complete(bl4);
        }
    }

    protected void addInstallationActions(UpdateInstaller updateInstaller, Map<String, List<String[]>> map, String string, File file, File file2) throws UpdateException {
        block5: {
            block4: {
                if (!file.isDirectory()) break block4;
                File[] fileArray = file.listFiles();
                if (fileArray == null) break block5;
                for (int i = 0; i < fileArray.length; ++i) {
                    this.addInstallationActions(updateInstaller, map, string + "/" + fileArray[i].getName(), fileArray[i], new File(file2, fileArray[i].getName()));
                }
                break block5;
            }
            updateInstaller.addMoveAction(file.getAbsolutePath(), file2.getAbsolutePath());
            List<String[]> list = map.get(string);
            if (list != null) {
                for (String[] stringArray : list) {
                    String string2 = stringArray[1];
                    if (string2.equals("chmod")) {
                        if (Constants.isWindows) continue;
                        this.log.log("Applying " + string2 + " " + stringArray[2] + " to " + file2);
                        updateInstaller.addChangeRightsAction(stringArray[2], file2.getAbsolutePath());
                        continue;
                    }
                    if (!string2.equals("rm")) continue;
                    this.log.log("Deleting " + file2);
                    updateInstaller.addRemoveAction(file2.getAbsolutePath());
                }
            }
        }
    }

    protected void applyInstallProperties(Map<String, List<String[]>> map, String string, File file) {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                File[] fileArray = file.listFiles();
                if (fileArray == null) break block6;
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    String string2 = file2.getName();
                    if (string2.equals(".") || string2.equals("..")) continue;
                    String string3 = string + "/" + string2;
                    boolean bl = false;
                    for (String string4 : map.keySet()) {
                        if (!string4.startsWith(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    this.applyInstallProperties(map, string3, fileArray[i]);
                }
                break block6;
            }
            List<String[]> list = map.get(string);
            if (list != null) {
                for (String[] stringArray : list) {
                    String string5 = stringArray[1];
                    if (string5.equals("chmod")) {
                        if (Constants.isWindows) continue;
                        this.runCommand(new String[]{"chmod", stringArray[2], file.getAbsolutePath().replaceAll(" ", "\\ ")});
                        continue;
                    }
                    if (!string5.equals("rm")) continue;
                    this.log.log("Deleting " + file);
                    file.delete();
                }
            }
        }
    }

    private void runCommand(String[] stringArray) {
        try {
            stringArray[0] = this.findCommand(stringArray[0]);
            String string = "";
            for (String string2 : stringArray) {
                string = string + " " + string2;
            }
            this.log.log("Executing" + string);
            Runtime.getRuntime().exec(stringArray).waitFor();
        }
        catch (Throwable throwable) {
            this.log.log("Failed to execute command", throwable);
        }
    }

    private String findCommand(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"/bin", "/usr/bin"}) {
            File file = new File(string2, string);
            if (!file.exists() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        return string;
    }

    protected boolean isVersioned(String string) {
        int n = string.lastIndexOf(95);
        if (n == -1 || string.endsWith("_")) {
            return false;
        }
        String string2 = string.substring(n + 1);
        if ((n = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(0, n);
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    protected void logMultiLine(String string, List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.log.log(1, string + (String)list.get(i));
        }
    }
}

