/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.download;

import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;

public class RPDownloadStats
extends RPObject
implements DownloadStats {
    protected transient DownloadStats delegate;
    public long downloaded;
    public long uploaded;
    public int completed;
    public int downloadCompletedLive;
    public int downloadCompletedStored;
    public String status;
    public String status_localised;
    public long upload_average;
    public long download_average;
    public String eta;
    public int share_ratio;
    public float availability;
    public int health;

    public static RPDownloadStats create(DownloadStats downloadStats) {
        RPDownloadStats rPDownloadStats = (RPDownloadStats)RPDownloadStats._lookupLocal(downloadStats);
        if (rPDownloadStats == null) {
            rPDownloadStats = new RPDownloadStats(downloadStats);
        }
        return rPDownloadStats;
    }

    protected RPDownloadStats(DownloadStats downloadStats) {
        super(downloadStats);
    }

    @Override
    protected void _setDelegate(Object object) {
        this.delegate = (DownloadStats)object;
        this.downloaded = this.delegate.getDownloaded();
        this.uploaded = this.delegate.getUploaded();
        this.completed = this.delegate.getCompleted();
        this.downloadCompletedLive = this.delegate.getDownloadCompleted(true);
        this.downloadCompletedStored = this.delegate.getDownloadCompleted(false);
        this.status = this.delegate.getStatus();
        this.status_localised = this.delegate.getStatus(true);
        this.upload_average = this.delegate.getUploadAverage();
        this.download_average = this.delegate.getDownloadAverage();
        this.eta = this.delegate.getETA();
        this.share_ratio = this.delegate.getShareRatio();
        this.availability = this.delegate.getAvailability();
        this.health = this.delegate.getHealth();
    }

    @Override
    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    @Override
    public RPReply _process(RPRequest rPRequest) {
        String string = rPRequest.getMethod();
        throw new RPException("Unknown method: " + string);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getStatus(boolean bl) {
        return bl ? this.status_localised : this.status;
    }

    @Override
    public String getDownloadDirectory() {
        this.notSupported();
        return null;
    }

    @Override
    public String getTargetFileOrDir() {
        this.notSupported();
        return null;
    }

    @Override
    public String getTrackerStatus() {
        this.notSupported();
        return null;
    }

    @Override
    public int getCompleted() {
        return this.completed;
    }

    @Override
    public int getDownloadCompleted(boolean bl) {
        return bl ? this.downloadCompletedLive : this.downloadCompletedStored;
    }

    @Override
    public int getCheckingDoneInThousandNotation() {
        this.notSupported();
        return 0;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public long getUploaded() {
        return this.uploaded;
    }

    @Override
    public long getRemaining() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getDiscarded() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getDownloadAverage() {
        return this.download_average;
    }

    @Override
    public long getUploadAverage() {
        return this.upload_average;
    }

    @Override
    public long getTotalAverage() {
        this.notSupported();
        return 0L;
    }

    @Override
    public String getElapsedTime() {
        this.notSupported();
        return null;
    }

    @Override
    public String getETA() {
        return this.eta;
    }

    @Override
    public long getETASecs() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getHashFails() {
        this.notSupported();
        return 0L;
    }

    @Override
    public int getShareRatio() {
        return this.share_ratio;
    }

    @Override
    public long getTimeStarted() {
        this.notSupported();
        return 0L;
    }

    @Override
    public float getAvailability() {
        return this.availability;
    }

    @Override
    public long getSecondsDownloading() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getSecondsOnlySeeding() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getTimeStartedSeeding() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getSecondsSinceLastDownload() {
        this.notSupported();
        return 0L;
    }

    @Override
    public long getSecondsSinceLastUpload() {
        this.notSupported();
        return 0L;
    }

    @Override
    public int getHealth() {
        return this.health;
    }
}

