/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPObjectNoLongerExistsException;

public class RPObject
implements Serializable {
    protected static Map object_registry = new WeakHashMap();
    protected static Map object_registry_reverse = new WeakHashMap();
    protected static long next_key = new Random(SystemTime.getCurrentTime()).nextLong();
    public Long _object_id;
    protected transient Object __delegate;
    protected transient RPRequestDispatcher _dispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RPObject _lookupLocal(Object object) {
        Map map = object_registry;
        synchronized (map) {
            RPObject rPObject = (RPObject)object_registry.get(object);
            if (rPObject != null) {
                rPObject._setLocal();
            }
            return rPObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RPObject _lookupLocal(long l) {
        Map map = object_registry;
        synchronized (map) {
            Object v = object_registry_reverse.get(new Long(l));
            if (v == null) {
                throw new RPObjectNoLongerExistsException();
            }
            RPObject rPObject = (RPObject)object_registry.get(v);
            if (rPObject == null) {
                throw new RPObjectNoLongerExistsException();
            }
            return rPObject;
        }
    }

    public RPObject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RPObject(Object object) {
        Map map = object_registry;
        synchronized (map) {
            RPObject rPObject = (RPObject)object_registry.get(object);
            if (rPObject != null) {
                this._object_id = rPObject._object_id;
            } else {
                this._object_id = new Long(next_key++);
                object_registry.put(object, this);
                object_registry_reverse.put(this._object_id, object);
            }
        }
        this.__delegate = object;
        this._setDelegate(this.__delegate);
    }

    public long _getOID() {
        return this._object_id;
    }

    protected void _setDelegate(Object object) {
        throw new RuntimeException("you've got to implement this - " + object);
    }

    public Object _getDelegate() {
        return this.__delegate;
    }

    protected Object _fixupLocal() throws RPException {
        Object v = object_registry_reverse.get(this._object_id);
        if (v == null) {
            throw new RPObjectNoLongerExistsException();
        }
        this._setDelegate(v);
        return v;
    }

    public void _setRemote(RPRequestDispatcher rPRequestDispatcher) {
        this._dispatcher = rPRequestDispatcher;
    }

    protected RPRequestDispatcher getDispatcher() {
        return this._dispatcher;
    }

    public RPReply _process(RPRequest rPRequest) {
        throw new RuntimeException("you've got to implement this - " + rPRequest);
    }

    public Object _setLocal() {
        throw new RuntimeException("you've got to implement this");
    }

    public void _refresh() {
        RPObject rPObject = (RPObject)this._dispatcher.dispatch(new RPRequest(this, "_refresh", null)).getResponse();
        this._setDelegate(rPObject);
    }

    public String _getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if (string.startsWith("RP")) {
            string = string.substring(2);
        }
        return string;
    }

    public void notSupported() {
        throw new RuntimeException("RPObject:: method not supported");
    }

    public void notSupported(Object object) {
        throw new RuntimeException("RPObject:: method not supported - " + object);
    }
}

