/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import com.aelitis.azureus.core.update.AzureusRestarter;
import com.aelitis.azureus.core.update.AzureusRestarterFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateInstallerListener;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;

public class UpdateInstallerImpl
implements UpdateInstaller {
    protected static final String UPDATE_DIR = "updates";
    protected static final String ACTIONS_LEGACY = "install.act";
    protected static final String ACTIONS_UTF8 = "install.act.utf8";
    protected static AEMonitor class_mon = new AEMonitor("UpdateInstaller:class");
    private UpdateManagerImpl manager;
    private File install_dir;

    protected static void checkForFailedInstalls(UpdateManagerImpl updateManagerImpl) {
        try {
            File file = new File(updateManagerImpl.getUserDir() + File.separator + UPDATE_DIR);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                boolean bl = false;
                String string = "";
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.isDirectory()) continue;
                    bl = true;
                    File[] fileArray2 = file2.listFiles();
                    if (fileArray2 != null) {
                        for (int j = 0; j < fileArray2.length; ++j) {
                            string = string + (string.length() == 0 ? "" : ",") + fileArray2[j].getName();
                        }
                    }
                    FileUtil.recursiveDelete(file2);
                }
                if (bl) {
                    Logger.log(new LogAlert(false, 3, MessageText.getString("Alert.failed.update", new String[]{string})));
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateInstallerImpl(UpdateManagerImpl updateManagerImpl) throws UpdateException {
        this.manager = updateManagerImpl;
        try {
            class_mon.enter();
            String string = this.getUserDir() + File.separator + UPDATE_DIR;
            for (int i = 1; i < 1024; ++i) {
                File file = new File(string + File.separator + "inst_" + i);
                if (file.exists()) continue;
                if (!FileUtil.mkdirs(file)) {
                    throw new UpdateException("Failed to create a temporary installation dir");
                }
                this.install_dir = file;
                break;
            }
            if (this.install_dir == null) {
                throw new UpdateException("Failed to find a temporary installation dir");
            }
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void addResource(String string, InputStream inputStream) throws UpdateException {
        this.addResource(string, inputStream, true);
    }

    @Override
    public void addResource(String string, InputStream inputStream, boolean bl) throws UpdateException {
        try {
            File file = new File(this.install_dir, string);
            FileUtil.copyFile(inputStream, (OutputStream)new FileOutputStream(file), bl);
        }
        catch (Throwable throwable) {
            throw new UpdateException("UpdateInstaller: resource addition fails", throwable);
        }
    }

    @Override
    public String getInstallDir() {
        return this.manager.getInstallDir();
    }

    @Override
    public String getUserDir() {
        return this.manager.getUserDir();
    }

    @Override
    public void addMoveAction(String string, String string2) throws UpdateException {
        if (string.indexOf(File.separator) == -1) {
            string = this.install_dir.toString() + File.separator + string;
        }
        try {
            File file = new File(string2);
            File file2 = file.getParentFile();
            if (file2 != null && !file2.exists()) {
                file2.mkdirs();
            }
            boolean bl = true;
            if (file2 != null && !file2.canWrite()) {
                bl = false;
                if (!Constants.isWindowsVistaOrHigher) {
                    Logger.log(new LogAlert(false, 1, "The location '" + file2.toString() + "' isn't writable, this update will probably fail." + " Check permissions and retry the update"));
                }
            }
            try {
                PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
                if (platformManager.hasCapability(PlatformManagerCapabilities.CopyFilePermissions)) {
                    String string3 = file2.getAbsolutePath();
                    PlatformManagerFactory.getPlatformManager().copyFilePermissions(string3, string);
                }
            }
            catch (Throwable throwable) {
                if (bl && !Constants.isWindowsVistaOrHigher) {
                    Debug.out(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.appendAction("move," + string + "," + string2);
    }

    @Override
    public void addChangeRightsAction(String string, String string2) throws UpdateException {
        this.appendAction("chmod," + string + "," + string2);
    }

    @Override
    public void addRemoveAction(String string) throws UpdateException {
        this.appendAction("remove," + string);
    }

    protected void appendAction(String string) throws UpdateException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(this.install_dir.toString() + File.separator + ACTIONS_LEGACY, true));
            printWriter.println(string);
        }
        catch (Throwable throwable) {
            throw new UpdateException("Failed to write actions file", throwable);
        }
        finally {
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable) {
                    throw new UpdateException("Failed to write actions file", throwable);
                }
            }
        }
        PrintWriter printWriter2 = null;
        try {
            printWriter2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.install_dir.toString() + File.separator + ACTIONS_UTF8, true), "UTF-8"));
            printWriter2.println(string);
        }
        catch (Throwable throwable) {
            throw new UpdateException("Failed to write actions file", throwable);
        }
        finally {
            if (printWriter2 != null) {
                try {
                    printWriter2.close();
                }
                catch (Throwable throwable) {
                    throw new UpdateException("Failed to write actions file", throwable);
                }
            }
        }
    }

    @Override
    public void installNow(final UpdateInstallerListener updateInstallerListener) throws UpdateException {
        try {
            UpdateInstaller[] updateInstallerArray = this.manager.getInstallers();
            if (updateInstallerArray.length != 1 || updateInstallerArray[0] != this) {
                throw new UpdateException("Other installers exist - aborting");
            }
            updateInstallerListener.reportProgress("Update starts");
            AzureusRestarter azureusRestarter = AzureusRestarterFactory.create(this.manager.getCore());
            azureusRestarter.updateNow();
            new AEThread2("installNow:waiter", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        block10: {
                            long l = SystemTime.getMonotonousTime();
                            UpdateException updateException = null;
                            do {
                                Thread.sleep(1000L);
                                updateInstallerListener.reportProgress("Checking progress");
                                if (!UpdateInstallerImpl.this.install_dir.exists()) break block10;
                                File file = new File(UpdateInstallerImpl.this.install_dir, "install.fail");
                                if (!file.exists()) continue;
                                try {
                                    String string = FileUtil.readFileAsString(file, 1024);
                                    throw new UpdateException(string);
                                }
                                catch (Throwable throwable) {
                                    if (throwable instanceof UpdateException) {
                                        throw throwable;
                                    }
                                    if (updateException != null) {
                                        throw updateException;
                                    }
                                    updateException = new UpdateException("Install failed, reason unknown");
                                }
                            } while (SystemTime.getMonotonousTime() - l < 300000L);
                            updateInstallerListener.reportProgress("Timeout");
                            throw new UpdateException("Timeout waiting for update to apply");
                        }
                        updateInstallerListener.reportProgress("Complete");
                        updateInstallerListener.complete();
                    }
                    catch (Throwable throwable) {
                        UpdateException updateException = throwable instanceof UpdateException ? (UpdateException)throwable : new UpdateException("install failed", throwable);
                        updateInstallerListener.reportProgress(updateException.getMessage());
                        updateInstallerListener.failed(updateException);
                    }
                    finally {
                        UpdateInstallerImpl.this.deleteInstaller();
                    }
                }
            }.start();
        }
        catch (Throwable throwable) {
            this.deleteInstaller();
            UpdateException updateException = throwable instanceof UpdateException ? (UpdateException)throwable : new UpdateException("install failed", throwable);
            updateInstallerListener.reportProgress(updateException.getMessage());
            updateInstallerListener.failed(updateException);
            throw updateException;
        }
    }

    @Override
    public void destroy() {
        this.deleteInstaller();
    }

    private void deleteInstaller() {
        this.manager.removeInstaller(this);
        if (this.install_dir.exists()) {
            FileUtil.recursiveDelete(this.install_dir);
        }
    }
}

