/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostPeer;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRequest;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentWillBeRemovedListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerPeer;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerPeerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentRequestImpl;

public class TrackerTorrentImpl
implements TrackerTorrent,
TRHostTorrentListener,
TRHostTorrentWillBeRemovedListener {
    protected TRHostTorrent host_torrent;
    protected List listeners_cow = new ArrayList();
    protected List removal_listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TrackerTorrent");

    public TrackerTorrentImpl(TRHostTorrent tRHostTorrent) {
        this.host_torrent = tRHostTorrent;
    }

    public TRHostTorrent getHostTorrent() {
        return this.host_torrent;
    }

    @Override
    public void start() throws TrackerException {
        try {
            this.host_torrent.start();
        }
        catch (Throwable throwable) {
            throw new TrackerException("Start failed", throwable);
        }
    }

    @Override
    public void stop() throws TrackerException {
        try {
            this.host_torrent.stop();
        }
        catch (Throwable throwable) {
            throw new TrackerException("Stop failed", throwable);
        }
    }

    @Override
    public void remove() throws TrackerTorrentRemovalVetoException {
        try {
            this.host_torrent.remove();
        }
        catch (TRHostTorrentRemovalVetoException tRHostTorrentRemovalVetoException) {
            throw new TrackerTorrentRemovalVetoException(tRHostTorrentRemovalVetoException.getMessage());
        }
    }

    @Override
    public boolean canBeRemoved() throws TrackerTorrentRemovalVetoException {
        try {
            this.host_torrent.canBeRemoved();
        }
        catch (TRHostTorrentRemovalVetoException tRHostTorrentRemovalVetoException) {
            throw new TrackerTorrentRemovalVetoException(tRHostTorrentRemovalVetoException.getMessage());
        }
        return true;
    }

    @Override
    public Torrent getTorrent() {
        return new TorrentImpl(this.host_torrent.getTorrent());
    }

    @Override
    public TrackerPeer[] getPeers() {
        TRHostPeer[] tRHostPeerArray = this.host_torrent.getPeers();
        TrackerPeer[] trackerPeerArray = new TrackerPeer[tRHostPeerArray.length];
        for (int i = 0; i < tRHostPeerArray.length; ++i) {
            trackerPeerArray[i] = new TrackerPeerImpl(tRHostPeerArray[i]);
        }
        return trackerPeerArray;
    }

    @Override
    public int getStatus() {
        int n = this.host_torrent.getStatus();
        switch (n) {
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        throw new RuntimeException("TrackerTorrent: status invalid");
    }

    @Override
    public long getTotalUploaded() {
        return this.host_torrent.getTotalUploaded();
    }

    @Override
    public long getTotalDownloaded() {
        return this.host_torrent.getTotalDownloaded();
    }

    @Override
    public long getAverageUploaded() {
        return this.host_torrent.getAverageUploaded();
    }

    @Override
    public long getAverageDownloaded() {
        return this.host_torrent.getAverageDownloaded();
    }

    @Override
    public long getTotalLeft() {
        return this.host_torrent.getTotalLeft();
    }

    @Override
    public long getCompletedCount() {
        return this.host_torrent.getCompletedCount();
    }

    @Override
    public long getTotalBytesIn() {
        return this.host_torrent.getTotalBytesIn();
    }

    @Override
    public long getAverageBytesIn() {
        return this.host_torrent.getAverageBytesIn();
    }

    @Override
    public long getTotalBytesOut() {
        return this.host_torrent.getTotalBytesOut();
    }

    @Override
    public long getAverageBytesOut() {
        return this.host_torrent.getAverageBytesOut();
    }

    @Override
    public long getAverageScrapeCount() {
        return this.host_torrent.getAverageScrapeCount();
    }

    @Override
    public long getScrapeCount() {
        return this.host_torrent.getScrapeCount();
    }

    @Override
    public long getAverageAnnounceCount() {
        return this.host_torrent.getAverageAnnounceCount();
    }

    @Override
    public long getAnnounceCount() {
        return this.host_torrent.getAnnounceCount();
    }

    @Override
    public int getSeedCount() {
        return this.host_torrent.getSeedCount();
    }

    @Override
    public int getLeecherCount() {
        return this.host_torrent.getLeecherCount();
    }

    @Override
    public int getBadNATCount() {
        return this.host_torrent.getBadNATCount();
    }

    @Override
    public void disableReplyCaching() {
        this.host_torrent.disableReplyCaching();
    }

    @Override
    public boolean isPassive() {
        return this.host_torrent.isPassive();
    }

    @Override
    public long getDateAdded() {
        return this.host_torrent.getDateAdded();
    }

    @Override
    public void preProcess(TRHostTorrentRequest tRHostTorrentRequest) throws TRHostException {
        List list = this.listeners_cow;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((TrackerTorrentListener)list.get(i)).preProcess(new TrackerTorrentRequestImpl(tRHostTorrentRequest));
                continue;
            }
            catch (TrackerException trackerException) {
                throw new TRHostException(trackerException.getMessage(), trackerException);
            }
            catch (Throwable throwable) {
                throw new TRHostException("Pre-process fails", throwable);
            }
        }
    }

    @Override
    public void postProcess(TRHostTorrentRequest tRHostTorrentRequest) throws TRHostException {
        List list = this.listeners_cow;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((TrackerTorrentListener)list.get(i)).postProcess(new TrackerTorrentRequestImpl(tRHostTorrentRequest));
                continue;
            }
            catch (TrackerException trackerException) {
                throw new TRHostException(trackerException.getMessage(), trackerException);
            }
            catch (Throwable throwable) {
                throw new TRHostException("Post-process fails", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TrackerTorrentListener trackerTorrentListener) {
        try {
            this.this_mon.enter();
            ArrayList<TrackerTorrentListener> arrayList = new ArrayList<TrackerTorrentListener>(this.listeners_cow);
            arrayList.add(trackerTorrentListener);
            if (arrayList.size() == 1) {
                this.host_torrent.addListener(this);
            }
            this.listeners_cow = arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(TrackerTorrentListener trackerTorrentListener) {
        try {
            this.this_mon.enter();
            ArrayList arrayList = new ArrayList(this.listeners_cow);
            arrayList.remove(trackerTorrentListener);
            if (arrayList.size() == 0) {
                this.host_torrent.removeListener(this);
            }
            this.listeners_cow = arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void torrentWillBeRemoved(TRHostTorrent tRHostTorrent) throws TRHostTorrentRemovalVetoException {
        for (int i = 0; i < this.removal_listeners.size(); ++i) {
            try {
                ((TrackerTorrentWillBeRemovedListener)this.removal_listeners.get(i)).torrentWillBeRemoved(this);
                continue;
            }
            catch (TrackerTorrentRemovalVetoException trackerTorrentRemovalVetoException) {
                throw new TRHostTorrentRemovalVetoException(trackerTorrentRemovalVetoException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemovalListener(TrackerTorrentWillBeRemovedListener trackerTorrentWillBeRemovedListener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(trackerTorrentWillBeRemovedListener);
            if (this.removal_listeners.size() == 1) {
                this.host_torrent.addRemovalListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRemovalListener(TrackerTorrentWillBeRemovedListener trackerTorrentWillBeRemovedListener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(trackerTorrentWillBeRemovedListener);
            if (this.removal_listeners.size() == 0) {
                this.host_torrent.removeRemovalListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof TrackerTorrentImpl) {
            return this.host_torrent == ((TrackerTorrentImpl)object).host_torrent;
        }
        return false;
    }

    public int hashCode() {
        return this.host_torrent.hashCode();
    }
}

