/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentCreator;
import org.gudy.azureus2.plugins.torrent.TorrentCreatorListener;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentEncodingException;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.torrent.TorrentManagerEvent;
import org.gudy.azureus2.plugins.torrent.TorrentManagerListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeCategoryImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeDisplayNameImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeNetworksImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributePeerSourcesImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeRelativeSavePathImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeSharePropertiesImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeTrackerClientExtImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeUserCommentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentDownloaderImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class TorrentManagerImpl
implements TorrentManager,
TOTorrentProgressListener {
    private static TorrentManagerImpl singleton;
    private static AEMonitor class_mon;
    private static TorrentAttribute category_attribute;
    private static TorrentAttribute share_properties_attribute;
    private static TorrentAttribute networks_attribute;
    private static TorrentAttribute peer_sources_attribute;
    private static TorrentAttribute tr_ext_attribute;
    private static TorrentAttribute disp_name_attribute;
    private static TorrentAttribute comment_attribute;
    private static TorrentAttribute relative_save_path_attribute;
    private static Map attribute_map;
    protected static List listeners;
    protected PluginInterface plugin_interface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TorrentManagerImpl getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TorrentManagerImpl(null);
            }
            TorrentManagerImpl torrentManagerImpl = singleton;
            return torrentManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected TorrentManagerImpl(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
    }

    public TorrentManager specialise(PluginInterface pluginInterface) {
        return new TorrentManagerImpl(pluginInterface);
    }

    @Override
    public TorrentDownloader getURLDownloader(URL uRL) throws TorrentException {
        return new TorrentDownloaderImpl(this, uRL);
    }

    @Override
    public TorrentDownloader getURLDownloader(URL uRL, String string, String string2) throws TorrentException {
        return new TorrentDownloaderImpl(this, uRL, string, string2);
    }

    @Override
    public Torrent createFromBEncodedFile(File file) throws TorrentException {
        return this.createFromBEncodedFile(file, false);
    }

    @Override
    public Torrent createFromBEncodedFile(File file, boolean bl) throws TorrentException {
        try {
            TOTorrent tOTorrent = bl ? TorrentUtils.readFromFile(file, true, true) : TorrentUtils.readFromFile(file, false);
            return new TorrentImpl(this.plugin_interface, tOTorrent);
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("TorrentManager::createFromBEncodedFile Fails", tOTorrentException);
        }
    }

    @Override
    public Torrent createFromBEncodedInputStream(InputStream inputStream) throws TorrentException {
        try {
            return new TorrentImpl(this.plugin_interface, TorrentUtils.readFromBEncodedInputStream(inputStream));
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("TorrentManager::createFromBEncodedFile Fails", tOTorrentException);
        }
    }

    @Override
    public Torrent createFromBEncodedData(byte[] byArray) throws TorrentException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            TorrentImpl torrentImpl = new TorrentImpl(this.plugin_interface, TorrentUtils.readFromBEncodedInputStream(byteArrayInputStream));
            return torrentImpl;
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("TorrentManager::createFromBEncodedData Fails", tOTorrentException);
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    @Override
    public Torrent createFromDataFile(File file, URL uRL) throws TorrentException {
        return this.createFromDataFile(file, uRL, false);
    }

    @Override
    public Torrent createFromDataFile(File file, URL uRL, boolean bl) throws TorrentException {
        try {
            TOTorrentCreator tOTorrentCreator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, uRL, bl);
            tOTorrentCreator.addListener(this);
            return new TorrentImpl(this.plugin_interface, tOTorrentCreator.create());
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("TorrentManager::createFromDataFile Fails", tOTorrentException);
        }
    }

    @Override
    public TorrentCreator createFromDataFileEx(File file, URL uRL, boolean bl) throws TorrentException {
        try {
            final TOTorrentCreator tOTorrentCreator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(file, uRL, bl);
            return new TorrentCreator(){
                private CopyOnWriteList listeners = new CopyOnWriteList();

                @Override
                public void start() {
                    tOTorrentCreator.addListener(new TOTorrentProgressListener(){

                        @Override
                        public void reportProgress(int n) {
                            Iterator iterator = listeners.iterator();
                            while (iterator.hasNext()) {
                                ((TorrentCreatorListener)iterator.next()).reportPercentageDone(n);
                            }
                        }

                        @Override
                        public void reportCurrentTask(String string) {
                            Iterator iterator = listeners.iterator();
                            while (iterator.hasNext()) {
                                ((TorrentCreatorListener)iterator.next()).reportActivity(string);
                            }
                        }
                    });
                    new AEThread("TorrentManager::create", true){

                        @Override
                        public void runSupport() {
                            try {
                                TOTorrent tOTorrent = tOTorrentCreator.create();
                                TorrentImpl torrentImpl = new TorrentImpl(TorrentManagerImpl.this.plugin_interface, tOTorrent);
                                Iterator iterator = listeners.iterator();
                                while (iterator.hasNext()) {
                                    ((TorrentCreatorListener)iterator.next()).complete(torrentImpl);
                                }
                            }
                            catch (TOTorrentException tOTorrentException) {
                                Iterator iterator = listeners.iterator();
                                while (iterator.hasNext()) {
                                    ((TorrentCreatorListener)iterator.next()).failed(new TorrentException(tOTorrentException));
                                }
                            }
                        }
                    }.start();
                }

                @Override
                public void cancel() {
                    tOTorrentCreator.cancel();
                }

                @Override
                public void addListener(TorrentCreatorListener torrentCreatorListener) {
                    this.listeners.add(torrentCreatorListener);
                }

                @Override
                public void removeListener(TorrentCreatorListener torrentCreatorListener) {
                    this.listeners.remove(torrentCreatorListener);
                }
            };
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("TorrentManager::createFromDataFile Fails", tOTorrentException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TorrentAttribute[] getDefinedAttributes() {
        try {
            class_mon.enter();
            Collection collection = attribute_map.values();
            TorrentAttribute[] torrentAttributeArray = new TorrentAttribute[collection.size()];
            collection.toArray(torrentAttributeArray);
            TorrentAttribute[] torrentAttributeArray2 = torrentAttributeArray;
            return torrentAttributeArray2;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TorrentAttribute getAttribute(String string) {
        try {
            class_mon.enter();
            TorrentAttribute torrentAttribute = (TorrentAttribute)attribute_map.get(string);
            if (torrentAttribute == null && string.startsWith("Plugin.")) {
                torrentAttribute = new TorrentAttributePluginImpl(string);
                attribute_map.put(string, torrentAttribute);
            }
            if (torrentAttribute == null) {
                throw new IllegalArgumentException("No such attribute: \"" + string + "\"");
            }
            TorrentAttribute torrentAttribute2 = torrentAttribute;
            return torrentAttribute2;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TorrentAttribute getPluginAttribute(String string) {
        string = "Plugin." + this.plugin_interface.getPluginID() + "." + string;
        try {
            class_mon.enter();
            TorrentAttribute torrentAttribute = (TorrentAttribute)attribute_map.get(string);
            if (torrentAttribute != null) {
                TorrentAttribute torrentAttribute2 = torrentAttribute;
                return torrentAttribute2;
            }
            torrentAttribute = new TorrentAttributePluginImpl(string);
            attribute_map.put(string, torrentAttribute);
            TorrentAttribute torrentAttribute3 = torrentAttribute;
            return torrentAttribute3;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public Torrent createFromBEncodedData(byte[] byArray, int n) throws TorrentException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(byteArrayInputStream);
            TorrentImpl torrentImpl = new TorrentImpl(this.plugin_interface, this.preserveFields(tOTorrent, n));
            return torrentImpl;
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("Failed to read TorrentData", tOTorrentException);
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Torrent createFromBEncodedFile(File file, int n) throws TorrentException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(fileInputStream);
            TorrentImpl torrentImpl = new TorrentImpl(this.plugin_interface, this.preserveFields(tOTorrent, n));
            return torrentImpl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TorrentException("Failed to read from TorrentFile", fileNotFoundException);
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("Failed to read TorrentData", tOTorrentException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Torrent createFromBEncodedInputStream(InputStream inputStream, int n) throws TorrentException {
        try {
            TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(inputStream);
            return new TorrentImpl(this.plugin_interface, this.preserveFields(tOTorrent, n));
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("Failed to read TorrentData", tOTorrentException);
        }
    }

    private TOTorrent preserveFields(TOTorrent tOTorrent, int n) {
        if (n == -1) {
            return tOTorrent;
        }
        if ((n & 1) > 0) {
            String string = tOTorrent.getAdditionalStringProperty("encoding");
            tOTorrent.removeAdditionalProperties();
            if (string != null) {
                tOTorrent.setAdditionalStringProperty("encoding", string);
            }
        } else if (n == 0) {
            tOTorrent.removeAdditionalProperties();
        }
        return tOTorrent;
    }

    @Override
    public void reportProgress(int n) {
    }

    @Override
    public void reportCurrentTask(final String string) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ((TorrentManagerListener)iterator.next()).event(new TorrentManagerEvent(){

                @Override
                public Object getData() {
                    return string;
                }
            });
        }
    }

    protected void tryToSetTorrentEncoding(TOTorrent tOTorrent, String string) throws TorrentEncodingException {
        try {
            LocaleTorrentUtil.setTorrentEncoding(tOTorrent, string);
        }
        catch (LocaleUtilEncodingException localeUtilEncodingException) {
            String[] stringArray = localeUtilEncodingException.getValidCharsets();
            if (stringArray == null) {
                throw new TorrentEncodingException("Failed to set requested encoding", localeUtilEncodingException);
            }
            throw new TorrentEncodingException(stringArray, localeUtilEncodingException.getValidTorrentNames());
        }
    }

    protected void tryToSetDefaultTorrentEncoding(TOTorrent tOTorrent) throws TorrentException {
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(tOTorrent);
        }
        catch (LocaleUtilEncodingException localeUtilEncodingException) {
            String[] stringArray = localeUtilEncodingException.getValidCharsets();
            if (stringArray == null) {
                throw new TorrentEncodingException("Failed to set default encoding", localeUtilEncodingException);
            }
            throw new TorrentEncodingException(stringArray, localeUtilEncodingException.getValidTorrentNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TorrentManagerListener torrentManagerListener) {
        try {
            class_mon.enter();
            ArrayList<TorrentManagerListener> arrayList = new ArrayList<TorrentManagerListener>(listeners);
            arrayList.add(torrentManagerListener);
            listeners = arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(TorrentManagerListener torrentManagerListener) {
        try {
            class_mon.enter();
            ArrayList arrayList = new ArrayList(listeners);
            arrayList.remove(torrentManagerListener);
            listeners = arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    static {
        class_mon = new AEMonitor("TorrentManager");
        category_attribute = new TorrentAttributeCategoryImpl();
        share_properties_attribute = new TorrentAttributeSharePropertiesImpl();
        networks_attribute = new TorrentAttributeNetworksImpl();
        peer_sources_attribute = new TorrentAttributePeerSourcesImpl();
        tr_ext_attribute = new TorrentAttributeTrackerClientExtImpl();
        disp_name_attribute = new TorrentAttributeDisplayNameImpl();
        comment_attribute = new TorrentAttributeUserCommentImpl();
        relative_save_path_attribute = new TorrentAttributeRelativeSavePathImpl();
        attribute_map = new HashMap();
        attribute_map.put("Category", category_attribute);
        attribute_map.put("ShareProperties", share_properties_attribute);
        attribute_map.put("Networks", networks_attribute);
        attribute_map.put("PeerSources", peer_sources_attribute);
        attribute_map.put("TrackerClientExtensions", tr_ext_attribute);
        attribute_map.put("DisplayName", disp_name_attribute);
        attribute_map.put("UserComment", comment_attribute);
        attribute_map.put("RelativePath", relative_save_path_attribute);
        listeners = new ArrayList();
    }
}

