/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.plugins.magnet.MagnetPlugin;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLList;
import org.gudy.azureus2.plugins.torrent.TorrentEncodingException;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentFile;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAnnounceURLListImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentFileImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class TorrentImpl
extends LogRelation
implements Torrent {
    private static MagnetPlugin magnet_plugin;
    private PluginInterface pi;
    private TOTorrent torrent;
    private LocaleUtilDecoder decoder;
    private boolean complete;

    public TorrentImpl(TOTorrent tOTorrent) {
        this(null, tOTorrent);
    }

    public TorrentImpl(PluginInterface pluginInterface, TOTorrent tOTorrent) {
        this.pi = pluginInterface;
        this.torrent = tOTorrent;
    }

    @Override
    public String getName() {
        String string = this.torrent.getUTF8Name();
        String string2 = string == null ? this.decode(this.torrent.getName()) : string;
        string2 = FileUtil.convertOSSpecificChars(string2, false);
        return string2;
    }

    @Override
    public URL getAnnounceURL() {
        return this.torrent.getAnnounceURL();
    }

    @Override
    public void setAnnounceURL(URL uRL) {
        this.torrent.setAnnounceURL(uRL);
        this.updated();
    }

    @Override
    public TorrentAnnounceURLList getAnnounceURLList() {
        return new TorrentAnnounceURLListImpl(this);
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public boolean isDecentralised() {
        return TorrentUtils.isDecentralised(this.torrent);
    }

    @Override
    public boolean isDecentralisedBackupEnabled() {
        return TorrentUtils.getDHTBackupEnabled(this.torrent);
    }

    @Override
    public void setDecentralisedBackupRequested(boolean bl) {
        TorrentUtils.setDHTBackupRequested(this.torrent, bl);
    }

    @Override
    public boolean isDecentralisedBackupRequested() {
        return TorrentUtils.isDHTBackupRequested(this.torrent);
    }

    @Override
    public boolean isPrivate() {
        return TorrentUtils.getPrivate(this.torrent);
    }

    @Override
    public void setPrivate(boolean bl) {
        TorrentUtils.setPrivate(this.torrent, bl);
    }

    @Override
    public boolean wasCreatedByUs() {
        return TorrentUtils.isCreatedTorrent(this.torrent);
    }

    @Override
    public URL getMagnetURI() throws TorrentException {
        Object object;
        if (magnet_plugin == null && (object = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(MagnetPlugin.class)) != null) {
            magnet_plugin = (MagnetPlugin)object.getPlugin();
        }
        if (magnet_plugin == null) {
            throw new TorrentException("MegnetPlugin unavailable");
        }
        try {
            object = magnet_plugin.getMagnetURL(this.torrent.getHash());
            return object;
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException(tOTorrentException);
        }
    }

    @Override
    public byte[] getHash() {
        try {
            return this.torrent.getHash();
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return null;
        }
    }

    @Override
    public long getSize() {
        return this.torrent.getSize();
    }

    @Override
    public String getComment() {
        return this.decode(this.torrent.getComment());
    }

    @Override
    public void setComment(String string) {
        this.torrent.setComment(string);
    }

    @Override
    public long getCreationDate() {
        return this.torrent.getCreationDate();
    }

    @Override
    public String getCreatedBy() {
        return this.decode(this.torrent.getCreatedBy());
    }

    @Override
    public long getPieceSize() {
        return this.torrent.getPieceLength();
    }

    @Override
    public long getPieceCount() {
        return this.torrent.getNumberOfPieces();
    }

    @Override
    public byte[][] getPieces() {
        try {
            return this.torrent.getPieces();
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return new byte[0][0];
        }
    }

    @Override
    public TorrentFile[] getFiles() {
        TOTorrentFile[] tOTorrentFileArray = this.torrent.getFiles();
        TorrentFile[] torrentFileArray = new TorrentFile[tOTorrentFileArray.length];
        for (int i = 0; i < torrentFileArray.length; ++i) {
            TOTorrentFile tOTorrentFile = tOTorrentFileArray[i];
            byte[][] byArray = tOTorrentFile.getPathComponents();
            String string = "";
            for (int j = 0; j < byArray.length; ++j) {
                String string2 = this.decode(byArray[j]);
                string2 = FileUtil.convertOSSpecificChars(string2, j != byArray.length - 1);
                string = string + (j == 0 ? "" : File.separator) + string2;
            }
            torrentFileArray[i] = new TorrentFileImpl(string, tOTorrentFile.getLength());
        }
        return torrentFileArray;
    }

    protected void getDecoder() {
        try {
            this.decoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getEncoding() {
        this.getDecoder();
        if (this.decoder != null) {
            return this.decoder.getName();
        }
        return "UTF8";
    }

    @Override
    public void setEncoding(String string) throws TorrentEncodingException {
        try {
            LocaleTorrentUtil.setTorrentEncoding(this.torrent, string);
        }
        catch (LocaleUtilEncodingException localeUtilEncodingException) {
            throw new TorrentEncodingException("Failed to set the encoding", localeUtilEncodingException);
        }
    }

    @Override
    public void setDefaultEncoding() throws TorrentEncodingException {
        this.setEncoding("UTF8");
    }

    protected String decode(byte[] byArray) {
        this.getDecoder();
        if (byArray != null) {
            if (this.decoder != null) {
                try {
                    return this.decoder.decodeString(byArray);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new String(byArray);
        }
        return "";
    }

    @Override
    public Object getAdditionalProperty(String string) {
        return this.torrent.getAdditionalProperty(string);
    }

    @Override
    public Torrent removeAdditionalProperties() {
        try {
            TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromMap(this.torrent.serialiseToMap());
            tOTorrent.removeAdditionalProperties();
            return new TorrentImpl(tOTorrent);
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return this;
        }
    }

    @Override
    public void setPluginStringProperty(String string, String string2) {
        PluginInterface pluginInterface = this.pi;
        if (pluginInterface == null) {
            pluginInterface = UtilitiesImpl.getPluginThreadContext();
        }
        string = pluginInterface == null ? "<internal>." + string : pluginInterface.getPluginID() + "." + string;
        TorrentUtils.setPluginStringProperty(this.torrent, string, string2);
    }

    @Override
    public String getPluginStringProperty(String string) {
        PluginInterface pluginInterface = this.pi;
        if (pluginInterface == null) {
            pluginInterface = UtilitiesImpl.getPluginThreadContext();
        }
        string = pluginInterface == null ? "<internal>." + string : pluginInterface.getPluginID() + "." + string;
        return TorrentUtils.getPluginStringProperty(this.torrent, string);
    }

    @Override
    public void setMapProperty(String string, Map map) {
        TorrentUtils.setPluginMapProperty(this.torrent, string, map);
    }

    @Override
    public Map getMapProperty(String string) {
        return TorrentUtils.getPluginMapProperty(this.torrent, string);
    }

    @Override
    public Map writeToMap() throws TorrentException {
        try {
            return this.torrent.serialiseToMap();
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("Torrent::writeToMap: fails", tOTorrentException);
        }
    }

    @Override
    public byte[] writeToBEncodedData() throws TorrentException {
        try {
            Map map = this.torrent.serialiseToMap();
            return BEncoder.encode(map);
        }
        catch (Throwable throwable) {
            throw new TorrentException("Torrent::writeToBEncodedData: fails", throwable);
        }
    }

    @Override
    public void writeToFile(File file) throws TorrentException {
        try {
            this.torrent.serialiseToBEncodedFile(file);
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("Torrent::writeToFile: fails", tOTorrentException);
        }
    }

    protected void updated() {
        try {
            DownloadImpl downloadImpl = (DownloadImpl)DownloadManagerImpl.getDownloadStatic(this.torrent);
            if (downloadImpl != null) {
                downloadImpl.torrentChanged();
            }
        }
        catch (DownloadException downloadException) {
            // empty catch block
        }
    }

    @Override
    public void save() throws TorrentException {
        try {
            TorrentUtils.writeToFile(this.torrent);
        }
        catch (TOTorrentException tOTorrentException) {
            throw new TorrentException("Torrent::save Fails", tOTorrentException);
        }
    }

    @Override
    public void setComplete(File file) throws TorrentException {
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(this.torrent);
            DownloadManagerState downloadManagerState = DownloadManagerStateFactory.getDownloadState(this.torrent);
            TorrentUtils.setResumeDataCompletelyValid(downloadManagerState);
            downloadManagerState.save();
            this.complete = true;
        }
        catch (Throwable throwable) {
            throw new TorrentException("encoding selection fails", throwable);
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public String getRelationText() {
        return this.propogatedRelationText(this.torrent);
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.torrent};
    }

    @Override
    public boolean isSimpleTorrent() {
        return this.torrent.isSimpleTorrent();
    }
}

