/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.FilePluginInstaller;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.PluginInstallerListener;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.FailedPlugin;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.installer.FilePluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.InstallablePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.StandardPluginImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsException;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;

public class PluginInstallerImpl
implements PluginInstaller {
    protected static PluginInstallerImpl singleton;
    private PluginManager manager;
    private List listeners = new ArrayList();
    private AsyncDispatcher add_file_install_dispatcher;

    public static PluginInstallerImpl getSingleton(PluginManager pluginManager) {
        if (singleton == null) {
            singleton = new PluginInstallerImpl(pluginManager);
        }
        return singleton;
    }

    protected PluginInstallerImpl(PluginManager pluginManager) {
        this.manager = pluginManager;
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            @Override
            public void process(VuzeFile[] vuzeFileArray, int n) {
                for (int i = 0; i < vuzeFileArray.length; ++i) {
                    VuzeFile vuzeFile = vuzeFileArray[i];
                    VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
                    for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                        VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                        if (vuzeFileComponent.getType() != 8) continue;
                        try {
                            Map map = vuzeFileComponent.getContent();
                            String string = new String((byte[])map.get("id"), "UTF-8");
                            String string2 = new String((byte[])map.get("version"), "UTF-8");
                            String string3 = (Long)map.get("is_jar") == 1L ? "jar" : "zip";
                            byte[] byArray = (byte[])map.get("file");
                            File file = AETemporaryFileHandler.createTempDir();
                            File file2 = new File(file, string + "_" + string2 + "." + string3);
                            FileUtil.copyFile((InputStream)new ByteArrayInputStream(byArray), file2);
                            FilePluginInstaller filePluginInstaller = PluginInstallerImpl.this.installFromFile(file2);
                            PluginInstallerImpl.this.addFileInstallOperation(filePluginInstaller);
                            vuzeFileComponent.setProcessed();
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileInstallOperation(final FilePluginInstaller filePluginInstaller) {
        PluginInstallerImpl pluginInstallerImpl = this;
        synchronized (pluginInstallerImpl) {
            if (this.add_file_install_dispatcher == null) {
                this.add_file_install_dispatcher = new AsyncDispatcher();
            }
            this.add_file_install_dispatcher.dispatch(new AERunnable(){

                @Override
                public void runSupport() {
                    try {
                        final AESemaphore aESemaphore = new AESemaphore("PluginInstall:fio");
                        final UIManager uIManager = StaticUtilities.getUIManager(120000L);
                        new AEThread2("PluginInstall:fio", true){

                            @Override
                            public void run() {
                                if (filePluginInstaller.isAlreadyInstalled()) {
                                    String string = MessageText.getString("fileplugininstall.duplicate.desc", new String[]{filePluginInstaller.getName(), filePluginInstaller.getVersion()});
                                    uIManager.showMessageBox("fileplugininstall.duplicate.title", "!" + string + "!", 1L);
                                    aESemaphore.release();
                                } else {
                                    String string = MessageText.getString("fileplugininstall.install.desc", new String[]{filePluginInstaller.getName(), filePluginInstaller.getVersion()});
                                    long l = uIManager.showMessageBox("fileplugininstall.install.title", "!" + string + "!", 12L);
                                    if (l == 4L) {
                                        try {
                                            PluginInstallerImpl.this.install(new InstallablePlugin[]{filePluginInstaller}, false, true, null, new PluginInstallationListener(){

                                                @Override
                                                public void completed() {
                                                    aESemaphore.release();
                                                }

                                                @Override
                                                public void cancelled() {
                                                    aESemaphore.release();
                                                }

                                                @Override
                                                public void failed(PluginException pluginException) {
                                                    aESemaphore.release();
                                                    Debug.out("Installation failed", pluginException);
                                                }
                                            });
                                        }
                                        catch (Throwable throwable) {
                                            Debug.printStackTrace(throwable);
                                            aESemaphore.release();
                                        }
                                    } else if (l == 8L) {
                                        aESemaphore.release();
                                    } else {
                                        Debug.out("Message box not handled");
                                        aESemaphore.release();
                                    }
                                }
                            }
                        }.start();
                        while (!aESemaphore.reserve(60000L)) {
                            if (PluginInstallerImpl.this.add_file_install_dispatcher.getQueueSize() <= 0) continue;
                            Debug.out("File plugin install operation queued pending completion of previous");
                        }
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
            });
        }
    }

    protected PluginManager getPluginManager() {
        return this.manager;
    }

    @Override
    public StandardPlugin[] getStandardPlugins() throws PluginException {
        try {
            SFPluginDetailsLoader sFPluginDetailsLoader = SFPluginDetailsLoaderFactory.getSingleton();
            SFPluginDetails[] sFPluginDetailsArray = sFPluginDetailsLoader.getPluginDetails();
            ArrayList<StandardPluginImpl> arrayList = new ArrayList<StandardPluginImpl>();
            for (int i = 0; i < sFPluginDetailsArray.length; ++i) {
                SFPluginDetails sFPluginDetails = sFPluginDetailsArray[i];
                String string = sFPluginDetails.getId();
                String string2 = "";
                if (Constants.isCVSVersion()) {
                    string2 = sFPluginDetails.getCVSVersion();
                }
                if (string2 == null || string2.length() == 0 || !Character.isDigit(string2.charAt(0))) {
                    string2 = sFPluginDetails.getVersion();
                } else {
                    String string3 = sFPluginDetails.getVersion();
                    if (string2.equals(string3 + "_CVS")) {
                        string2 = string3;
                    }
                }
                if (string.startsWith("azplatform") || string.equals("azupdater") || string2 == null || string2.length() == 0 || !Character.isDigit(string2.charAt(0)) || sFPluginDetails.getCategory().equalsIgnoreCase("hidden")) continue;
                arrayList.add(new StandardPluginImpl(this, sFPluginDetailsArray[i], string2));
            }
            StandardPlugin[] standardPluginArray = new StandardPlugin[arrayList.size()];
            arrayList.toArray(standardPluginArray);
            return standardPluginArray;
        }
        catch (SFPluginDetailsException sFPluginDetailsException) {
            throw new PluginException("Failed to load standard plugin details", sFPluginDetailsException);
        }
    }

    @Override
    public StandardPlugin getStandardPlugin(String string) throws PluginException {
        try {
            SFPluginDetailsLoader sFPluginDetailsLoader = SFPluginDetailsLoaderFactory.getSingleton();
            SFPluginDetails[] sFPluginDetailsArray = sFPluginDetailsLoader.getPluginDetails();
            for (int i = 0; i < sFPluginDetailsArray.length; ++i) {
                SFPluginDetails sFPluginDetails = sFPluginDetailsArray[i];
                String string2 = sFPluginDetails.getId();
                if (!string2.equals(string)) continue;
                String string3 = "";
                if (Constants.isCVSVersion()) {
                    string3 = sFPluginDetails.getCVSVersion();
                }
                if (string3 == null || string3.length() == 0 || !Character.isDigit(string3.charAt(0))) {
                    string3 = sFPluginDetails.getVersion();
                } else {
                    String string4 = sFPluginDetails.getVersion();
                    if (string3.equals(string4 + "_CVS")) {
                        string3 = string4;
                    }
                }
                if (string2.startsWith("azplatform") || string2.equals("azupdater") || string3 == null || string3.length() == 0 || !Character.isDigit(string3.charAt(0))) continue;
                return new StandardPluginImpl(this, sFPluginDetailsArray[i], string3);
            }
            return null;
        }
        catch (SFPluginDetailsException sFPluginDetailsException) {
            throw new PluginException("Failed to load standard plugin details", sFPluginDetailsException);
        }
    }

    @Override
    public FilePluginInstaller installFromFile(File file) throws PluginException {
        return new FilePluginInstallerImpl(this, file);
    }

    public void install(InstallablePlugin installablePlugin, boolean bl) throws PluginException {
        this.install(new InstallablePlugin[]{installablePlugin}, bl);
    }

    @Override
    public void install(InstallablePlugin[] installablePluginArray, boolean bl) throws PluginException {
        this.install(installablePluginArray, bl, false, null, null);
    }

    @Override
    public UpdateCheckInstance install(InstallablePlugin[] installablePluginArray, boolean bl, Map<Integer, Object> map, PluginInstallationListener pluginInstallationListener) throws PluginException {
        return this.install(installablePluginArray, bl, false, map, pluginInstallationListener);
    }

    protected UpdateCheckInstance install(InstallablePlugin[] installablePluginArray, boolean bl, boolean bl2, Map<Integer, Object> map, final PluginInstallationListener pluginInstallationListener) throws PluginException {
        PluginInterface pluginInterface = this.manager.getPluginInterfaceByClass(PluginUpdatePlugin.class);
        if (pluginInterface == null) {
            throw new PluginException("Installation aborted, plugin-update plugin unavailable");
        }
        if (!pluginInterface.getPluginState().isOperational()) {
            throw new PluginException("Installation aborted, plugin-update plugin not operational");
        }
        PluginUpdatePlugin pluginUpdatePlugin = (PluginUpdatePlugin)pluginInterface.getPlugin();
        UpdateManagerImpl updateManagerImpl = (UpdateManagerImpl)this.manager.getDefaultPluginInterface().getUpdateManager();
        UpdateCheckInstanceImpl updateCheckInstanceImpl = updateManagerImpl.createEmptyUpdateCheckInstance(1, "update.instance.install", bl2);
        if (map != null) {
            for (Map.Entry<Integer, Object> object : map.entrySet()) {
                updateCheckInstanceImpl.setProperty(object.getKey(), object.getValue());
            }
        }
        if (pluginInstallationListener != null) {
            updateCheckInstanceImpl.addListener(new UpdateCheckInstanceListener(){

                @Override
                public void cancelled(UpdateCheckInstance updateCheckInstance) {
                    pluginInstallationListener.cancelled();
                }

                @Override
                public void complete(UpdateCheckInstance updateCheckInstance) {
                    final Update[] updateArray = updateCheckInstance.getUpdates();
                    if (updateArray.length == 0) {
                        pluginInstallationListener.failed(new PluginException("No updates were added during check process"));
                    } else {
                        for (int i = 0; i < updateArray.length; ++i) {
                            updateArray[i].addListener(new UpdateListener(){
                                private boolean cancelled;

                                @Override
                                public void cancelled(Update update) {
                                    this.cancelled = true;
                                    this.check();
                                }

                                @Override
                                public void complete(Update update) {
                                    this.check();
                                }

                                protected void check() {
                                    Update update = null;
                                    for (Update update2 : updateArray) {
                                        if (!update2.isCancelled() && !update2.isComplete()) {
                                            return;
                                        }
                                        if (update2.wasSuccessful()) continue;
                                        update = update2;
                                    }
                                    if (this.cancelled) {
                                        pluginInstallationListener.cancelled();
                                    } else if (update == null) {
                                        PluginInitializer.waitForPluginEvents();
                                        pluginInstallationListener.completed();
                                    } else {
                                        pluginInstallationListener.failed(new PluginException("Install of " + update.getName() + " failed"));
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
        try {
            for (int i = 0; i < installablePluginArray.length; ++i) {
                String string;
                InstallablePlugin installablePlugin = installablePluginArray[i];
                final String string2 = installablePlugin.getId();
                PluginInterface pluginInterface2 = this.manager.getPluginInterfaceByID(string2, false);
                Plugin plugin = null;
                if (pluginInterface2 != null) {
                    plugin = pluginInterface2.getPlugin();
                    string = pluginInterface2.getPluginVersion();
                    if (string != null) {
                        int n = Constants.compareVersions(installablePlugin.getVersion(), string);
                        if (n < 0) {
                            throw new PluginException("A higher version (" + string + ") of Plugin '" + string2 + "' is already installed");
                        }
                        if (n == 0) {
                            throw new PluginException("Version (" + string + ") of Plugin '" + string2 + "' is already installed");
                        }
                    }
                }
                string = bl ? FileUtil.getApplicationFile("plugins").toString() : FileUtil.getUserFile("plugins").toString();
                string = string + File.separator + string2;
                new File(string).mkdir();
                if (plugin == null) {
                    FailedPlugin failedPlugin = new FailedPlugin(string2, string);
                    PluginManager.registerPlugin(failedPlugin, string2);
                    final PluginInterface pluginInterface3 = this.manager.getPluginInterfaceByID(string2, false);
                    ((InstallablePluginImpl)installablePlugin).addUpdate(updateCheckInstanceImpl, pluginUpdatePlugin, failedPlugin, pluginInterface3);
                    updateCheckInstanceImpl.addListener(new UpdateCheckInstanceListener(){

                        @Override
                        public void cancelled(UpdateCheckInstance updateCheckInstance) {
                            try {
                                pluginInterface3.getPluginState().unload();
                            }
                            catch (Throwable throwable) {
                                Debug.out("Failed to unload plugin", throwable);
                            }
                        }

                        @Override
                        public void complete(UpdateCheckInstance updateCheckInstance) {
                            PluginInterface pluginInterface = PluginInstallerImpl.this.manager.getPluginInterfaceByID(string2, false);
                            if (pluginInterface != null && pluginInterface.getPlugin() instanceof FailedPlugin) {
                                try {
                                    pluginInterface.getPluginState().unload();
                                }
                                catch (Throwable throwable) {
                                    Debug.out("Failed to unload plugin", throwable);
                                }
                            }
                        }
                    });
                    continue;
                }
                ((InstallablePluginImpl)installablePlugin).addUpdate(updateCheckInstanceImpl, pluginUpdatePlugin, plugin, pluginInterface2);
            }
            updateCheckInstanceImpl.start();
            return updateCheckInstanceImpl;
        }
        catch (Throwable throwable) {
            updateCheckInstanceImpl.cancel();
            if (throwable instanceof PluginException) {
                throw (PluginException)throwable;
            }
            throw new PluginException("Failed to create installer", throwable);
        }
    }

    public void uninstall(InstallablePlugin installablePlugin) throws PluginException {
        PluginInterface pluginInterface = installablePlugin.getAlreadyInstalledPlugin();
        if (pluginInterface == null) {
            throw new PluginException(" Plugin '" + installablePlugin.getId() + "' is not installed");
        }
        pluginInterface.getPluginState().uninstall();
    }

    @Override
    public void uninstall(PluginInterface pluginInterface) throws PluginException {
        this.uninstall(new PluginInterface[]{pluginInterface});
    }

    @Override
    public void uninstall(PluginInterface[] pluginInterfaceArray) throws PluginException {
        Object object;
        for (int i = 0; i < pluginInterfaceArray.length; ++i) {
            object = pluginInterfaceArray[i];
            if (object.getPluginState().isMandatory()) {
                throw new PluginException("Plugin '" + object.getPluginID() + "' is mandatory, can't uninstall");
            }
            if (object.getPluginState().isBuiltIn()) {
                throw new PluginException("Plugin '" + object.getPluginID() + "' is built-in, can't uninstall");
            }
            String string = object.getPluginDirectoryName();
            if (string != null && new File(string).exists()) continue;
            throw new PluginException("Plugin '" + object.getPluginID() + "' is not loaded from the file system, can't uninstall");
        }
        try {
            UpdateManager updateManager = this.manager.getDefaultPluginInterface().getUpdateManager();
            object = updateManager.createEmptyUpdateCheckInstance(3, "update.instance.uninstall");
            for (int i = 0; i < pluginInterfaceArray.length; ++i) {
                final PluginInterface pluginInterface = pluginInterfaceArray[i];
                final String string = pluginInterface.getPluginDirectoryName();
                object.addUpdatableComponent(new UpdatableComponent(){

                    @Override
                    public String getName() {
                        return pluginInterface.getPluginName();
                    }

                    @Override
                    public int getMaximumCheckTime() {
                        return 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void checkForUpdate(final UpdateChecker updateChecker) {
                        try {
                            ResourceDownloader resourceDownloader = PluginInstallerImpl.this.manager.getDefaultPluginInterface().getUtilities().getResourceDownloaderFactory().create(new File(string));
                            String string2 = "";
                            PluginInterface[] pluginInterfaceArray = PluginInstallerImpl.this.manager.getPluginInterfaces();
                            Arrays.sort(pluginInterfaceArray, new Comparator(){

                                public int compare(Object object, Object object2) {
                                    return ((PluginInterface)object).getPluginName().compareTo(((PluginInterface)object2).getPluginName());
                                }
                            });
                            for (int i = 0; i < pluginInterfaceArray.length; ++i) {
                                if (!pluginInterfaceArray[i].getPluginID().equals(pluginInterface.getPluginID())) continue;
                                string2 = string2 + (string2.length() == 0 ? "" : ",") + pluginInterfaceArray[i].getPluginName();
                            }
                            final Update update = updateChecker.addUpdate(string2, new String[]{"Uninstall: " + string}, pluginInterface.getPluginVersion(), resourceDownloader, pluginInterface.getPluginState().isUnloadable() ? 1 : 2);
                            resourceDownloader.addListener(new ResourceDownloaderAdapter(){

                                @Override
                                public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
                                    try {
                                        if (pluginInterface.getPluginState().isUnloadable()) {
                                            pluginInterface.getPluginState().unload();
                                            FileUtil.recursiveDelete(new File(string));
                                        }
                                        UpdateInstaller updateInstaller = updateChecker.createInstaller();
                                        updateInstaller.addRemoveAction(new File(string).getCanonicalPath());
                                        update.complete(true);
                                        try {
                                            PluginInitializer.fireEvent(12, pluginInterface.getPluginID());
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        update.complete(false);
                                        Debug.printStackTrace(throwable);
                                        Logger.log(new LogAlert(true, "Plugin uninstall failed", throwable));
                                    }
                                    return true;
                                }

                                @Override
                                public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
                                    update.complete(false);
                                    if (!resourceDownloader.isCancelled()) {
                                        Logger.log(new LogAlert(true, "Plugin uninstall failed", resourceDownloaderException));
                                    }
                                }
                            });
                        }
                        finally {
                            updateChecker.completed();
                        }
                    }
                }, false);
            }
            object.start();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected PluginInterface getAlreadyInstalledPlugin(String string) {
        return this.getPluginManager().getPluginInterfaceByID(string, false);
    }

    @Override
    public void requestInstall(String string, InstallablePlugin installablePlugin) throws PluginException {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!((PluginInstallerListener)this.listeners.get(i)).installRequest(string, installablePlugin)) continue;
            return;
        }
        throw new PluginException("No listeners registered to perform installation of '" + installablePlugin.getName() + " (" + string + ")");
    }

    @Override
    public void addListener(PluginInstallerListener pluginInstallerListener) {
        this.listeners.add(pluginInstallerListener);
    }

    @Override
    public void removeListener(PluginInstallerListener pluginInstallerListener) {
        this.listeners.remove(pluginInstallerListener);
    }
}

