/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadStats;

public class DownloadStatsImpl
implements DownloadStats {
    protected DownloadManager dm;
    protected DownloadManagerStats dm_stats;

    protected DownloadStatsImpl(DownloadManager downloadManager) {
        this.dm = downloadManager;
        this.dm_stats = this.dm.getStats();
    }

    @Override
    public String getStatus() {
        return DisplayFormatters.formatDownloadStatusDefaultLocale(this.dm);
    }

    @Override
    public String getStatus(boolean bl) {
        return bl ? DisplayFormatters.formatDownloadStatus(this.dm) : this.getStatus();
    }

    @Override
    public String getDownloadDirectory() {
        return this.dm.getSaveLocation().getParent();
    }

    @Override
    public String getTargetFileOrDir() {
        return this.dm.getSaveLocation().toString();
    }

    @Override
    public String getTrackerStatus() {
        return this.dm.getTrackerStatus();
    }

    @Override
    public int getCompleted() {
        return this.dm_stats.getCompleted();
    }

    @Override
    public int getDownloadCompleted(boolean bl) {
        return this.dm_stats.getDownloadCompleted(bl);
    }

    @Override
    public int getCheckingDoneInThousandNotation() {
        DiskManager diskManager = this.dm.getDiskManager();
        if (diskManager != null) {
            return diskManager.getCompleteRecheckStatus();
        }
        return -1;
    }

    @Override
    public long getDownloaded() {
        return this.dm_stats.getTotalDataBytesReceived();
    }

    @Override
    public long getRemaining() {
        return this.dm_stats.getRemaining();
    }

    @Override
    public long getUploaded() {
        return this.dm_stats.getTotalDataBytesSent();
    }

    @Override
    public long getDiscarded() {
        return this.dm_stats.getDiscarded();
    }

    @Override
    public long getDownloadAverage() {
        return this.dm_stats.getDataReceiveRate();
    }

    @Override
    public long getUploadAverage() {
        return this.dm_stats.getDataSendRate();
    }

    @Override
    public long getTotalAverage() {
        return this.dm_stats.getTotalAverage();
    }

    @Override
    public String getElapsedTime() {
        return this.dm_stats.getElapsedTime();
    }

    @Override
    public String getETA() {
        return DisplayFormatters.formatETA(this.dm_stats.getETA());
    }

    @Override
    public long getETASecs() {
        return this.dm_stats.getETA();
    }

    @Override
    public long getHashFails() {
        return this.dm_stats.getHashFailCount();
    }

    @Override
    public int getShareRatio() {
        return this.dm_stats.getShareRatio();
    }

    @Override
    public long getTimeStarted() {
        return this.dm_stats.getTimeStarted();
    }

    @Override
    public float getAvailability() {
        return this.dm_stats.getAvailability();
    }

    @Override
    public long getSecondsOnlySeeding() {
        return this.dm_stats.getSecondsOnlySeeding();
    }

    @Override
    public long getSecondsDownloading() {
        return this.dm_stats.getSecondsDownloading();
    }

    @Override
    public long getTimeStartedSeeding() {
        return this.dm_stats.getTimeStartedSeeding();
    }

    @Override
    public long getSecondsSinceLastDownload() {
        return this.dm_stats.getTimeSinceLastDataReceivedInSeconds();
    }

    @Override
    public long getSecondsSinceLastUpload() {
        return this.dm_stats.getTimeSinceLastDataSentInSeconds();
    }

    @Override
    public int getHealth() {
        switch (this.dm.getHealthStatus()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        Debug.out("Invalid health status");
        return this.dm.getHealthStatus();
    }
}

