/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins.peers;

import java.util.List;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;

public interface Peer {
    public static final int CONNECTING = 10;
    public static final int HANDSHAKING = 20;
    public static final int TRANSFERING = 30;
    public static final int CLOSING = 40;
    public static final int DISCONNECTED = 50;
    public static final Object PR_PRIORITY_CONNECTION = new Object();

    public PeerManager getManager();

    public int getState();

    public byte[] getId();

    public String getIp();

    public int getTCPListenPort();

    public int getUDPListenPort();

    public int getUDPNonDataListenPort();

    public int getPort();

    public boolean[] getAvailable();

    public boolean isPieceAvailable(int var1);

    public boolean isTransferAvailable();

    public int readBytes(int var1);

    public int writeBytes(int var1);

    public boolean isDownloadPossible();

    public boolean isChoked();

    public boolean isChoking();

    public boolean isInterested();

    public boolean isInteresting();

    public boolean isSeed();

    public boolean isSnubbed();

    public long getSnubbedTime();

    public void setSnubbed(boolean var1);

    public PeerStats getStats();

    public boolean isIncoming();

    public int getPercentDone();

    public int getPercentDoneInThousandNotation();

    public String getClient();

    public boolean isOptimisticUnchoke();

    public void setOptimisticUnchoke(boolean var1);

    public List getExpiredRequests();

    public List getRequests();

    public int getMaximumNumberOfRequests();

    public int getNumberOfRequests();

    public void cancelRequest(PeerReadRequest var1);

    public boolean requestAllocationStarts(int[] var1);

    public int[] getPriorityOffsets();

    public void requestAllocationComplete();

    public boolean addRequest(PeerReadRequest var1);

    public void close(String var1, boolean var2, boolean var3);

    public int getPercentDoneOfCurrentIncomingRequest();

    public int getPercentDoneOfCurrentOutgoingRequest();

    public void addListener(PeerListener var1);

    public void removeListener(PeerListener var1);

    public void addListener(PeerListener2 var1);

    public void removeListener(PeerListener2 var1);

    public Connection getConnection();

    public boolean supportsMessaging();

    public Message[] getSupportedMessages();

    public void setUserData(Object var1, Object var2);

    public Object getUserData(Object var1);

    public byte[] getHandshakeReservedBytes();

    public boolean isPriorityConnection();

    public void setPriorityConnection(boolean var1);
}

