/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.util.Debug;

public class AEJarReader {
    protected Map entries = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AEJarReader(String string) {
        InputStream inputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            JarEntry jarEntry;
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            zipInputStream = new JarInputStream(inputStream);
            while ((jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry()) != null) {
                int n;
                if (jarEntry.isDirectory()) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[8192];
                while ((n = zipInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                this.entries.put(jarEntry.getName(), new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        finally {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public InputStream getResource(String string) {
        return (InputStream)this.entries.get(string);
    }
}

