/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public class SystemTime {
    public static final long TIME_GRANULARITY_MILLIS = 25L;
    private static SystemTimeProvider instance;
    private static final boolean SOD_IT_LETS_USE_HPC = false;
    private static volatile List systemTimeConsumers;
    private static volatile List monotoneTimeConsumers;
    private static volatile List clock_change_list;
    private static long hpc_base_time;
    private static long hpc_last_time;
    private static boolean no_hcp_logged;

    public static void useRawProvider() {
        if (!(instance instanceof RawProvider)) {
            Debug.out("Whoa, someone already created a non-raw provider!");
            instance = new RawProvider();
        }
    }

    public static long getCurrentTime() {
        return instance.getTime();
    }

    public static long getMonotonousTime() {
        return instance.getMonoTime();
    }

    public static long getSteppedMonotonousTime() {
        return instance.getSteppedMonoTime();
    }

    public static long getOffsetTime(long l) {
        return instance.getTime() + l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConsumer(TickConsumer tickConsumer) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<TickConsumer> arrayList = new ArrayList<TickConsumer>(systemTimeConsumers);
            arrayList.add(tickConsumer);
            systemTimeConsumers = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConsumer(TickConsumer tickConsumer) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList arrayList = new ArrayList(systemTimeConsumers);
            arrayList.remove(tickConsumer);
            systemTimeConsumers = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMonotonousConsumer(TickConsumer tickConsumer) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<TickConsumer> arrayList = new ArrayList<TickConsumer>(monotoneTimeConsumers);
            arrayList.add(tickConsumer);
            monotoneTimeConsumers = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterMonotonousConsumer(TickConsumer tickConsumer) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList arrayList = new ArrayList(monotoneTimeConsumers);
            arrayList.remove(tickConsumer);
            monotoneTimeConsumers = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClockChangeListener(ChangeListener changeListener) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(clock_change_list);
            arrayList.add(changeListener);
            clock_change_list = arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClockChangeListener(ChangeListener changeListener) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList arrayList = new ArrayList(clock_change_list);
            arrayList.remove(changeListener);
            clock_change_list = arrayList;
        }
    }

    public static long getHighPrecisionCounter() {
        return System.nanoTime();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 1; ++i) {
            new Thread(){

                @Override
                public void run() {
                    long l = SystemTime.getCurrentTime();
                    long l2 = SystemTime.getMonotonousTime();
                    System.out.println("alter system clock to see differences between monotonous and current time");
                    long l3 = l;
                    long l4 = l2;
                    while (true) {
                        long l5 = SystemTime.getMonotonousTime();
                        long l6 = SystemTime.getCurrentTime();
                        System.out.println("current: " + (l6 - l) + " monotonous:" + (l5 - l2) + " delta current:" + (l6 - l3) + " delta monotonous:" + (l5 - l4));
                        l3 = l6;
                        l4 = l5;
                        try {
                            Thread.sleep(15L);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            }.start();
        }
    }

    static {
        try {
            if (System.getProperty("azureus.time.use.raw.provider", "0").equals("1")) {
                System.out.println("Warning: Using Raw Provider");
                instance = new RawProvider();
            } else {
                instance = new SteppedProvider();
            }
        }
        catch (Throwable throwable) {
            instance = new SteppedProvider();
        }
        systemTimeConsumers = new ArrayList();
        monotoneTimeConsumers = new ArrayList();
        clock_change_list = new ArrayList();
    }

    public static interface ChangeListener {
        public void clockChanged(long var1, long var3);
    }

    public static interface TickConsumer {
        public void consume(long var1);
    }

    protected static class RawProvider
    implements SystemTimeProvider {
        private static final int STEPS_PER_SECOND = 40;
        private final Thread updater;

        private RawProvider() {
            System.out.println("SystemTime: using raw time provider");
            this.updater = new Thread("SystemTime"){
                long last_time;

                @Override
                public void run() {
                    while (true) {
                        Object object;
                        long l;
                        long l2 = RawProvider.this.getTime();
                        if (this.last_time != 0L && ((l = l2 - this.last_time) < 0L || l > 5000L)) {
                            object = clock_change_list.iterator();
                            while (object.hasNext()) {
                                ((ChangeListener)object.next()).clockChanged(l2, l);
                            }
                        }
                        this.last_time = l2;
                        List list = systemTimeConsumers;
                        for (int i = 0; i < list.size(); ++i) {
                            object = (TickConsumer)list.get(i);
                            try {
                                object.consume(l2);
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        list = monotoneTimeConsumers;
                        long l3 = RawProvider.this.getMonoTime();
                        for (int i = 0; i < list.size(); ++i) {
                            TickConsumer tickConsumer = (TickConsumer)list.get(i);
                            try {
                                tickConsumer.consume(l3);
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception exception) {
                            Debug.printStackTrace(exception);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.updater.setDaemon(true);
            this.updater.setPriority(10);
            this.updater.start();
        }

        @Override
        public long getTime() {
            return System.currentTimeMillis();
        }

        @Override
        public long getMonoTime() {
            return SystemTime.getHighPrecisionCounter() / 1000000L;
        }

        @Override
        public long getSteppedMonoTime() {
            return this.getMonoTime();
        }
    }

    protected static class SteppedProvider
    implements SystemTimeProvider {
        private static final int STEPS_PER_SECOND = 40;
        private static final long HPC_START = SystemTime.getHighPrecisionCounter() / 1000000L;
        private final Thread updater;
        private volatile long stepped_time = 0L;
        private volatile long currentTimeOffset = System.currentTimeMillis();
        private AtomicLong last_approximate_time = new AtomicLong();
        private volatile int access_count;
        private volatile int slice_access_count;
        private volatile int access_average_per_slice;
        private volatile int drift_adjusted_granularity;
        private volatile long stepped_mono_time;

        private SteppedProvider() {
            this.updater = new Thread("SystemTime"){

                @Override
                public void run() {
                    long l = SteppedProvider.this.currentTimeOffset;
                    Average average = Average.getInstance(1000, 10);
                    Average average2 = Average.getInstance(1000, 10);
                    long l2 = l;
                    long l3 = -1000L;
                    int n = 0;
                    while (true) {
                        Object object;
                        long l4;
                        long l5;
                        long l6;
                        if ((l6 = (l5 = (l4 = System.currentTimeMillis()) - l) - SteppedProvider.this.stepped_time) < 0L || l6 > 1000L) {
                            SteppedProvider.this.stepped_time += 25L;
                            l = l4 - SteppedProvider.this.stepped_time;
                        } else {
                            SteppedProvider.this.stepped_time = l5;
                        }
                        if (++n == 40) {
                            long l7;
                            if (l2 != l) {
                                l7 = l - l2;
                                object = clock_change_list.iterator();
                                while (object.hasNext()) {
                                    ((ChangeListener)object.next()).clockChanged(l4, l7);
                                }
                                l2 = l;
                                SteppedProvider.this.currentTimeOffset = l;
                            }
                            l7 = SteppedProvider.this.stepped_time - l3 - 1000L;
                            l3 = SteppedProvider.this.stepped_time;
                            average2.addValue(l7);
                            SteppedProvider.this.drift_adjusted_granularity = (int)(25L + average2.getAverage() / 40L);
                            average.addValue(SteppedProvider.this.access_count);
                            SteppedProvider.this.access_average_per_slice = (int)(average.getAverage() / 40L);
                            SteppedProvider.this.access_count = 0;
                            n = 0;
                        }
                        SteppedProvider.this.slice_access_count = 0;
                        SteppedProvider.this.stepped_mono_time = SteppedProvider.this.stepped_time;
                        List list = monotoneTimeConsumers;
                        for (int i = 0; i < list.size(); ++i) {
                            object = (TickConsumer)list.get(i);
                            try {
                                object.consume(SteppedProvider.this.stepped_time);
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        list = systemTimeConsumers;
                        long l8 = SteppedProvider.this.stepped_time + SteppedProvider.this.currentTimeOffset;
                        for (int i = 0; i < list.size(); ++i) {
                            TickConsumer tickConsumer = (TickConsumer)list.get(i);
                            try {
                                tickConsumer.consume(l8);
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception exception) {
                            Debug.printStackTrace(exception);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.updater.setDaemon(true);
            this.updater.setPriority(10);
            this.updater.start();
        }

        @Override
        public long getTime() {
            return this.getMonoTime() + this.currentTimeOffset;
        }

        @Override
        public long getMonoTime() {
            long l;
            long l2;
            long l3 = this.access_average_per_slice;
            if (l3 > 0L) {
                l2 = (long)(this.drift_adjusted_granularity * this.slice_access_count) / l3;
                if (l2 >= (long)this.drift_adjusted_granularity) {
                    l2 = this.drift_adjusted_granularity - 1;
                }
                l = l2 + this.stepped_time;
            } else {
                l = this.stepped_time;
            }
            ++this.access_count;
            ++this.slice_access_count;
            l2 = this.last_approximate_time.get();
            if (l < l2) {
                l = l2;
            } else {
                this.last_approximate_time.compareAndSet(l2, l);
            }
            return l;
        }

        @Override
        public long getSteppedMonoTime() {
            return this.stepped_mono_time;
        }
    }

    protected static interface SystemTimeProvider {
        public long getTime();

        public long getMonoTime();

        public long getSteppedMonoTime();
    }
}

