/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class LightHashMap<S, T>
extends AbstractMap<S, T>
implements Cloneable {
    private static final Object THOMBSTONE = new Object();
    private static final Object NULLKEY = new Object();
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CAPACITY = 8;
    final float loadFactor;
    int size;
    Object[] data;

    public LightHashMap() {
        this(8, 0.75f);
    }

    public LightHashMap(int n) {
        this(n, 0.75f);
    }

    public LightHashMap(Map map) {
        this(0);
        if (map instanceof LightHashMap) {
            LightHashMap lightHashMap = (LightHashMap)map;
            this.size = lightHashMap.size;
            this.data = (Object[])lightHashMap.data.clone();
        } else {
            this.putAll(map);
        }
    }

    @Override
    public Object clone() {
        try {
            LightHashMap lightHashMap = (LightHashMap)super.clone();
            lightHashMap.data = (Object[])this.data.clone();
            return lightHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public LightHashMap(int n, float f) {
        int n2;
        if (f > 1.0f) {
            throw new IllegalArgumentException("Load factor must not be > 1");
        }
        this.loadFactor = f;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.data = new Object[n2 * 2];
    }

    @Override
    public Set entrySet() {
        return new EntrySet();
    }

    @Override
    public T put(Object object, Object object2) {
        this.checkCapacity(1);
        return (T)this.add(object, object2, false);
    }

    @Override
    public void putAll(Map map) {
        this.checkCapacity(map.size());
        for (Map.Entry entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue(), true);
        }
    }

    @Override
    public Set<S> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<T> values() {
        return new Values();
    }

    public int capacity() {
        return this.data.length >> 1;
    }

    @Override
    public T get(Object object) {
        if (object == null) {
            object = NULLKEY;
        }
        return (T)this.data[this.nonModifyingFindIndex(object) + 1];
    }

    private Object add(Object object, Object object2, boolean bl) {
        if (object == null) {
            object = NULLKEY;
        }
        int n = bl ? this.nonModifyingFindIndex(object) : this.findIndex(object);
        Object object3 = this.data[n + 1];
        if (this.data[n] == null || this.data[n] == THOMBSTONE) {
            this.data[n] = object;
            ++this.size;
        }
        this.data[n + 1] = object2;
        return object3;
    }

    @Override
    public T remove(Object object) {
        int n;
        if (this.size == 0) {
            return null;
        }
        if (object == null) {
            object = NULLKEY;
        }
        if (this.keysEqual(this.data[n = this.findIndex(object)], object)) {
            return (T)this.removeForIndex(n);
        }
        return null;
    }

    private Object removeForIndex(int n) {
        Object object = this.data[n + 1];
        this.data[n] = THOMBSTONE;
        this.data[n + 1] = null;
        --this.size;
        return object;
    }

    @Override
    public void clear() {
        int n;
        this.size = 0;
        for (n = 1; n < 8; n <<= 1) {
        }
        this.data = new Object[n * 2];
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.size == 0) {
            return false;
        }
        if (object == null) {
            object = NULLKEY;
        }
        return this.keysEqual(object, this.data[this.nonModifyingFindIndex(object)]);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object != null) {
            for (int i = 0; i < this.data.length; i += 2) {
                if (!object.equals(this.data[i + 1])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.data.length; i += 2) {
                if (this.data[i + 1] != null || this.data[i] == null || this.data[i] == THOMBSTONE) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean keysEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.hashCode() == object2.hashCode() && object.equals(object2);
    }

    private int findIndex(Object object) {
        int n = object.hashCode() << 1;
        int n2 = 1;
        int n3 = n & this.data.length - 1;
        int n4 = -1;
        int n5 = 0;
        int n6 = Math.min((this.data.length >> 1) - this.size, 100);
        while (this.data[n3] != null && !this.keysEqual(this.data[n3], object)) {
            if (this.data[n3] == THOMBSTONE) {
                if (n4 == -1) {
                    n4 = n3;
                }
                if (++n5 * 2 > n6) {
                    this.compactify(0.0f);
                    n4 = -1;
                    n2 = 0;
                    n5 = 0;
                }
            }
            n3 = n + n2 + n2 * n2 & this.data.length - 1;
            ++n2;
        }
        if (n4 != -1 && !this.keysEqual(this.data[n3], object)) {
            return n4;
        }
        return n3;
    }

    private int nonModifyingFindIndex(Object object) {
        int n = object.hashCode() << 1;
        int n2 = n & this.data.length - 1;
        int n3 = -1;
        for (int i = 1; this.data[n2] != null && !this.keysEqual(this.data[n2], object) && i < this.data.length >> 1; ++i) {
            if (this.data[n2] == THOMBSTONE && n3 == -1) {
                n3 = n2;
            }
            n2 = n + i + i * i & this.data.length - 1;
        }
        if (n3 != -1 && !this.keysEqual(this.data[n2], object)) {
            return n3;
        }
        return n2;
    }

    private void checkCapacity(int n) {
        int n2 = this.data.length >> 1;
        if ((float)(this.size + n) < (float)n2 * this.loadFactor) {
            return;
        }
        int n3 = n2;
        while ((float)(n3 <<= 1) * this.loadFactor < (float)(this.size + n)) {
        }
        this.adjustCapacity(n3);
    }

    public void compactify(float f) {
        int n = 1;
        float f2 = Math.abs(f);
        if (f2 <= 0.0f || f2 >= 1.0f) {
            f2 = this.loadFactor;
        }
        while ((float)n * f2 < (float)(this.size + 1)) {
            n <<= 1;
        }
        if (n < this.data.length / 2 || f >= 0.0f) {
            this.adjustCapacity(n);
        }
    }

    private void adjustCapacity(int n) {
        Object[] objectArray = this.data;
        this.data = new Object[n * 2];
        this.size = 0;
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] == null || objectArray[i] == THOMBSTONE) continue;
            this.add(objectArray[i], objectArray[i + 1], true);
        }
    }

    static void test() {
        int n;
        Random random = new Random();
        byte[] byArray = new byte[5];
        String[] stringArray = new String[1950351];
        for (int i = 0; i < stringArray.length; ++i) {
            random.nextBytes(byArray);
            stringArray[i] = new String(byArray);
            stringArray[i].hashCode();
        }
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        LightHashMap lightHashMap = new LightHashMap();
        System.out.println("fill:");
        long l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            hashMap.put(stringArray[n], byArray);
        }
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            lightHashMap.put(stringArray[n], byArray);
        }
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("replace-fill:");
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            hashMap.put(stringArray[n], byArray);
        }
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            lightHashMap.put(stringArray[n], byArray);
        }
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("get:");
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            hashMap.get(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            lightHashMap.get(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("compactify light map");
        l = System.currentTimeMillis();
        lightHashMap.compactify(0.9f);
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("transfer to hashmap");
        l = System.currentTimeMillis();
        new HashMap(hashMap);
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        new HashMap(lightHashMap);
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("transfer to lighthashmap");
        l = System.currentTimeMillis();
        new LightHashMap(hashMap);
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        new LightHashMap(lightHashMap);
        System.out.println(System.currentTimeMillis() - l);
        System.out.println("remove entry by entry");
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            hashMap.remove(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
        l = System.currentTimeMillis();
        for (n = 0; n < stringArray.length; ++n) {
            lightHashMap.remove(stringArray[n]);
        }
        System.out.println(System.currentTimeMillis() - l);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        System.out.println("Call with -Xmx300m -Xcomp -server");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        LightHashMap.test();
        System.out.println("-------------------------------------");
        System.gc();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        LightHashMap.test();
        System.out.println("\n\nPerforming sanity tests");
        Random random = new Random();
        byte[] byArray = new byte[25];
        String[] stringArray2 = new String[1048];
        for (int i = 0; i < stringArray2.length; ++i) {
            random.nextBytes(byArray);
            stringArray2[i] = new String(byArray);
            stringArray2[i].hashCode();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LightHashMap lightHashMap = new LightHashMap();
        for (n2 = 0; n2 < stringArray2.length * 10; ++n2) {
            n = random.nextInt(stringArray2.length);
            hashMap.put(null, stringArray2[n2 % stringArray2.length]);
            lightHashMap.put(null, stringArray2[n2 % stringArray2.length]);
            if (!hashMap.equals(lightHashMap)) {
                System.out.println("Error 0");
            }
            hashMap.put(stringArray2[n], stringArray2[n2 % stringArray2.length]);
            lightHashMap.put(stringArray2[n], stringArray2[n2 % stringArray2.length]);
            if (hashMap.equals(lightHashMap)) continue;
            System.out.println("Error 1");
        }
        for (n2 = 0; n2 < stringArray2.length / 2; ++n2) {
            n = random.nextInt(stringArray2.length);
            hashMap.remove(stringArray2[n]);
            lightHashMap.remove(stringArray2[n]);
            if (hashMap.equals(lightHashMap)) continue;
            System.out.println("Error 2");
        }
        for (n2 = 0; n2 < stringArray2.length * 10; ++n2) {
            n = random.nextInt(stringArray2.length);
            hashMap.put(stringArray2[n], stringArray2[n2 % stringArray2.length]);
            hashMap.put(null, stringArray2[n2 % stringArray2.length]);
            lightHashMap.put(stringArray2[n], stringArray2[n2 % stringArray2.length]);
            lightHashMap.put(null, stringArray2[n2 % stringArray2.length]);
            if (hashMap.equals(lightHashMap)) continue;
            System.out.println("Error 3");
        }
        Iterator iterator = hashMap.entrySet().iterator();
        Iterator iterator2 = lightHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            iterator2.next();
            iterator2.remove();
        }
        if (!hashMap.equals(lightHashMap)) {
            System.out.println("Error 4");
        }
        lightHashMap.clear();
        for (int i = 0; i < 100000; ++i) {
            random.nextBytes(byArray);
            String string = new String(byArray);
            lightHashMap.put(string, byArray);
            lightHashMap.containsKey(string);
            lightHashMap.remove(string);
        }
        System.out.println("checks done");
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return LightHashMap.this.size;
        }

        private class ValueIterator
        extends HashIterator {
            private ValueIterator() {
            }

            @Override
            Object nextIntern() {
                return this.itData[this.currentIdx + 1];
            }
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeySetIterator();
        }

        @Override
        public int size() {
            return LightHashMap.this.size;
        }

        private class KeySetIterator
        extends HashIterator {
            private KeySetIterator() {
            }

            @Override
            Object nextIntern() {
                Object object = this.itData[this.currentIdx];
                return object != NULLKEY ? object : null;
            }
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LightHashMap.this.size;
        }

        private class EntrySetIterator
        extends HashIterator {
            private EntrySetIterator() {
            }

            @Override
            public Object nextIntern() {
                return new Entry(this.currentIdx);
            }

            private final class Entry
            implements Map.Entry {
                final int entryIndex;

                public Entry(int n) {
                    this.entryIndex = n;
                }

                public Object getKey() {
                    Object object = EntrySetIterator.this.itData[this.entryIndex];
                    return object != NULLKEY ? object : null;
                }

                public Object getValue() {
                    return EntrySetIterator.this.itData[this.entryIndex + 1];
                }

                public Object setValue(Object object) {
                    Object object2 = EntrySetIterator.this.itData[this.entryIndex + 1];
                    EntrySetIterator.this.itData[this.entryIndex + 1] = object;
                    return object2;
                }

                @Override
                public boolean equals(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
                }

                @Override
                public int hashCode() {
                    return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
                }
            }
        }
    }

    private abstract class HashIterator
    implements Iterator {
        protected int nextIdx = -2;
        protected int currentIdx = -2;
        protected Object[] itData;

        public HashIterator() {
            this.itData = LightHashMap.this.data;
            this.findNext();
        }

        private void findNext() {
            do {
                this.nextIdx += 2;
            } while (this.nextIdx < this.itData.length && (this.itData[this.nextIdx] == null || this.itData[this.nextIdx] == THOMBSTONE));
        }

        @Override
        public void remove() {
            if (this.currentIdx == -2) {
                throw new IllegalStateException("No entry to delete, use next() first");
            }
            if (this.itData != LightHashMap.this.data) {
                throw new ConcurrentModificationException("removal opperation not supported as concurrent structural modification occured");
            }
            LightHashMap.this.removeForIndex(this.currentIdx);
            this.currentIdx = -2;
        }

        @Override
        public boolean hasNext() {
            return this.nextIdx < this.itData.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more entries");
            }
            this.currentIdx = this.nextIdx;
            this.findNext();
            return this.nextIntern();
        }

        abstract Object nextIntern();
    }
}

