/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolverException;
import org.gudy.azureus2.core3.util.HostNameToIPResolverListener;

public class HostNameToIPResolver {
    protected static AEThread2 resolver_thread;
    protected static List request_queue;
    protected static AEMonitor request_queue_mon;
    protected static AESemaphore request_semaphore;
    static final int INADDRSZ = 4;

    public static boolean isNonDNSName(String string) {
        return AENetworkClassifier.categoriseAddress(string) != "Public";
    }

    public static InetAddress syncResolve(String string) throws UnknownHostException {
        if (HostNameToIPResolver.isNonDNSName(string)) {
            throw new HostNameToIPResolverException("non-DNS name '" + string + "'", true);
        }
        byte[] byArray = HostNameToIPResolver.textToNumericFormat(string);
        if (byArray != null) {
            return InetAddress.getByAddress(byArray);
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '.' || Character.isDigit(cArray[i])) continue;
            bl = true;
            break;
        }
        if (bl) {
            return InetAddress.getByName(string);
        }
        throw new UnknownHostException("Host '" + string + "' doesn't obey minimal validation rules");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResolverRequest(String string, HostNameToIPResolverListener hostNameToIPResolverListener) {
        byte[] byArray = HostNameToIPResolver.textToNumericFormat(string);
        if (byArray != null) {
            try {
                hostNameToIPResolverListener.hostNameResolutionComplete(InetAddress.getByAddress(string, byArray));
                return;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        try {
            request_queue_mon.enter();
            request_queue.add(new request(string, hostNameToIPResolverListener));
            request_semaphore.release();
            if (resolver_thread == null) {
                resolver_thread = new AEThread2("HostNameToIPResolver", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block8: while (true) {
                            try {
                                while (true) {
                                    request request2;
                                    request_semaphore.reserve(30000L);
                                    try {
                                        request_queue_mon.enter();
                                        if (request_queue.isEmpty()) {
                                            resolver_thread = null;
                                            break block8;
                                        }
                                        request2 = (request)request_queue.remove(0);
                                    }
                                    finally {
                                        request_queue_mon.exit();
                                    }
                                    try {
                                        InetAddress inetAddress = HostNameToIPResolver.syncResolve(request2.getHost());
                                        request2.getListener().hostNameResolutionComplete(inetAddress);
                                        continue block8;
                                    }
                                    catch (Throwable throwable) {
                                        request2.getListener().hostNameResolutionComplete(null);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                                continue;
                            }
                            break;
                        }
                    }
                };
                resolver_thread.start();
            }
        }
        finally {
            request_queue_mon.exit();
        }
    }

    public static byte[] hostAddressToBytes(String string) {
        byte[] byArray = HostNameToIPResolver.textToNumericFormat(string);
        return byArray;
    }

    static byte[] textToNumericFormat(String string) {
        if (string.length() == 0) {
            return null;
        }
        if (string.indexOf(58) != -1) {
            try {
                return InetAddress.getByName(string).getAddress();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        byte[] byArray = new byte[4];
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            char c;
            if (Character.isDigit(c = cArray[n2++])) {
                int n4 = (byArray[n3] & 0xFF) * 10 + (Character.digit(c, 10) & 0xFF);
                if (n4 > 255) {
                    return null;
                }
                byArray[n3] = (byte)(n4 & 0xFF);
                if (bl) continue;
                if (++n > 4) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == '.' && bl) {
                if (n == 4) {
                    return null;
                }
                byArray[++n3] = 0;
                bl = false;
                continue;
            }
            return null;
        }
        if (n < 4) {
            return null;
        }
        return byArray;
    }

    static {
        request_queue = new ArrayList();
        request_queue_mon = new AEMonitor("HostNameToIPResolver");
        request_semaphore = new AESemaphore("HostNameToIPResolver");
    }

    protected static class request {
        protected String host;
        protected HostNameToIPResolverListener listener;

        protected request(String string, HostNameToIPResolverListener hostNameToIPResolverListener) {
            this.host = string;
            this.listener = hostNameToIPResolverListener;
        }

        protected String getHost() {
            return this.host;
        }

        protected HostNameToIPResolverListener getListener() {
            return this.listener;
        }
    }
}

