/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;

public class TRBlockingServerProcessor
extends TRTrackerServerProcessorTCP {
    protected static final int KEEP_ALIVE_SOCKET_TIMEOUT = 30000;
    private static final LogIDs LOGID = LogIDs.TRACKER;
    protected Socket socket;
    protected int timeout_ticks = 1;
    protected String current_request;

    protected TRBlockingServerProcessor(TRTrackerServerTCP tRTrackerServerTCP, Socket socket) {
        super(tRTrackerServerTCP);
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSupport() {
        boolean bl = this.getServer().isKeepAliveEnabled();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.socket.getInputStream());
            do {
                this.setTaskState("entry");
                try {
                    if (bl) {
                        this.socket.setSoTimeout(30000);
                        this.setTimeoutsDisabled(true);
                    } else {
                        this.socket.setSoTimeout(5000);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.setTaskState("reading header");
                try {
                    int n;
                    Object object;
                    Object object2;
                    int n2;
                    String string;
                    Object object3;
                    byte[] byArray = new byte[16384];
                    int n3 = 0;
                    while (n3 < byArray.length) {
                        int n4 = ((InputStream)bufferedInputStream).read(byArray, n3, 1);
                        if (n4 != 1) {
                            throw new Exception("Premature end of stream reading header");
                        }
                        if (++n3 < 4 || byArray[n3 - 4] != 13 || byArray[n3 - 3] != 10 || byArray[n3 - 2] != 13 || byArray[n3 - 1] != 10) continue;
                        break;
                    }
                    String string2 = new String(byArray, 0, n3, "ISO-8859-1");
                    if (Logger.isEnabled()) {
                        object3 = string2;
                        int n5 = ((String)object3).indexOf("\r\n");
                        if (n5 != -1) {
                            object3 = ((String)object3).substring(0, n5);
                        }
                        Logger.log(new LogEvent(LOGID, "Tracker Server: received header '" + (String)object3 + "' from " + this.socket.getRemoteSocketAddress()));
                    }
                    object3 = null;
                    File file = null;
                    boolean bl2 = false;
                    if (string2.startsWith("GET ")) {
                        this.timeout_ticks = 1;
                        string = string2.toLowerCase();
                        n2 = 4;
                    } else if (string2.startsWith("HEAD ")) {
                        this.timeout_ticks = 1;
                        string = string2.toLowerCase();
                        n2 = 5;
                        bl2 = true;
                    } else if (string2.startsWith("POST ")) {
                        this.timeout_ticks = TRTrackerServerTCP.PROCESSING_POST_MULTIPLIER;
                        if (this.timeout_ticks == 0) {
                            this.setTimeoutsDisabled(true);
                        }
                        this.setTaskState("reading content");
                        string = string2.toLowerCase();
                        n2 = 5;
                        String string3 = this.getHeaderField(string2, string, "content-length:");
                        if (string3 == null) {
                            throw new Exception("Content-Length missing");
                        }
                        int n6 = Integer.parseInt(string3);
                        ByteArrayOutputStream byteArrayOutputStream = null;
                        object2 = null;
                        if (n6 <= 262144) {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            object = byteArrayOutputStream;
                        } else {
                            file = AETemporaryFileHandler.createTempFile();
                            file.deleteOnExit();
                            object = object2 = new FileOutputStream(file);
                        }
                        while (n6 > 0) {
                            int n7 = ((InputStream)bufferedInputStream).read(byArray, 0, Math.min(n6, byArray.length));
                            if (n7 < 0) {
                                throw new TRTrackerServerException("premature end of input stream");
                            }
                            ((OutputStream)object).write(byArray, 0, n7);
                            n6 -= n7;
                        }
                        if (byteArrayOutputStream != null) {
                            object3 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        } else {
                            ((FileOutputStream)object2).close();
                            object3 = new BufferedInputStream(new FileInputStream(file), 262144);
                        }
                    } else {
                        n = string2.indexOf(32);
                        if (n == -1) {
                            throw new TRTrackerServerException("header doesn't have space in right place");
                        }
                        this.timeout_ticks = 1;
                        string = string2.toLowerCase();
                        n2 = n + 1;
                    }
                    this.setTaskState("processing request");
                    this.current_request = string2;
                    try {
                        if (object3 == null) {
                            object3 = new ByteArrayInputStream(new byte[0]);
                        }
                        if ((n = string2.indexOf(" ", n2)) == -1) {
                            throw new TRTrackerServerException("header doesn't have space in right place");
                        }
                        String string4 = string2.substring(n2, n).trim();
                        int n8 = string2.indexOf("\r\n", n);
                        if (n8 == -1) {
                            throw new TRTrackerServerException("header doesn't have nl in right place");
                        }
                        object2 = string2.substring(n, n8).trim();
                        object = this.getHeaderField(string2, string, "connection:");
                        if (object == null) {
                            if (((String)object2).equalsIgnoreCase("HTTP/1.0")) {
                                bl = false;
                            }
                        } else if (((String)object).equalsIgnoreCase("close")) {
                            bl = false;
                        }
                        if (bl2) {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
                            if (!this.processRequest(string2, string, string4, (InetSocketAddress)this.socket.getLocalSocketAddress(), (InetSocketAddress)this.socket.getRemoteSocketAddress(), false, bl, (InputStream)object3, byteArrayOutputStream, null)) {
                                bl = false;
                            }
                            byte[] byArray2 = byteArrayOutputStream.toByteArray();
                            int n9 = byArray2.length;
                            for (int i = 3; i < byArray2.length; ++i) {
                                if (byArray2[i - 3] != 13 || byArray2[i - 2] != 10 || byArray2[i - 1] != 13 || byArray2[i] != 10) continue;
                                n9 = i + 1;
                                break;
                            }
                            this.setTaskState("writing head response");
                            this.socket.getOutputStream().write(byArray2, 0, n9);
                            this.socket.getOutputStream().flush();
                        } else if (!this.processRequest(string2, string, string4, (InetSocketAddress)this.socket.getLocalSocketAddress(), (InetSocketAddress)this.socket.getRemoteSocketAddress(), false, bl, (InputStream)object3, this.socket.getOutputStream(), null)) {
                            bl = false;
                        }
                    }
                    finally {
                        if (object3 != null) {
                            ((InputStream)object3).close();
                        }
                        if (file != null) {
                            file.delete();
                        }
                    }
                }
                catch (Throwable throwable) {
                    bl = false;
                }
            } while (bl);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.setTaskState("final socket close");
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected String getHeaderField(String string, String string2, String string3) {
        int n = string2.indexOf(string3);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf("\r\n", n);
        if (n2 == -1) {
            return null;
        }
        return string.substring(n + string3.length(), n2).trim();
    }

    @Override
    public void interruptTask() {
        try {
            if (!this.areTimeoutsDisabled()) {
                --this.timeout_ticks;
                if (this.timeout_ticks <= 0) {
                    System.out.println("Tracker task interrupted in state '" + this.getTaskState() + "' : processing time limit exceeded for " + this.socket.getInetAddress());
                    this.socket.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

