/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNatCheckerListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;

public class TRTrackerServerNATChecker {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    protected static TRTrackerServerNATChecker singleton = new TRTrackerServerNATChecker();
    protected static final int THREAD_POOL_SIZE = 32;
    protected static final int CHECK_QUEUE_LIMIT = 2048;
    protected static int check_timeout = 15000;
    protected boolean enabled;
    protected ThreadPool thread_pool;
    protected List check_queue = new ArrayList();
    protected AESemaphore check_queue_sem = new AESemaphore("TracerServerNATChecker");
    protected AEMonitor check_queue_mon = new AEMonitor("TRTrackerServerNATChecker:Q");
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServerNATChecker");

    protected static TRTrackerServerNATChecker getSingleton() {
        return singleton;
    }

    protected TRTrackerServerNATChecker() {
        String[] stringArray = new String[]{"Tracker NAT Check Enable", "Tracker NAT Check Timeout"};
        for (int i = 0; i < stringArray.length; ++i) {
            COConfigurationManager.addParameterListener(stringArray[i], new ParameterListener(){

                @Override
                public void parameterChanged(String string) {
                    TRTrackerServerNATChecker.this.checkConfig("Tracker NAT Check Enable", "Tracker NAT Check Timeout");
                }
            });
        }
        this.checkConfig("Tracker NAT Check Enable", "Tracker NAT Check Timeout");
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConfig(String string, String string2) {
        try {
            this.this_mon.enter();
            this.enabled = COConfigurationManager.getBooleanParameter(string);
            check_timeout = COConfigurationManager.getIntParameter(string2) * 1000;
            if (check_timeout < 1000) {
                Debug.out("NAT check timeout too small - " + check_timeout);
                check_timeout = 1000;
            }
            if (this.thread_pool == null) {
                this.thread_pool = new ThreadPool("Tracker NAT Checker", 32);
                this.thread_pool.setExecutionLimit(check_timeout);
                AEThread aEThread = new AEThread("Tracker NAT Checker Dispatcher"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void runSupport() {
                        while (true) {
                            ThreadPoolTask threadPoolTask;
                            TRTrackerServerNATChecker.this.check_queue_sem.reserve();
                            try {
                                TRTrackerServerNATChecker.this.check_queue_mon.enter();
                                threadPoolTask = (ThreadPoolTask)TRTrackerServerNATChecker.this.check_queue.remove(0);
                            }
                            finally {
                                TRTrackerServerNATChecker.this.check_queue_mon.exit();
                            }
                            try {
                                TRTrackerServerNATChecker.this.thread_pool.run(threadPoolTask);
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                                continue;
                            }
                            break;
                        }
                    }
                };
                aEThread.setDaemon(true);
                aEThread.start();
            } else {
                this.thread_pool.setExecutionLimit(check_timeout);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addNATCheckRequest(final String string, final int n, final TRTrackerServerNatCheckerListener tRTrackerServerNatCheckerListener) {
        if (!this.enabled || this.thread_pool == null) {
            return false;
        }
        try {
            this.check_queue_mon.enter();
            if (this.check_queue.size() > 2048) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "NAT Check queue size too large, check for '" + string + ":" + n + "' skipped"));
                }
                tRTrackerServerNatCheckerListener.NATCheckComplete(true);
            } else {
                this.check_queue.add(new ThreadPoolTask(){
                    protected Socket socket;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void runSupport() {
                        boolean bl = false;
                        try {
                            InetSocketAddress inetSocketAddress = new InetSocketAddress(AEProxyFactory.getAddressMapper().internalise(string), n);
                            this.socket = new Socket();
                            this.socket.connect(inetSocketAddress, check_timeout);
                            bl = true;
                            this.socket.close();
                            this.socket = null;
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            tRTrackerServerNatCheckerListener.NATCheckComplete(bl);
                            if (this.socket != null) {
                                try {
                                    this.socket.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    }

                    @Override
                    public void interruptTask() {
                        if (this.socket != null) {
                            try {
                                this.socket.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                });
                this.check_queue_sem.release();
            }
        }
        finally {
            this.check_queue_mon.exit();
        }
        return true;
    }
}

