/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.TOTorrentListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class TOTorrentMetadata
implements TOTorrent {
    private final byte[] hash;
    private final String displayName;
    private final String saveLocation;
    private final Map<Integer, byte[]> metadataPieces;
    private URL announceURL;
    private TOTorrentAnnounceURLGroup announceURLGroup;
    private List<TOTorrentAnnounceURLSet> announceURLSet;
    private byte[] infoBytes;

    public TOTorrentMetadata(byte[] byArray, String string, URL[] uRLArray) {
        this.hash = byArray;
        this.displayName = string != null ? string : ByteFormatter.encodeString(byArray);
        String string2 = "metadata_" + ByteFormatter.encodeString(byArray) + ".torrent";
        this.saveLocation = new File(COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory"), string2).getAbsolutePath();
        this.metadataPieces = new HashMap<Integer, byte[]>();
        this.announceURL = uRLArray[0];
        this.setAnnounceUrlGroup(uRLArray);
    }

    public void setAnnounceUrlGroup(URL[] uRLArray) {
        this.announceURLSet = new ArrayList<TOTorrentAnnounceURLSet>();
        this.announceURLGroup = new TOTorrentAnnounceURLGroup(){

            @Override
            public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
                return TOTorrentMetadata.this.announceURLSet.toArray(new TOTorrentAnnounceURLSet[0]);
            }

            @Override
            public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray) {
                TOTorrentMetadata.this.announceURLSet = Arrays.asList(tOTorrentAnnounceURLSetArray);
            }

            @Override
            public TOTorrentAnnounceURLSet createAnnounceURLSet(final URL[] uRLArray) {
                TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = new TOTorrentAnnounceURLSet(){

                    @Override
                    public URL[] getAnnounceURLs() {
                        return uRLArray;
                    }

                    @Override
                    public void setAnnounceURLs(URL[] uRLArray2) {
                    }
                };
                TOTorrentMetadata.this.announceURLSet.add(tOTorrentAnnounceURLSet);
                return tOTorrentAnnounceURLSet;
            }
        };
        this.announceURLGroup.createAnnounceURLSet(uRLArray);
    }

    @Override
    public void setPrivate(boolean bl) throws TOTorrentException {
    }

    @Override
    public void setPieces(byte[][] byArray) throws TOTorrentException {
    }

    @Override
    public void setHashOverride(byte[] byArray) throws TOTorrentException {
    }

    @Override
    public void setCreationDate(long l) {
    }

    @Override
    public void setCreatedBy(byte[] byArray) {
    }

    @Override
    public void setComment(String string) {
    }

    @Override
    public boolean setAnnounceURL(URL uRL) {
        this.announceURL = uRL;
        return true;
    }

    @Override
    public void setAdditionalStringProperty(String string, String string2) {
    }

    @Override
    public void setAdditionalProperty(String string, Object object) {
    }

    @Override
    public void setAdditionalMapProperty(String string, Map map) {
    }

    @Override
    public void setAdditionalLongProperty(String string, Long l) {
    }

    @Override
    public void setAdditionalListProperty(String string, List list) {
    }

    @Override
    public void setAdditionalByteArrayProperty(String string, byte[] byArray) {
    }

    @Override
    public void serialiseToXMLFile(File file) throws TOTorrentException {
    }

    @Override
    public Map serialiseToMap() throws TOTorrentException {
        try {
            Object[] objectArray = this.metadataPieces.keySet().toArray(new Integer[0]);
            Arrays.sort(objectArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (Object object : objectArray) {
                byte[] byArray = this.metadataPieces.get(object);
                byteArrayOutputStream.write(byArray);
            }
            byteArrayOutputStream.close();
            DirectByteBuffer directByteBuffer = new DirectByteBuffer(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("info", MessagingUtil.convertBencodedByteStreamToPayload(directByteBuffer, 2, "info"));
            hashMap.put("announce", this.getAnnounceURL().toString().getBytes("UTF8"));
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = this.getAnnounceURLGroup().getAnnounceURLSets();
            if (tOTorrentAnnounceURLSetArray.length > 0) {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                    TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrentAnnounceURLSetArray[i];
                    URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
                    if (uRLArray.length == 0) continue;
                    ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
                    arrayList.add(arrayList2);
                    for (int j = 0; j < uRLArray.length; ++j) {
                        arrayList2.add(uRLArray[j].toString().getBytes("UTF8"));
                    }
                }
                if (arrayList.size() > 0) {
                    hashMap.put("announce-list", arrayList);
                }
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            throw new TOTorrentException("Error serialising torrent", 5, throwable);
        }
    }

    @Override
    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        byte[] byArray = this.serialiseToByteArray();
        FilterOutputStream filterOutputStream = null;
        try {
            File file2;
            boolean bl;
            File file3 = file.getParentFile();
            if (file3 == null) {
                throw new TOTorrentException("Path '" + file + "' is invalid", 5);
            }
            if (!file3.isDirectory() && !(bl = FileUtil.mkdirs(file3))) {
                if (file3.exists()) {
                    if (!file3.isDirectory()) {
                        throw new TOTorrentException("Path '" + file + "' is invalid", 5);
                    }
                } else {
                    throw new TOTorrentException("Failed to create directory '" + file3 + "'", 5);
                }
            }
            if ((file2 = new File(file3, file.getName() + ".saving")).exists()) {
                if (!file2.delete()) {
                    throw new TOTorrentException("Insufficient permissions to delete '" + file2 + "'", 5);
                }
            } else {
                boolean bl2 = false;
                try {
                    bl2 = file2.createNewFile();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!bl2) {
                    throw new TOTorrentException("Insufficient permissions to write '" + file2 + "'", 5);
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2, false);
            filterOutputStream = new BufferedOutputStream(fileOutputStream, 8192);
            filterOutputStream.write(byArray);
            ((BufferedOutputStream)filterOutputStream).flush();
            if (!Constants.isCVSVersion()) {
                fileOutputStream.getFD().sync();
            }
            filterOutputStream.close();
            filterOutputStream = null;
            if (file2.length() > 1L) {
                file.delete();
                file2.renameTo(file);
            }
        }
        catch (TOTorrentException tOTorrentException) {
            throw tOTorrentException;
        }
        catch (Throwable throwable) {
            throw new TOTorrentException("Failed to serialise torrent: " + Debug.getNestedExceptionMessage(throwable), 5);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    Debug.printStackTrace(iOException);
                }
            }
        }
    }

    @Override
    public void removeListener(TOTorrentListener tOTorrentListener) {
    }

    @Override
    public void removeAdditionalProperty(String string) {
    }

    @Override
    public void removeAdditionalProperties() {
    }

    @Override
    public void print() {
    }

    @Override
    public boolean isSimpleTorrent() {
        return false;
    }

    @Override
    public boolean isCreated() {
        return false;
    }

    @Override
    public boolean hasSameHashAs(TOTorrent tOTorrent) {
        try {
            return Arrays.equals(this.hash, tOTorrent.getHash());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public String getUTF8Name() {
        return this.displayName;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public boolean getPrivate() {
        return false;
    }

    @Override
    public byte[][] getPieces() throws TOTorrentException {
        return null;
    }

    @Override
    public long getPieceLength() {
        return 0L;
    }

    @Override
    public int getNumberOfPieces() {
        return 0;
    }

    @Override
    public byte[] getName() {
        return this.getUTF8Name().getBytes();
    }

    @Override
    public AEMonitor getMonitor() {
        return null;
    }

    @Override
    public HashWrapper getHashWrapper() throws TOTorrentException {
        return new HashWrapper(this.hash);
    }

    @Override
    public byte[] getHash() throws TOTorrentException {
        return this.hash;
    }

    @Override
    public TOTorrentFile[] getFiles() {
        return null;
    }

    @Override
    public long getCreationDate() {
        return 0L;
    }

    @Override
    public byte[] getCreatedBy() {
        return null;
    }

    @Override
    public byte[] getComment() {
        return null;
    }

    @Override
    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return this.announceURLGroup;
    }

    @Override
    public URL getAnnounceURL() {
        return this.announceURL;
    }

    @Override
    public String getAdditionalStringProperty(String string) {
        return null;
    }

    @Override
    public Object getAdditionalProperty(String string) {
        return null;
    }

    @Override
    public Map getAdditionalMapProperty(String string) {
        return null;
    }

    @Override
    public Long getAdditionalLongProperty(String string) {
        return null;
    }

    @Override
    public List getAdditionalListProperty(String string) {
        return null;
    }

    @Override
    public byte[] getAdditionalByteArrayProperty(String string) {
        return null;
    }

    @Override
    public void addListener(TOTorrentListener tOTorrentListener) {
    }

    public String getSaveLocation() {
        return this.saveLocation;
    }

    public void notifyComplete() {
    }

    public void updateMetadataPieces(Map<Integer, byte[]> map, int n) {
        for (Map.Entry<Integer, byte[]> entry : map.entrySet()) {
            if (this.metadataPieces.containsKey(entry.getKey())) continue;
            this.metadataPieces.put((Integer)entry.getKey(), (byte[])entry.getValue());
        }
        int n2 = 0;
        for (byte[] byArray : this.metadataPieces.values()) {
            n2 += byArray.length;
        }
        if (n2 == n) {
            this.notifyComplete();
        }
    }

    public Map<Integer, byte[]> getMetadataPieces() {
        return this.metadataPieces;
    }

    public byte[] getInfoBytes() {
        if (this.infoBytes == null) {
            try {
                Map map = this.serialiseToMap();
                this.infoBytes = BEncoder.encode((Map)map.get("info"));
            }
            catch (Throwable throwable) {
                this.infoBytes = new byte[0];
            }
        }
        return this.infoBytes;
    }

    public boolean validHash() {
        SHA1Hasher sHA1Hasher = new SHA1Hasher();
        return Arrays.equals(this.hash, sHA1Hasher.calculateHash(this.getInfoBytes()));
    }

    public boolean save() {
        try {
            this.serialiseToBEncodedFile(new File(this.getSaveLocation()));
            return true;
        }
        catch (TOTorrentException tOTorrentException) {
            return false;
        }
    }

    protected byte[] serialiseToByteArray() throws TOTorrentException {
        Map map = this.serialiseToMap();
        try {
            return BEncoder.encode(map);
        }
        catch (IOException iOException) {
            throw new TOTorrentException("Failed to serialise torrent: " + Debug.getNestedExceptionMessage(iOException), 5);
        }
    }

    public static class TorrentWrapper {
        private static final Map<String, byte[]> INFOS = new HashMap<String, byte[]>();
        private final TOTorrent torrent;
        private String key;

        public TorrentWrapper(TOTorrent tOTorrent) {
            this.torrent = tOTorrent;
            try {
                this.key = ByteFormatter.encodeString(tOTorrent.getHash());
            }
            catch (TOTorrentException tOTorrentException) {
                this.key = null;
            }
        }

        public byte[] getInfoBytes() {
            if (!INFOS.containsKey(this.key)) {
                byte[] byArray = this.serializeInfo();
                INFOS.put(this.key, byArray);
            }
            return INFOS.get(this.key);
        }

        private byte[] serializeInfo() {
            byte[] byArray = null;
            try {
                Map map = this.torrent.serialiseToMap();
                Map map2 = (Map)map.get("info");
                byArray = BEncoder.encode(map2);
            }
            catch (Throwable throwable) {
                byArray = new byte[]{};
            }
            return byArray;
        }
    }
}

