/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;

public class PEPeerTransportDebugger {
    protected int piece_length;
    protected static final int BT_READING_LENGTH_AND_TYPE = 1234567;
    protected int state = -1;
    protected byte[] data_read = new byte[68];
    protected int data_read_pos;

    protected PEPeerTransportDebugger(PEPeerTransportProtocol pEPeerTransportProtocol) {
        this.piece_length = pEPeerTransportProtocol.getControl().getPieceLength(0);
    }

    public int write(SocketChannel socketChannel, ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        int n2 = socketChannel.write(byteBuffer);
        if (n2 > 0) {
            byteBuffer.position(n);
            this.analyse(byteBuffer, n2);
        }
        return n2;
    }

    public long write(SocketChannel socketChannel, ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        int[] nArray = new int[byteBufferArray.length];
        for (int i = n; i < n + n2; ++i) {
            nArray[i] = byteBufferArray[i].position();
        }
        long l = socketChannel.write(byteBufferArray, n, n2);
        for (int i = n; i < n + n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray[i];
            int n3 = byteBuffer.position() - nArray[i];
            if (n3 <= 0) continue;
            byteBuffer.position(nArray[i]);
            this.analyse(byteBuffer, n3);
        }
        return l;
    }

    protected void analyse(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            if (this.data_read_pos == this.data_read.length) {
                int n2;
                ByteBuffer byteBuffer2;
                if (this.state == 1234567) {
                    byteBuffer2 = ByteBuffer.wrap(this.data_read);
                    n2 = byteBuffer2.getInt();
                    this.state = byteBuffer2.get();
                    if (n2 == 1) {
                        this.state = 1234567;
                        this.data_read = new byte[5];
                    } else {
                        this.data_read = new byte[n2 - 1];
                    }
                } else {
                    if (this.state == 7) {
                        byteBuffer2 = ByteBuffer.wrap(this.data_read);
                        n2 = byteBuffer2.getInt();
                        int n3 = byteBuffer2.getInt();
                        long l = (long)n2 * (long)this.piece_length + (long)n3;
                        while (byteBuffer2.hasRemaining()) {
                            byte by = byteBuffer2.get();
                            if ((byte)l != by) {
                                System.out.println("piece: write is bad at " + l + ": expected = " + (byte)l + ", actual = " + by);
                                break;
                            }
                            ++l;
                        }
                    }
                    this.state = 1234567;
                    this.data_read = new byte[5];
                }
                this.data_read_pos = 0;
            }
            this.data_read[this.data_read_pos++] = byArray[i];
        }
    }
}

