/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterExternalHandler;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.BannedIpImpl;
import org.gudy.azureus2.core3.ipfilter.impl.BlockedIpImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IPAddressRangeManager;
import org.gudy.azureus2.core3.ipfilter.impl.IpFilterAutoLoaderImpl;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UnresolvableHostManager;

public class IpFilterImpl
implements IpFilter {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final long BAN_IP_PERSIST_TIME = 604800000L;
    private static final int MAX_BLOCKS_TO_REMEMBER = 500;
    private static IpFilterImpl ipFilter;
    private static AEMonitor2 class_mon;
    private IPAddressRangeManager range_manager = new IPAddressRangeManager();
    private Map bannedIps;
    private LinkedList ipsBlocked;
    private int num_ips_blocked = 0;
    private int num_ips_blocked_loggable = 0;
    private long last_update_time;
    private List listeners = new ArrayList();
    private CopyOnWriteList external_handlers = new CopyOnWriteList();
    FrequencyLimitedDispatcher blockedListChangedDispatcher;
    private IpFilterAutoLoaderImpl ipFilterAutoLoader;
    private boolean ip_filter_enabled;
    private boolean ip_filter_allow;

    private IpFilterImpl() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Ip Filter Allow", "Ip Filter Enabled"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                IpFilterImpl.this.ip_filter_enabled = COConfigurationManager.getBooleanParameter("Ip Filter Enabled");
                IpFilterImpl.this.ip_filter_allow = COConfigurationManager.getBooleanParameter("Ip Filter Allow");
            }
        });
        ipFilter = this;
        this.bannedIps = new HashMap();
        this.ipsBlocked = new LinkedList();
        this.blockedListChangedDispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

            @Override
            public void runSupport() {
                Object[] objectArray = IpFilterImpl.this.listeners.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        IPFilterListener iPFilterListener = (IPFilterListener)objectArray[i];
                        iPFilterListener.IPBlockedListChanged(IpFilterImpl.this);
                        continue;
                    }
                    catch (Exception exception) {
                        Debug.out(exception);
                    }
                }
            }
        }, 10000);
        this.ipFilterAutoLoader = new IpFilterAutoLoaderImpl(this);
        try {
            this.loadBannedIPs();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        try {
            this.loadFilters(true, true);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
        COConfigurationManager.addParameterListener(new String[]{"Ip Filter Allow", "Ip Filter Enabled"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                IpFilterImpl.this.markAsUpToDate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpFilter getInstance() {
        try {
            class_mon.enter();
            if (ipFilter == null) {
                ipFilter = new IpFilterImpl();
            }
            IpFilterImpl ipFilterImpl = ipFilter;
            return ipFilterImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public File getFile() {
        return FileUtil.getUserFile("filters.config");
    }

    @Override
    public void reload() throws Exception {
        this.reload(true);
    }

    public void reload(boolean bl) throws Exception {
        if (COConfigurationManager.getBooleanParameter("Ip Filter Clear On Reload")) {
            this.range_manager.clearAllEntries();
        }
        this.markAsUpToDate();
        this.loadFilters(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws Exception {
        try {
            Object object;
            Object object22;
            class_mon.enter();
            HashMap hashMap = new HashMap();
            ArrayList arrayList = new ArrayList();
            hashMap.put("ranges", arrayList);
            ArrayList arrayList2 = this.range_manager.getEntries();
            for (Object object22 : arrayList2) {
                if (!object22.isValid() || object22.isSessionOnly()) continue;
                object = object22.getDescription();
                String string = object22.getStartIp();
                String string2 = object22.getEndIp();
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("description", ((String)object).getBytes("UTF-8"));
                hashMap2.put("start", string);
                hashMap2.put("end", string2);
                arrayList.add(hashMap2);
            }
            object22 = null;
            try {
                object = FileUtil.getUserFile("filters.config");
                object22 = new FileOutputStream((File)object);
                ((FileOutputStream)object22).write(BEncoder.encode(hashMap));
            }
            finally {
                if (object22 != null) {
                    ((FileOutputStream)object22).close();
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFilters(boolean bl, boolean bl2) throws Exception {
        long l = System.currentTimeMillis();
        this.ipFilterAutoLoader.loadOtherFilters(bl, bl2);
        if (this.getNbRanges() > 0) {
            Logger.log(new LogEvent(LOGID, System.currentTimeMillis() - l + "ms for " + this.getNbRanges() + ". now loading norm"));
        }
        try {
            Object object;
            class_mon.enter();
            ArrayList<IpRangeImpl> arrayList = new ArrayList<IpRangeImpl>(1024);
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                object = FileUtil.getUserFile("filters.config");
                if (((File)object).exists()) {
                    fileInputStream = new FileInputStream((File)object);
                    bufferedInputStream = new BufferedInputStream(fileInputStream, 16384);
                    Map map = BDecoder.decode(bufferedInputStream);
                    List list = (List)map.get("ranges");
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        Map map2 = (Map)listIterator.next();
                        String string = new String((byte[])map2.get("description"), "UTF-8");
                        String string2 = new String((byte[])map2.get("start"));
                        String string3 = new String((byte[])map2.get("end"));
                        IpRangeImpl ipRangeImpl = new IpRangeImpl(string, string2, string3, false);
                        ipRangeImpl.setAddedToRangeList(true);
                        arrayList.add(ipRangeImpl);
                    }
                }
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    ((IpRange)object.next()).checkValid();
                }
                this.markAsUpToDate();
            }
        }
        finally {
            class_mon.exit();
        }
        Logger.log(new LogEvent(LOGID, System.currentTimeMillis() - l + "ms to load all IP Filters"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBannedIPs() {
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Banning Persistent")) {
            return;
        }
        try {
            class_mon.enter();
            Map map = FileUtil.readResilientConfigFile("banips.config");
            List list = (List)map.get("ips");
            if (list != null) {
                long l = SystemTime.getCurrentTime();
                for (int i = 0; i < list.size(); ++i) {
                    Map map2 = (Map)list.get(i);
                    String string = new String((byte[])map2.get("ip"));
                    String string2 = new String((byte[])map2.get("desc"), "UTF-8");
                    Long l2 = (Long)map2.get("time");
                    long l3 = l2;
                    boolean bl = false;
                    if (l3 > l) {
                        l3 = l;
                    } else if (l - l3 >= 604800000L) {
                        bl = true;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 0, "Persistent ban dropped as too old : " + string + ", " + string2));
                        }
                    }
                    if (bl) continue;
                    int n = this.range_manager.addressToInt(string);
                    this.bannedIps.put(new Integer(n), new BannedIpImpl(string, string2, l3));
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBannedIPs() {
        if (!COConfigurationManager.getBooleanParameter("Ip Filter Banning Persistent")) {
            return;
        }
        try {
            class_mon.enter();
            HashMap hashMap = new HashMap();
            ArrayList arrayList = new ArrayList();
            for (BannedIpImpl bannedIpImpl : this.bannedIps.values()) {
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap2.put("ip", bannedIpImpl.getIp());
                hashMap2.put("desc", bannedIpImpl.getTorrentName().getBytes("UTF-8"));
                hashMap2.put("time", new Long(bannedIpImpl.getBanningTime()));
                arrayList.add(hashMap2);
            }
            hashMap.put("ips", arrayList);
            FileUtil.writeResilientConfigFile("banips.config", hashMap);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public boolean isInRange(String string) {
        return this.isInRange(string, "", null);
    }

    @Override
    public boolean isInRange(String string, String string2, byte[] byArray) {
        return this.isInRange(string, string2, byArray, true);
    }

    @Override
    public boolean isInRange(String string, String string2, byte[] byArray, boolean bl) {
        IpRange ipRange;
        if (this.isBanned(string)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (string.equals("127.0.0.1")) {
            return false;
        }
        if (string.indexOf(":") != -1) {
            return false;
        }
        if (AddressUtils.isLANLocalAddress(string) != 2) {
            return false;
        }
        boolean bl2 = this.ip_filter_allow;
        IpRange ipRange2 = (IpRange)this.range_manager.isInRange(string);
        if ((ipRange2 == null || bl2) && (ipRange = this.checkExternalHandlers(byArray, string)) != null) {
            ipRange2 = ipRange;
            bl2 = false;
        }
        if (ipRange2 != null) {
            if (!bl2) {
                if (AENetworkClassifier.categoriseAddress(string) != "Public") {
                    return false;
                }
                if (this.addBlockedIP(new BlockedIpImpl(string, ipRange2, string2, bl), byArray, bl)) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + string + ", in range : " + ipRange2));
                    }
                    return true;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocking Denied : " + string + ", in range : " + ipRange2));
                }
                return false;
            }
            return false;
        }
        if (bl2) {
            if (AENetworkClassifier.categoriseAddress(string) != "Public") {
                return false;
            }
            if (this.addBlockedIP(new BlockedIpImpl(string, null, string2, bl), byArray, bl)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + string + ", not in any range"));
                }
                return true;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Ip Blocking Denied : " + string + ", not in any range"));
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isInRange(InetAddress inetAddress, String string, byte[] byArray, boolean bl) {
        IpRange ipRange;
        if (this.isBanned(inetAddress)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) {
            return false;
        }
        if (inetAddress instanceof Inet6Address) {
            return false;
        }
        if (AddressUtils.isLANLocalAddress(inetAddress) != 2) {
            return false;
        }
        boolean bl2 = this.ip_filter_allow;
        IpRange ipRange2 = (IpRange)this.range_manager.isInRange(inetAddress);
        if ((ipRange2 == null || bl2) && (ipRange = this.checkExternalHandlers(byArray, inetAddress)) != null) {
            ipRange2 = ipRange;
            bl2 = false;
        }
        if (ipRange2 != null) {
            if (!bl2) {
                if (this.addBlockedIP(new BlockedIpImpl(inetAddress.getHostAddress(), ipRange2, string, bl), byArray, bl)) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + inetAddress + ", in range : " + ipRange2));
                    }
                    return true;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocking Denied: " + inetAddress + ", in range : " + ipRange2));
                }
                return false;
            }
            return false;
        }
        if (bl2) {
            if (this.addBlockedIP(new BlockedIpImpl(inetAddress.getHostAddress(), null, string, bl), byArray, bl)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Ip Blocked : " + inetAddress + ", not in any range"));
                }
                return true;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Ip Blocking Denied : " + inetAddress + ", not in any range"));
            }
            return false;
        }
        return false;
    }

    protected IpRange checkExternalHandlers(byte[] byArray, String string) {
        if (this.external_handlers.size() > 0) {
            Iterator iterator = this.external_handlers.iterator();
            while (iterator.hasNext()) {
                if (!((IpFilterExternalHandler)iterator.next()).isBlocked(byArray, string)) continue;
                return new IpRangeImpl("External handler", string, string, true);
            }
        }
        return null;
    }

    protected IpRange checkExternalHandlers(byte[] byArray, InetAddress inetAddress) {
        if (this.external_handlers.size() > 0) {
            Iterator iterator = this.external_handlers.iterator();
            while (iterator.hasNext()) {
                if (!((IpFilterExternalHandler)iterator.next()).isBlocked(byArray, inetAddress)) continue;
                String string = inetAddress.getHostAddress();
                return new IpRangeImpl("External handler", string, string, true);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addBlockedIP(BlockedIp blockedIp, byte[] byArray, boolean bl) {
        if (byArray != null) {
            List list = this.listeners;
            for (int i = 0; i < list.size(); ++i) {
                try {
                    if (!((IPFilterListener)list.get(i)).canIPBeBlocked(blockedIp.getBlockedIp(), byArray)) {
                        return false;
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        try {
            class_mon.enter();
            this.ipsBlocked.addLast(blockedIp);
            ++this.num_ips_blocked;
            if (bl) {
                ++this.num_ips_blocked_loggable;
            }
            if (this.ipsBlocked.size() > 500) {
                this.ipsBlocked.removeFirst();
            }
        }
        finally {
            class_mon.exit();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBanned(InetAddress inetAddress) {
        try {
            class_mon.enter();
            int n = this.range_manager.addressToInt(inetAddress);
            Integer n2 = new Integer(n);
            boolean bl = this.bannedIps.get(n2) != null;
            return bl;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBanned(String string) {
        try {
            class_mon.enter();
            int n = this.range_manager.addressToInt(string);
            Integer n2 = new Integer(n);
            boolean bl = this.bannedIps.get(n2) != null;
            return bl;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public boolean getInRangeAddressesAreAllowed() {
        return this.ip_filter_allow;
    }

    @Override
    public void setInRangeAddressesAreAllowed(boolean bl) {
        COConfigurationManager.setParameter("Ip Filter Allow", bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getIpRanges() {
        try {
            class_mon.enter();
            ArrayList arrayList = new ArrayList(this.range_manager.getEntries());
            return arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IpRange[] getRanges() {
        try {
            class_mon.enter();
            ArrayList arrayList = this.range_manager.getEntries();
            IpRange[] ipRangeArray = new IpRange[arrayList.size()];
            arrayList.toArray(ipRangeArray);
            IpRange[] ipRangeArray2 = ipRangeArray;
            return ipRangeArray2;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public IpRange createRange(boolean bl) {
        return new IpRangeImpl("", "", "", bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRange(IpRange ipRange) {
        try {
            class_mon.enter();
            ((IpRangeImpl)ipRange).setAddedToRangeList(true);
            ipRange.checkValid();
        }
        finally {
            class_mon.exit();
        }
        this.markAsUpToDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRange(IpRange ipRange) {
        try {
            class_mon.enter();
            ((IpRangeImpl)ipRange).setAddedToRangeList(false);
            this.range_manager.removeRange(ipRange);
        }
        finally {
            class_mon.exit();
        }
        this.markAsUpToDate();
    }

    @Override
    public int getNbRanges() {
        ArrayList arrayList = this.range_manager.getEntries();
        return arrayList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValidOrNot(IpRange ipRange, boolean bl) {
        try {
            class_mon.enter();
            if (!ipRange.getAddedToRangeList()) {
                return;
            }
        }
        finally {
            class_mon.exit();
        }
        if (bl) {
            this.range_manager.addRange(ipRange);
        } else {
            this.range_manager.removeRange(ipRange);
        }
    }

    @Override
    public int getNbIpsBlocked() {
        return this.num_ips_blocked;
    }

    @Override
    public int getNbIpsBlockedAndLoggable() {
        return this.num_ips_blocked_loggable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ban(String string, String string2, boolean bl) {
        BannedIp bannedIp;
        if (!bl) {
            List list = this.listeners;
            for (int i = 0; i < list.size(); ++i) {
                try {
                    if (!((IPFilterListener)list.get(i)).canIPBeBanned(string)) {
                        return false;
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        boolean bl2 = false;
        ArrayList<BannedIpImpl> arrayList = new ArrayList<BannedIpImpl>();
        try {
            class_mon.enter();
            int n = this.range_manager.addressToInt(string);
            Integer n2 = new Integer(n);
            if (this.bannedIps.get(n2) == null) {
                bannedIp = new BannedIpImpl(string, string2);
                arrayList.add((BannedIpImpl)bannedIp);
                this.bannedIps.put(n2, bannedIp);
                if (!UnresolvableHostManager.isPseudoAddress(string)) {
                    long l = n;
                    if (l < 0L) {
                        l += 0x100000000L;
                    }
                    long l2 = l & 0xFFFFFFFFFFFFFF00L;
                    long l3 = l2 + 256L;
                    int n3 = 0;
                    for (long i = l2; i < l3; ++i) {
                        Integer n4 = new Integer((int)i);
                        if (this.bannedIps.get(n4) == null) continue;
                        ++n3;
                    }
                    int n5 = COConfigurationManager.getIntParameter("Ip Filter Ban Block Limit");
                    if (n3 >= n5) {
                        bl2 = true;
                        for (long i = l2; i < l3; ++i) {
                            Integer n6 = new Integer((int)i);
                            if (this.bannedIps.get(n6) != null) continue;
                            BannedIpImpl bannedIpImpl = new BannedIpImpl(PRHelpers.intToAddress((int)i), string2 + " [block ban]");
                            arrayList.add(bannedIpImpl);
                            this.bannedIps.put(n6, bannedIpImpl);
                        }
                    }
                }
                this.saveBannedIPs();
            }
        }
        finally {
            class_mon.exit();
        }
        List list = this.listeners;
        for (int i = 0; i < arrayList.size(); ++i) {
            bannedIp = (BannedIp)arrayList.get(i);
            for (int j = 0; j < list.size(); ++j) {
                try {
                    ((IPFilterListener)list.get(j)).IPBanned(bannedIp);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BannedIp[] getBannedIps() {
        try {
            class_mon.enter();
            BannedIp[] bannedIpArray = new BannedIp[this.bannedIps.size()];
            this.bannedIps.values().toArray(bannedIpArray);
            BannedIp[] bannedIpArray2 = bannedIpArray;
            return bannedIpArray2;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public int getNbBannedIps() {
        return this.bannedIps.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBannedIps() {
        try {
            class_mon.enter();
            this.bannedIps.clear();
            this.saveBannedIPs();
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unban(String string) {
        try {
            class_mon.enter();
            int n = this.range_manager.addressToInt(string);
            Integer n2 = new Integer(n);
            if (this.bannedIps.remove(n2) != null) {
                this.saveBannedIPs();
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unban(String string, boolean bl) {
        if (bl) {
            int n = this.range_manager.addressToInt(string);
            long l = n;
            if (l < 0L) {
                l += 0x100000000L;
            }
            long l2 = l & 0xFFFFFFFFFFFFFF00L;
            long l3 = l2 + 256L;
            boolean bl2 = false;
            try {
                class_mon.enter();
                for (long i = l2; i < l3; ++i) {
                    Integer n2 = new Integer((int)i);
                    if (this.bannedIps.remove(n2) == null) continue;
                    bl2 = true;
                }
                if (!bl2) return;
                this.saveBannedIPs();
                return;
            }
            finally {
                class_mon.exit();
            }
        }
        try {
            class_mon.enter();
            int n = this.range_manager.addressToInt(string);
            Integer n3 = new Integer(n);
            if (this.bannedIps.remove(n3) == null) return;
            this.saveBannedIPs();
            return;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockedIp[] getBlockedIps() {
        try {
            class_mon.enter();
            BlockedIp[] blockedIpArray = new BlockedIp[this.ipsBlocked.size()];
            this.ipsBlocked.toArray(blockedIpArray);
            BlockedIp[] blockedIpArray2 = blockedIpArray;
            return blockedIpArray2;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBlockedIPs() {
        try {
            class_mon.enter();
            this.ipsBlocked.clear();
            this.num_ips_blocked = 0;
            this.num_ips_blocked_loggable = 0;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.ip_filter_enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        COConfigurationManager.setParameter("Ip Filter Enabled", bl);
    }

    @Override
    public void markAsUpToDate() {
        this.last_update_time = SystemTime.getCurrentTime();
        this.blockedListChangedDispatcher.dispatch();
    }

    @Override
    public long getLastUpdateTime() {
        return this.last_update_time;
    }

    @Override
    public long getTotalAddressesInRange() {
        return this.range_manager.getTotalSpan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IPFilterListener iPFilterListener) {
        try {
            class_mon.enter();
            ArrayList<IPFilterListener> arrayList = new ArrayList<IPFilterListener>(this.listeners);
            arrayList.add(iPFilterListener);
            this.listeners = arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IPFilterListener iPFilterListener) {
        try {
            class_mon.enter();
            ArrayList arrayList = new ArrayList(this.listeners);
            arrayList.remove(iPFilterListener);
            this.listeners = arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public void addExternalHandler(IpFilterExternalHandler ipFilterExternalHandler) {
        this.external_handlers.add(ipFilterExternalHandler);
    }

    @Override
    public void removeExternalHandler(IpFilterExternalHandler ipFilterExternalHandler) {
        this.external_handlers.remove(ipFilterExternalHandler);
    }

    public static void main(String[] stringArray) {
        IpFilterImpl ipFilterImpl = new IpFilterImpl();
        ipFilterImpl.ban("255.1.1.1", "parp", true);
        ipFilterImpl.ban("255.1.1.2", "parp", true);
        ipFilterImpl.ban("255.1.2.2", "parp", true);
        System.out.println("is banned:" + ipFilterImpl.isBanned("255.1.1.4"));
    }

    static {
        class_mon = new AEMonitor2("IpFilter:class");
    }
}

