/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerStats;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import com.aelitis.net.udp.uc.PRUDPPrimordialHandler;
import com.aelitis.net.udp.uc.PRUDPRequestHandler;
import com.aelitis.net.udp.uc.impl.PRUDPPacketHandlerRequestImpl;
import com.aelitis.net.udp.uc.impl.PRUDPPacketHandlerSocks;
import com.aelitis.net.udp.uc.impl.PRUDPPacketHandlerStatsImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.PasswordAuthentication;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEMonitor2;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class PRUDPPacketHandlerImpl
implements PRUDPPacketHandler {
    private static final LogIDs LOGID = LogIDs.NET;
    private boolean TRACE_REQUESTS = false;
    private static final long MAX_SEND_QUEUE_DATA_SIZE = 0x200000L;
    private static final long MAX_RECV_QUEUE_DATA_SIZE = 0x100000L;
    private static boolean use_socks;
    private int port;
    private DatagramSocket socket;
    private CopyOnWriteList<PRUDPPrimordialHandler> primordial_handlers = new CopyOnWriteList();
    private PRUDPRequestHandler request_handler;
    private PRUDPPacketHandlerStatsImpl stats = new PRUDPPacketHandlerStatsImpl(this);
    private Map requests = new LightHashMap();
    private AEMonitor2 requests_mon = new AEMonitor2("PRUDPPH:req");
    private AEMonitor2 send_queue_mon = new AEMonitor2("PRUDPPH:sd");
    private long send_queue_data_size;
    private List[] send_queues = new List[]{new LinkedList(), new LinkedList(), new LinkedList()};
    private AESemaphore send_queue_sem = new AESemaphore("PRUDPPH:sq");
    private AEThread send_thread;
    private AEMonitor recv_queue_mon = new AEMonitor("PRUDPPH:rq");
    private long recv_queue_data_size;
    private List recv_queue = new ArrayList();
    private AESemaphore recv_queue_sem = new AESemaphore("PRUDPPH:rq");
    private AEThread recv_thread;
    private int send_delay = 0;
    private int receive_delay = 0;
    private int queued_request_timeout = 0;
    private long total_requests_received;
    private long total_requests_processed;
    private long total_replies;
    private long last_error_report;
    private AEMonitor bind_address_mon = new AEMonitor("PRUDPPH:bind");
    private InetAddress default_bind_ip;
    private InetAddress explicit_bind_ip;
    private volatile InetAddress current_bind_ip;
    private volatile InetAddress target_bind_ip;
    private volatile boolean failed;
    private volatile boolean destroyed;
    private AESemaphore destroy_sem = new AESemaphore("PRUDPPacketHandler:destroy");
    private Throwable init_error;
    private PRUDPPacketHandlerImpl altProtocolDelegate;
    private final PacketTransformer packet_transformer;

    protected PRUDPPacketHandlerImpl(int n, InetAddress inetAddress, PacketTransformer packetTransformer) {
        TimerEventPeriodic timerEventPeriodic;
        this.port = n;
        this.explicit_bind_ip = inetAddress;
        this.packet_transformer = packetTransformer;
        this.default_bind_ip = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
        this.calcBind();
        final AESemaphore aESemaphore = new AESemaphore("PRUDPPacketHandler:init");
        new AEThread2("PRUDPPacketReciever:" + this.port, true){

            @Override
            public void run() {
                PRUDPPacketHandlerImpl.this.receiveLoop(aESemaphore);
            }
        }.start();
        final TimerEventPeriodic[] timerEventPeriodicArray = new TimerEventPeriodic[]{null};
        timerEventPeriodicArray[0] = timerEventPeriodic = SimpleTimer.addPeriodicEvent("PRUDP:timeouts", 5000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent timerEvent2) {
                if (PRUDPPacketHandlerImpl.this.destroyed && timerEventPeriodicArray[0] != null) {
                    timerEventPeriodicArray[0].cancel();
                }
                PRUDPPacketHandlerImpl.this.checkTimeouts();
            }
        });
        aESemaphore.reserve();
    }

    @Override
    public void addPrimordialHandler(PRUDPPrimordialHandler pRUDPPrimordialHandler) {
        if (this.primordial_handlers.contains(pRUDPPrimordialHandler)) {
            Debug.out("Primordial handler already added!");
            return;
        }
        this.primordial_handlers.add(pRUDPPrimordialHandler);
    }

    @Override
    public void removePrimordialHandler(PRUDPPrimordialHandler pRUDPPrimordialHandler) {
        if (!this.primordial_handlers.contains(pRUDPPrimordialHandler)) {
            Debug.out("Primordial handler not found!");
            return;
        }
        this.primordial_handlers.remove(pRUDPPrimordialHandler);
    }

    @Override
    public void setRequestHandler(PRUDPRequestHandler pRUDPRequestHandler) {
        if (this.request_handler != null && pRUDPRequestHandler != null) {
            throw new RuntimeException("Multiple handlers per endpoint not supported");
        }
        this.request_handler = pRUDPRequestHandler;
        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = this.altProtocolDelegate;
        if (pRUDPPacketHandlerImpl != null) {
            pRUDPPacketHandlerImpl.setRequestHandler(pRUDPRequestHandler);
        }
    }

    @Override
    public PRUDPRequestHandler getRequestHandler() {
        return this.request_handler;
    }

    @Override
    public int getPort() {
        if (this.port == 0 && this.socket != null) {
            return this.socket.getLocalPort();
        }
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultBindAddress(InetAddress inetAddress) {
        try {
            this.bind_address_mon.enter();
            this.default_bind_ip = inetAddress;
            this.calcBind();
        }
        finally {
            this.bind_address_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExplicitBindAddress(InetAddress inetAddress) {
        try {
            this.bind_address_mon.enter();
            this.explicit_bind_ip = inetAddress;
            this.calcBind();
        }
        finally {
            this.bind_address_mon.exit();
        }
        int n = 0;
        while (this.current_bind_ip != this.target_bind_ip && !this.failed && !this.destroyed) {
            if (n >= 100) {
                Debug.out("Giving up on wait for bind ip change to take effect");
                break;
            }
            try {
                Thread.sleep(50L);
                ++n;
            }
            catch (Throwable throwable) {
                break;
            }
        }
    }

    protected void calcBind() {
        if (this.explicit_bind_ip != null) {
            if (this.altProtocolDelegate != null) {
                this.altProtocolDelegate.destroy();
                this.altProtocolDelegate = null;
            }
            this.target_bind_ip = this.explicit_bind_ip;
        } else {
            InetAddress inetAddress = null;
            NetworkAdmin networkAdmin = NetworkAdmin.getSingleton();
            try {
                if (this.default_bind_ip instanceof Inet6Address && !this.default_bind_ip.isAnyLocalAddress() && networkAdmin.hasIPV4Potential()) {
                    inetAddress = networkAdmin.getSingleHomedServiceBindAddress(1);
                } else if (this.default_bind_ip instanceof Inet4Address && networkAdmin.hasIPV6Potential()) {
                    inetAddress = networkAdmin.getSingleHomedServiceBindAddress(2);
                }
            }
            catch (UnsupportedAddressTypeException unsupportedAddressTypeException) {
                // empty catch block
            }
            if (this.altProtocolDelegate != null && !this.altProtocolDelegate.explicit_bind_ip.equals(inetAddress)) {
                this.altProtocolDelegate.destroy();
                this.altProtocolDelegate = null;
            }
            if (inetAddress != null && this.altProtocolDelegate == null) {
                this.altProtocolDelegate = new PRUDPPacketHandlerImpl(this.port, inetAddress, this.packet_transformer);
                this.altProtocolDelegate.stats = this.stats;
                this.altProtocolDelegate.primordial_handlers = this.primordial_handlers;
                this.altProtocolDelegate.request_handler = this.request_handler;
            }
            this.target_bind_ip = this.default_bind_ip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveLoop(AESemaphore aESemaphore) {
        Object object;
        long l = 0L;
        NetworkAdminPropertyChangeListener networkAdminPropertyChangeListener = new NetworkAdminPropertyChangeListener(){

            @Override
            public void propertyChanged(String string) {
                if (string == "Default Bind IP") {
                    PRUDPPacketHandlerImpl.this.setDefaultBindAddress(NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress());
                }
            }
        };
        NetworkAdmin.getSingleton().addPropertyChangeListener(networkAdminPropertyChangeListener);
        try {
            block20: while (!this.failed && !this.destroyed) {
                DatagramSocket datagramSocket;
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                try {
                    if (this.target_bind_ip == null) {
                        object = new InetSocketAddress("127.0.0.1", this.port);
                        datagramSocket = new DatagramSocket(this.port);
                    } else {
                        object = new InetSocketAddress(this.target_bind_ip, this.port);
                        datagramSocket = new DatagramSocket((SocketAddress)object);
                    }
                }
                catch (BindException bindException) {
                    if (this.target_bind_ip.isAnyLocalAddress()) {
                        InetAddress inetAddress = NetworkAdmin.getSingleton().guessRoutableBindAddress();
                        if (inetAddress != null) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "PRUDPPacketReceiver: retrying with bind IP guess of " + inetAddress));
                            }
                            try {
                                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
                                datagramSocket = new DatagramSocket(inetSocketAddress);
                                this.target_bind_ip = inetAddress;
                                object = inetSocketAddress;
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "PRUDPPacketReceiver: Switched to explicit bind ip " + this.target_bind_ip + " after initial bind failure with wildcard (" + bindException.getMessage() + ")"));
                                }
                            }
                            catch (Throwable throwable) {
                                throw bindException;
                            }
                        }
                        throw bindException;
                    }
                    throw bindException;
                }
                datagramSocket.setReuseAddress(true);
                datagramSocket.setSoTimeout(1000);
                this.socket = datagramSocket;
                this.current_bind_ip = this.target_bind_ip;
                aESemaphore.release();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "PRUDPPacketReceiver: receiver established on port " + this.port + (this.current_bind_ip == null ? "" : ", bound to " + this.current_bind_ip)));
                }
                byte[] byArray = null;
                long l2 = 0L;
                long l3 = 0L;
                while (!this.failed && !this.destroyed && this.current_bind_ip == this.target_bind_ip) {
                    try {
                        if (byArray == null) {
                            byArray = new byte[8192];
                        }
                        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, (SocketAddress)object);
                        this.receiveFromSocket(datagramPacket);
                        long l4 = SystemTime.getCurrentTime();
                        ++l2;
                        l3 = 0L;
                        for (PRUDPPrimordialHandler pRUDPPrimordialHandler : this.primordial_handlers) {
                            if (!pRUDPPrimordialHandler.packetReceived(datagramPacket)) continue;
                            byArray = null;
                            this.stats.primordialPacketReceived(datagramPacket.getLength());
                            break;
                        }
                        if (byArray == null) continue;
                        this.process(datagramPacket, l4);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                    }
                    catch (Throwable throwable) {
                        String string = throwable.getMessage();
                        if (this.socket.isClosed() || string != null && string.toLowerCase().indexOf("socket closed") != -1) {
                            long l5 = SystemTime.getCurrentTime();
                            if (l5 - l < 500L) {
                                Thread.sleep(250L);
                            }
                            l = l5;
                            if (!Logger.isEnabled()) continue block20;
                            Logger.log(new LogEvent(LOGID, "PRUDPPacketReceiver: recycled UDP port " + this.port + " after close: ok=" + l2));
                            continue block20;
                        }
                        ++l3;
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "PRUDPPacketReceiver: receive failed on port " + this.port + ": ok=" + l2 + ", fails=" + l3, throwable));
                        }
                        if ((l3 <= 100L || l2 != 0L) && l3 <= 1000L) continue;
                        Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.port, "UDP"});
                        this.init_error = throwable;
                        this.failed = true;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.init_error = throwable;
            if (!(throwable instanceof BindException) || !Constants.isWindowsVistaOrHigher) {
                Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"UDP:" + this.port});
            }
            Logger.log(new LogEvent(LOGID, "PRUDPPacketReceiver: DatagramSocket bind failed on port " + this.port, throwable));
        }
        finally {
            aESemaphore.release();
            this.destroy_sem.releaseForever();
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
            if ((object = this.altProtocolDelegate) != null) {
                ((PRUDPPacketHandlerImpl)object).destroy();
            }
            NetworkAdmin.getSingleton().removePropertyChangeListener(networkAdminPropertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        PRUDPPacketHandlerRequestImpl pRUDPPacketHandlerRequestImpl;
        long l = SystemTime.getCurrentTime();
        ArrayList<PRUDPPacketHandlerRequestImpl> arrayList = new ArrayList<PRUDPPacketHandlerRequestImpl>();
        try {
            this.requests_mon.enter();
            Iterator iterator = this.requests.values().iterator();
            while (iterator.hasNext()) {
                pRUDPPacketHandlerRequestImpl = (PRUDPPacketHandlerRequestImpl)iterator.next();
                long l2 = pRUDPPacketHandlerRequestImpl.getSendTime();
                if (l2 == 0L || l - l2 < pRUDPPacketHandlerRequestImpl.getTimeout()) continue;
                iterator.remove();
                this.stats.requestTimedOut();
                arrayList.add(pRUDPPacketHandlerRequestImpl);
            }
        }
        finally {
            this.requests_mon.exit();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            pRUDPPacketHandlerRequestImpl = (PRUDPPacketHandlerRequestImpl)arrayList.get(i);
            if (this.TRACE_REQUESTS && Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "PRUDPPacketHandler: request timeout"));
            }
            try {
                pRUDPPacketHandlerRequestImpl.setException(new PRUDPPacketHandlerException("timed out"));
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DatagramPacket datagramPacket, long l) {
        block25: {
            try {
                PRUDPPacketHandlerRequestImpl pRUDPPacketHandlerRequestImpl;
                PRUDPPacket pRUDPPacket;
                boolean bl;
                byte[] byArray = datagramPacket.getData();
                int n = datagramPacket.getLength();
                this.stats.packetReceived(n);
                InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.getSocketAddress();
                if ((byArray[0] & 0x80) == 0) {
                    bl = false;
                    pRUDPPacket = PRUDPPacketReply.deserialiseReply(this, inetSocketAddress, new DataInputStream(new ByteArrayInputStream(byArray, 0, n)));
                } else {
                    bl = true;
                    pRUDPPacket = PRUDPPacketRequest.deserialiseRequest(this, new DataInputStream(new ByteArrayInputStream(byArray, 0, n)));
                }
                pRUDPPacket.setSerialisedSize(n);
                pRUDPPacket.setAddress(inetSocketAddress);
                if (bl) {
                    ++this.total_requests_received;
                    if (this.TRACE_REQUESTS) {
                        Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: request packet received: " + pRUDPPacket.getString()));
                    }
                    if (this.receive_delay > 0) {
                        try {
                            this.recv_queue_mon.enter();
                            if (this.recv_queue_data_size > 0x100000L) {
                                long l2 = SystemTime.getCurrentTime();
                                if (l2 - this.last_error_report > 30000L) {
                                    this.last_error_report = l2;
                                    Debug.out("Receive queue size limit exceeded (1048576), dropping request packet [" + this.total_requests_received + "/" + this.total_requests_processed + ":" + this.total_replies + "]");
                                }
                            } else if (this.receive_delay * this.recv_queue.size() > this.queued_request_timeout) {
                                long l3 = SystemTime.getCurrentTime();
                                if (l3 - this.last_error_report > 30000L) {
                                    this.last_error_report = l3;
                                    Debug.out("Receive queue entry limit exceeded (" + this.recv_queue.size() + "), dropping request packet ]" + this.total_requests_received + "/" + this.total_requests_processed + ":" + this.total_replies + "]");
                                }
                            } else {
                                this.recv_queue.add(new Object[]{pRUDPPacket, new Integer(datagramPacket.getLength())});
                                this.recv_queue_data_size += (long)datagramPacket.getLength();
                                this.recv_queue_sem.release();
                                if (this.recv_thread == null) {
                                    this.recv_thread = new AEThread("PRUDPPacketHandler:receiver"){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        @Override
                                        public void runSupport() {
                                            while (true) {
                                                try {
                                                    while (true) {
                                                        Object[] objectArray;
                                                        PRUDPPacketHandlerImpl.this.recv_queue_sem.reserve();
                                                        try {
                                                            PRUDPPacketHandlerImpl.this.recv_queue_mon.enter();
                                                            objectArray = (Object[])PRUDPPacketHandlerImpl.this.recv_queue.remove(0);
                                                            PRUDPPacketHandlerImpl.this.total_requests_processed++;
                                                        }
                                                        finally {
                                                            PRUDPPacketHandlerImpl.this.recv_queue_mon.exit();
                                                        }
                                                        PRUDPPacketRequest pRUDPPacketRequest = (PRUDPPacketRequest)objectArray[0];
                                                        PRUDPPacketHandlerImpl.this.recv_queue_data_size -= ((Integer)objectArray[1]).intValue();
                                                        PRUDPRequestHandler pRUDPRequestHandler = PRUDPPacketHandlerImpl.this.request_handler;
                                                        if (pRUDPRequestHandler == null) continue;
                                                        pRUDPRequestHandler.process(pRUDPPacketRequest);
                                                        Thread.sleep(PRUDPPacketHandlerImpl.this.receive_delay);
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    Debug.printStackTrace(throwable);
                                                    continue;
                                                }
                                                break;
                                            }
                                        }
                                    };
                                    this.recv_thread.setDaemon(true);
                                    this.recv_thread.start();
                                }
                            }
                            break block25;
                        }
                        finally {
                            this.recv_queue_mon.exit();
                        }
                    }
                    PRUDPRequestHandler pRUDPRequestHandler = this.request_handler;
                    if (pRUDPRequestHandler != null) {
                        pRUDPRequestHandler.process((PRUDPPacketRequest)pRUDPPacket);
                    }
                    break block25;
                }
                ++this.total_replies;
                if (this.TRACE_REQUESTS) {
                    Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: reply packet received: " + pRUDPPacket.getString()));
                }
                try {
                    this.requests_mon.enter();
                    pRUDPPacketHandlerRequestImpl = pRUDPPacket.hasContinuation() ? (PRUDPPacketHandlerRequestImpl)this.requests.get(new Integer(pRUDPPacket.getTransactionId())) : (PRUDPPacketHandlerRequestImpl)this.requests.remove(new Integer(pRUDPPacket.getTransactionId()));
                }
                finally {
                    this.requests_mon.exit();
                }
                if (pRUDPPacketHandlerRequestImpl == null) {
                    if (this.TRACE_REQUESTS) {
                        Logger.log(new LogEvent(LOGID, 3, "PRUDPPacketReceiver: unmatched reply received, discarding:" + pRUDPPacket.getString()));
                    }
                } else {
                    pRUDPPacketHandlerRequestImpl.setReply(pRUDPPacket, (InetSocketAddress)datagramPacket.getSocketAddress(), l);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof IOException) break block25;
                Logger.log(new LogEvent(LOGID, "", throwable));
            }
        }
    }

    public PRUDPPacket sendAndReceive(PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        return this.sendAndReceive(null, pRUDPPacket, inetSocketAddress);
    }

    @Override
    public PRUDPPacket sendAndReceive(PasswordAuthentication passwordAuthentication, PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        return this.sendAndReceive(passwordAuthentication, pRUDPPacket, inetSocketAddress, 30000L);
    }

    @Override
    public PRUDPPacket sendAndReceive(PasswordAuthentication passwordAuthentication, PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress, long l) throws PRUDPPacketHandlerException {
        PRUDPPacketHandlerRequestImpl pRUDPPacketHandlerRequestImpl = this.sendAndReceive(passwordAuthentication, pRUDPPacket, inetSocketAddress, null, l, 1);
        return pRUDPPacketHandlerRequestImpl.getReply();
    }

    @Override
    public PRUDPPacket sendAndReceive(PasswordAuthentication passwordAuthentication, PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress, long l, int n) throws PRUDPPacketHandlerException {
        PRUDPPacketHandlerRequestImpl pRUDPPacketHandlerRequestImpl = this.sendAndReceive(passwordAuthentication, pRUDPPacket, inetSocketAddress, null, l, n);
        return pRUDPPacketHandlerRequestImpl.getReply();
    }

    @Override
    public void sendAndReceive(PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress, PRUDPPacketReceiver pRUDPPacketReceiver, long l, int n) throws PRUDPPacketHandlerException {
        this.sendAndReceive(null, pRUDPPacket, inetSocketAddress, pRUDPPacketReceiver, l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PRUDPPacketHandlerRequestImpl sendAndReceive(PasswordAuthentication passwordAuthentication, PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress, PRUDPPacketReceiver pRUDPPacketReceiver, long l, int n) throws PRUDPPacketHandlerException {
        if (this.socket == null) {
            if (this.init_error == null) throw new PRUDPPacketHandlerException("Transport unavailable");
            throw new PRUDPPacketHandlerException("Transport unavailable", this.init_error);
        }
        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = this.altProtocolDelegate;
        if (pRUDPPacketHandlerImpl != null && inetSocketAddress.getAddress().getClass().isInstance(pRUDPPacketHandlerImpl.explicit_bind_ip)) {
            return pRUDPPacketHandlerImpl.sendAndReceive(passwordAuthentication, pRUDPPacket, inetSocketAddress, pRUDPPacketReceiver, l, n);
        }
        try {
            String string;
            Object object;
            Object object2;
            this.checkTargetAddress(inetSocketAddress);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            pRUDPPacket.serialise(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            pRUDPPacket.setSerialisedSize(byArray.length);
            if (passwordAuthentication != null) {
                object2 = new SHA1Hasher();
                object = passwordAuthentication.getUserName();
                string = new String(passwordAuthentication.getPassword());
                byte[] byArray2 = ((String)object).equals("<internal>") ? Base64.decode(string) : ((SHA1Hasher)object2).calculateHash(string.getBytes());
                byte[] byArray3 = new byte[8];
                Arrays.fill(byArray3, (byte)0);
                for (int i = 0; i < byArray3.length && i < ((String)object).length(); ++i) {
                    byArray3[i] = (byte)((String)object).charAt(i);
                }
                object2 = new SHA1Hasher();
                ((SHA1Hasher)object2).update(byArray);
                ((SHA1Hasher)object2).update(byArray3);
                ((SHA1Hasher)object2).update(byArray2);
                byte[] byArray4 = ((SHA1Hasher)object2).getDigest();
                byteArrayOutputStream.write(byArray3);
                byteArrayOutputStream.write(byArray4, 0, 8);
                byArray = byteArrayOutputStream.toByteArray();
            }
            object2 = new DatagramPacket(byArray, byArray.length, inetSocketAddress);
            object = new PRUDPPacketHandlerRequestImpl(pRUDPPacketReceiver, l);
            try {
                this.requests_mon.enter();
                this.requests.put(new Integer(pRUDPPacket.getTransactionId()), object);
            }
            finally {
                this.requests_mon.exit();
            }
            try {
                if (this.send_delay > 0 && n != 99) {
                    try {
                        this.send_queue_mon.enter();
                        if (this.send_queue_data_size > 0x200000L) {
                            ((PRUDPPacketHandlerRequestImpl)object).sent();
                            this.sendToSocket((DatagramPacket)object2);
                            this.stats.packetSent(byArray.length);
                            if (this.TRACE_REQUESTS) {
                                Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: request packet sent to " + inetSocketAddress + ": " + pRUDPPacket.getString()));
                            }
                            Thread.sleep(this.send_delay);
                            return object;
                        }
                        this.send_queue_data_size += (long)((DatagramPacket)object2).getLength();
                        this.send_queues[n].add(new Object[]{object2, object});
                        if (this.TRACE_REQUESTS) {
                            string = "";
                            for (int i = 0; i < this.send_queues.length; ++i) {
                                string = string + (i == 0 ? "" : ",") + this.send_queues[i].size();
                            }
                            System.out.println("send queue sizes: " + string);
                        }
                        this.send_queue_sem.release();
                        if (this.send_thread != null) return object;
                        this.send_thread = new AEThread("PRUDPPacketHandler:sender"){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                int[] nArray = new int[PRUDPPacketHandlerImpl.this.send_queues.length];
                                while (true) {
                                    try {
                                        while (true) {
                                            Object[] objectArray;
                                            Object object;
                                            PRUDPPacketHandlerImpl.this.send_queue_sem.reserve();
                                            int n = 0;
                                            try {
                                                PRUDPPacketHandlerImpl.this.send_queue_mon.enter();
                                                for (int i = 0; i < PRUDPPacketHandlerImpl.this.send_queues.length; ++i) {
                                                    object = PRUDPPacketHandlerImpl.this.send_queues[i];
                                                    int n2 = object.size();
                                                    if (n2 > 0) {
                                                        n = i;
                                                        if (nArray[i] >= 4 || i < PRUDPPacketHandlerImpl.this.send_queues.length - 1 && PRUDPPacketHandlerImpl.this.send_queues[i + 1].size() - n2 > 500) {
                                                            nArray[i] = 0;
                                                            continue;
                                                        }
                                                        int n3 = i;
                                                        nArray[n3] = nArray[n3] + 1;
                                                        break;
                                                    }
                                                    nArray[i] = 0;
                                                }
                                                objectArray = (Object[])PRUDPPacketHandlerImpl.this.send_queues[n].remove(0);
                                            }
                                            finally {
                                                PRUDPPacketHandlerImpl.this.send_queue_mon.exit();
                                            }
                                            DatagramPacket datagramPacket = (DatagramPacket)objectArray[0];
                                            object = (PRUDPPacketHandlerRequestImpl)objectArray[1];
                                            PRUDPPacketHandlerImpl.this.send_queue_data_size -= datagramPacket.getLength();
                                            ((PRUDPPacketHandlerRequestImpl)object).sent();
                                            PRUDPPacketHandlerImpl.this.sendToSocket(datagramPacket);
                                            PRUDPPacketHandlerImpl.this.stats.packetSent(datagramPacket.getLength());
                                            if (PRUDPPacketHandlerImpl.this.TRACE_REQUESTS) {
                                                Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: request packet sent to " + datagramPacket.getAddress()));
                                            }
                                            long l = PRUDPPacketHandlerImpl.this.send_delay;
                                            if (n == 0) {
                                                l /= 2L;
                                            }
                                            Thread.sleep(l);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Logger.log(new LogEvent(LOGID, 1, "PRUDPPacketHandler: send failed: " + Debug.getNestedExceptionMessage(throwable)));
                                        continue;
                                    }
                                    break;
                                }
                            }
                        };
                        this.send_thread.setDaemon(true);
                        this.send_thread.start();
                        return object;
                    }
                    finally {
                        this.send_queue_mon.exit();
                    }
                } else {
                    ((PRUDPPacketHandlerRequestImpl)object).sent();
                    if (object2 == null) {
                        throw new NullPointerException("dg_packet is null");
                    }
                    this.sendToSocket((DatagramPacket)object2);
                    this.stats.packetSent(byArray.length);
                    if (!this.TRACE_REQUESTS) return object;
                    Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: request packet sent to " + inetSocketAddress + ": " + pRUDPPacket.getString()));
                }
                return object;
            }
            catch (Throwable throwable) {
                try {
                    this.requests_mon.enter();
                    this.requests.remove(new Integer(pRUDPPacket.getTransactionId()));
                    throw throwable;
                }
                finally {
                    this.requests_mon.exit();
                }
            }
        }
        catch (PRUDPPacketHandlerException pRUDPPacketHandlerException) {
            throw pRUDPPacketHandlerException;
        }
        catch (Throwable throwable) {
            if (throwable instanceof NullPointerException) {
                Debug.out(throwable);
            }
            String string = Debug.getNestedExceptionMessage(throwable);
            Logger.log(new LogEvent(LOGID, 3, "PRUDPPacketHandler: sendAndReceive to " + inetSocketAddress + " failed: " + string));
            if (string.indexOf("Invalid data length") == -1) throw new PRUDPPacketHandlerException("PRUDPPacketHandler:sendAndReceive failed", throwable);
            Debug.out("packet=" + pRUDPPacket.getString() + ",auth=" + passwordAuthentication);
            Debug.out(throwable);
            throw new PRUDPPacketHandlerException("PRUDPPacketHandler:sendAndReceive failed", throwable);
        }
    }

    @Override
    public void send(PRUDPPacket pRUDPPacket, InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        if (this.socket == null || this.socket.isClosed()) {
            if (this.init_error != null) {
                throw new PRUDPPacketHandlerException("Transport unavailable", this.init_error);
            }
            throw new PRUDPPacketHandlerException("Transport unavailable");
        }
        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = this.altProtocolDelegate;
        if (pRUDPPacketHandlerImpl != null && inetSocketAddress.getAddress().getClass().isInstance(pRUDPPacketHandlerImpl.explicit_bind_ip)) {
            pRUDPPacketHandlerImpl.send(pRUDPPacket, inetSocketAddress);
            return;
        }
        try {
            this.checkTargetAddress(inetSocketAddress);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            pRUDPPacket.serialise(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            pRUDPPacket.setSerialisedSize(byArray.length);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetSocketAddress);
            if (this.TRACE_REQUESTS) {
                Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: reply packet sent: " + pRUDPPacket.getString()));
            }
            this.sendToSocket(datagramPacket);
            this.stats.packetSent(byArray.length);
        }
        catch (PRUDPPacketHandlerException pRUDPPacketHandlerException) {
            throw pRUDPPacketHandlerException;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof NoRouteToHostException)) {
                throwable.printStackTrace();
            }
            Logger.log(new LogEvent(LOGID, 3, "PRUDPPacketHandler: send to " + inetSocketAddress + " failed: " + Debug.getNestedExceptionMessage(throwable)));
            throw new PRUDPPacketHandlerException("PRUDPPacketHandler:send failed", throwable);
        }
    }

    protected void checkTargetAddress(InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        if (inetSocketAddress.getPort() == 0) {
            throw new PRUDPPacketHandlerException("Invalid port - 0");
        }
        if (inetSocketAddress.getAddress() == null) {
            throw new PRUDPPacketHandlerException("Unresolved host '" + inetSocketAddress.getHostName() + "'");
        }
    }

    @Override
    public void setDelays(int n, int n2, int n3) {
        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl;
        this.send_delay = n;
        this.receive_delay = n2;
        this.queued_request_timeout = n3 - 5000;
        if (this.queued_request_timeout < 5000) {
            this.queued_request_timeout = 5000;
        }
        if ((pRUDPPacketHandlerImpl = this.altProtocolDelegate) != null) {
            pRUDPPacketHandlerImpl.setDelays(n, n2, n3);
        }
    }

    public long getSendQueueLength() {
        int n = 0;
        for (int i = 0; i < this.send_queues.length; ++i) {
            n += this.send_queues[i].size();
        }
        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = this.altProtocolDelegate;
        if (pRUDPPacketHandlerImpl != null) {
            n = (int)((long)n + pRUDPPacketHandlerImpl.getSendQueueLength());
        }
        return n;
    }

    public long getReceiveQueueLength() {
        long l = this.recv_queue.size();
        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = this.altProtocolDelegate;
        if (pRUDPPacketHandlerImpl != null) {
            l += pRUDPPacketHandlerImpl.getReceiveQueueLength();
        }
        return l;
    }

    @Override
    public void primordialSend(byte[] byArray, InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        if (this.socket == null || this.socket.isClosed()) {
            if (this.init_error != null) {
                throw new PRUDPPacketHandlerException("Transport unavailable", this.init_error);
            }
            throw new PRUDPPacketHandlerException("Transport unavailable");
        }
        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = this.altProtocolDelegate;
        if (pRUDPPacketHandlerImpl != null && inetSocketAddress.getAddress().getClass().isInstance(pRUDPPacketHandlerImpl.explicit_bind_ip)) {
            pRUDPPacketHandlerImpl.primordialSend(byArray, inetSocketAddress);
            return;
        }
        try {
            this.checkTargetAddress(inetSocketAddress);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetSocketAddress);
            if (this.TRACE_REQUESTS) {
                Logger.log(new LogEvent(LOGID, "PRUDPPacketHandler: reply packet sent: " + byArray.length + " to " + inetSocketAddress));
            }
            this.sendToSocket(datagramPacket);
            this.stats.primordialPacketSent(byArray.length);
        }
        catch (Throwable throwable) {
            throw new PRUDPPacketHandlerException(throwable.getMessage());
        }
    }

    private void sendToSocket(DatagramPacket datagramPacket) throws IOException {
        if (this.packet_transformer != null) {
            this.packet_transformer.transformSend(datagramPacket);
        }
        this.socket.send(datagramPacket);
    }

    private void receiveFromSocket(DatagramPacket datagramPacket) throws IOException {
        this.socket.receive(datagramPacket);
        if (this.packet_transformer != null) {
            this.packet_transformer.transformReceive(datagramPacket);
        }
    }

    @Override
    public PRUDPPacketHandlerStats getStats() {
        return this.stats;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        PRUDPPacketHandlerImpl pRUDPPacketHandlerImpl = this.altProtocolDelegate;
        if (pRUDPPacketHandlerImpl != null) {
            pRUDPPacketHandlerImpl.destroy();
        }
        this.destroy_sem.reserve();
    }

    @Override
    public PRUDPPacketHandler openSession(InetSocketAddress inetSocketAddress) throws PRUDPPacketHandlerException {
        if (use_socks) {
            return new PRUDPPacketHandlerSocks(inetSocketAddress);
        }
        return this;
    }

    @Override
    public void closeSession() throws PRUDPPacketHandlerException {
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enable.Proxy", "Enable.SOCKS"}, new ParameterListener(){

            @Override
            public void parameterChanged(String string) {
                boolean bl = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                boolean bl2 = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                use_socks = bl && bl2;
            }
        });
    }

    protected static interface PacketTransformer {
        public void transformSend(DatagramPacket var1);

        public void transformReceive(DatagramPacket var1);
    }
}

