/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.natpmp.impl;

import com.aelitis.azureus.core.util.NetUtils;
import com.aelitis.net.natpmp.NATPMPDeviceAdapter;
import com.aelitis.net.natpmp.NatPMPDevice;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;

public class NatPMPDeviceImpl
implements NatPMPDevice {
    static final int NATMAP_VER = 0;
    static final int NATMAP_PORT = 5351;
    static final int NATMAP_RESPONSE_MASK = 128;
    static final int NATMAP_INIT_RETRY = 250;
    static final int NATMAP_MAX_RETRY = 2250;
    static final int NATMAP_DEFAULT_LEASE = 86400;
    static final String NATMAP_LLM = "224.0.0.1";
    static final byte NATOp_AddrRequest = 0;
    static final byte NATOp_MapUDP = 1;
    static final byte NATOp_MapTCP = 2;
    static final int NATAddrRequest = 2;
    static final int NATPortMapRequestLen = 12;
    static final int NATAddrReplyLen = 12;
    static final int NATPortMapReplyLen = 16;
    static final int NATResultSuccess = 0;
    static final int NATResultUnsupportedVer = 1;
    static final int NATResultNotAuth = 2;
    static final int NATResultNetFailure = 3;
    static final int NATResultNoResc = 4;
    static final int NATResultUnsupportedOp = 5;
    String current_router_address = "?";
    InetAddress hostInet;
    InetAddress natPriInet;
    InetAddress natPubInet;
    NetworkInterface networkInterface;
    InetAddress llmInet;
    boolean nat_pmp_found = false;
    int nat_epoch = 0;
    private NATPMPDeviceAdapter adapter;
    private static NatPMPDeviceImpl NatPMPDeviceSingletonRef;

    public static synchronized NatPMPDeviceImpl getSingletonObject(NATPMPDeviceAdapter nATPMPDeviceAdapter) throws Exception {
        if (NatPMPDeviceSingletonRef == null) {
            NatPMPDeviceSingletonRef = new NatPMPDeviceImpl(nATPMPDeviceAdapter);
        }
        return NatPMPDeviceSingletonRef;
    }

    private NatPMPDeviceImpl(NATPMPDeviceAdapter nATPMPDeviceAdapter) throws Exception {
        this.adapter = nATPMPDeviceAdapter;
        this.hostInet = NetUtils.getLocalHost();
        this.checkRouterAddress();
    }

    protected void checkRouterAddress() throws Exception {
        String string = this.adapter.getRouterAddress().trim();
        if (string.length() == 0) {
            string = this.convertHost2RouterAddress(this.hostInet);
        }
        if (string.equals(this.current_router_address)) {
            return;
        }
        this.current_router_address = string;
        this.log("Using Router IP: " + string);
        this.natPriInet = InetAddress.getByName(string);
        this.networkInterface = NetworkInterface.getByInetAddress(this.natPriInet);
    }

    public DatagramPacket sendNATMsg(InetAddress inetAddress, DatagramPacket datagramPacket, byte[] byArray) throws Exception {
        int n = 250;
        boolean bl = false;
        DatagramSocket datagramSocket = new DatagramSocket();
        datagramSocket.connect(inetAddress, 5351);
        datagramSocket.setSoTimeout(250);
        datagramSocket.send(datagramPacket);
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
        while (!bl && n < 2250) {
            try {
                datagramSocket.receive(datagramPacket2);
                bl = true;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                Thread.sleep(n);
                n += n * 2;
            }
        }
        if (!bl) {
            throw new PortUnreachableException();
        }
        return datagramPacket2;
    }

    @Override
    public boolean connect() throws Exception {
        this.checkRouterAddress();
        try {
            byte[] byArray = new byte[]{0, 0};
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            byte[] byArray2 = new byte[12];
            this.sendNATMsg(this.natPriInet, datagramPacket, byArray2);
            int n = NatPMPDeviceImpl.unsigned16ByteArrayToInt(byArray2, 2);
            int n2 = NatPMPDeviceImpl.unsigned32ByteArrayToInt(byArray2, 4);
            String string = NatPMPDeviceImpl.unsigned8ByteArrayToInt(byArray2, 8) + "." + NatPMPDeviceImpl.unsigned8ByteArrayToInt(byArray2, 9) + "." + NatPMPDeviceImpl.unsigned8ByteArrayToInt(byArray2, 10) + "." + NatPMPDeviceImpl.unsigned8ByteArrayToInt(byArray2, 11);
            this.natPubInet = InetAddress.getByName(string);
            this.nat_epoch = n2;
            if (n != 0) {
                throw new Exception("NAT-PMP connection error: " + n);
            }
            this.log("Err: " + n);
            this.log("Uptime: " + n2);
            this.log("Public Address: " + string);
            this.nat_pmp_found = true;
            return true;
        }
        catch (PortUnreachableException portUnreachableException) {
            return false;
        }
    }

    @Override
    public int addPortMapping(boolean bl, int n, int n2) throws Exception {
        return this.portMappingProtocol(bl, n, n2, 86400);
    }

    @Override
    public void deletePortMapping(boolean bl, int n, int n2) throws Exception {
        this.portMappingProtocol(bl, n, n2, 0);
    }

    public int portMappingProtocol(boolean bl, int n, int n2, int n3) throws Exception {
        int n4 = bl ? 2 : 1;
        byte[] byArray = this.intToByteArray(n);
        byte[] byArray2 = this.intToByteArray(n2);
        byte[] byArray3 = this.intToByteArray(n3);
        byte[] byArray4 = new byte[12];
        byArray4[0] = 0;
        byArray4[1] = n4;
        byArray4[2] = 0;
        byArray4[3] = 0;
        byArray4[4] = byArray2[2];
        byArray4[5] = byArray2[3];
        byArray4[6] = byArray[2];
        byArray4[7] = byArray[3];
        for (int i = 0; i < 4; ++i) {
            byArray4[8 + i] = byArray3[i];
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray4, byArray4.length);
        byte[] byArray5 = new byte[16];
        this.sendNATMsg(this.natPriInet, datagramPacket, byArray5);
        int n5 = NatPMPDeviceImpl.unsigned8ByteArrayToInt(byArray5, 1);
        int n6 = NatPMPDeviceImpl.unsigned16ByteArrayToInt(byArray5, 2);
        int n7 = NatPMPDeviceImpl.unsigned32ByteArrayToInt(byArray5, 4);
        int n8 = NatPMPDeviceImpl.unsigned16ByteArrayToInt(byArray5, 10);
        int n9 = NatPMPDeviceImpl.unsigned32ByteArrayToInt(byArray5, 12);
        this.log("Seconds since Start of Epoch: " + n7);
        this.log("Returned Mapped Port Lifetime: " + n9);
        if (n6 != 0) {
            throw new Exception("An error occured while getting a port mapping: " + n6);
        }
        if (n5 != n4 + 128) {
            throw new Exception("Received the incorrect port type: " + n5);
        }
        if (n3 != n9) {
            this.log("Received different port life time!");
        }
        return n8;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.hostInet;
    }

    @Override
    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    @Override
    public String getExternalIPAddress() {
        return this.natPubInet.getHostAddress();
    }

    @Override
    public int getEpoch() {
        return this.nat_epoch;
    }

    protected void log(String string) {
        this.adapter.log(string);
    }

    public static int unsigned32ByteArrayToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            int n3 = (3 - i) * 8;
            n2 += (byArray[i + n] & 0xFF) << n3;
        }
        return n2;
    }

    public static int unsigned16ByteArrayToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            int n3 = (1 - i) * 8;
            n2 += (byArray[i + n] & 0xFF) << n3;
        }
        return n2;
    }

    public static int unsigned8ByteArrayToInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public short unsignedByteArrayToShort(byte[] byArray) {
        if (byArray.length == 2) {
            int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            return (short)n;
        }
        return -1;
    }

    public byte[] shortToByteArray(short s) {
        byte[] byArray = new byte[]{(byte)(0xFF & s >> 8), (byte)(0xFF & s >> 0)};
        return byArray;
    }

    public byte[] intToByteArray(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = 24;
        while (n2 < 4) {
            byArray[n2] = (byte)(0xFF & n >> n3);
            ++n2;
            n3 -= 8;
        }
        return byArray;
    }

    public String intArrayString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]).append(" ");
        }
        return stringBuffer.toString();
    }

    public String byteArrayString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]).append(" ");
        }
        return stringBuffer.toString();
    }

    private String convertHost2RouterAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        byArray[3] = 1;
        String string = (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
        return string;
    }
}

