/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin;

import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesFPListener;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadStats;

public class DefaultRankCalculator
implements Comparable {
    public static final int FIRSTPRIORITY_ALL = 0;
    public static final int FIRSTPRIORITY_ANY = 1;
    private static final int FORCE_ACTIVE_FOR = 30000;
    private static final int ACTIVE_CHANGE_WAIT = 10000;
    private static int SPRATIO_BASE_LIMIT = 99999;
    private static int SEEDONLY_SHIFT = SPRATIO_BASE_LIMIT + 1;
    private static COConfigurationListener configListener = null;
    public static final int SR_COMPLETE_STARTS_AT = 1000000000;
    public static final int SR_TIMED_QUEUED_ENDS_AT = 999999;
    public static final int SR_IGNORED_LESS_THAN = -1;
    public static final int SR_NOTQUEUED = -2;
    public static final int SR_FP_SPRATIOMET = -3;
    public static final int SR_RATIOMET = -4;
    public static final int SR_NUMSEEDSMET = -5;
    public static final int SR_FP0PEERS = -6;
    public static final int SR_0PEERS = -7;
    public static final int SR_SHARERATIOMET = -8;
    public static final String[] SR_NEGATIVE_DEBUG = new String[]{"?", "Not Qd", "FP SPRatioMet", "Ratio Met", "# CDs Met", "FP 0 Peers", "0 Peers", "Share Ratio Met"};
    private static final long STALE_REFRESH_INTERVAL = 60000L;
    protected static int iRankType = -1;
    private static int minPeersToBoostNoSeeds;
    private static int minSpeedForActiveDL;
    private static int minSpeedForActiveSeeding;
    private static int iIgnoreSeedCount;
    private static boolean bIgnore0Peers;
    private static int iIgnoreShareRatio;
    private static int iIgnoreShareRatio_SeedStart;
    private static int iIgnoreRatioPeers;
    private static int iIgnoreRatioPeers_SeedStart;
    private static int iRankTypeSeedFallback;
    private static boolean bPreferLargerSwarms;
    private static int minQueueingShareRatio;
    private static int iFirstPriorityIgnoreSPRatio;
    private static boolean bFirstPriorityIgnore0Peer;
    private static int iFirstPriorityType;
    private static int iFirstPrioritySeedingMinutes;
    private static int iFirstPriorityActiveMinutes;
    private static int iFirstPriorityIgnoreIdleHours;
    private static long minTimeAlive;
    private static boolean bAutoStart0Peers;
    protected Download dl;
    private boolean bActivelyDownloading;
    private long lDLActivelyChangedOn;
    private boolean bActivelySeeding;
    private long lCDActivelyChangedOn;
    private long staleCDSince;
    private long staleCDOffset;
    private long lastStaleCDRefresh;
    private boolean bIsFirstPriority;
    public String sExplainFP = "";
    public String sExplainSR = "";
    public String sTrace = "";
    private AEMonitor downloadData_this_mon = new AEMonitor("StartStopRules:downloadData");
    private final StartStopRulesDefaultPlugin rules;
    int lastModifiedScrapeResultPeers = 0;
    int lastModifiedScrapeResultSeeds = 0;
    int lastModifiedShareRatio = 0;
    boolean lastScrapeResultOk = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultRankCalculator(StartStopRulesDefaultPlugin startStopRulesDefaultPlugin, Download download) {
        this.rules = startStopRulesDefaultPlugin;
        this.dl = download;
        try {
            this.downloadData_this_mon.enter();
            if (configListener == null) {
                configListener = new COConfigurationListener(){

                    @Override
                    public void configurationSaved() {
                        DefaultRankCalculator.reloadConfigParams(((DefaultRankCalculator)DefaultRankCalculator.this).rules.plugin_config);
                    }
                };
                COConfigurationManager.addListener(configListener);
                configListener.configurationSaved();
            }
        }
        finally {
            this.downloadData_this_mon.exit();
        }
    }

    public static void reloadConfigParams(PluginConfig pluginConfig) {
        iRankType = pluginConfig.getUnsafeIntParameter("StartStopManager_iRankType");
        minPeersToBoostNoSeeds = pluginConfig.getUnsafeIntParameter("StartStopManager_iMinPeersToBoostNoSeeds");
        minSpeedForActiveDL = pluginConfig.getUnsafeIntParameter("StartStopManager_iMinSpeedForActiveDL");
        minSpeedForActiveSeeding = pluginConfig.getUnsafeIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
        iRankTypeSeedFallback = pluginConfig.getUnsafeIntParameter("StartStopManager_iRankTypeSeedFallback");
        bPreferLargerSwarms = pluginConfig.getUnsafeBooleanParameter("StartStopManager_bPreferLargerSwarms");
        minTimeAlive = pluginConfig.getUnsafeIntParameter("StartStopManager_iMinSeedingTime") * 1000;
        bAutoStart0Peers = pluginConfig.getUnsafeBooleanParameter("StartStopManager_bAutoStart0Peers");
        iIgnoreSeedCount = pluginConfig.getUnsafeIntParameter("StartStopManager_iIgnoreSeedCount");
        bIgnore0Peers = pluginConfig.getUnsafeBooleanParameter("StartStopManager_bIgnore0Peers");
        iIgnoreShareRatio = (int)(1000.0f * pluginConfig.getFloatParameter("Stop Ratio"));
        iIgnoreShareRatio_SeedStart = pluginConfig.getUnsafeIntParameter("StartStopManager_iIgnoreShareRatioSeedStart");
        iIgnoreRatioPeers = pluginConfig.getIntParameter("Stop Peers Ratio", 0);
        iIgnoreRatioPeers_SeedStart = pluginConfig.getUnsafeIntParameter("StartStopManager_iIgnoreRatioPeersSeedStart", 0);
        minQueueingShareRatio = pluginConfig.getUnsafeIntParameter("StartStopManager_iFirstPriority_ShareRatio");
        iFirstPriorityType = pluginConfig.getUnsafeIntParameter("StartStopManager_iFirstPriority_Type");
        iFirstPrioritySeedingMinutes = pluginConfig.getUnsafeIntParameter("StartStopManager_iFirstPriority_SeedingMinutes");
        iFirstPriorityActiveMinutes = pluginConfig.getUnsafeIntParameter("StartStopManager_iFirstPriority_DLMinutes");
        iFirstPriorityIgnoreSPRatio = pluginConfig.getUnsafeIntParameter("StartStopManager_iFirstPriority_ignoreSPRatio");
        bFirstPriorityIgnore0Peer = pluginConfig.getUnsafeBooleanParameter("StartStopManager_bFirstPriority_ignore0Peer");
        iFirstPriorityIgnoreIdleHours = pluginConfig.getUnsafeIntParameter("StartStopManager_iFirstPriority_ignoreIdleHours");
    }

    public int compareTo(Object object) {
        if (!(object instanceof DefaultRankCalculator)) {
            return -1;
        }
        DefaultRankCalculator defaultRankCalculator = (DefaultRankCalculator)object;
        if (defaultRankCalculator.bIsFirstPriority && !this.bIsFirstPriority) {
            return 1;
        }
        if (!defaultRankCalculator.bIsFirstPriority && this.bIsFirstPriority) {
            return -1;
        }
        boolean bl = defaultRankCalculator.dl.isComplete();
        boolean bl2 = this.dl.isComplete();
        if (bl && !bl2) {
            return -1;
        }
        if (!bl && bl2) {
            return 1;
        }
        if (iRankType == 0) {
            return this.dl.getPosition() - defaultRankCalculator.dl.getPosition();
        }
        int n = defaultRankCalculator.dl.getSeedingRank() - this.dl.getSeedingRank();
        if (n != 0) {
            return n;
        }
        if (iRankType != 3) {
            int n2 = defaultRankCalculator.lastModifiedScrapeResultPeers;
            int n3 = this.lastModifiedScrapeResultPeers;
            n = bPreferLargerSwarms ? n2 - n3 : n3 - n2;
            if (n != 0) {
                return n;
            }
            n = this.lastModifiedShareRatio - defaultRankCalculator.lastModifiedShareRatio;
            if (n != 0) {
                return n;
            }
        }
        return this.dl.getPosition() - defaultRankCalculator.dl.getPosition();
    }

    public Download getDownloadObject() {
        return this.dl;
    }

    public boolean isForceActive() {
        DownloadStats downloadStats = this.dl.getStats();
        return SystemTime.getCurrentTime() - downloadStats.getTimeStarted() <= 30000L;
    }

    public boolean getActivelyDownloading() {
        boolean bl = false;
        DownloadStats downloadStats = this.dl.getStats();
        int n = this.dl.getState();
        if (n != 4) {
            bl = false;
        } else if (SystemTime.getCurrentTime() - downloadStats.getTimeStarted() <= 30000L) {
            bl = true;
        } else {
            boolean bl2 = bl = downloadStats.getDownloadAverage() >= (long)minSpeedForActiveDL;
            if (this.bActivelyDownloading != bl) {
                long l = SystemTime.getCurrentTime();
                if (this.lDLActivelyChangedOn == -1L) {
                    this.lDLActivelyChangedOn = l;
                    bl = !bl;
                } else if (l - this.lDLActivelyChangedOn < 10000L) {
                    bl = !bl;
                }
            } else {
                this.lDLActivelyChangedOn = -1L;
            }
        }
        if (this.bActivelyDownloading != bl) {
            this.bActivelyDownloading = bl;
            if (this.rules != null) {
                this.rules.requestProcessCycle(null);
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: ActivelyDownloading changed");
                }
            }
        }
        return this.bActivelyDownloading;
    }

    public boolean getActivelySeeding() {
        boolean bl = false;
        DownloadStats downloadStats = this.dl.getStats();
        int n = this.dl.getState();
        if (!(iRankType != 3 || this.isFirstPriority() || bAutoStart0Peers && this.rules.calcPeersNoUs(this.dl) == 0 && this.lastScrapeResultOk)) {
            bl = n == 5;
        } else if (n != 5 || bAutoStart0Peers && this.rules.calcPeersNoUs(this.dl) == 0) {
            bl = false;
            this.staleCDSince = -1L;
        } else if (SystemTime.getCurrentTime() - downloadStats.getTimeStarted() <= 30000L) {
            bl = true;
            this.staleCDSince = -1L;
        } else {
            boolean bl2 = bl = downloadStats.getUploadAverage() >= (long)minSpeedForActiveSeeding;
            if (this.bActivelySeeding != bl) {
                long l = SystemTime.getCurrentTime();
                if (this.lCDActivelyChangedOn < 0L) {
                    this.lCDActivelyChangedOn = l;
                    bl = !bl;
                } else if (l - this.lCDActivelyChangedOn < 10000L) {
                    boolean bl3 = bl = !bl;
                }
                if (this.bActivelySeeding != bl) {
                    if (bl) {
                        this.staleCDSince = -1L;
                        this.staleCDOffset = 0L;
                    } else {
                        this.staleCDSince = System.currentTimeMillis();
                    }
                }
            } else {
                this.lCDActivelyChangedOn = -1L;
            }
        }
        if (this.bActivelySeeding != bl) {
            this.bActivelySeeding = bl;
            if (this.rules != null) {
                this.rules.requestProcessCycle(null);
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: ActivelySeeding changed");
                }
            }
        }
        return this.bActivelySeeding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recalcSeedingRank() {
        try {
            float f;
            boolean bl;
            this.downloadData_this_mon.enter();
            this.sExplainSR = "";
            int n = this.dl.getSeedingRank();
            DownloadStats downloadStats = this.dl.getStats();
            int n2 = 0;
            if (!this.dl.isComplete()) {
                n2 = 1000000000 + (10000 - this.dl.getPosition());
                this.dl.setSeedingRank(n2);
                if (this.rules.bDebugLog) {
                    this.sExplainSR = this.sExplainSR + "  not complete. SetSR " + n2 + "\n";
                }
                int n3 = n2;
                return n3;
            }
            this.lastModifiedShareRatio = downloadStats.getShareRatio();
            this.lastModifiedScrapeResultPeers = this.rules.calcPeersNoUs(this.dl);
            this.lastModifiedScrapeResultSeeds = this.rules.calcSeedsNoUs(this.dl);
            boolean bl2 = bl = (this.lastModifiedScrapeResultPeers > 0 || this.lastModifiedScrapeResultSeeds > 0 || this.lastScrapeResultOk) && this.lastModifiedScrapeResultPeers >= 0 && this.lastModifiedScrapeResultSeeds >= 0;
            if (!this.isFirstPriority()) {
                if (!(iIgnoreShareRatio == 0 || this.lastModifiedShareRatio < iIgnoreShareRatio || this.lastModifiedScrapeResultSeeds < iIgnoreShareRatio_SeedStart && bl || this.lastModifiedShareRatio == -1)) {
                    if (this.rules.bDebugLog) {
                        this.sExplainSR = this.sExplainSR + "  shareratio met: shareRatio(" + this.lastModifiedShareRatio + ") >= " + iIgnoreShareRatio + "\n";
                    }
                    this.dl.setSeedingRank(-8);
                    int n4 = -8;
                    return n4;
                }
                if (this.rules.bDebugLog && iIgnoreShareRatio != 0 && this.lastModifiedShareRatio >= iIgnoreShareRatio) {
                    this.sExplainSR = this.sExplainSR + "  shareratio NOT met: ";
                    if (this.lastModifiedScrapeResultSeeds >= iIgnoreShareRatio_SeedStart) {
                        this.sExplainSR = this.sExplainSR + this.lastModifiedScrapeResultSeeds + " below seed threshold of " + iIgnoreShareRatio_SeedStart;
                    }
                    this.sExplainSR = this.sExplainSR + "\n";
                }
                if (this.lastModifiedScrapeResultPeers == 0 && bl) {
                    if (bIgnore0Peers) {
                        if (this.rules.bDebugLog) {
                            this.sExplainSR = this.sExplainSR + "  Ignore 0 Peers criteria met\n";
                        }
                        this.dl.setSeedingRank(-7);
                        int n5 = -7;
                        return n5;
                    }
                } else if (this.rules.bDebugLog && this.lastModifiedScrapeResultPeers == 0) {
                    this.sExplainSR = this.sExplainSR + "  0 Peer Ignore rule NOT applied: Scrape invalid\n";
                }
                if (iIgnoreSeedCount != 0 && this.lastModifiedScrapeResultSeeds >= iIgnoreSeedCount) {
                    if (this.rules.bDebugLog) {
                        this.sExplainSR = this.sExplainSR + "  SeedCount Ignore rule met.  numSeeds(" + this.lastModifiedScrapeResultSeeds + " >= iIgnoreSeedCount(" + iIgnoreSeedCount + ")\n";
                    }
                    this.dl.setSeedingRank(-5);
                    int n6 = -5;
                    return n6;
                }
                if (iIgnoreRatioPeers != 0 && this.lastModifiedScrapeResultSeeds != 0 && (f = (float)this.lastModifiedScrapeResultPeers / (float)this.lastModifiedScrapeResultSeeds) <= (float)iIgnoreRatioPeers && this.lastModifiedScrapeResultSeeds >= iIgnoreRatioPeers_SeedStart) {
                    if (this.rules.bDebugLog) {
                        this.sExplainSR = this.sExplainSR + "  P:S Ignore rule met.  ratio(" + f + " <= threshold(" + iIgnoreRatioPeers_SeedStart + ")\n";
                    }
                    this.dl.setSeedingRank(-4);
                    int n7 = -4;
                    return n7;
                }
            }
            if (iRankType == 0) {
                if (this.rules.bDebugLog) {
                    this.sExplainSR = this.sExplainSR + "  Ranking Type set to none.. blanking seeding rank\n";
                }
                this.dl.setSeedingRank(n2);
                int n8 = n2;
                return n8;
            }
            if (iRankType == 3) {
                if (this.bIsFirstPriority) {
                    this.dl.setSeedingRank(n2 += 1000000);
                    int n9 = n2;
                    return n9;
                }
                int n10 = this.dl.getState();
                if (n10 == 6 || n10 == 7 || n10 == 8) {
                    if (this.rules.bDebugLog) {
                        this.sExplainSR = this.sExplainSR + "  Download stopping, stopped or in error\n";
                    }
                    this.dl.setSeedingRank(-2);
                    int n11 = -2;
                    return n11;
                }
                if (n10 == 5 || n10 == 3 || n10 == 1 || n10 == 2) {
                    long l = 0L;
                    if (n10 == 5 && !this.dl.isForceStart()) {
                        l = SystemTime.getCurrentTime() - downloadStats.getTimeStartedSeeding();
                    }
                    if (l >= minTimeAlive) {
                        this.dl.setSeedingRank(1);
                        if (n > 999999) {
                            this.rules.requestProcessCycle(null);
                            if (this.rules.bDebugLog) {
                                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: TimeUp");
                            }
                        }
                    } else {
                        n2 = 1000000 + (int)(l / 1000L);
                        this.dl.setSeedingRank(n2);
                        if (n <= 999999) {
                            this.rules.requestProcessCycle(null);
                            if (this.rules.bDebugLog) {
                                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: strange timer change");
                            }
                        }
                    }
                    int n12 = n2;
                    return n12;
                }
                if (n <= 0) {
                    n2 = 999999 - this.dl.getPosition();
                    this.dl.setSeedingRank(n2);
                    this.rules.requestProcessCycle(null);
                    if (this.rules.bDebugLog) {
                        this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: NotIgnored");
                    }
                }
                int n13 = n2;
                return n13;
            }
            if (bl) {
                if (iRankType == 4) {
                    n2 = this.lastModifiedScrapeResultPeers > this.lastModifiedScrapeResultSeeds * 10 ? 100 * this.lastModifiedScrapeResultPeers * 10 : (int)(100L * (long)this.lastModifiedScrapeResultPeers * (long)this.lastModifiedScrapeResultPeers / (long)(this.lastModifiedScrapeResultSeeds + 1));
                } else if (iRankType == 2 && (iRankTypeSeedFallback == 0 || iRankTypeSeedFallback > this.lastModifiedScrapeResultSeeds)) {
                    n2 = this.lastModifiedScrapeResultSeeds < 10000 ? 10000 - this.lastModifiedScrapeResultSeeds : 1;
                    n2 *= SEEDONLY_SHIFT;
                } else if (this.lastModifiedScrapeResultPeers != 0) {
                    if (this.lastModifiedScrapeResultSeeds == 0) {
                        if (this.lastModifiedScrapeResultPeers >= minPeersToBoostNoSeeds) {
                            n2 += SPRATIO_BASE_LIMIT;
                        }
                    } else {
                        f = (float)this.lastModifiedScrapeResultSeeds / (float)this.lastModifiedScrapeResultPeers;
                        n2 = (int)((float)n2 + (float)SPRATIO_BASE_LIMIT / ((f + 1.0f) * (f + 1.0f)));
                    }
                }
            } else if (this.rules.bDebugLog) {
                this.sExplainSR = this.sExplainSR + "  Can't calculate SR, no scrape results\n";
            }
            if (this.staleCDOffset > 0L) {
                if ((long)n2 > this.staleCDOffset) {
                    n2 = (int)((long)n2 - this.staleCDOffset);
                    this.sExplainSR = this.sExplainSR + "  subtracted " + this.staleCDOffset + " due to non-activeness\n";
                } else {
                    this.staleCDOffset = 0L;
                }
            }
            if (n2 < 0) {
                n2 = 1;
            }
            if (n2 != n) {
                this.dl.setSeedingRank(n2);
            }
            int n14 = n2;
            return n14;
        }
        finally {
            this.downloadData_this_mon.exit();
        }
    }

    public boolean isFirstPriority() {
        boolean bl = this.pisFirstPriority();
        if (this.bIsFirstPriority != bl) {
            this.bIsFirstPriority = bl;
            this.rules.requestProcessCycle(null);
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: FP changed");
            }
        }
        return this.bIsFirstPriority;
    }

    private boolean pisFirstPriority() {
        int n;
        boolean bl;
        if (this.rules.bDebugLog) {
            this.sExplainFP = "FP if " + (iFirstPriorityType == 0 ? "all" : "any") + " criteria match:\n";
        }
        if (!this.dl.isPersistent()) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: Download not persistent\n";
            }
            return false;
        }
        if (this.dl.getState() == 8 || this.dl.getState() == 7) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: Download is ERROR or STOPPED\n";
            }
            return false;
        }
        if (!this.dl.isComplete()) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: Download not complete\n";
            }
            return false;
        }
        List list = this.rules.getFPListeners();
        StringBuffer stringBuffer = null;
        if (!list.isEmpty()) {
            if (this.rules.bDebugLog) {
                stringBuffer = new StringBuffer();
            }
            for (StartStopRulesFPListener startStopRulesFPListener : list) {
                boolean bl2 = startStopRulesFPListener.isFirstPriority(this.dl, this.lastModifiedScrapeResultSeeds, this.lastModifiedScrapeResultPeers, stringBuffer);
                if (stringBuffer != null && stringBuffer.length() > 0) {
                    char c = stringBuffer.charAt(stringBuffer.length() - 1);
                    if (c != '\n') {
                        stringBuffer.append('\n');
                    }
                    this.sExplainFP = this.sExplainFP + stringBuffer;
                    stringBuffer.setLength(0);
                }
                if (!bl2) continue;
                return true;
            }
        }
        if (this.lastModifiedScrapeResultPeers > 0 && this.lastModifiedScrapeResultSeeds > 0 && this.lastModifiedScrapeResultSeeds / this.lastModifiedScrapeResultPeers >= iFirstPriorityIgnoreSPRatio && iFirstPriorityIgnoreSPRatio != 0) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: S:P >= " + iFirstPriorityIgnoreSPRatio + ":1\n";
            }
            return false;
        }
        if (this.lastModifiedScrapeResultPeers == 0 && this.lastScrapeResultOk && bFirstPriorityIgnore0Peer) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "Not FP: 0 peers\n";
            }
            return false;
        }
        if (iFirstPriorityIgnoreIdleHours > 0) {
            long l = this.dl.getStats().getSecondsSinceLastUpload();
            if (l < 0L) {
                l = this.dl.getStats().getSecondsOnlySeeding();
            }
            if (l > (long)(3600 * iFirstPriorityIgnoreIdleHours)) {
                if (this.rules.bDebugLog) {
                    this.sExplainFP = this.sExplainFP + "Not FP: " + l + "s > " + iFirstPriorityIgnoreIdleHours + "h of no upload\n";
                }
                return false;
            }
        }
        boolean bl3 = bl = (n = this.dl.getStats().getShareRatio()) != -1 && n < minQueueingShareRatio;
        if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "  shareRatio(" + n + ") < " + minQueueingShareRatio + "=" + bl + "\n";
        }
        if (!bl && iFirstPriorityType == 0) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "..Not FP.  Exit Early\n";
            }
            return false;
        }
        if (bl && iFirstPriorityType == 1) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "..Is FP.  Exit Early\n";
            }
            return true;
        }
        boolean bl4 = bl = iFirstPrioritySeedingMinutes == 0;
        if (!bl) {
            long l = this.dl.getStats().getSecondsOnlySeeding();
            if (l >= 0L) {
                boolean bl5 = bl = l < (long)(iFirstPrioritySeedingMinutes * 60);
                if (this.rules.bDebugLog) {
                    this.sExplainFP = this.sExplainFP + "  SeedingTime(" + l + ") < " + iFirstPrioritySeedingMinutes * 60 + "=" + bl + "\n";
                }
                if (!bl && iFirstPriorityType == 0) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Not FP.  Exit Early\n";
                    }
                    return false;
                }
                if (bl && iFirstPriorityType == 1) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Is FP.  Exit Early\n";
                    }
                    return true;
                }
            }
        } else if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "  Skipping Seeding Time check (user disabled)\n";
        }
        boolean bl6 = bl = iFirstPriorityActiveMinutes == 0;
        if (!bl) {
            long l = this.dl.getStats().getSecondsDownloading() + this.dl.getStats().getSecondsOnlySeeding();
            if (l >= 0L) {
                boolean bl7 = bl = l < (long)(iFirstPriorityActiveMinutes * 60);
                if (this.rules.bDebugLog) {
                    this.sExplainFP = this.sExplainFP + "  ActiveTime(" + l + ") < " + iFirstPriorityActiveMinutes * 60 + "=" + bl + "\n";
                }
                if (!bl && iFirstPriorityType == 0) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Not FP.  Exit Early\n";
                    }
                    return false;
                }
                if (bl && iFirstPriorityType == 1) {
                    if (this.rules.bDebugLog) {
                        this.sExplainFP = this.sExplainFP + "..Is FP.  Exit Early\n";
                    }
                    return true;
                }
            }
        } else if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "  Skipping DL Time check (user disabled)\n";
        }
        if (iFirstPriorityType == 0) {
            if (this.rules.bDebugLog) {
                this.sExplainFP = this.sExplainFP + "..Is FP\n";
            }
            return true;
        }
        if (this.rules.bDebugLog) {
            this.sExplainFP = this.sExplainFP + "..Not FP\n";
        }
        return false;
    }

    public boolean getCachedIsFP() {
        return this.bIsFirstPriority;
    }

    public String toString() {
        return String.valueOf(this.dl.getSeedingRank());
    }

    public boolean changeChecker() {
        long l;
        if (this.getActivelySeeding()) {
            int n = this.dl.getStats().getShareRatio();
            int n2 = this.rules.calcSeedsNoUs(this.dl);
            if (!(iIgnoreShareRatio == 0 || n < iIgnoreShareRatio || n2 < iIgnoreShareRatio_SeedStart && this.lastScrapeResultOk || n == -1)) {
                if (this.rules.bDebugLog) {
                    this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: shareRatio changeChecker");
                }
                return true;
            }
        }
        if (this.dl.getState() == 3) {
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: Download is ready");
            }
            return true;
        }
        if (this.staleCDSince > 0L && (l = SystemTime.getCurrentTime()) - this.lastStaleCDRefresh > 60000L) {
            this.staleCDOffset += (l - this.lastStaleCDRefresh) / 60000L;
            this.lastStaleCDRefresh = l;
            if (this.rules.bDebugLog) {
                this.rules.log.log((Object)this.dl.getTorrent(), 1, "somethingChanged: staleCD changeChecker");
            }
            return true;
        }
        return false;
    }
}

