/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.sharing.hoster;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceEvent;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;
import org.gudy.azureus2.plugins.utils.DelayedTask;

public class ShareHosterPlugin
implements Plugin,
PluginListener,
ShareManagerListener {
    protected PluginInterface plugin_interface;
    protected LoggerChannel log;
    protected Tracker tracker;
    protected ShareManager share_manager;
    protected DownloadManager download_manager;
    protected Map resource_dl_map = new HashMap();
    protected Map resource_tt_map = new HashMap();
    protected Download download_being_removed;
    protected TrackerTorrent torrent_being_removed;

    public static void load(PluginInterface pluginInterface) {
        pluginInterface.getPluginProperties().setProperty("plugin.version", "1.0");
        pluginInterface.getPluginProperties().setProperty("plugin.name", "Share Hoster");
    }

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.log = this.plugin_interface.getLogger().getChannel("ShareHosterPlugin");
        this.log.log(1, "ShareHosterPlugin: initialisation starts");
        this.plugin_interface.addListener(this);
    }

    @Override
    public void initializationComplete() {
        DelayedTask delayedTask = this.plugin_interface.getUtilities().createDelayedTask(new Runnable(){

            @Override
            public void run() {
                ShareHosterPlugin.this.initialise();
            }
        });
        delayedTask.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise() {
        this.log.log(1, "ShareHosterPlugin: initialisation complete");
        Thread.currentThread().setPriority(1);
        try {
            this.tracker = this.plugin_interface.getTracker();
            this.download_manager = this.plugin_interface.getDownloadManager();
            this.share_manager = this.plugin_interface.getShareManager();
            this.share_manager.addListener(this);
            this.share_manager.initialise();
        }
        catch (ShareException shareException) {
            Debug.printStackTrace(shareException);
            this.log.log(shareException);
        }
        finally {
            this.plugin_interface.getPluginManager().firePluginEvent(5);
        }
    }

    @Override
    public void closedownInitiated() {
    }

    @Override
    public void closedownComplete() {
    }

    @Override
    public void resourceAdded(final ShareResource shareResource) {
        this.log.log(1, "Resource added:".concat(shareResource.getName()));
        try {
            Object object;
            Torrent torrent;
            TorrentAttribute[] torrentAttributeArray;
            ShareResource shareResource2;
            shareResource.addDeletionListener(new ShareResourceWillBeDeletedListener(){

                @Override
                public void resourceWillBeDeleted(ShareResource shareResource) throws ShareResourceDeletionVetoException {
                    ShareHosterPlugin.this.canResourceBeDeleted(shareResource);
                }
            });
            Download download = null;
            int n = shareResource.getType();
            if (n == 1) {
                shareResource2 = (ShareResourceFile)shareResource;
                torrentAttributeArray = shareResource2.getItem();
                torrent = torrentAttributeArray.getTorrent();
                object = this.download_manager.getDownload(torrent);
                if (object == null) {
                    download = this.download_manager.addNonPersistentDownload(torrent, torrentAttributeArray.getTorrentFile(), shareResource2.getFile());
                }
            } else if (n == 2 && (object = this.download_manager.getDownload(torrent = (torrentAttributeArray = (shareResource2 = (ShareResourceDir)shareResource).getItem()).getTorrent())) == null) {
                download = this.download_manager.addNonPersistentDownload(torrent, torrentAttributeArray.getTorrentFile(), shareResource2.getDir());
            }
            if (download != null) {
                shareResource2 = download;
                this.resource_dl_map.put(shareResource, download);
                shareResource.addChangeListener(new ShareResourceListener((Download)((Object)shareResource2)){
                    final /* synthetic */ Download val$f_new_download;
                    {
                        this.val$f_new_download = download;
                    }

                    @Override
                    public void shareResourceChanged(ShareResource shareResource, ShareResourceEvent shareResourceEvent) {
                        if (shareResourceEvent.getType() == 1) {
                            TorrentAttribute torrentAttribute = (TorrentAttribute)shareResourceEvent.getData();
                            this.val$f_new_download.setAttribute(torrentAttribute, shareResource.getAttribute(torrentAttribute));
                        }
                    }
                });
                torrentAttributeArray = shareResource.getAttributes();
                for (int i = 0; i < torrentAttributeArray.length; ++i) {
                    object = torrentAttributeArray[i];
                    download.setAttribute((TorrentAttribute)object, shareResource.getAttribute((TorrentAttribute)object));
                }
                download.addAttributeListener(new DownloadAttributeListener(){

                    @Override
                    public void attributeEventOccurred(Download download, TorrentAttribute torrentAttribute, int n) {
                        shareResource.setAttribute(torrentAttribute, download.getAttribute(torrentAttribute));
                    }
                }, this.plugin_interface.getTorrentManager().getAttribute("Category"), 1);
                Torrent torrent2 = download.getTorrent();
                if (torrent2 != null) {
                    object = this.tracker.host(torrent2, false);
                    object.addRemovalListener(new TrackerTorrentWillBeRemovedListener(){

                        @Override
                        public void torrentWillBeRemoved(TrackerTorrent trackerTorrent) throws TrackerTorrentRemovalVetoException {
                            if (trackerTorrent != ShareHosterPlugin.this.torrent_being_removed) {
                                throw new TrackerTorrentRemovalVetoException(MessageText.getString("plugin.sharing.torrent.remove.veto"));
                            }
                        }
                    });
                    this.resource_tt_map.put(shareResource, object);
                }
                download.addDownloadWillBeRemovedListener(new DownloadWillBeRemovedListener(){

                    @Override
                    public void downloadWillBeRemoved(Download download) throws DownloadRemovalVetoException {
                        if (download != ShareHosterPlugin.this.download_being_removed) {
                            throw new DownloadRemovalVetoException(MessageText.getString("plugin.sharing.download.remove.veto"));
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected void canResourceBeDeleted(ShareResource shareResource) throws ShareResourceDeletionVetoException {
        TrackerTorrent trackerTorrent;
        Download download = (Download)this.resource_dl_map.get(shareResource);
        if (download != null) {
            try {
                this.download_being_removed = download;
                download.canBeRemoved();
            }
            catch (DownloadRemovalVetoException downloadRemovalVetoException) {
                throw new ShareResourceDeletionVetoException(downloadRemovalVetoException.getMessage());
            }
            finally {
                this.download_being_removed = null;
            }
        }
        if ((trackerTorrent = (TrackerTorrent)this.resource_tt_map.get(shareResource)) != null) {
            try {
                this.torrent_being_removed = trackerTorrent;
                trackerTorrent.canBeRemoved();
            }
            catch (TrackerTorrentRemovalVetoException trackerTorrentRemovalVetoException) {
                throw new ShareResourceDeletionVetoException(trackerTorrentRemovalVetoException.getMessage());
            }
            finally {
                this.torrent_being_removed = null;
            }
        }
    }

    @Override
    public void resourceModified(ShareResource shareResource, ShareResource shareResource2) {
        this.log.log(1, "Resource modified:".concat(shareResource.getName()));
        this.resourceDeleted(shareResource);
        this.resourceAdded(shareResource2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceDeleted(ShareResource shareResource) {
        TrackerTorrent trackerTorrent;
        this.log.log(1, "Resource deleted:".concat(shareResource.getName()));
        Download download = (Download)this.resource_dl_map.get(shareResource);
        if (download != null) {
            try {
                this.download_being_removed = download;
                try {
                    download.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                download.remove();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            finally {
                this.download_being_removed = null;
            }
            this.resource_dl_map.remove(shareResource);
        }
        if ((trackerTorrent = (TrackerTorrent)this.resource_tt_map.get(shareResource)) != null) {
            try {
                this.torrent_being_removed = trackerTorrent;
                trackerTorrent.remove();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            finally {
                this.torrent_being_removed = null;
            }
            this.resource_tt_map.remove(shareResource);
        }
    }

    @Override
    public void reportProgress(int n) {
    }

    @Override
    public void reportCurrentTask(String string) {
        this.log.log(1, "Current Task:".concat(string));
    }
}

