/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.util;

import com.aelitis.azureus.core.util.Java15Utils;
import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public class ExternalSeedHTTPDownloaderLinear
implements ExternalSeedHTTPDownloader {
    private URL original_url;
    private String user_agent;
    private int last_response;
    private int last_response_retry_after_secs;
    private Downloader downloader;

    public ExternalSeedHTTPDownloaderLinear(URL uRL, String string) {
        this.original_url = uRL;
        this.user_agent = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadRange(long l, int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        Request request2;
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader == null) {
                this.downloader = new Downloader(externalSeedHTTPDownloaderListener, bl);
            }
            request2 = this.downloader.addRequest(l, n, externalSeedHTTPDownloaderListener);
        }
        do {
            if (!request2.waitFor(1000)) continue;
            return;
        } while (!externalSeedHTTPDownloaderListener.isCancelled());
        throw new ExternalSeedException("request cancelled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        Downloader downloader = null;
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader != null) {
                downloader = this.downloader;
                this.downloader = null;
            }
        }
        if (downloader != null) {
            downloader.destroy(new ExternalSeedException("deactivated"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destoyed(Downloader downloader) {
        ExternalSeedHTTPDownloaderLinear externalSeedHTTPDownloaderLinear = this;
        synchronized (externalSeedHTTPDownloaderLinear) {
            if (this.downloader == downloader) {
                this.downloader = null;
            }
        }
    }

    @Override
    public void download(int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        throw new ExternalSeedException("not supported");
    }

    @Override
    public void downloadSocket(int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) throws ExternalSeedException {
        throw new ExternalSeedException("not supported");
    }

    @Override
    public int getLastResponse() {
        return this.last_response;
    }

    @Override
    public int getLast503RetrySecs() {
        return this.last_response_retry_after_secs;
    }

    protected class Request {
        private long offset;
        private int length;
        private ExternalSeedHTTPDownloaderListener listener;
        private AESemaphore sem = new AESemaphore("ES:wait");
        private volatile ExternalSeedException exception;

        protected Request(long l, int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener) {
            this.offset = l;
            this.length = n;
            this.listener = externalSeedHTTPDownloaderListener;
        }

        protected long getOffset() {
            return this.offset;
        }

        protected int getLength() {
            return this.length;
        }

        protected ExternalSeedHTTPDownloaderListener getListener() {
            return this.listener;
        }

        protected void complete() {
            this.sem.release();
        }

        protected void destroy(ExternalSeedException externalSeedException) {
            this.exception = externalSeedException;
            this.sem.release();
        }

        public boolean waitFor(int n) throws ExternalSeedException {
            if (!this.sem.reserve(n)) {
                return false;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return true;
        }
    }

    protected class Downloader
    implements SEPasswordListener {
        private ExternalSeedHTTPDownloaderListener listener;
        private boolean con_fail_is_perm_fail;
        private volatile boolean destroyed;
        private List<Request> requests = new ArrayList<Request>();
        private RandomAccessFile raf = null;
        private File scratch_file = null;

        protected Downloader(ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener, boolean bl) {
            this.listener = externalSeedHTTPDownloaderListener;
            this.con_fail_is_perm_fail = bl;
            new AEThread2("ES:downloader", true){

                @Override
                public void run() {
                    Downloader.this.download();
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void download() {
            block41: {
                boolean bl = false;
                String string = "";
                try {
                    InputStream inputStream = null;
                    try {
                        SESecurityManager.setThreadPasswordHandler(this);
                        Object object = this;
                        synchronized (object) {
                            block40: {
                                if (!this.destroyed) break block40;
                                return;
                            }
                            this.scratch_file = AETemporaryFileHandler.createTempFile();
                            this.raf = new RandomAccessFile(this.scratch_file, "rw");
                        }
                        object = (HttpURLConnection)ExternalSeedHTTPDownloaderLinear.this.original_url.openConnection();
                        ((URLConnection)object).setRequestProperty("Connection", "Keep-Alive");
                        ((URLConnection)object).setRequestProperty("User-Agent", ExternalSeedHTTPDownloaderLinear.this.user_agent);
                        int n = this.listener.getPermittedTime();
                        if (n > 0) {
                            Java15Utils.setConnectTimeout((URLConnection)object, n);
                        }
                        ((URLConnection)object).connect();
                        n = this.listener.getPermittedTime();
                        if (n < 0) {
                            throw new IOException("Timeout during connect");
                        }
                        Java15Utils.setReadTimeout((URLConnection)object, n);
                        bl = true;
                        int n2 = ((HttpURLConnection)object).getResponseCode();
                        ExternalSeedHTTPDownloaderLinear.this.last_response = n2;
                        ExternalSeedHTTPDownloaderLinear.this.last_response_retry_after_secs = -1;
                        if (n2 == 503) {
                            long l = new Long(((HttpURLConnection)object).getHeaderFieldDate("Retry-After", -1L));
                            if (l <= -1L) {
                                ExternalSeedHTTPDownloaderLinear.this.last_response_retry_after_secs = ((URLConnection)object).getHeaderFieldInt("Retry-After", -1);
                            } else {
                                ExternalSeedHTTPDownloaderLinear.this.last_response_retry_after_secs = (int)((l - System.currentTimeMillis()) / 1000L);
                                if (ExternalSeedHTTPDownloaderLinear.this.last_response_retry_after_secs < 0) {
                                    ExternalSeedHTTPDownloaderLinear.this.last_response_retry_after_secs = -1;
                                }
                            }
                        }
                        inputStream = ((URLConnection)object).getInputStream();
                        if (n2 == 202 || n2 == 200 || n2 == 206) {
                            byte[] byArray = new byte[65536];
                            int n3 = 1;
                            while (!this.destroyed) {
                                int n4;
                                int n5 = this.listener.getPermittedBytes();
                                if (n3 == 0 || n5 < 1) {
                                    n5 = 1;
                                    Thread.sleep(100L);
                                }
                                if ((n4 = inputStream.read(byArray, 0, Math.min(n5, byArray.length))) <= 0) break;
                                Downloader downloader = this;
                                synchronized (downloader) {
                                    try {
                                        this.raf.write(byArray, 0, n4);
                                    }
                                    catch (Throwable throwable) {
                                        string = "Write failed: " + throwable.getMessage();
                                        ExternalSeedException externalSeedException = new ExternalSeedException(string, throwable);
                                        externalSeedException.setPermanentFailure(true);
                                        throw externalSeedException;
                                    }
                                }
                                this.listener.reportBytesRead(n4);
                                n3 = this.checkRequests();
                            }
                            this.checkRequests();
                            break block41;
                        }
                        string = "Connection failed: " + ((HttpURLConnection)object).getResponseMessage();
                        ExternalSeedException externalSeedException = new ExternalSeedException(string);
                        externalSeedException.setPermanentFailure(true);
                        throw externalSeedException;
                    }
                    catch (IOException iOException) {
                        if (this.con_fail_is_perm_fail && !bl) {
                            string = "Connection failed: " + iOException.getMessage();
                            ExternalSeedException externalSeedException = new ExternalSeedException(string);
                            externalSeedException.setPermanentFailure(true);
                            throw externalSeedException;
                        }
                        string = "Connection failed: " + Debug.getNestedExceptionMessage(iOException);
                        if (ExternalSeedHTTPDownloaderLinear.this.last_response_retry_after_secs >= 0) {
                            string = string + ", Retry-After: " + ExternalSeedHTTPDownloaderLinear.this.last_response_retry_after_secs + " seconds";
                        }
                        ExternalSeedException externalSeedException = new ExternalSeedException(string, iOException);
                        if (iOException instanceof FileNotFoundException) {
                            externalSeedException.setPermanentFailure(true);
                        }
                        throw externalSeedException;
                    }
                    catch (ExternalSeedException externalSeedException) {
                        throw externalSeedException;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ExternalSeedException) {
                            throw (ExternalSeedException)throwable;
                        }
                        string = "Connection failed: " + Debug.getNestedExceptionMessage(throwable);
                        throw new ExternalSeedException("Connection failed", throwable);
                    }
                    finally {
                        SESecurityManager.unsetThreadPasswordHandler();
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                catch (ExternalSeedException externalSeedException) {
                    if (!bl && this.con_fail_is_perm_fail) {
                        externalSeedException.setPermanentFailure(true);
                    }
                    this.destroy(externalSeedException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Request addRequest(long l, int n, ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener) throws ExternalSeedException {
            Request request2;
            Downloader downloader = this;
            synchronized (downloader) {
                if (this.destroyed) {
                    throw new ExternalSeedException("downloader destroyed");
                }
                request2 = new Request(l, n, externalSeedHTTPDownloaderListener);
                this.requests.add(request2);
            }
            this.checkRequests();
            return request2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int checkRequests() {
            try {
                Downloader downloader = this;
                synchronized (downloader) {
                    if (this.raf == null) {
                        return this.requests.size();
                    }
                    long l = this.raf.getFilePointer();
                    Iterator<Request> iterator = this.requests.iterator();
                    while (iterator.hasNext()) {
                        Request request2 = iterator.next();
                        long l2 = request2.getOffset() + (long)request2.getLength();
                        if (l < l2) continue;
                        ExternalSeedHTTPDownloaderListener externalSeedHTTPDownloaderListener = request2.getListener();
                        try {
                            int n;
                            this.raf.seek(request2.getOffset());
                            for (int i = 0; i < request2.getLength(); i += n) {
                                byte[] byArray = externalSeedHTTPDownloaderListener.getBuffer();
                                n = externalSeedHTTPDownloaderListener.getBufferLength();
                                this.raf.read(byArray, 0, n);
                                externalSeedHTTPDownloaderListener.done();
                            }
                        }
                        finally {
                            this.raf.seek(l);
                        }
                        request2.complete();
                        iterator.remove();
                    }
                    return this.requests.size();
                }
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
                this.destroy(new ExternalSeedException("read failed", throwable));
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy(ExternalSeedException externalSeedException) {
            Downloader downloader = this;
            synchronized (downloader) {
                if (this.destroyed) {
                    return;
                }
                this.destroyed = true;
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.scratch_file != null) {
                    this.scratch_file.delete();
                }
                for (Request request2 : this.requests) {
                    request2.destroy(externalSeedException);
                }
                this.requests.clear();
            }
            ExternalSeedHTTPDownloaderLinear.this.destoyed(this);
        }

        @Override
        public PasswordAuthentication getAuthentication(String string, URL uRL) {
            return null;
        }

        @Override
        public void setAuthenticationOutcome(String string, URL uRL, boolean bl) {
        }

        @Override
        public void clearPasswords() {
        }
    }
}

