/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.png;

import com.aelitis.azureus.core.util.png.Chunk;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;

public abstract class CRCedChunk
extends Chunk {
    private byte[] type;
    private static long[] crc_table = new long[256];
    private static boolean crc_table_computed = false;

    public CRCedChunk(byte[] byArray) throws InvalidParameterException {
        if (byArray.length != 4) {
            throw new InvalidParameterException("type must be of length 4, provided : " + byArray.length);
        }
        this.type = byArray;
    }

    @Override
    public byte[] getChunkPayload() {
        byte[] byArray = this.getContentPayload();
        int n = byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n + 12);
        byteBuffer.putInt(n);
        byteBuffer.put(this.type);
        byteBuffer.put(byArray);
        byteBuffer.position(4);
        byteBuffer.limit(n + 8);
        long l = CRCedChunk.crc(byteBuffer);
        byteBuffer.limit(n + 12);
        byteBuffer.putInt((int)l);
        byteBuffer.position(0);
        return byteBuffer.array();
    }

    public abstract byte[] getContentPayload();

    private static synchronized void make_crc_table() {
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                l = (l & 1L) != 0L ? 0xEDB88320L ^ l >> 1 & 0xFFFFFFFFFFFFFFFFL : (l >>= 1);
                l &= 0xFFFFFFFFFFFFFFFFL;
            }
            CRCedChunk.crc_table[i] = l;
        }
        crc_table_computed = true;
    }

    private static long update_crc(long l, ByteBuffer byteBuffer) {
        long l2 = l;
        if (!crc_table_computed) {
            CRCedChunk.make_crc_table();
        }
        while (byteBuffer.hasRemaining()) {
            l2 = crc_table[(int)((l2 ^ (long)byteBuffer.get()) & 0xFFL)] ^ l2 >> 8;
        }
        return l2;
    }

    private static long crc(ByteBuffer byteBuffer) {
        return CRCedChunk.update_crc(0xFFFFFFFFL, byteBuffer) ^ 0xFFFFFFFFL;
    }
}

