/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtils {
    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Throwable throwable) {
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface2 = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface2.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress = enumeration2.nextElement();
                        if (inetAddress.isLoopbackAddress() || inetAddress instanceof Inet6Address) continue;
                        return inetAddress;
                    }
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return InetAddress.getByName("127.0.0.1");
        }
    }
}

