/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.stats;

import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class AzureusCoreStats {
    public static final int AVERAGE_PERIOD = 1000;
    public static final String ST_ALL = ".*";
    public static final String ST_DISK = "disk.*";
    public static final String ST_DISK_READ_QUEUE_LENGTH = "disk.read.queue.length";
    public static final String ST_DISK_READ_QUEUE_BYTES = "disk.read.queue.bytes";
    public static final String ST_DISK_READ_REQUEST_COUNT = "disk.read.request.count";
    public static final String ST_DISK_READ_REQUEST_SINGLE = "disk.read.request.single";
    public static final String ST_DISK_READ_REQUEST_MULTIPLE = "disk.read.request.multiple";
    public static final String ST_DISK_READ_REQUEST_BLOCKS = "disk.read.request.blocks";
    public static final String ST_DISK_READ_BYTES_TOTAL = "disk.read.bytes.total";
    public static final String ST_DISK_READ_BYTES_SINGLE = "disk.read.bytes.single";
    public static final String ST_DISK_READ_BYTES_MULTIPLE = "disk.read.bytes.multiple";
    public static final String ST_DISK_READ_IO_TIME = "disk.read.io.time";
    public static final String ST_DISK_READ_IO_COUNT = "disk.read.io.count";
    public static final String ST_DISK_WRITE_QUEUE_LENGTH = "disk.write.queue.length";
    public static final String ST_DISK_WRITE_QUEUE_BYTES = "disk.write.queue.bytes";
    public static final String ST_DISK_WRITE_REQUEST_COUNT = "disk.write.request.count";
    public static final String ST_DISK_WRITE_REQUEST_BLOCKS = "disk.write.request.blocks";
    public static final String ST_DISK_WRITE_BYTES_TOTAL = "disk.write.bytes.total";
    public static final String ST_DISK_WRITE_BYTES_SINGLE = "disk.write.bytes.single";
    public static final String ST_DISK_WRITE_BYTES_MULTIPLE = "disk.write.bytes.multiple";
    public static final String ST_DISK_WRITE_IO_TIME = "disk.write.io.time";
    public static final String ST_DISK_WRITE_IO_COUNT = "disk.write.io.count";
    public static final String ST_NET_WRITE_CONTROL_WAIT_COUNT = "net.write.control.wait.count";
    public static final String ST_NET_WRITE_CONTROL_NP_COUNT = "net.write.control.np.count";
    public static final String ST_NET_WRITE_CONTROL_P_COUNT = "net.write.control.p.count";
    public static final String ST_NET_WRITE_CONTROL_ENTITY_COUNT = "net.write.control.entity.count";
    public static final String ST_NET_WRITE_CONTROL_CON_COUNT = "net.write.control.con.count";
    public static final String ST_NET_WRITE_CONTROL_READY_CON_COUNT = "net.write.control.ready.con.count";
    public static final String ST_NET_WRITE_CONTROL_READY_BYTE_COUNT = "net.write.control.ready.byte.count";
    public static final String ST_NET_READ_CONTROL_LOOP_COUNT = "net.read.control.loop.count";
    public static final String ST_NET_READ_CONTROL_NP_COUNT = "net.read.control.np.count";
    public static final String ST_NET_READ_CONTROL_P_COUNT = "net.read.control.p.count";
    public static final String ST_NET_READ_CONTROL_WAIT_COUNT = "net.read.control.wait.count";
    public static final String ST_NET_READ_CONTROL_ENTITY_COUNT = "net.read.control.entity.count";
    public static final String ST_NET_READ_CONTROL_CON_COUNT = "net.read.control.con.count";
    public static final String ST_NET_READ_CONTROL_READY_CON_COUNT = "net.read.control.ready.con.count";
    public static final String ST_NET_TCP_OUT_CONNECT_QUEUE_LENGTH = "net.tcp.outbound.connect.queue.length";
    public static final String ST_NET_TCP_OUT_PENDING_QUEUE_LENGTH = "net.tcp.outbound.pending.queue.length";
    public static final String ST_NET_TCP_OUT_CANCEL_QUEUE_LENGTH = "net.tcp.outbound.cancel.queue.length";
    public static final String ST_NET_TCP_OUT_CLOSE_QUEUE_LENGTH = "net.tcp.outbound.close.queue.length";
    public static final String ST_NET_TCP_SELECT_WRITE_COUNT = "net.tcp.select.write.count";
    public static final String ST_NET_TCP_SELECT_READ_COUNT = "net.tcp.select.read.count";
    public static final String ST_NET_HTTP_IN_REQUEST_COUNT = "net.http.inbound.request.count";
    public static final String ST_NET_HTTP_IN_REQUEST_OK_COUNT = "net.http.inbound.request.ok.count";
    public static final String ST_NET_HTTP_IN_REQUEST_INVALID_COUNT = "net.http.inbound.request.invalid.count";
    public static final String ST_NET_HTTP_IN_REQUEST_WEBSEED_COUNT = "net.http.inbound.request.webseed.count";
    public static final String ST_NET_HTTP_IN_REQUEST_GETRIGHT_COUNT = "net.http.inbound.request.getright.count";
    public static final String ST_PEER_CONTROL_SCHEDULE_COUNT = "peer.control.schedule.count";
    public static final String ST_PEER_CONTROL_LOOP_COUNT = "peer.control.loop.count";
    public static final String ST_PEER_CONTROL_YIELD_COUNT = "peer.control.yield.count";
    public static final String ST_PEER_CONTROL_WAIT_COUNT = "peer.control.wait.count";
    public static final String ST_PEER_CONTROL_WAIT_TIME = "peer.control.wait.time";
    public static final String ST_PEER_MANAGER_COUNT = "peer.manager.count";
    public static final String ST_PEER_MANAGER_PEER_COUNT = "peer.manager.peer.count";
    public static final String ST_PEER_MANAGER_PEER_SNUBBED_COUNT = "peer.manager.peer.snubbed.count";
    public static final String ST_PEER_MANAGER_PEER_STALLED_DISK_COUNT = "peer.manager.peer.stalled.disk.count";
    public static final String ST_TRACKER_READ_BYTES = "tracker.read.bytes.total";
    public static final String ST_TRACKER_WRITE_BYTES = "tracker.write.bytes.total";
    public static final String ST_TRACKER_ANNOUNCE_COUNT = "tracker.announce.count";
    public static final String ST_TRACKER_ANNOUNCE_TIME = "tracker.announce.time";
    public static final String ST_TRACKER_SCRAPE_COUNT = "tracker.scrape.count";
    public static final String ST_TRACKER_SCRAPE_TIME = "tracker.scrape.time";
    public static final String ST_XFER_UPLOADED_PROTOCOL_BYTES = "xfer.upload.protocol.bytes.total";
    public static final String ST_XFER_UPLOADED_DATA_BYTES = "xfer.upload.data.bytes.total";
    public static final String ST_XFER_DOWNLOADED_PROTOCOL_BYTES = "xfer.download.protocol.bytes.total";
    public static final String ST_XFER_DOWNLOADED_DATA_BYTES = "xfer.download.data.bytes.total";
    public static final String POINT = "Point";
    public static final String CUMULATIVE = "Cumulative";
    private static final List stats_names = new ArrayList();
    private static final Map stats_types = new HashMap();
    private static final String[][] _ST_ALL = new String[][]{{"disk.read.queue.length", "Point"}, {"disk.read.queue.bytes", "Point"}, {"disk.read.request.count", "Cumulative"}, {"disk.read.request.single", "Cumulative"}, {"disk.read.request.multiple", "Cumulative"}, {"disk.read.request.blocks", "Cumulative"}, {"disk.read.bytes.total", "Cumulative"}, {"disk.read.bytes.single", "Cumulative"}, {"disk.read.bytes.multiple", "Cumulative"}, {"disk.read.io.time", "Cumulative"}, {"disk.read.io.count", "Cumulative"}, {"disk.write.queue.length", "Point"}, {"disk.write.queue.bytes", "Point"}, {"disk.write.request.count", "Cumulative"}, {"disk.write.request.blocks", "Cumulative"}, {"disk.write.bytes.total", "Cumulative"}, {"disk.write.bytes.single", "Cumulative"}, {"disk.write.bytes.multiple", "Cumulative"}, {"disk.write.io.time", "Cumulative"}, {"disk.write.io.count", "Cumulative"}, {"net.write.control.wait.count", "Cumulative"}, {"net.write.control.p.count", "Cumulative"}, {"net.write.control.np.count", "Cumulative"}, {"net.write.control.entity.count", "Point"}, {"net.write.control.con.count", "Point"}, {"net.write.control.ready.con.count", "Point"}, {"net.write.control.ready.byte.count", "Point"}, {"net.read.control.loop.count", "Cumulative"}, {"net.read.control.p.count", "Cumulative"}, {"net.read.control.np.count", "Cumulative"}, {"net.read.control.wait.count", "Cumulative"}, {"net.read.control.entity.count", "Point"}, {"net.read.control.con.count", "Point"}, {"net.read.control.ready.con.count", "Point"}, {"net.tcp.outbound.connect.queue.length", "Point"}, {"net.tcp.outbound.pending.queue.length", "Point"}, {"net.tcp.outbound.cancel.queue.length", "Point"}, {"net.tcp.outbound.close.queue.length", "Point"}, {"net.tcp.select.write.count", "Cumulative"}, {"net.tcp.select.read.count", "Cumulative"}, {"net.http.inbound.request.count", "Cumulative"}, {"net.http.inbound.request.ok.count", "Cumulative"}, {"net.http.inbound.request.invalid.count", "Cumulative"}, {"net.http.inbound.request.webseed.count", "Cumulative"}, {"net.http.inbound.request.getright.count", "Cumulative"}, {"peer.control.schedule.count", "Cumulative"}, {"peer.control.loop.count", "Cumulative"}, {"peer.control.yield.count", "Cumulative"}, {"peer.control.wait.count", "Cumulative"}, {"peer.control.wait.time", "Cumulative"}, {"peer.manager.count", "Point"}, {"peer.manager.peer.count", "Point"}, {"peer.manager.peer.snubbed.count", "Point"}, {"peer.manager.peer.stalled.disk.count", "Point"}, {"tracker.read.bytes.total", "Cumulative"}, {"tracker.write.bytes.total", "Cumulative"}, {"tracker.announce.count", "Cumulative"}, {"tracker.announce.time", "Cumulative"}, {"tracker.scrape.count", "Cumulative"}, {"tracker.scrape.time", "Cumulative"}, {"xfer.upload.protocol.bytes.total", "Cumulative"}, {"xfer.upload.data.bytes.total", "Cumulative"}, {"xfer.download.protocol.bytes.total", "Cumulative"}, {"xfer.download.data.bytes.total", "Cumulative"}};
    private static final CopyOnWriteList providers;
    private static Map averages;
    private static boolean enable_averages;
    private static Timer average_timer;
    private static CopyOnWriteList provider_listeners;
    private static CopyOnWriteList derived_generators;

    public static void addStatsDefinitions(String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            stats_names.add(string);
            stats_types.put(string, stringArray[i][1]);
        }
    }

    public static Map getStats(Set set) {
        Iterator iterator;
        Object object;
        Object object2;
        Object object32;
        Object object4;
        Object object52;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object52 : set) {
            if (((String)object52).endsWith(".average")) {
                object52 = ((String)object52).substring(0, ((String)object52).length() - 8);
            }
            if (!((String)object52).endsWith("*")) {
                object52 = (String)object52 + ST_ALL;
            }
            object4 = Pattern.compile((String)object52);
            for (int i = 0; i < stats_names.size(); ++i) {
                object32 = (String)stats_names.get(i);
                if (!((Pattern)object4).matcher((CharSequence)object32).matches()) continue;
                hashSet.add(object32);
            }
            for (Object object32 : providers) {
                object2 = (Set)object32[0];
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    if (!((Pattern)object4).matcher(string).matches()) continue;
                    hashSet.add(string);
                }
            }
            object32 = derived_generators.iterator();
            while (object32.hasNext()) {
                try {
                    ((derivedStatsGenerator)object32.next()).match((Pattern)object4, hashSet);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        object52 = AzureusCoreStats.getStatsSupport(hashSet);
        object4 = averages;
        if (object4 != null) {
            Iterator<Object> iterator2 = object52.keySet().iterator();
            iterator = new HashMap();
            while (iterator2.hasNext()) {
                object32 = (String)iterator2.next();
                object2 = (Object[])object4.get(object32);
                if (object2 == null) continue;
                object = (Average)object2[0];
                iterator.put((String)object32 + ".average", new Long((long)object.getAverage()));
            }
            object52.putAll(iterator);
        }
        iterator = derived_generators.iterator();
        while (iterator.hasNext()) {
            try {
                ((derivedStatsGenerator)iterator.next()).generate((Map)object52);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return object52;
    }

    protected static Map getStatsSupport(Set set) {
        HashMap hashMap = new HashMap();
        for (Object[] objectArray : providers) {
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            Set set2 = set == null ? (Set)objectArray[0] : set;
            try {
                ((AzureusCoreStatsProvider)objectArray[1]).updateStats(set2, hashMap2);
                for (Map.Entry entry : hashMap2.entrySet()) {
                    String string = (String)entry.getKey();
                    Object v = entry.getValue();
                    if (v instanceof Long) {
                        Long l = (Long)hashMap.get(string);
                        if (l == null) {
                            hashMap.put(string, v);
                            continue;
                        }
                        long l2 = (Long)v;
                        hashMap.put(string, new Long(l2 + l));
                        continue;
                    }
                    hashMap.put(string, v);
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProvider(Set set, AzureusCoreStatsProvider azureusCoreStatsProvider) {
        CopyOnWriteList copyOnWriteList = providers;
        synchronized (copyOnWriteList) {
            providers.add(new Object[]{set, azureusCoreStatsProvider});
        }
        AzureusCoreStats.fireProvidersChangeListeners();
    }

    public static void addProvidersChangeListener(providersChangeListener providersChangeListener2) {
        provider_listeners.add(providersChangeListener2);
    }

    protected static void fireProvidersChangeListeners() {
        Iterator iterator = provider_listeners.iterator();
        while (iterator.hasNext()) {
            try {
                ((providersChangeListener)iterator.next()).providersChanged();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public static void registerDerivedStatsGenerator(derivedStatsGenerator derivedStatsGenerator2) {
        derived_generators.add(derivedStatsGenerator2);
    }

    public static synchronized void setEnableAverages(boolean bl) {
        if (bl == enable_averages) {
            return;
        }
        enable_averages = bl;
        if (bl) {
            if (average_timer == null) {
                average_timer = new Timer("AzureusCoreStats:average");
                averages = new HashMap();
                average_timer.addPeriodicEvent(1000L, new TimerEventPerformer(){
                    private Map ave = AzureusCoreStats.access$000();

                    @Override
                    public void perform(TimerEvent timerEvent2) {
                        Map map = AzureusCoreStats.getStatsSupport(null);
                        Iterator iterator = map.entrySet().iterator();
                        boolean bl = false;
                        while (iterator.hasNext()) {
                            boolean bl2;
                            long l;
                            Average average;
                            Map.Entry entry = iterator.next();
                            String string = (String)entry.getKey();
                            Object v = entry.getValue();
                            if (!(v instanceof Long)) continue;
                            Object[] objectArray = (Object[])this.ave.get(string);
                            if (objectArray == null) {
                                average = AverageFactory.MovingImmediateAverage(10);
                                l = 0L;
                                objectArray = new Object[]{average, v};
                                this.ave.put(string, objectArray);
                                bl2 = true;
                                bl = true;
                            } else {
                                average = (Average)objectArray[0];
                                l = (Long)objectArray[1];
                                bl2 = false;
                            }
                            if (stats_types.get(string) == AzureusCoreStats.CUMULATIVE) {
                                if (!bl2) {
                                    average.update((Long)v - l);
                                }
                            } else {
                                average.update(((Long)v).longValue());
                            }
                            objectArray[1] = v;
                        }
                        if (bl) {
                            AzureusCoreStats.fireProvidersChangeListeners();
                        }
                    }
                });
            }
        } else if (average_timer != null) {
            average_timer.destroy();
            average_timer = null;
            averages = null;
        }
    }

    public static boolean getEnableAverages() {
        return enable_averages;
    }

    static /* synthetic */ Map access$000() {
        return averages;
    }

    static {
        AzureusCoreStats.addStatsDefinitions(_ST_ALL);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generate(IndentWriter indentWriter) {
                indentWriter.println("Stats");
                boolean bl = !AzureusCoreStats.getEnableAverages();
                try {
                    indentWriter.indent();
                    if (bl) {
                        AzureusCoreStats.setEnableAverages(true);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add(AzureusCoreStats.ST_ALL);
                    Map map = AzureusCoreStats.getStats(hashSet);
                    Iterator iterator = map.entrySet().iterator();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        arrayList.add(entry.getKey() + " -> " + entry.getValue());
                    }
                    Collections.sort(arrayList);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        indentWriter.println((String)arrayList.get(i));
                    }
                }
                finally {
                    if (bl) {
                        AzureusCoreStats.setEnableAverages(false);
                    }
                    indentWriter.exdent();
                }
            }
        });
        providers = new CopyOnWriteList();
        averages = new HashMap();
        provider_listeners = new CopyOnWriteList();
        derived_generators = new CopyOnWriteList();
    }

    public static interface derivedStatsGenerator {
        public void match(Pattern var1, Set var2);

        public void generate(Map var1);
    }

    public static interface providersChangeListener {
        public void providersChanged();
    }
}

