/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.LimitControl;
import com.aelitis.azureus.core.speedmanager.impl.v2.LimitControlDropUploadFirst;
import com.aelitis.azureus.core.speedmanager.impl.v2.PSMonitorListener;
import com.aelitis.azureus.core.speedmanager.impl.v2.PingSpaceMapper;
import com.aelitis.azureus.core.speedmanager.impl.v2.PingSpaceMon;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMConst;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMInstance;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMSearchLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMUpdate;
import com.aelitis.azureus.core.speedmanager.impl.v2.SaturatedMode;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitConfidence;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitListener;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.TransferMode;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.RealTimeInfo;
import org.gudy.azureus2.core3.util.SystemTime;

public class SpeedLimitMonitor
implements PSMonitorListener {
    private int uploadLimitMax = 30720;
    private int uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
    private int downloadLimitMax = 61440;
    private int downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
    private TransferMode transferMode = new TransferMode();
    private SaturatedMode uploadBandwidthStatus = SaturatedMode.NONE;
    private SaturatedMode downloadBandwidthStatus = SaturatedMode.NONE;
    private SaturatedMode uploadLimitSettingStatus = SaturatedMode.AT_LIMIT;
    private SaturatedMode downloadLimitSettingStatus = SaturatedMode.AT_LIMIT;
    private SpeedLimitConfidence uploadLimitConf = SpeedLimitConfidence.NONE;
    private SpeedLimitConfidence downloadLimitConf = SpeedLimitConfidence.NONE;
    private long clLastIncreaseTime = -1L;
    private long clFirstBadPingTime = -1L;
    private boolean currTestDone;
    private boolean beginLimitTest;
    private int highestUploadRate = 0;
    private int highestDownloadRate = 0;
    private int preTestUploadCapacity = 5042;
    private int preTestUploadLimit = 5142;
    private int preTestDownloadCapacity = 5042;
    private int preTestDownloadLimit = 5142;
    public static final String UPLOAD_CONF_LIMIT_SETTING = "SpeedLimitMonitor.setting.upload.limit.conf";
    public static final String DOWNLOAD_CONF_LIMIT_SETTING = "SpeedLimitMonitor.setting.download.limit.conf";
    public static final String UPLOAD_CHOKE_PING_COUNT = "SpeedLimitMonitor.setting.choke.ping.count";
    private static final long CONF_LIMIT_TEST_LENGTH = 30000L;
    private boolean isUploadMaxPinned = true;
    private boolean isDownloadMaxPinned = true;
    private long uploadAtLimitStartTime = SystemTime.getCurrentTime();
    private long downloadAtLimitStartTime = SystemTime.getCurrentTime();
    private int uploadChokePingCount = 1;
    private int uploadPinCounter = 0;
    private static final long TIME_AT_LIMIT_BEFORE_UNPINNING = 30000L;
    public static final String USED_UPLOAD_CAPACITY_DOWNLOAD_MODE = "SpeedLimitMonitor.setting.upload.used.download.mode";
    public static final String USED_UPLOAD_CAPACITY_SEEDING_MODE = "SpeedLimitMonitor.setting.upload.used.seeding.mode";
    private float percentUploadCapacityDownloadMode = 0.6f;
    PingSpaceMapper pingMapOfDownloadMode;
    PingSpaceMapper pingMapOfSeedingMode;
    boolean useVariancePingMap = false;
    SpeedManagerPingMapper transientPingMap;
    PingSpaceMon longTermMonitor = new PingSpaceMon();
    LimitControl slider = new LimitControlDropUploadFirst();
    SpeedLimitListener persistentMapListener;

    public SpeedLimitMonitor(SpeedManager speedManager) {
        this.longTermMonitor.addListener(this);
        this.persistentMapListener = new SpeedLimitListener(this);
        speedManager.addListener(this.persistentMapListener);
    }

    public void updateSettingsFromCOConfigManager() {
        this.percentUploadCapacityDownloadMode = (float)COConfigurationManager.getIntParameter(USED_UPLOAD_CAPACITY_DOWNLOAD_MODE, 60) / 100.0f;
        this.slider.updateSeedSettings(this.percentUploadCapacityDownloadMode);
    }

    public void updateFromCOConfigManager() {
        this.uploadLimitMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit");
        this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
        this.downloadLimitMax = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit");
        this.downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
        this.uploadLimitConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter(UPLOAD_CONF_LIMIT_SETTING));
        this.downloadLimitConf = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter(DOWNLOAD_CONF_LIMIT_SETTING));
        this.percentUploadCapacityDownloadMode = (float)COConfigurationManager.getIntParameter(USED_UPLOAD_CAPACITY_DOWNLOAD_MODE, 60) / 100.0f;
        this.uploadChokePingCount = Math.min(COConfigurationManager.getIntParameter(UPLOAD_CHOKE_PING_COUNT), 30);
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        this.slider.updateSeedSettings(this.percentUploadCapacityDownloadMode);
        if (this.isSettingDownloadUnlimited()) {
            this.slider.setDownloadUnlimitedMode(true);
        }
    }

    public void readFromPersistentMap() {
        SpeedManager speedManager = AzureusCoreFactory.getSingleton().getSpeedManager();
        SpeedManagerLimitEstimate speedManagerLimitEstimate = SMConst.filterEstimate(speedManager.getEstimatedUploadCapacityBytesPerSec(), 30720);
        int n = speedManagerLimitEstimate.getBytesPerSec();
        this.uploadLimitMax = n < 30720 ? 30720 : n;
        this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
        SpeedManagerLimitEstimate speedManagerLimitEstimate2 = SMConst.filterEstimate(speedManager.getEstimatedDownloadCapacityBytesPerSec(), 61440);
        int n2 = speedManagerLimitEstimate2.getBytesPerSec();
        if (this.isSettingDownloadUnlimited()) {
            this.slider.setDownloadUnlimitedMode(true);
        } else {
            this.slider.setDownloadUnlimitedMode(false);
        }
        this.downloadLimitMax = n2 < 61440 ? 61440 : n2;
        this.downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
        this.uploadLimitConf = SpeedLimitConfidence.convertType(speedManagerLimitEstimate.getEstimateType());
        this.downloadLimitConf = SpeedLimitConfidence.convertType(speedManagerLimitEstimate2.getEstimateType());
        this.percentUploadCapacityDownloadMode = (float)COConfigurationManager.getIntParameter(USED_UPLOAD_CAPACITY_DOWNLOAD_MODE, 60) / 100.0f;
        this.saveToCOConfiguration();
    }

    public void saveToCOConfiguration() {
        COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
        COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
        COConfigurationManager.setParameter(UPLOAD_CONF_LIMIT_SETTING, this.uploadLimitConf.getString());
        COConfigurationManager.setParameter(DOWNLOAD_CONF_LIMIT_SETTING, this.downloadLimitConf.getString());
        COConfigurationManager.setParameter(UPLOAD_CHOKE_PING_COUNT, this.uploadChokePingCount);
    }

    private void logPMData(int n, SpeedLimitConfidence speedLimitConfidence, int n2, float f, String string) {
    }

    public void logPMDataEx() {
        int n = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit");
        int n2 = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit");
        SpeedManager speedManager = AzureusCoreFactory.getSingleton().getSpeedManager();
        SpeedManagerLimitEstimate speedManagerLimitEstimate = speedManager.getEstimatedDownloadCapacityBytesPerSec();
        int n3 = speedManagerLimitEstimate.getBytesPerSec();
        float f = speedManagerLimitEstimate.getEstimateType();
        SpeedManagerLimitEstimate speedManagerLimitEstimate2 = speedManager.getEstimatedUploadCapacityBytesPerSec();
        int n4 = speedManagerLimitEstimate2.getBytesPerSec();
        float f2 = speedManagerLimitEstimate2.getEstimateType();
        SpeedLimitConfidence speedLimitConfidence = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter(UPLOAD_CONF_LIMIT_SETTING));
        SpeedLimitConfidence speedLimitConfidence2 = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter(DOWNLOAD_CONF_LIMIT_SETTING));
        this.logPMData(n, speedLimitConfidence, n4, f2, "check-upload");
        this.logPMData(n2, speedLimitConfidence2, n3, f, "check-download");
    }

    private boolean isSettingDownloadUnlimited() {
        SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter = SMInstance.getInstance().getAdapter();
        SpeedManager speedManager = speedManagerAlgorithmProviderAdapter.getSpeedManager();
        SpeedManagerLimitEstimate speedManagerLimitEstimate = speedManager.getEstimatedDownloadCapacityBytesPerSec();
        int n = speedManagerLimitEstimate.getBytesPerSec();
        float f = speedManagerLimitEstimate.getEstimateType();
        if (n == 0 && f == 1.0f) {
            return true;
        }
        return n == 0 && f == -0.1f;
    }

    public void setDownloadBandwidthMode(int n, int n2) {
        this.downloadBandwidthStatus = SaturatedMode.getSaturatedMode(n, n2);
    }

    public void setUploadBandwidthMode(int n, int n2) {
        this.uploadBandwidthStatus = SaturatedMode.getSaturatedMode(n, n2);
    }

    public void setDownloadLimitSettingMode(int n) {
        this.downloadLimitSettingStatus = SaturatedMode.getSaturatedMode(n, this.downloadLimitMax);
    }

    public void setUploadLimitSettingMode(int n) {
        this.uploadLimitSettingStatus = !this.transferMode.isDownloadMode() ? SaturatedMode.getSaturatedMode(n, this.uploadLimitMax) : SaturatedMode.getSaturatedMode(n, this.uploadLimitMax);
    }

    public int getUploadMaxLimit() {
        return this.uploadLimitMax;
    }

    public int getDownloadMaxLimit() {
        return this.downloadLimitMax;
    }

    public int getUploadMinLimit() {
        return this.uploadLimitMin;
    }

    public int getDownloadMinLimit() {
        return this.downloadLimitMin;
    }

    public String getUploadConfidence() {
        return this.uploadLimitConf.getString();
    }

    public String getDownloadConfidence() {
        return this.downloadLimitConf.getString();
    }

    public SaturatedMode getDownloadBandwidthMode() {
        return this.downloadBandwidthStatus;
    }

    public SaturatedMode getUploadBandwidthMode() {
        return this.uploadBandwidthStatus;
    }

    public SaturatedMode getDownloadLimitSettingMode() {
        return this.downloadLimitSettingStatus;
    }

    public SaturatedMode getUploadLimitSettingMode() {
        return this.uploadLimitSettingStatus;
    }

    public void updateTransferMode() {
        this.transferMode.updateStatus(this.downloadBandwidthStatus);
    }

    public String getTransferModeAsString() {
        return this.transferMode.getString();
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    public boolean bandwidthUsageLow() {
        return this.uploadBandwidthStatus.compareTo(SaturatedMode.LOW) <= 0 && this.downloadBandwidthStatus.compareTo(SaturatedMode.LOW) <= 0;
    }

    public boolean bandwidthUsageMedium() {
        return this.uploadBandwidthStatus.compareTo(SaturatedMode.MED) <= 0 && this.downloadBandwidthStatus.compareTo(SaturatedMode.MED) <= 0;
    }

    public boolean bandwidthUsageAtLimit() {
        return this.uploadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0 && this.downloadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0;
    }

    public boolean isUploadBandwidthUsageHigh() {
        return this.uploadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0 || this.uploadBandwidthStatus.compareTo(SaturatedMode.HIGH) == 0;
    }

    public boolean isEitherLimitUnpinned() {
        return !this.isUploadMaxPinned || !this.isDownloadMaxPinned;
    }

    public SMUpdate modifyLimits(float f, float f2, int n, int n2) {
        if (this.isStartLimitTestFlagSet()) {
            SpeedManagerLogger.trace("modifyLimits - startLimitTesting.");
            SMUpdate sMUpdate = this.startLimitTesting(n, n2);
            return this.checkActiveProgressiveDownloadLimit(sMUpdate);
        }
        if (this.isEitherLimitUnpinned()) {
            SpeedManagerLogger.trace("modifyLimits - calculateNewUnpinnedLimits");
            SMUpdate sMUpdate = this.calculateNewUnpinnedLimits(f);
            return this.checkActiveProgressiveDownloadLimit(sMUpdate);
        }
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        this.slider.updateStatus(n, this.uploadBandwidthStatus, n2, this.downloadBandwidthStatus, this.transferMode);
        SMUpdate sMUpdate = this.slider.adjust(f * f2);
        return this.checkActiveProgressiveDownloadLimit(sMUpdate);
    }

    private SMUpdate checkActiveProgressiveDownloadLimit(SMUpdate sMUpdate) {
        long l = RealTimeInfo.getProgressiveActiveBytesPerSec();
        if (l == 0L) {
            return sMUpdate;
        }
        if (l * 2L > (long)sMUpdate.newDownloadLimit && sMUpdate.newDownloadLimit != 0) {
            this.log("Active Progressive download in progress. Overriding limit. curr=" + sMUpdate.newDownloadLimit + " progDownloadLimit=" + l * 2L);
            sMUpdate.newDownloadLimit = (int)l * 2;
        }
        return sMUpdate;
    }

    private void logPinningInfo() {
        StringBuffer stringBuffer = new StringBuffer("pin: ");
        if (this.isUploadMaxPinned) {
            stringBuffer.append("ul-pinned:");
        } else {
            stringBuffer.append("ul-unpinned:");
        }
        if (this.isDownloadMaxPinned) {
            stringBuffer.append("dl-pinned:");
        } else {
            stringBuffer.append("dl-unpinned:");
        }
        long l = SystemTime.getCurrentTime();
        long l2 = l - this.uploadAtLimitStartTime;
        long l3 = l - this.downloadAtLimitStartTime;
        stringBuffer.append(l2).append(":").append(l3);
        this.log(stringBuffer.toString());
    }

    public SMUpdate calculateNewUnpinnedLimits(float f) {
        if (f < 0.0f) {
            this.isUploadMaxPinned = true;
            this.isDownloadMaxPinned = true;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.uploadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0 && this.uploadLimitSettingStatus.compareTo(SaturatedMode.AT_LIMIT) == 0) {
            bl = true;
        }
        if (this.downloadBandwidthStatus.compareTo(SaturatedMode.AT_LIMIT) == 0 && this.downloadLimitSettingStatus.compareTo(SaturatedMode.AT_LIMIT) == 0) {
            bl2 = true;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl && !this.transferMode.isDownloadMode()) {
            ++this.uploadPinCounter;
            if ((double)this.uploadPinCounter % Math.ceil(Math.sqrt(this.uploadChokePingCount)) == 0.0) {
                this.uploadLimitMax += this.calculateUnpinnedStepSize(this.uploadLimitMax);
                bl3 = true;
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
                COConfigurationManager.setParameter(UPLOAD_CHOKE_PING_COUNT, this.uploadChokePingCount);
            }
        }
        if (bl2 && !this.slider.isDownloadUnlimitedMode()) {
            this.downloadLimitMax += this.calculateUnpinnedStepSize(this.downloadLimitMax);
            bl4 = true;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
        }
        if (this.uploadLimitMax > this.downloadLimitMax) {
            this.downloadLimitMax = this.uploadLimitMax;
            bl4 = true;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
        }
        this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
        this.downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
        if (this.slider.isDownloadUnlimitedMode()) {
            SpeedManagerLogger.trace("upload unpinned while download is unlimited.");
            return new SMUpdate(this.uploadLimitMax, bl3, 0, false);
        }
        return new SMUpdate(this.uploadLimitMax, bl3, this.downloadLimitMax, bl4);
    }

    private int calculateUnpinnedStepSize(int n) {
        if (n < 102400) {
            return 1024;
        }
        if (n < 409600) {
            return 5120;
        }
        if (n >= 409600) {
            return 10240;
        }
        return 1024;
    }

    public void checkForUnpinningCondition() {
        long l = SystemTime.getCurrentTime();
        this.slider.setDownloadUnlimitedMode(this.isSettingDownloadUnlimited());
        if (!this.uploadBandwidthStatus.equals(SaturatedMode.AT_LIMIT) || !this.uploadLimitSettingStatus.equals(SaturatedMode.AT_LIMIT)) {
            this.uploadAtLimitStartTime = l;
        } else if (this.uploadAtLimitStartTime + 30000L * (long)this.uploadChokePingCount < l) {
            if (this.isUploadConfidenceLow()) {
                if (!this.transferMode.isDownloadMode()) {
                    this.isUploadMaxPinned = false;
                }
            } else if (!this.isUploadConfidenceAbsolute()) {
                this.isUploadMaxPinned = false;
                SpeedManagerLogger.trace("unpinning the upload max limit!! #choke-pings=" + this.uploadChokePingCount + ", pin-counter=" + this.uploadPinCounter);
            }
        }
        if (!this.downloadBandwidthStatus.equals(SaturatedMode.AT_LIMIT) || !this.downloadLimitSettingStatus.equals(SaturatedMode.AT_LIMIT)) {
            this.downloadAtLimitStartTime = l;
        } else if (this.downloadAtLimitStartTime + 30000L < l) {
            if (this.isDownloadConfidenceLow()) {
                if (this.transferMode.isDownloadMode()) {
                    this.triggerLimitTestingFlag();
                }
            } else if (!this.isDownloadConfidenceAbsolute()) {
                this.isDownloadMaxPinned = false;
                SpeedManagerLogger.trace("unpinning the download max limit!!");
            }
        }
        this.logPinningInfo();
    }

    public void notifyOfDownSignal() {
        String string;
        if (!this.isUploadMaxPinned) {
            ++this.uploadChokePingCount;
            string = "pinning the upload max limit, due to downtick signal. #downtick=" + this.uploadChokePingCount;
            SpeedManagerLogger.trace(string);
            SMSearchLogger.log(string);
        }
        if (!this.isDownloadMaxPinned) {
            string = "pinning the download max limit, due to downtick signal.";
            SpeedManagerLogger.trace(string);
            SMSearchLogger.log(string);
        }
        this.resetPinSearch();
    }

    void resetPinSearch() {
        long l;
        this.uploadAtLimitStartTime = l = SystemTime.getCurrentTime();
        this.downloadAtLimitStartTime = l;
        this.isUploadMaxPinned = true;
        this.isDownloadMaxPinned = true;
    }

    void resetPinSearch(SpeedManagerLimitEstimate speedManagerLimitEstimate) {
        float f = speedManagerLimitEstimate.getEstimateType();
        if (f >= 0.5f) {
            ++this.uploadChokePingCount;
        }
        this.resetPinSearch();
    }

    public boolean isConfTestingLimits() {
        return this.transferMode.isConfTestingLimits();
    }

    public boolean isDownloadConfidenceLow() {
        return this.downloadLimitConf.compareTo(SpeedLimitConfidence.MED) < 0;
    }

    public boolean isUploadConfidenceLow() {
        return this.uploadLimitConf.compareTo(SpeedLimitConfidence.MED) < 0;
    }

    public boolean isDownloadConfidenceAbsolute() {
        return this.downloadLimitConf.compareTo(SpeedLimitConfidence.ABSOLUTE) == 0;
    }

    public boolean isUploadConfidenceAbsolute() {
        return this.uploadLimitConf.compareTo(SpeedLimitConfidence.ABSOLUTE) == 0;
    }

    public synchronized void updateLimitTestingData(int n, int n2) {
        long l;
        if (n > this.highestDownloadRate) {
            this.highestDownloadRate = n;
        }
        if (n2 > this.highestUploadRate) {
            this.highestUploadRate = n2;
        }
        if ((l = SystemTime.getCurrentTime()) > this.clLastIncreaseTime + 30000L) {
            this.currTestDone = true;
        }
        if (this.clFirstBadPingTime != -1L && l > this.clFirstBadPingTime + 30000L) {
            this.currTestDone = true;
        }
    }

    public void updateLimitTestingPing(int n) {
        if (n > 500) {
            this.updateLimitTestingPing(-1.0f);
        }
    }

    public void updateLimitTestingPing(float f) {
        if (f < -0.3f) {
            this.clFirstBadPingTime = SystemTime.getCurrentTime();
        }
    }

    public SMUpdate startLimitTesting(int n, int n2) {
        SMUpdate sMUpdate;
        this.clLastIncreaseTime = SystemTime.getCurrentTime();
        this.clFirstBadPingTime = -1L;
        this.highestUploadRate = 0;
        this.highestDownloadRate = 0;
        this.currTestDone = false;
        this.beginLimitTest = false;
        this.preTestUploadLimit = n;
        this.preTestDownloadLimit = n2;
        if (this.transferMode.isDownloadMode()) {
            sMUpdate = new SMUpdate(this.uploadLimitMin, true, Math.round((float)this.downloadLimitMax * 1.2f), true);
            this.preTestDownloadCapacity = this.downloadLimitMax;
            this.transferMode.setMode(TransferMode.State.DOWNLOAD_LIMIT_SEARCH);
        } else {
            sMUpdate = new SMUpdate(Math.round((float)this.uploadLimitMax * 1.2f), true, this.downloadLimitMin, true);
            this.preTestUploadCapacity = this.uploadLimitMax;
            this.transferMode.setMode(TransferMode.State.UPLOAD_LIMIT_SEARCH);
        }
        return sMUpdate;
    }

    public SMUpdate rampTestingLimit(int n, int n2) {
        SMUpdate sMUpdate;
        if (this.transferMode.getMode() == TransferMode.State.DOWNLOAD_LIMIT_SEARCH && this.downloadBandwidthStatus.isGreater(SaturatedMode.MED)) {
            n2 = (int)((float)n2 * 1.1f);
            this.clLastIncreaseTime = SystemTime.getCurrentTime();
            sMUpdate = new SMUpdate(n, false, n2, true);
        } else if (this.transferMode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH && this.uploadBandwidthStatus.isGreater(SaturatedMode.MED)) {
            n = (int)((float)n * 1.1f);
            this.clLastIncreaseTime = SystemTime.getCurrentTime();
            sMUpdate = new SMUpdate(n, true, n2, false);
        } else {
            sMUpdate = new SMUpdate(n, false, n2, false);
            SpeedManagerLogger.trace("ERROR: rampTestLimit should only be called during limit testing. ");
        }
        return sMUpdate;
    }

    public void triggerLimitTestingFlag() {
        SpeedManagerLogger.trace("triggerd fast limit test.");
        this.beginLimitTest = true;
        if (this.useVariancePingMap) {
            SMInstance sMInstance = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter = sMInstance.getAdapter();
            if (this.transientPingMap != null) {
                this.transientPingMap.destroy();
            }
            this.transientPingMap = speedManagerAlgorithmProviderAdapter.createTransientPingMapper();
        }
    }

    public synchronized boolean isStartLimitTestFlagSet() {
        return this.beginLimitTest;
    }

    public synchronized boolean isConfLimitTestFinished() {
        return this.currTestDone;
    }

    public synchronized SMUpdate endLimitTesting(int n, int n2) {
        SpeedManagerLogger.trace(" repalce highestDownloadRate: " + this.highestDownloadRate + " with " + n);
        SpeedManagerLogger.trace(" replace highestUploadRate: " + this.highestUploadRate + " with " + n2);
        this.highestDownloadRate = n;
        this.highestUploadRate = n2;
        return this.endLimitTesting();
    }

    public synchronized SMUpdate endLimitTesting() {
        SMUpdate sMUpdate;
        if (this.transferMode.getMode() == TransferMode.State.DOWNLOAD_LIMIT_SEARCH) {
            this.downloadLimitConf = this.determineConfidenceLevel();
            SpeedManagerLogger.trace("pre-upload-setting=" + this.preTestUploadCapacity + " up-capacity" + this.uploadLimitMax + " pre-download-setting=" + this.preTestDownloadCapacity + " down-capacity=" + this.downloadLimitMax);
            sMUpdate = new SMUpdate(this.preTestUploadLimit, true, this.downloadLimitMax, true);
            this.transferMode.setMode(TransferMode.State.DOWNLOADING);
        } else if (this.transferMode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH) {
            this.uploadLimitConf = this.determineConfidenceLevel();
            sMUpdate = new SMUpdate(this.uploadLimitMax, true, this.downloadLimitMax, true);
            this.transferMode.setMode(TransferMode.State.SEEDING);
        } else {
            SpeedManagerLogger.log("SpeedLimitMonitor had IllegalState during endLimitTesting.");
            sMUpdate = new SMUpdate(this.preTestUploadLimit, true, this.preTestDownloadLimit, true);
        }
        this.currTestDone = true;
        this.uploadAtLimitStartTime = SystemTime.getCurrentTime();
        this.downloadAtLimitStartTime = SystemTime.getCurrentTime();
        return sMUpdate;
    }

    public SpeedLimitConfidence determineConfidenceLevel() {
        int n;
        int n2;
        boolean bl;
        String string;
        String string2;
        SpeedLimitConfidence speedLimitConfidence = SpeedLimitConfidence.NONE;
        if (this.transferMode.getMode() == TransferMode.State.DOWNLOAD_LIMIT_SEARCH) {
            string2 = DOWNLOAD_CONF_LIMIT_SETTING;
            string = "SpeedManagerAlgorithmProviderV2.setting.download.max.limit";
            bl = true;
            n2 = this.preTestDownloadCapacity;
            n = this.highestDownloadRate;
        } else if (this.transferMode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH) {
            string2 = UPLOAD_CONF_LIMIT_SETTING;
            string = "SpeedManagerAlgorithmProviderV2.setting.upload.max.limit";
            bl = false;
            n2 = this.preTestUploadCapacity;
            n = this.highestUploadRate;
        } else {
            SpeedManagerLogger.log("IllegalState in determineConfidenceLevel(). Setting level to NONE.");
            return SpeedLimitConfidence.NONE;
        }
        boolean bl2 = this.hadChockingPing();
        float f = (float)Math.abs(n - n2) / (float)Math.max(n, n2);
        speedLimitConfidence = f < 0.15f && bl2 ? SpeedLimitConfidence.MED : SpeedLimitConfidence.LOW;
        COConfigurationManager.setParameter(string2, speedLimitConfidence.getString());
        int n3 = n;
        COConfigurationManager.setParameter(string, n3);
        int n4 = bl ? SMConst.calculateMinDownload(n3) : SMConst.calculateMinUpload(n3);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.transferMode.getMode() == TransferMode.State.UPLOAD_LIMIT_SEARCH) {
            stringBuffer.append("new upload limits: ");
            this.uploadLimitMax = n3;
            this.uploadLimitMin = n4;
            if (this.downloadLimitMax < this.uploadLimitMax) {
                this.downloadLimitMax = this.uploadLimitMax;
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
            }
            stringBuffer.append(this.uploadLimitMax);
        } else {
            stringBuffer.append("new download limits: ");
            this.downloadLimitMax = n3;
            this.downloadLimitMin = n4;
            if (this.uploadLimitMax * 40 < this.downloadLimitMax) {
                this.uploadLimitMax = this.downloadLimitMax / 40;
                COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
                this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
            }
            stringBuffer.append(this.downloadLimitMax);
        }
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        SpeedManagerLogger.trace(stringBuffer.toString());
        return speedLimitConfidence;
    }

    public boolean areSettingsInSpec(int n, int n2) {
        if (this.isConfTestingLimits()) {
            return true;
        }
        boolean bl = true;
        if (n > this.uploadLimitMax) {
            bl = false;
        }
        if (n2 > this.downloadLimitMax && this.slider.isDownloadUnlimitedMode()) {
            bl = false;
        }
        return bl;
    }

    private int choseBestLimit(SpeedManagerLimitEstimate speedManagerLimitEstimate, int n, SpeedLimitConfidence speedLimitConfidence) {
        int n2;
        float f = speedManagerLimitEstimate.getEstimateType();
        int n3 = speedManagerLimitEstimate.getBytesPerSec();
        if (n3 < n && n3 < 20480) {
            return n;
        }
        String string = "";
        if (f == 1.0f) {
            n2 = n3;
            string = "manual";
        } else if (f == -0.1f) {
            n2 = Math.max(n3, n);
            string = "unknown";
        } else if (f == 0.0f) {
            if ((double)speedManagerLimitEstimate.getMetricRating() >= 0.0) {
                return n;
            }
            n2 = n3;
            string = "estimate and bad metric";
        } else {
            n2 = n3;
        }
        SpeedManagerLogger.trace("bestChosenLimit: reason=" + string + ",chosenLimit=" + n2);
        return n2;
    }

    public void setRefLimits(SpeedManagerLimitEstimate speedManagerLimitEstimate, SpeedManagerLimitEstimate speedManagerLimitEstimate2) {
        SpeedManagerLimitEstimate speedManagerLimitEstimate3 = SMConst.filterEstimate(speedManagerLimitEstimate, 5120);
        int n = this.choseBestLimit(speedManagerLimitEstimate3, this.uploadLimitMax, this.uploadLimitConf);
        SpeedManagerLimitEstimate speedManagerLimitEstimate4 = SMConst.filterEstimate(speedManagerLimitEstimate2, 20480);
        int n2 = this.choseBestLimit(speedManagerLimitEstimate4, this.downloadLimitMax, this.downloadLimitConf);
        if (n2 < n) {
            SpeedManagerLogger.trace("down max-limit was less then up-max limit. increasing down max-limit. upMax=" + n + " downMax=" + n2);
            n2 = n;
        }
        this.setRefLimits(n, n2);
    }

    public void setRefLimits(int n, int n2) {
        if (this.uploadLimitMax != n && n > 0) {
            this.uploadLimitMax = n;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
        }
        this.uploadLimitMin = SMConst.calculateMinUpload(n);
        if (this.downloadLimitMax != n2 && n2 > 0) {
            this.downloadLimitMax = n2;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", this.downloadLimitMax);
        }
        this.downloadLimitMin = SMConst.calculateMinDownload(n2);
        SpeedManagerLogger.trace("setRefLimits uploadMax=" + n + " uploadLimitMax=" + this.uploadLimitMax + ", downloadMax=" + n2 + " downloadLimitMax=" + this.downloadLimitMax);
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
    }

    public SMUpdate adjustLimitsToSpec(int n, int n2) {
        int n3 = n;
        boolean bl = false;
        int n4 = n2;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (n > this.uploadLimitMax && this.uploadLimitMax != 0) {
            n3 = this.uploadLimitMax;
            bl = true;
            stringBuffer.append(" (a) upload line-speed cap below current limit. ");
        }
        if (this.uploadLimitMax == 0) {
            stringBuffer.append("** uploadLimitMax=0 (Unlimited)! ** ");
        }
        if (n2 > this.downloadLimitMax && !this.slider.isDownloadUnlimitedMode()) {
            n4 = this.downloadLimitMax;
            bl2 = true;
            stringBuffer.append(" (b) download line-speed cap below current limit. ");
        }
        if (n < this.uploadLimitMin) {
            n3 = this.uploadLimitMin;
            bl = true;
            stringBuffer.append(" (c) min upload limit raised. ");
        }
        if (n2 < this.downloadLimitMin) {
            n4 = this.downloadLimitMin;
            bl2 = true;
            stringBuffer.append(" (d)  min download limit raised. ");
        }
        SpeedManagerLogger.trace("Adjusting limits due to out of spec: new-up=" + n3 + " new-down=" + n4 + "  reasons: " + stringBuffer.toString());
        return new SMUpdate(n3, bl, n4, bl2);
    }

    protected void log(String string) {
        SpeedManagerLogger.log(string);
    }

    public void initPingSpaceMap(int n, int n2) {
        this.pingMapOfDownloadMode = new PingSpaceMapper(n, n2);
        this.pingMapOfSeedingMode = new PingSpaceMapper(n, n2);
        this.useVariancePingMap = false;
    }

    public void initPingSpaceMap() {
        this.useVariancePingMap = true;
    }

    public void betaLogPingMapperEstimates(String string, SpeedManagerLimitEstimate speedManagerLimitEstimate, boolean bl, SpeedManagerLimitEstimate speedManagerLimitEstimate2, PingSpaceMapper pingSpaceMapper, PingSpaceMapper pingSpaceMapper2) {
        boolean bl2;
        boolean bl3;
        float f;
        int n;
        StringBuffer stringBuffer = new StringBuffer("beta-ping-maps-").append(string).append(": ");
        if (speedManagerLimitEstimate != null) {
            n = speedManagerLimitEstimate.getBytesPerSec();
            f = speedManagerLimitEstimate.getMetricRating();
            stringBuffer.append("transient-").append(n).append("(").append(f).append(")");
        }
        stringBuffer.append(" chockPing=").append(bl);
        if (speedManagerLimitEstimate2 != null) {
            n = speedManagerLimitEstimate2.getBytesPerSec();
            f = speedManagerLimitEstimate2.getMetricRating();
            stringBuffer.append("; perm-").append(n).append("(").append(f).append(")");
        }
        if (pingSpaceMapper != null) {
            n = pingSpaceMapper.guessDownloadLimit();
            int n2 = pingSpaceMapper.guessUploadLimit();
            bl3 = pingSpaceMapper.hadChockingPing(true);
            bl2 = pingSpaceMapper.hadChockingPing(false);
            stringBuffer.append("; downMode- ");
            stringBuffer.append("rateDown=").append(n).append(" ");
            stringBuffer.append("rateUp=").append(n2).append(" ");
            stringBuffer.append("downChockPing=").append(bl3).append(" ");
            stringBuffer.append("upChockPing=").append(bl2).append(" ");
        }
        if (pingSpaceMapper2 != null) {
            n = pingSpaceMapper2.guessDownloadLimit();
            int n3 = pingSpaceMapper2.guessUploadLimit();
            bl3 = pingSpaceMapper2.hadChockingPing(true);
            bl2 = pingSpaceMapper2.hadChockingPing(false);
            stringBuffer.append("; seedMode- ");
            stringBuffer.append("rateDown=").append(n).append(" ");
            stringBuffer.append("rateUp=").append(n3).append(" ");
            stringBuffer.append("downChockPing=").append(bl3).append(" ");
            stringBuffer.append("upChockPing=").append(bl2).append(" ");
        }
        SpeedManagerLogger.log(stringBuffer.toString());
    }

    public int guessDownloadLimit() {
        if (!this.useVariancePingMap) {
            return this.pingMapOfDownloadMode.guessDownloadLimit();
        }
        boolean bl = true;
        SpeedManagerLimitEstimate speedManagerLimitEstimate = null;
        if (this.transientPingMap != null && (speedManagerLimitEstimate = this.transientPingMap.getLastBadDownloadLimit()) == null) {
            bl = false;
            speedManagerLimitEstimate = this.transientPingMap.getEstimatedDownloadLimit(false);
        }
        SMInstance sMInstance = SMInstance.getInstance();
        SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter = sMInstance.getAdapter();
        SpeedManagerPingMapper speedManagerPingMapper = speedManagerAlgorithmProviderAdapter.getPingMapper();
        SpeedManagerLimitEstimate speedManagerLimitEstimate2 = speedManagerPingMapper.getEstimatedDownloadLimit(false);
        this.betaLogPingMapperEstimates("down", speedManagerLimitEstimate, bl, speedManagerLimitEstimate2, this.pingMapOfDownloadMode, this.pingMapOfSeedingMode);
        if (speedManagerLimitEstimate != null) {
            return this.choseBestLimit(speedManagerLimitEstimate, this.downloadLimitMax, this.downloadLimitConf);
        }
        return this.downloadLimitMax;
    }

    public int guessUploadLimit() {
        if (!this.useVariancePingMap) {
            int n = this.pingMapOfDownloadMode.guessUploadLimit();
            int n2 = this.pingMapOfSeedingMode.guessUploadLimit();
            return Math.max(n, n2);
        }
        boolean bl = true;
        SpeedManagerLimitEstimate speedManagerLimitEstimate = null;
        if (this.transientPingMap != null && (speedManagerLimitEstimate = this.transientPingMap.getLastBadUploadLimit()) == null) {
            bl = false;
            speedManagerLimitEstimate = this.transientPingMap.getEstimatedUploadLimit(false);
        }
        SMInstance sMInstance = SMInstance.getInstance();
        SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter = sMInstance.getAdapter();
        SpeedManagerPingMapper speedManagerPingMapper = speedManagerAlgorithmProviderAdapter.getPingMapper();
        SpeedManagerLimitEstimate speedManagerLimitEstimate2 = speedManagerPingMapper.getEstimatedUploadLimit(false);
        this.betaLogPingMapperEstimates("up", speedManagerLimitEstimate, bl, speedManagerLimitEstimate2, this.pingMapOfDownloadMode, this.pingMapOfSeedingMode);
        if (speedManagerLimitEstimate != null) {
            return this.choseBestLimit(speedManagerLimitEstimate, this.uploadLimitMax, this.uploadLimitConf);
        }
        return this.uploadLimitMax;
    }

    public boolean hadChockingPing() {
        if (!this.useVariancePingMap) {
            return this.pingMapOfDownloadMode.hadChockingPing(true);
        }
        SpeedManagerPingMapper speedManagerPingMapper = SMInstance.getInstance().getAdapter().getPingMapper();
        SpeedManagerLimitEstimate speedManagerLimitEstimate = speedManagerPingMapper.getEstimatedDownloadLimit(true);
        SpeedManagerLimitEstimate speedManagerLimitEstimate2 = speedManagerPingMapper.getEstimatedUploadLimit(true);
        boolean bl = speedManagerLimitEstimate2.getEstimateType() == 0.5f;
        boolean bl2 = speedManagerLimitEstimate.getEstimateType() == 0.5f;
        return bl || bl2;
    }

    public void logPingMapData() {
        if (!this.useVariancePingMap) {
            int n = this.pingMapOfDownloadMode.guessDownloadLimit();
            int n2 = this.pingMapOfDownloadMode.guessUploadLimit();
            int n3 = this.pingMapOfSeedingMode.guessUploadLimit();
            StringBuffer stringBuffer = new StringBuffer("ping-map: ");
            stringBuffer.append(":down=").append(n);
            stringBuffer.append(":up=").append(n2);
            stringBuffer.append(":(seed)up=").append(n3);
            SpeedManagerLogger.log(stringBuffer.toString());
        } else {
            SMInstance sMInstance = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter = sMInstance.getAdapter();
            SpeedManagerPingMapper speedManagerPingMapper = speedManagerAlgorithmProviderAdapter.getPingMapper();
            SpeedManagerLimitEstimate speedManagerLimitEstimate = speedManagerPingMapper.getEstimatedUploadLimit(false);
            SpeedManagerLimitEstimate speedManagerLimitEstimate2 = speedManagerPingMapper.getEstimatedDownloadLimit(false);
            int n = speedManagerLimitEstimate2.getBytesPerSec();
            float f = speedManagerLimitEstimate2.getMetricRating();
            int n4 = speedManagerLimitEstimate.getBytesPerSec();
            float f2 = speedManagerLimitEstimate.getMetricRating();
            String string = speedManagerPingMapper.getName();
            StringBuffer stringBuffer = new StringBuffer("new-ping-map: ");
            stringBuffer.append(" name=").append(string);
            stringBuffer.append(", down=").append(n);
            stringBuffer.append(", down-conf=").append(f);
            stringBuffer.append(", up=").append(n4);
            stringBuffer.append(", up-conf=").append(f2);
            SpeedManagerLogger.log(stringBuffer.toString());
        }
    }

    public void setCurrentTransferRates(int n, int n2) {
        if (this.pingMapOfDownloadMode != null && this.pingMapOfSeedingMode != null) {
            this.pingMapOfDownloadMode.setCurrentTransferRates(n, n2);
            this.pingMapOfSeedingMode.setCurrentTransferRates(n, n2);
        }
    }

    public void resetPingSpace() {
        if (this.pingMapOfDownloadMode != null && this.pingMapOfSeedingMode != null) {
            this.pingMapOfDownloadMode.reset();
            this.pingMapOfSeedingMode.reset();
        }
        if (this.transientPingMap != null) {
            this.transientPingMap.destroy();
        }
    }

    public void addToPingMapData(int n) {
        String string = this.getTransferModeAsString();
        if (string.equalsIgnoreCase(TransferMode.State.DOWNLOADING.getString()) || string.equalsIgnoreCase(TransferMode.State.DOWNLOAD_LIMIT_SEARCH.getString())) {
            this.pingMapOfDownloadMode.addMetricToMap(n);
        } else if (string.equalsIgnoreCase(TransferMode.State.SEEDING.getString()) || string.equalsIgnoreCase(TransferMode.State.UPLOAD_LIMIT_SEARCH.getString())) {
            this.pingMapOfSeedingMode.addMetricToMap(n);
        }
        this.updateLimitTestingPing(n);
        this.longTermMonitor.updateStatus(this.transferMode);
    }

    @Override
    public void notifyUpload(SpeedManagerLimitEstimate speedManagerLimitEstimate) {
        int n = this.choseBestLimit(speedManagerLimitEstimate, this.uploadLimitMax, this.uploadLimitConf);
        SpeedManagerLogger.trace("notifyUpload uploadLimitMax=" + this.uploadLimitMax);
        this.tempLogEstimate(speedManagerLimitEstimate);
        if (n != this.uploadLimitMax) {
            SpeedManagerLogger.log("persistent PingMap changed upload limit to " + n);
            this.resetPinSearch(speedManagerLimitEstimate);
            this.uploadLimitMax = n;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit", this.uploadLimitMax);
        }
        this.uploadLimitMin = SMConst.calculateMinUpload(this.uploadLimitMax);
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        SMSearchLogger.log("new upload rate: " + this.uploadLimitMax);
    }

    @Override
    public void notifyDownload(SpeedManagerLimitEstimate speedManagerLimitEstimate) {
        int n = this.choseBestLimit(speedManagerLimitEstimate, this.downloadLimitMax, this.downloadLimitConf);
        SpeedManagerLogger.trace("notifyDownload downloadLimitMax=" + this.downloadLimitMax + " conf=" + this.downloadLimitConf.getString() + " (" + this.downloadLimitConf.asEstimateType() + ")");
        this.tempLogEstimate(speedManagerLimitEstimate);
        if (this.downloadLimitMax != n) {
            SpeedManagerLogger.log("persistent PingMap changed download limit to " + n);
            this.downloadLimitMax = n;
            COConfigurationManager.setParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit", n);
        }
        this.downloadLimitMin = SMConst.calculateMinDownload(this.downloadLimitMax);
        this.slider.updateLimits(this.uploadLimitMax, this.uploadLimitMin, this.downloadLimitMax, this.downloadLimitMin);
        if (speedManagerLimitEstimate.getBytesPerSec() != 0) {
            this.slider.setDownloadUnlimitedMode(false);
        } else {
            this.slider.setDownloadUnlimitedMode(true);
        }
        SMSearchLogger.log("download " + this.downloadLimitMax);
    }

    private void tempLogEstimate(SpeedManagerLimitEstimate speedManagerLimitEstimate) {
        if (speedManagerLimitEstimate == null) {
            SpeedManagerLogger.trace("notify log: SpeedManagerLimitEstimate was null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        float f = speedManagerLimitEstimate.getMetricRating();
        float f2 = speedManagerLimitEstimate.getEstimateType();
        int n = speedManagerLimitEstimate.getBytesPerSec();
        String string = speedManagerLimitEstimate.getString();
        stringBuffer.append("notify log: ").append(string);
        stringBuffer.append(" metricRating=").append(f);
        stringBuffer.append(" rate=").append(n);
        stringBuffer.append(" type=").append(f2);
        SpeedManagerLogger.trace(stringBuffer.toString());
    }
}

