/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl;

import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContact;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContactListener;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterListener;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class TestPingSourceImpl
implements DHTSpeedTester {
    private SpeedManagerAlgorithmProviderAdapter adapter;
    private volatile int contact_num;
    private List listeners = new ArrayList();
    private CopyOnWriteList sources = new CopyOnWriteList();
    private int period;

    protected TestPingSourceImpl(SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter) {
        this.adapter = speedManagerAlgorithmProviderAdapter;
        SimpleTimer.addPeriodicEvent("TestPingSourceImpl", 1000L, new TimerEventPerformer(){
            private int ticks;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent2) {
                List<testSource> list;
                ++this.ticks;
                testSource[] testSourceArray = TestPingSourceImpl.this.sources;
                synchronized (testSourceArray) {
                    while (TestPingSourceImpl.this.sources.size() < TestPingSourceImpl.this.contact_num) {
                        TestPingSourceImpl.this.addContact(new testSource());
                    }
                    list = TestPingSourceImpl.this.sources.getList();
                }
                if (TestPingSourceImpl.this.period > 0 && this.ticks % TestPingSourceImpl.this.period == 0) {
                    testSourceArray = new testSource[list.size()];
                    list.toArray(testSourceArray);
                    TestPingSourceImpl.this.update(testSourceArray);
                }
            }
        });
    }

    protected SpeedManagerAlgorithmProviderAdapter getAdapter() {
        return this.adapter;
    }

    protected void update(testSource[] testSourceArray) {
        int n;
        int[] nArray = new int[testSourceArray.length];
        this.updateSources(testSourceArray);
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = testSourceArray[n].getRTT();
        }
        for (n = 0; n < this.listeners.size(); ++n) {
            ((DHTSpeedTesterListener)this.listeners.get(n)).resultGroup(testSourceArray, nArray);
        }
    }

    protected abstract void updateSources(testSource[] var1);

    @Override
    public int getContactNumber() {
        return this.contact_num;
    }

    @Override
    public void setContactNumber(int n) {
        this.contact_num = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContact(testSource testSource2) {
        CopyOnWriteList copyOnWriteList = this.sources;
        synchronized (copyOnWriteList) {
            this.sources.add(testSource2);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((DHTSpeedTesterListener)this.listeners.get(i)).contactAdded(testSource2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeContact(testSource testSource2) {
        CopyOnWriteList copyOnWriteList = this.sources;
        synchronized (copyOnWriteList) {
            this.sources.remove(testSource2);
        }
    }

    @Override
    public void addListener(DHTSpeedTesterListener dHTSpeedTesterListener) {
        this.listeners.add(dHTSpeedTesterListener);
    }

    @Override
    public void removeListener(DHTSpeedTesterListener dHTSpeedTesterListener) {
        this.listeners.remove(dHTSpeedTesterListener);
    }

    protected class testSource
    implements DHTSpeedTesterContact {
        private InetSocketAddress address = new InetSocketAddress(1);
        private List listeners = new ArrayList();
        private int rtt;

        protected testSource() {
        }

        @Override
        public InetSocketAddress getAddress() {
            return this.address;
        }

        @Override
        public String getString() {
            return "test source";
        }

        @Override
        public int getPingPeriod() {
            return TestPingSourceImpl.this.period;
        }

        @Override
        public void setPingPeriod(int n) {
            TestPingSourceImpl.this.period = n;
        }

        protected int getRTT() {
            return this.rtt;
        }

        protected void setRTT(int n) {
            this.rtt = n;
        }

        protected void failed() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((DHTSpeedTesterContactListener)this.listeners.get(i)).contactDied(this);
            }
        }

        @Override
        public void destroy() {
            TestPingSourceImpl.this.removeContact(this);
        }

        @Override
        public void addListener(DHTSpeedTesterContactListener dHTSpeedTesterContactListener) {
            this.listeners.add(dHTSpeedTesterContactListener);
        }

        @Override
        public void removeListener(DHTSpeedTesterContactListener dHTSpeedTesterContactListener) {
            this.listeners.remove(dHTSpeedTesterContactListener);
        }
    }
}

