/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.security.impl;

import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.security.CryptoManagerException;
import com.aelitis.azureus.core.security.CryptoSTSEngine;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import org.bouncycastle.jce.provider.JCEECDHKeyAgreement;

final class CryptoSTSEngineImpl
implements CryptoSTSEngine {
    public static final int VERSION = 1;
    private KeyPair ephemeralKeyPair;
    private PublicKey myPublicKey;
    private PrivateKey myPrivateKey;
    private PublicKey remotePubKey;
    private byte[] sharedSecret;
    private InternalDH ecDH;

    CryptoSTSEngineImpl(PublicKey publicKey, PrivateKey privateKey) throws CryptoManagerException {
        this.myPublicKey = publicKey;
        this.myPrivateKey = privateKey;
        this.ephemeralKeyPair = CryptoECCUtils.createKeys();
        try {
            this.ecDH = new InternalDH();
            this.ecDH.init(this.ephemeralKeyPair.getPrivate());
        }
        catch (Exception exception) {
            throw new CryptoManagerException("Couldn't initialize crypto handshake", exception);
        }
    }

    @Override
    public void getKeys(ByteBuffer byteBuffer) throws CryptoManagerException {
        this.getMessage(byteBuffer, true);
    }

    @Override
    public void putKeys(ByteBuffer byteBuffer) throws CryptoManagerException {
        this.putMessage(byteBuffer, true);
    }

    @Override
    public void getAuth(ByteBuffer byteBuffer) throws CryptoManagerException {
        this.getMessage(byteBuffer, false);
    }

    @Override
    public void putAuth(ByteBuffer byteBuffer) throws CryptoManagerException {
        this.putMessage(byteBuffer, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putMessage(ByteBuffer byteBuffer, boolean bl) throws CryptoManagerException {
        try {
            int n = this.getInt(byteBuffer, 255);
            if (n != 1) {
                throw new CryptoManagerException("invalid version (" + n + ")");
            }
            if (bl) {
                if (this.sharedSecret != null) {
                    throw new CryptoManagerException("phase error: keys already received");
                }
                byte[] byArray = this.getBytes(byteBuffer, 65535);
                byte[] byArray2 = this.getBytes(byteBuffer, 65535);
                byte[] byArray3 = this.getBytes(byteBuffer, 65535);
                byte[] byArray4 = this.getBytes(byteBuffer, 65535);
                this.remotePubKey = CryptoECCUtils.rawdataToPubkey(byArray);
                Signature signature = CryptoECCUtils.getSignature(this.remotePubKey);
                signature.update(byArray);
                signature.update(byArray2);
                if (!signature.verify(byArray3)) throw new CryptoManagerException("Signature check failed");
                this.ecDH.doPhase(CryptoECCUtils.rawdataToPubkey(byArray2), true);
                this.sharedSecret = this.ecDH.generateSecret();
                return;
            } else {
                if (this.sharedSecret == null) {
                    throw new CryptoManagerException("phase error: keys not received");
                }
                byte[] byArray = this.getBytes(byteBuffer, 65535);
                byte[] byArray5 = this.getBytes(byteBuffer, 65535);
                Signature signature = CryptoECCUtils.getSignature(this.remotePubKey);
                signature.update(byArray);
                signature.update(this.sharedSecret);
                if (signature.verify(byArray5)) return;
                throw new CryptoManagerException("Signature check failed");
            }
        }
        catch (CryptoManagerException cryptoManagerException) {
            throw cryptoManagerException;
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to generate message");
        }
    }

    public void getMessage(ByteBuffer byteBuffer, boolean bl) throws CryptoManagerException {
        try {
            this.putInt(byteBuffer, 1, 255);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            Signature signature = CryptoECCUtils.getSignature(this.myPrivateKey);
            if (bl) {
                byte[] byArray = CryptoECCUtils.keyToRawdata(this.myPublicKey);
                byte[] byArray2 = CryptoECCUtils.keyToRawdata(this.ephemeralKeyPair.getPublic());
                signature.update(byArray);
                signature.update(byArray2);
                byte[] byArray3 = signature.sign();
                byte[] byArray4 = new byte[secureRandom.nextInt(32)];
                secureRandom.nextBytes(byArray4);
                this.putBytes(byteBuffer, byArray, 65535);
                this.putBytes(byteBuffer, byArray2, 65535);
                this.putBytes(byteBuffer, byArray3, 65535);
                this.putBytes(byteBuffer, byArray4, 65535);
            } else {
                if (this.sharedSecret == null) {
                    throw new CryptoManagerException("phase error: keys not received");
                }
                byte[] byArray = new byte[20 + secureRandom.nextInt(32)];
                secureRandom.nextBytes(byArray);
                signature.update(byArray);
                signature.update(this.sharedSecret);
                byte[] byArray5 = signature.sign();
                this.putBytes(byteBuffer, byArray, 65535);
                this.putBytes(byteBuffer, byArray5, 65535);
            }
        }
        catch (CryptoManagerException cryptoManagerException) {
            throw cryptoManagerException;
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to generate message");
        }
    }

    @Override
    public byte[] getSharedSecret() throws CryptoManagerException {
        if (this.sharedSecret == null) {
            throw new CryptoManagerException("secret not yet available");
        }
        return this.sharedSecret;
    }

    @Override
    public byte[] getRemotePublicKey() throws CryptoManagerException {
        if (this.remotePubKey == null) {
            throw new CryptoManagerException("key not yet available");
        }
        return CryptoECCUtils.keyToRawdata(this.remotePubKey);
    }

    protected int getInt(ByteBuffer byteBuffer, int n) throws CryptoManagerException {
        try {
            if (n < 256) {
                return byteBuffer.get() & 0xFF;
            }
            if (n < 65536) {
                return byteBuffer.getShort() & 0xFFFF;
            }
            return byteBuffer.getInt();
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to get int", throwable);
        }
    }

    protected byte[] getBytes(ByteBuffer byteBuffer, int n) throws CryptoManagerException {
        int n2 = this.getInt(byteBuffer, n);
        if (n2 > n) {
            throw new CryptoManagerException("Invalid length");
        }
        try {
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray);
            return byArray;
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to get byte[]", throwable);
        }
    }

    protected void putInt(ByteBuffer byteBuffer, int n, int n2) throws CryptoManagerException {
        try {
            if (n2 < 256) {
                byteBuffer.put((byte)n);
            } else if (n2 < 65536) {
                byteBuffer.putShort((short)n);
            } else {
                byteBuffer.putInt(n);
            }
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to put int", throwable);
        }
    }

    protected void putBytes(ByteBuffer byteBuffer, byte[] byArray, int n) throws CryptoManagerException {
        this.putInt(byteBuffer, byArray.length, n);
        try {
            byteBuffer.put(byArray);
        }
        catch (Throwable throwable) {
            throw new CryptoManagerException("Failed to put byte[]", throwable);
        }
    }

    class InternalDH
    extends JCEECDHKeyAgreement.DH {
        InternalDH() {
        }

        @Override
        public void init(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.engineInit(key, null);
        }

        @Override
        public Key doPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
            return this.engineDoPhase(key, bl);
        }

        @Override
        public byte[] generateSecret() throws IllegalStateException {
            return this.engineGenerateSecret();
        }
    }
}

